import { AnyRecord, AnyValue, Context, Node, NodeExternalQueryOptions, NodeFactory, OrderBy, OrderByClause, PropertyAndValue } from '@sage/xtrem-core';
import { X3StorageManager } from '../storage';
import { ConversionResult, OutputColumn } from './sql-converter';
export declare class SqlQuery<T extends Node> {
    private readonly context;
    private readonly factory;
    private readonly options;
    private readonly schemaName;
    private readonly sqlConverter;
    private orderByClauses?;
    private before;
    private after;
    private aggregateResult?;
    private groupColumns;
    private valueColumns;
    private _selectedColumns;
    private _inactiveProperties;
    static internalStatistics: {
        queryCount: number;
    };
    currentLocale: string;
    constructor(context: Context, factory: NodeFactory, options: NodeExternalQueryOptions<T>, schemaName: string);
    private fillFallbackPropertyOptions;
    get externalStorageManager(): X3StorageManager<T>;
    get outputColumns(): ConversionResult[] | undefined;
    get groupValueColumns(): {
        groups?: ConversionResult[];
        values?: ConversionResult[];
    };
    private getGroupsOrderBy;
    private orderBySql;
    /** Get the aggregator operation of the column in the order by clause from group by or values clause */
    private static getAggregationOrderByAlias;
    private cursorWhere;
    private whereClause;
    private getGroupByClauses;
    private static transformConverted;
    /**
     * Converts a selector to an array of paths for the selected columns.
     * For each selected column the returned path the array of properties that lead to this column.
     * For example a selector like `{ name: true, reference: { quantity: true, amount: true } }`
     * is converted to `[['name'], ['reference', 'quantity'], ['reference', 'amount']]`.
     * If the selector is just true, the selected columns will just be true
     */
    private getOutputPaths;
    /**
     * Returns the paths for all the columns of a table.
     * The result is an array of paths and each path is an array of property names, like the result of getOutputPaths,
     * but the path arrays contain only one property name in this case.
     */
    private getTableColumnPaths;
    private getOutputColumns;
    columnValue(column: OutputColumn, sqlVal: AnyValue): AnyValue;
    mapRecordIn(outputColumns: OutputColumn[], record: AnyRecord): Promise<any>;
    mapAggregateRecordIn(groupColumns: OutputColumn[], valueColumns: OutputColumn[], record: AnyRecord): Promise<AnyRecord>;
    isAggregateQuery(): boolean;
    private isSingleResult;
    get defaultOrderBy(): OrderBy<Node>;
    private static lockClause;
    private static safeParseInt;
    private static safeParseFloat;
    private static parsePropertyValue;
    private static removeCursorChecksum;
    private static parseCursorValues;
    static parseCursor(orderByClauses: OrderByClause[], value: string): PropertyAndValue[];
    private isMissingColumnInOrderByClause;
    getSqlQuery(): {
        sql: string;
        promisedParameterValues: Promise<AnyValue[]>;
    };
}
//# sourceMappingURL=sql-query.d.ts.map