/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.SqlConverter=void 0;const xtrem_core_1=require("@sage/xtrem-core"),xtrem_date_time_1=require("@sage/xtrem-date-time"),xtrem_decimal_1=require("@sage/xtrem-decimal"),xtrem_ts_to_sql_1=require("@sage/xtrem-ts-to-sql"),xtrem_x3_config_manager_1=require("@sage/xtrem-x3-config-manager"),_=require("lodash"),storage_1=require("../storage"),sql_resolver_1=require("./sql-resolver"),sql_value_converter_1=require("./sql-value-converter"),binaryOps={_eq:(e,t,r,o,n)=>`(${o} = ${n}${t?` AND (${sql_resolver_1.SqlResolver.convertToConversionPair(e,o,r,["1","0"])}=0)`:""})`,_ne:(e,t,r,o,n)=>{const s=[`${o} != ${n}`];switch(r){case"string":case"enum":case"datetime":case"date":if(t&&n===sql_resolver_1.SqlResolver.nullValue(e,r))s.push(`(${o} IS NULL)`);else if(t)s.push(`(${sql_resolver_1.SqlResolver.convertToConversionPair(e,o,r,["1","0"])}=1)`);break;default:if(t)s.push(`(${sql_resolver_1.SqlResolver.convertToConversionPair(e,o,r,["1","0"])}=1)`)}return`(${SqlConverter.or(s)})`},_gt:(e,t,r,o,n)=>`(${o} > ${n}${t?` AND (${sql_resolver_1.SqlResolver.convertToConversionPair(e,o,r,["1","0"])}=0)`:""})`,_gte:(e,t,r,o,n)=>`(${o} >= ${n}${t?` AND (${sql_resolver_1.SqlResolver.convertToConversionPair(e,o,r,["1","0"])}=0)`:""})`,_lt:(e,t,r,o,n)=>`(${o} < ${n}${t?` OR (${sql_resolver_1.SqlResolver.convertToConversionPair(e,o,r,["1","0"])}=1)`:""})`,_lte:(e,t,r,o,n)=>`(${o} <= ${n}${t?` OR (${sql_resolver_1.SqlResolver.convertToConversionPair(e,o,r,["1","0"])}=1)`:""})`,_contains:(e,t,r,o,n)=>`(${o} @> ${n}${t?` OR (${sql_resolver_1.SqlResolver.convertToConversionPair(e,o,r,["1","0"])}=1)`:""})`,_containedBy:(e,t,r,o,n)=>`(${o} <@ ${n}${t?` OR (${sql_resolver_1.SqlResolver.convertToConversionPair(e,o,r,["1","0"])}=1)`:""})`};function isFilterObject(e){return!!e&&(0,xtrem_core_1.isCompound)(e)}const logger=xtrem_core_1.Logger.getLogger(__filename,"sql-mapper");function logWrongType(e,t,r){let o=typeof r;if(o===e)return;if("object"===o)o=null==r?"null":r.constructor.name;logger.warn(`'${t}': expected a 'string', got type='${o}', value=${JSON.stringify(r)}`)}(0,xtrem_ts_to_sql_1.setLogger)(logger);class SqlConverter extends xtrem_ts_to_sql_1.Converter{constructor(e,t,r){let o;switch(sql_resolver_1.SqlResolver.getX3Pool(e).dialect){case"oracle":o="oracle";break;case"postgres":o="postgres";break;default:o="sqlServer"}super(e,r,{resolveColumnName:(e,t,r)=>sql_resolver_1.SqlResolver.resolve(this,e,t,r),resolveTableName:e=>{const r=e.tableName||e.name;if(/SELECT.* FROM/.test(r))return r;return`${t}.${r.toUpperCase()}`},resolveLiteral:e=>this.resolveLiteral(e)},{dialect:o,maxSubQueryDepth:xtrem_x3_config_manager_1.X3ConfigManager.current.storage?.sql?.maxSubQueryDepth}),this.context=e,this.schemaName=t,this.rootFactory=r,this.sqlParameters=[],this.#e={},this.localizedStringLanguage="ENG"}addSqlParameter(e){let{sql:t}=e;if("postgres"===sql_resolver_1.SqlResolver.getX3Pool(this.context).dialect&&["boolean","number"].includes(typeof e.literalValue)){const r={sql:t,type:"string"},o="boolean"==typeof e.literalValue?"boolean":"integer";t=this.cast(r,o).sql}return this.sqlParameters.push(e),t}addValuePathParameter(e,t,r){const o=this.sqlParameters.find(t=>t.valuePath===e);if(o)return o.sql;const n=sql_resolver_1.SqlResolver.getX3Pool(this.context).param(this.sqlParameters.length);return this.addSqlParameter({sql:n,valuePath:e,type:t,property:r})}#e;addLiteralParameter(e){if("boolean"==typeof e)return this.addLiteralParameter(e?1:0);const t=`${typeof e}/${e.toString()}`;if(!this.#e[t]){const r=sql_resolver_1.SqlResolver.getX3Pool(this.context).param(this.sqlParameters.length);this.#e[t]=this.addSqlParameter({sql:r,valuePath:"",type:"string",literalValue:e})}return this.#e[t]}static convertNumberParameter(e,t){const r="number"==typeof t?t:parseFloat(String(t));if(!Number.isFinite(r))throw new xtrem_core_1.DataInputError(`${"valuePath"in e?e.valuePath:e.path}: invalid numeric value: '${t}'`);return r}static convertBinaryParameter(e,t){if(Buffer.isBuffer(t.value))return t.value;throw new Error(`${e.valuePath}: cannot convert value ${t} of type ${typeof t} to ${e.type} to SQL`)}static getParameterSubValue(e,t){switch(e.subPath){case"_atLeast":case"_atMost":{const r=t?.[e.subPath];if("number"!=typeof r)throw new Error(`${e.valuePath}.${e.subPath}: invalid value: ${r}`);return r}default:throw new xtrem_core_1.LogicError(`${e.valuePath}: invalid subPath: ${e.subPath}`)}}getParameterValue(e,t,r){if(t.isArray&&Array.isArray(r))return Promise.all(r.map(r=>this.getParameterValue(e,{...t,isArray:false},r)));if(null==r){const r="encryptedString"===t.type?"string":t.type;return SqlConverter.typeDefaultValue(e,{property:t.property,type:r,isNullable:t.property?.isNullable})}if(t.subPath)return SqlConverter.getParameterSubValue(t,r);switch(t.type){case"boolean":return this.booleanSqlValue(r);case"enum":if(!t.property)throw new Error(`${t.valuePath}: enum property not set`);return this.enumSqlValue(t.property,t.type,{type:t.type,sql:"",alias:"",path:t.valuePath??"",factory:t.property.factory},r);case"encryptedString":if("string"!=typeof r)throw new Error(`Invalid value for ${t.type}: ${r} of type ${typeof r}`);return e.vault.getValueFromVault(r);case"string":if("string"!=typeof r)logWrongType(t.type,t.valuePath||"",r);return String(r||" ");case"decimal":return String(r);case"short":case"float":case"double":case"integer":return SqlConverter.convertNumberParameter(t,r);case"binaryStream":return SqlConverter.convertBinaryParameter(t,r);case"textStream":case"date":case"time":case"datetime":case"uuid":return r;default:throw new Error(`${t.valuePath}: cannot convert type ${t.type} to SQL`)}}getParameterValues(e,t){const r=e.tenantId?{...t,context:{tenantId:e.tenantId}}:t;return Promise.all(this.sqlParameters.map(t=>void 0!==t.literalValue?t.literalValue:this.getParameterValue(e,t,_.get(r,t.valuePath))))}fetchParameterUsingArgKey(e){return this.sqlParameters.find(t=>t.sql===e)}resolveLiteral(e){if(null==e)return"NULL";return this.addLiteralParameter(e)}static isSystemOrTechnicalColumn(e){return sql_resolver_1.SqlResolver.isSystemOrTechnicalColumn(e)}static getQuantifier(e,t){if(!t||"object"!=typeof t)throw new Error(`${e.path}: invalid collection filter - not an object`);const r=Object.keys(t).filter(e=>/^_(atMost|atLeast|every|none)$/.test(e));if(0===r.length)throw new Error(`${e.path}: missing _atLeast/_atMost/_every/_none quantifier on nested filter`);if(r.length>1)throw new Error(`${e.path}: only ONE _atLeast/_atMost/_every/_none quantifier on nested filter can be defined but found ${r}`);return r[0]}static checkQuantifierValue(e,t,r){if("_atMost"===r||"_atLeast"===r){if("number"!=typeof t[r])throw new Error(`${e.path}.${r}: value must be a number`)}else if(true!==t[r])throw new Error(`${e.path}.${r}: value must be true`)}convertCollectionFilter(e,t,r){const o=SqlConverter.getQuantifier(t,r);SqlConverter.checkQuantifierValue(t,r,o);const n=t.compositePath&&t.compositePath.length>0?this.convertOutputPath(t.compositePath):{...t,joinCondition:""},s=_.omit(r,[o]),l=this.withSubQueryScope(()=>({innerFilterSql:this.convertFilterObject(e,n,s)})),a="_every"===o?`NOT(${l.innerFilterSql})`:l.innerFilterSql,i=`(SELECT COUNT(*) FROM ${l.aliases.trim()} WHERE  ${SqlConverter.and([l.joinCondition,a])})`;switch(o){case"_atLeast":{const t=sql_resolver_1.SqlResolver.getX3Pool(this.context).param(this.sqlParameters.length);return`(${i} >= ${this.addSqlParameter({sql:t,valuePath:e,subPath:"_atLeast",type:"integer"})})`}case"_atMost":{const t=sql_resolver_1.SqlResolver.getX3Pool(this.context).param(this.sqlParameters.length);return`(${i} <= ${this.addSqlParameter({sql:t,valuePath:e,subPath:"_atMost",type:"integer"})})`}case"_none":case"_every":return`(${i} = 0)`;default:throw new Error(`invalid quantifier: ${o}`)}}convertIdValue(e,t){if(null==t||""===t)return null;const r=e.property&&sql_resolver_1.SqlResolver.getPropertyType(e.property);let o=t;if(["boolean","integer","short"].includes(r||"string"))o=parseInt(t,10);if("enum"===r){const r=e.property?.dataType;o=r.numberValue(t)}return sql_value_converter_1.SqlValueConverter.fromSql(this.context,e,o)}convertIdFilter(e,t,r){if("number"==typeof r&&r<0)return"1=1";if(null==r)return"1=2";if("string"==typeof r&&r.startsWith("#"))return this.convertIdFilter(e,t,r.substring(1));let o=t.parent;if("_id"!==t.property?.name){if("reference"!==t.property?.type)throw new Error(`${t.path}: cannot convert id filter for non-reference property`);o=t}if(!o)throw new Error(`${t.path}: missing parent.`);const n=String(r).split("|"),s=t.factory?.keyProperties.reduce((e,t,r)=>{const s=this.withThisResultScope(o,()=>this.convertOutputPath([t.name]));return e[t.name]=this.convertIdValue(s,n[r]),e},{});return this.convertFilterObject(e,o,s)}convertPropertyFilter(e,t,r,o){const n=this.walk(t,o),s=r[o],l=`${e}.${o}`;if(("_id"===n.property?.name||"_id"===o)&&!isFilterObject(s))return this.convertIdFilter(l,n,s);if("collection"===n.type)return this.convertCollectionFilter(l,n,s);return this.convertAnyFilter(l,n,s)}static typeDefaultValue(e,t){if(t.isNullable)return null;switch(t.type||t.property?.columnType){case"string":return"";case"float":case"double":case"integer":case"short":case"enum":return 0;case"decimal":return xtrem_decimal_1.Decimal.make(0);case"boolean":return false;case"date":return sql_resolver_1.SqlResolver.getNullDate(sql_resolver_1.SqlResolver.getX3Pool(e).dialect);case"datetime":{const t=sql_resolver_1.SqlResolver.getNullDate(sql_resolver_1.SqlResolver.getX3Pool(e).dialect);return xtrem_date_time_1.Datetime.makeUtc(t.year,t.month,t.day)}case"uuid":return xtrem_core_1.Uuid.generate();case"binaryStream":return xtrem_core_1.BinaryStream.fromBuffer(Buffer.alloc(0));case"textStream":return xtrem_core_1.TextStream.fromString("");default:throw new Error(`unsupported type ${t.type}`)}}booleanSqlValue(e){return e?1:0}jsonReferenceSqlValue(e){return"string"==typeof e?(0,xtrem_ts_to_sql_1.quote)(e):e}enumSqlValue(e,t,r,o){if(!o)return SqlConverter.typeDefaultValue(this.context,{property:e,type:t,isNullable:r.isNullable});if(!Number.isFinite(Number(o))){const t=e.dataType;return SqlConverter.convertNumberParameter(r,t.numberValue(o))}return SqlConverter.convertNumberParameter(r,o)}sqlValue(e,t){const{property:r}=e;if(!r?.type&&!e.type)throw new Error(`${e.path}: cannot establish type`);const o=sql_resolver_1.SqlResolver.getType(e);if(null==t)return SqlConverter.typeDefaultValue(this.context,{property:r,type:o,isNullable:e.isNullable});switch(o){case"boolean":{if("boolean"!=typeof t&&"string"!=typeof t)logWrongType(o,e.path,t);const r="string"==typeof t?"true"===t.toLowerCase():Boolean(t);return this.addLiteralParameter(r)}case"enum":if(!r)throw new Error(`${e.path}: enum property not set`);return this.addLiteralParameter(this.enumSqlValue(r,o,e,t));case"string":return this.addLiteralParameter(String(t||" ").replaceAll(storage_1.X3StorageManager.hashtagPlaceholder,"#"));case"decimal":case"time":case"textStream":return this.addLiteralParameter(String(t));case"short":case"float":case"double":case"integer":return this.addLiteralParameter(SqlConverter.convertNumberParameter(e,t));case"date":{let e=t.toString();if("string"==typeof t)e=e.includes("T")?xtrem_date_time_1.DateValue.parse(t,void 0,"YYYY-MM-DDThh:mm:ss.SSSZ").toString():xtrem_date_time_1.DateValue.parse(t).toString();return this.dateConverter.convertToDate(this.addLiteralParameter(e))}case"datetime":{const e="string"==typeof t?xtrem_date_time_1.Datetime.parse(t).toString():t.toString();return this.dateConverter.convertToDate(this.addLiteralParameter(e),true)}case"json":case"jsonReference":return this.addLiteralParameter(this.jsonReferenceSqlValue(t));default:throw new Error(`${e.path}: cannot convert type ${o} to SQL`)}}convertRegExpOps(e,t){const r=t._options||"",o=sql_resolver_1.SqlResolver.getType(e);return this.regexConverter.convertRegex(String(t._regex),r,{sql:e.sql,type:o}).sql}static jsonCast(e,t){throw new Error("NYI: JSON Conversion")}convertValue(e,t,r){const o=sql_resolver_1.SqlResolver.getType(t),getExpression=(e,r)=>{if("boolean"===t.property?.type&&t.property?.getValue){const t=this.fetchParameterUsingArgKey(r);let o=r;if(t)o=null!=t.literalValue?String(t.literalValue):o;return"1"===o?e:`(NOT (${e}))`}return`${e} = ${r}`};if(null===r)return`${sql_resolver_1.SqlResolver.convertToConversionPair(this.context,t.sql,o||"string",["1","0"])}=1`;if(("_id"===t.property?.name||"reference"===t.type)&&"string"==typeof r&&"#"===r[0]){if(!t.factory)throw new Error(`${t.path}: missing target factory`);const o=t.factory.parseNodeId(r);return this.convertFilterObject(e,t,o)}const n=this.sqlValue(t,r),s="json"===t.type||"jsonReference"===t.type?SqlConverter.jsonCast(t.sql,n):t.sql;if(t.denormalizeChildSlots&&t.denormalizeChildSlots.length>0){const e=t.denormalizeChildSlots.map(e=>{const t="json"===e.type||"jsonReference"===e.type?SqlConverter.jsonCast(e.sql,n):e.sql;return getExpression(t,n)});return SqlConverter.or(e)}return getExpression(s,n)}static checkArray(e,t){if(!Array.isArray(t))throw new Error(`${e.path}: values is not an array`)}convertXinFilter(e,t,r,o){const n=sql_resolver_1.SqlResolver.getType(t),s=r[o];if(SqlConverter.checkArray(t,s),0===s.length)return"_in"===o?"1=0":"1=1";if(s.indexOf(null)>=0){const r=s.filter(e=>null!==e),l=this.convertFilterObject(e,t,"_in"===o?{_eq:null}:{_ne:null});if(0===r.length)return l;const a=`(${r.map(e=>this.sqlValue(t,e)).join(",")})`;if("_in"===o){const e=`(${t.sql} IN ${a})`;return SqlConverter.or([l,e])}const i=`(${t.sql} NOT IN ${a} OR ${sql_resolver_1.SqlResolver.convertToConversionPair(this.context,t.sql,n,["1","0"])}=1)`;return SqlConverter.and([l,i])}const l=`(${s.map(e=>this.sqlValue(t,e)).join(",")})`;return"_in"===o?`(${t.sql} IN ${l})`:`(${t.sql} NOT IN ${l} OR ${sql_resolver_1.SqlResolver.convertToConversionPair(this.context,t.sql,n,["1","0"])}=1)`}convertAndFilter(e,t,r){SqlConverter.checkArray(t,r);const o=r.map((r,o)=>this.convertFilterObject(`${e}._and.${o}`,t,r));return SqlConverter.and(o)}convertOrFilter(e,t,r){SqlConverter.checkArray(t,r);const o=r.map((r,o)=>this.convertAnyFilter(`${e}._and.${o}`,t,r));return SqlConverter.or(o)}convertModFilter(e,t){if(SqlConverter.checkArray(e,t),2!==t.length)throw new Error(`${e.path}: expected 2 values in array, got ${t.length}`);const r=t.map(t=>this.sqlValue(e,t));return`(${e.sql} % ${r[0]} = ${r[1]})`}convertNotFilter(e,t,r){return`(NOT (${this.convertFilterObject(`${e}._not`,t,r)}))`}convertBinaryOpFilter(e,t,r){const{property:o}=e;if(!o)throw new Error(`${e.path}: Property not set on slot`);const n=sql_resolver_1.SqlResolver.getType(e),s=binaryOps[r];let l=t[r];const a=e.parent||e,getNullValue=()=>{let t=1;if("_ne"===r)t=0;if(e.denormalizeChildSlots&&e.denormalizeChildSlots.length>0)return SqlConverter.or(e.denormalizeChildSlots.map(e=>`${sql_resolver_1.SqlResolver.convertToConversionPair(this.context,e.sql,n,["1","0"])}=${t}`));return`${sql_resolver_1.SqlResolver.convertToConversionPair(this.context,e.sql,n,["1","0"])}=${t}`};if("_id"===o.name){const t=String(l).split("|"),o=e.factory?.keyProperties.map((e,o)=>{const n=this.withThisResultScope(a,()=>this.convertOutputPath([e.name]));return this.convertBinaryOpFilter(n,{[r]:this.convertIdValue(n,t[o])},r)}).join(" AND ");if(!o)return getNullValue();return`(${o})`}if(null==l){if(e.isNullable||e.path&&e.path.split(".").length>2)return getNullValue();l=SqlConverter.typeDefaultValue(this.context,{property:o,type:n,isNullable:e.isNullable})}const i=this.sqlValue(e,l),getOpSql=e=>{const t="json"===e.type||"jsonReference"===e.type?SqlConverter.jsonCast(e.sql,l):e.sql;return s(this.context,!!e.isNullable,n,t,i)};if(e.denormalizeChildSlots&&e.denormalizeChildSlots.length>0)return SqlConverter.or(e.denormalizeChildSlots.map(getOpSql));return getOpSql(e)}convertNorFilter(e,t,r){SqlConverter.checkArray(t,r);const o=r.map((r,o)=>this.convertAnyFilter(`${e}._nor.${o}`,t,r));return SqlConverter.and(o.map(e=>`(NOT (${e}))`))}convertOperatorFilter(e,t,r,o){if(binaryOps[o])return this.convertBinaryOpFilter(t,r,o);const n=r[o];switch(o){case"_in":case"_nin":return this.convertXinFilter(e,t,r,o);case"_and":return this.convertAndFilter(e,t,n);case"_or":return this.convertOrFilter(e,t,n);case"_nor":return this.convertNorFilter(e,t,n);case"_mod":return this.convertModFilter(t,n);case"_not":return this.convertNotFilter(e,t,n);case"_regex":return this.convertRegExpOps(t,r);case"_options":if(!r._regex)throw new Error(`${t.path}: _options without _regex`);return"";case"_fn":if("string"!=typeof n)throw new Error(`${t.path}: _fn value is not a string`);return this.convertFunctionBody(t,n).sql;default:throw new Error(`${t.path}: invalid operator: ${o}`)}}convertFilterObject(e,t,r){const o=Object.keys(r);if(0===o.length||1===o.length&&"denormalizedIndex"===o[0]){if(t.parent&&(!t.path||!this.results.get(t.path)))this.makeAliasAndJoin(t);return"1=1"}const{factory:n}=t;if(!n)throw new Error(`${t.path}: missing target factory`);const s=o.filter(e=>"denormalizedIndex"!==e).map(o=>{if("_"===o[0]&&!SqlConverter.isSystemOrTechnicalColumn(o))return this.convertOperatorFilter(e,t,r,o);return this.convertPropertyFilter(e,t,r,o)}).filter(e=>!!e);return SqlConverter.and(s)}convertFunctionValue(e,t){const r=this.convertFunction(t).sql,o="json"===e.type||"jsonReference"===e.type?SqlConverter.jsonCast(e.sql,r):e.sql,n=`${o} = ${r}`;return e.isNullable?`(${n} OR (${o} IS NULL AND ${r} is NULL))`:n}convertLiteral(e){if("string"==typeof e)return super.convertLiteral(e.replaceAll(storage_1.X3StorageManager.hashtagPlaceholder,"#"));return super.convertLiteral(e)}convertJoinLiteralValue(e,t){const r=this.convertLiteral(t.value).sql,o="json"===e.type||"jsonReference"===e.type?SqlConverter.jsonCast(e.sql,r):e.sql,n=`${o} = ${r}`;return e.isNullable?`(${n} OR (${o} IS NULL AND ${r} is NULL))`:n}convertAnyFilter(e,t,r){if(r instanceof RegExp)return this.convertAnyFilter(e,t,{_regex:r.source,_options:r.flags});if(r instanceof xtrem_core_1.Node)return this.convertFilterObject(e,t,{_id:r._id});if("function"==typeof r)return this.convertFunctionValue(t,r);if(r instanceof xtrem_core_1.JoinLiteralValue)return this.convertJoinLiteralValue(t,r);if(isFilterObject(r))return this.convertFilterObject(e,t,r);return this.convertValue(e,t,r)}convertFilter(e,t){if("string"==typeof t)return t;if("function"==typeof t)return super.convertFunction(t).sql;if(!(t&&"object"==typeof t))throw new Error(`filter is not an object: ${t&&typeof t}`);const r={factory:this.rootFactory,type:"reference",sql:"t0",path:"this",alias:"t0"};return this.convertFilterObject(e,r,t)}convertFilters(e){return e.map((e,t)=>this.convertFilter(`filters.${t}`,e))}convertOrderBy(e){const t=[],convertOne=(e,r,o)=>{Object.keys(o).forEach(n=>{const s=[...r,n],l=this.withThisResultScope(e,()=>this.walk(e,n)),a=o[n];if(a&&"object"==typeof a)convertOne(l,s,a);else if(-1===a||1===a){if(!l.property)throw new Error(`${s}: 'Missing property in result.`);t.push({property:l.property,path:s,direction:a,sql:"denormalizedIndex"!==l.property?.name?l.sql:"1",columnAlias:l.columnAlias||sql_resolver_1.SqlResolver.makeColumnAlias(`${l.property?.name.toUpperCase()}_0`,this.dialect)})}else throw new Error(`${s}: invalid value: ${a})`)})},r=super.convertThisExpression();return convertOne(r,[],e),t}convertOutputPath(e){let t=super.convertThisExpression();return e.forEach(e=>{t=this.walk(t,e)}),{...t,payloadPath:e}}convertOutputPaths(e){return e.map(e=>this.convertOutputPath(e))}convertAggregateGroups(e){return e.map(e=>sql_resolver_1.SqlResolver.resolveAggregate(this.context,this.convertOutputPath(e.path),e.groupedBy||"value"))}convertAggregate(e){if(!e)return{};return{groups:e.groups.map(e=>sql_resolver_1.SqlResolver.resolveAggregate(this.context,this.convertOutputPath(e.path),e.groupedBy||"value")),values:e.values.map(e=>sql_resolver_1.SqlResolver.resolveAggregate(this.context,this.convertOutputPath(e.path),e.operator||"distinctCount"))}}withSubQueryScope(e){const t=super.withSubQueryScope(e);return{...t,aliases:t.aliases.replace(/ AS /g," ").trim(),joinCondition:t.joinCondition}}static getLanguageFromLocale(e){if(!xtrem_core_1.Context.localizationManager.getLanguageFromLocale||true===e.globals.localizationManagerBusy)return"ENG";return e.currentLanguageCode}static getDefaultFolderLanguage(e){if(!xtrem_core_1.Context.localizationManager.getFolderDefaultLanguage||true===e.globals.localizationManagerBusy)return"FRA";return e.defaultLanguageCode}resolveColumnName(e,t){return this.resolver.resolveColumnName(this.context,e,t)}resolveTableName(e){return this.resolver.resolveTableName(e)}static and(e){return SqlConverter.joinThis(e," AND ","1=1")}static or(e){const t=SqlConverter.joinThis(e," OR ","1=0");return e.length>1?`(${t})`:t}static joinThis(e,t,r){const o=e.filter(e=>!!e);if(o.length>1)return`${o.join(t)}`;if(1===o.length&&o[0])return o[0];return r}static convertCompositePath(e,t){const{factory:r}=e,o=r?.externalStorageManager,{compositeReferencePaths:n}=o;if(n[t])return n[t];return[t]}resolveJoinElement(e,t,r,o){if("string"==typeof r){const o=this.resolveColumnName(e,r);if(t.childDenormalizedIndex&&t.childDenormalizedIndex>0&&o.denormalizeChildSlots&&o.denormalizeChildSlots.length>=t.childDenormalizedIndex)return o.denormalizeChildSlots[t.childDenormalizedIndex-1].sql;return o.sql}if("function"==typeof r){const n=this.withThisResultScope(e,()=>this.convertFunction(r).sql);if("null"===n.toLowerCase()){const e=t.factory.findProperty(o,{includeSystemProperties:true});return sql_value_converter_1.SqlValueConverter.toSql(this.context,t.factory,e,null)}const s=this.resolveColumnName(t,o),l=this.fetchParameterUsingArgKey(n);if("enum"===s.property?.type&&l?.literalValue&&"string"==typeof l.literalValue){const e=s.property?.dataType,t=l.literalValue.replace(/^[`']|[`']$/g,"");if(e.numberValue(t)>=0){const r=this.sqlParameters.findIndex(e=>e.sql===l.sql);if(r>=0)this.sqlParameters[r].literalValue=e.numberValue(t)}}return n}if(r instanceof xtrem_core_1.JoinLiteralValue)return this.convertJoinLiteralValue(t,r);throw new Error(`Join of ${t.property?.name} cannot be resolved. ${o}`)}constructJoin(e,t,r){const o=[],n={alias:t.join?.left.alias,sqls:[]},s={alias:t.join?.right.alias||"",sqls:[]},l=t.property?.join||{};return Object.keys(l).filter(e=>!r?.joinsToExclude||!r.joinsToExclude.includes(e)).forEach(r=>{const a=this.resolveColumnName(t,r),i=a.sql;n.sqls.push(i);const getJoinSql=t=>{let o=this.resolveJoinElement(e,t,l[r],r);if("enum"===t.property?.type&&"string"==typeof o){const e=a.property?.dataType;if(o=o.replace(/^[`']|[`']$/g,""),e.numberValue(o)>=0)o=e.numberValue(o).toString()}return o};if(t.denormalizeChildSlots&&t.denormalizeChildSlots.length>0){const e=t.denormalizeChildSlots.map(getJoinSql).join(",");s.sqls.push(e);const r=`${i} IN (${e})`;o.push(r)}else{const e=getJoinSql(t);s.sqls.push(e||"");const r=`${i} = ${e}`;o.push(r)}}),{...t.join||{isNullable:true},condition:SqlConverter.and(o),left:n,right:s}}manageReferenceJoinFallbackProperties(e,t){const{factory:r}=t,o=t.property?.join||{},n=r.externalStorageManager.joinFallbackProperties,s="r0",l={...t,alias:s};t.join=this.constructJoin(e,t,{joinsToExclude:n});const a=[this.constructJoin(e,l,{joinsToExclude:n}).condition],i=[];n.forEach(t=>{const n=this.resolveColumnName(l,t).sql,s=sql_resolver_1.SqlResolver.orderByDirections(this.context),c=r.findProperty(t,{includeSystemProperties:true}),u=sql_resolver_1.SqlResolver.getPropertyType(c),h=sql_resolver_1.SqlResolver.nullValue(this.context,u),p=[];let v=s.desc;if(void 0!==o[t]){const r=this.resolveJoinElement(e,l,o[t],t);if(p.push(`${n} = ${h}`),r!==h&&"null"!==r.toLowerCase())p.push(`${n} = ${r}`)}else v=s.asc;if(i.push(`${n} ${v}`),p.length>0)a.push(SqlConverter.or(p))});const c=sql_resolver_1.SqlResolver.getX3Pool(this.context),u=sql_resolver_1.SqlResolver.limitClause(1,c.dialect),h=sql_resolver_1.SqlResolver.fetchOnlyClause(1,c.dialect);if(!r.tableName)throw new Error(`${t.path}: target factory tableName not set.`);const p=this.resolveTableName(r);r.keyProperties.filter(e=>"denormalizedIndex"!==e.name).forEach(e=>{const r=this.resolveColumnName(t,e.name).sql,o=this.resolveColumnName({...t,alias:s},e.name).sql;a.push(`${r} = ${o}`)});const v=`SELECT ${u} * FROM ${p} ${s} WHERE ${SqlConverter.and(a)} ORDER BY ${i.join()} ${h}`,m=SqlConverter.and([t.join.condition,`EXISTS(${v})`]);t.join={...t.join,condition:m,left:{...t.join.left,sqls:[]},right:{...t.join.right,sqls:[]}}}convertReferenceProperty(e,t){const{factory:r}=t,o=r?.externalStorageManager,{joinFallbackProperties:n}=o;if(n&&n.length>0)this.manageReferenceJoinFallbackProperties(e,t);else t.join=this.constructJoin(e,t);return t}convertForeignNodeProperty(e,t){if("reference"===t.property?.type)return this.convertReferenceProperty(e,t);return t.join=this.constructJoin(e,t),t}convertId(e){const{parent:t}=e;if(!t)throw new Error(`${e.path}: parent not set.`);const r=t.factory;if(!r)throw new Error(`${e.path}: parent factory not set.`);const{keyProperties:o}=r,n=o.map(e=>this.resolveColumnName(t,e.name)),s=r.externalStorageManager,getIdSql=e=>this.concat(n.map(t=>{if("date"===t.type)return this.dateConverter.convertToChar(t);if("denormalizedIndex"===t.property?.name)return`'${e+1}'`;const r=sql_resolver_1.SqlResolver.getX3Pool(this.context);return sql_resolver_1.SqlResolver.toChar(t,r.dialect)}).map((e,t)=>{if(0===t)return e;return this.concat([(0,xtrem_ts_to_sql_1.quote)("|"),e])}));if(e.sql=getIdSql(0),e.columnAlias=sql_resolver_1.SqlResolver.makeColumnAlias(`${e.alias}._ID_0`,this.dialect),s.isDenormalized){e.sql="",e.columnAlias="",e.denormalizeChildSlots=[];const t=s.getMaxRepeat(this.context);for(let r=0;r<t;r+=1){const t=`${e.alias}._ID_${r}`;e.denormalizeChildSlots.push({...e,sql:getIdSql(r),columnAlias:sql_resolver_1.SqlResolver.makeColumnAlias(t,this.dialect),childDenormalizedIndex:r+1,path:`${e.path}.${r+1}`})}}}createReferenceJoin(e){if("string"===e.parent?.property?.type&&e.parent?.property?.isLocalized)return void(e.join=this.createLocalizedJoin(e,this.localizedStringLanguage));const{parent:t}=e;if(!t)throw new Error(`${e.path}: parent not set.`);const{join:r}=this.convertForeignNodeProperty(t,e);e.join={left:{alias:t.alias||"",sqls:[t.sql]},right:{alias:e.alias||"",sqls:[e.sql]},condition:r?.condition||"1=1",isNullable:!!e.property?.isNullable||!!t.join?.isNullable}}createCollectionJoin(e){const{parent:t}=e;if(!t)throw new Error(`${e.path}: parent not set.`);this.scopeAlias={tableName:this.resolver.resolveTableName(e.factory),alias:e.alias||"",join:this.constructJoin(t,e)}}mapLocalizedKey(e,t,r){const o=e.factory,n=o?.externalStorageManager,s=sql_resolver_1.SqlResolver.getX3Pool(this.context);return this.withThisResultScope(e,()=>t.map(t=>{if("function"==typeof t)return this.convertFunction(t).sql;if("string"==typeof t){if("denormalizedIndex"===t)return`${r}`;const l=this.resolveColumnName(e,t);let{sql:a}=l;if(n.isDenormalized&&!o?.keyProperties.find(e=>e.name===t)&&!SqlConverter.isSystemOrTechnicalColumn(t))a=`${l.alias}.${l.property?.columnName}_${r}`;if("date"===l.type||"reference"===l.type&&"date"===l.property?.columnType){const e="sqlServer"===s.dialect?"112":"YYYYMMDD";return this.dateConverter.convertToChar({...l,sql:a},e)}return a}return(0,xtrem_ts_to_sql_1.quote)(" ")}))}convertLocalizedStringKeyValue(e,t){if(0===e.length)return(0,xtrem_ts_to_sql_1.quote)(" ");const r=sql_resolver_1.SqlResolver.getX3Pool(this.context);return this.concat(e.map((e,o)=>{if(0===o)return sql_resolver_1.SqlResolver.toChar({sql:e,type:"string"},r.dialect);return this.concat([(0,xtrem_ts_to_sql_1.quote)(t),sql_resolver_1.SqlResolver.toChar({sql:e,type:"string"},r.dialect)])}))}createLocalizedJoin(e,t){const r=[],o={alias:e.alias,sqls:[]},n=e.parent;if(!n)throw new Error(`${e.path}: missing parent.`);const s=super.convertThisExpression();s.childDenormalizedIndex=n.childDenormalizedIndex;const l=n.parent??s;if(!l)throw new Error(`${e.path}: Missing node parent.`);const a={alias:l.alias,sqls:[]},i=n.factory,c=i.externalStorageManager,u=n.property?.name||"",h=c.getLocalization(u),p=h?h.tableName:i.tableName,v=h?h.columnName:n.property?.columnName,m=" ";let d=[],f=[];const q=l.childDenormalizedIndex?l.childDenormalizedIndex-1:0;if(h){if(!h.key1||!h.key1.length)throw new Error(`${i.name}.${u}: localization attribute key1 details not supplied for property.`);if(d=this.mapLocalizedKey(l,h.key1??[],q),h.key2&&h.key2.length)f=this.mapLocalizedKey(l,h.key2??[],q)}else{if(i.keyProperties.length>2)throw new Error(`${i.name}.${u}: localization details not supplied for property and key properties are more than 2.`);if(d=this.mapLocalizedKey(l,[i.keyProperties[0].name],q),i.keyProperties.length>=2)f=this.mapLocalizedKey(l,i.keyProperties.slice(1).map(e=>e.name),q)}const addJoin=(t,n)=>{o.sqls.push(`${e.alias}.${t}`),a.sqls.push(n),r.push(`${e.alias}.${t} = ${n}`)};addJoin("CODFIC_0","function"==typeof p?this.withThisResultScope(l,()=>this.convertFunction(p).sql):(0,xtrem_ts_to_sql_1.quote)(p?.toUpperCase()??m));addJoin("ZONE_0","function"==typeof v?this.withThisResultScope(l,()=>this.convertFunction(v).sql):(0,xtrem_ts_to_sql_1.quote)(v?.toUpperCase()??m));const g=h&&h.concatenator?h.concatenator:"~";addJoin("IDENT1_0",this.convertLocalizedStringKeyValue(d,g));return addJoin("IDENT2_0",this.convertLocalizedStringKeyValue(f,g)),addJoin("LANGUE_0",(0,xtrem_ts_to_sql_1.quote)(t)),{condition:SqlConverter.and(r),left:a,right:o,isNullable:true}}withLocalizedStringScope(e,t){this.localizedStringLanguage=e;try{return t()}finally{this.localizedStringLanguage=e}}createLocalizedStringAliasAndJoin(e,t){const r={parent:e,factory:{tableName:"ATEXTRA"},path:`${e.path}.${t}`,sql:""};return this.withLocalizedStringScope(t,()=>this.makeAliasAndJoin(r)),r}getLocalizedStringSql(e,t,r){const o=`${this.createLocalizedStringAliasAndJoin(e,t).alias}.TEXTE_0`;if(t===r)return o;return`(CASE WHEN (${o} IS NOT NULL) THEN ${o} ELSE ${`${this.createLocalizedStringAliasAndJoin(e,r).alias}.TEXTE_0`} END)`}convertLocalizedString(e){const{path:t}=e;if(!t)throw new Error("cannot convert localized string property: no path");if(this.results.get(t))return;const r=SqlConverter.getDefaultFolderLanguage(this.context),o=SqlConverter.getLanguageFromLocale(this.context);if(e.denormalizeChildSlots&&e.denormalizeChildSlots.length>0)e.sql="",e.columnAlias="",e.denormalizeChildSlots.forEach(e=>{if(this.results.get(e.path))return;e.sql=this.getLocalizedStringSql(e,o,r),this.results.set(e.path,e)});else e.sql=this.getLocalizedStringSql(e,o,r);this.results.set(t,e)}convertBinaryExpression(e){const t=this.convertExpression(e.left),r=this.convertExpression(e.right),o=e.operator,n=t.property&&sql_resolver_1.SqlResolver.getPropertyType(t.property);if("boolean"===n&&"Literal"===e.right.type&&["===","!=="].includes(o)){const e="==="===o?"=":"!=";return xtrem_ts_to_sql_1.Converter.booleanResult(`(${t.sql} ${e} ${this.cast(r,t.type).sql})`)}if(["==","!="].includes(o)&&"null"===r.sql.trim().toLowerCase()){const e="=="===o?"1":"0";return xtrem_ts_to_sql_1.Converter.booleanResult(`${sql_resolver_1.SqlResolver.convertToConversionPair(this.context,t.sql,n??t.type,["1","0"])} = ${e}`)}return super.convertBinaryExpression(e)}convertToBooleanExpression(e){const t=super.convertToBooleanExpression(e);if(t.property&&"boolean"===sql_resolver_1.SqlResolver.getPropertyType(t.property))return t.sql=`(${t.sql} = 1)`,t;return t}walk(e,t){const r=SqlConverter.convertCompositePath(e,t);if(r.length>1)return this.withThisResultScope(e,()=>this.convertOutputPath(r));const o=super.walk(e,t);if(o.property?.isLocalized)this.convertLocalizedString(o);if("_id"===o.property?.name)this.convertId(o);return o}concat(e){if(0===e.length)return"";if(1===e.length)return e[0];const t=e.slice(),r=t.pop();return`CONCAT(${this.concat(t)},${r})`}}exports.SqlConverter=SqlConverter;
//# sourceMappingURL=sql-converter.js.map