import { AccessRightsManager, AnyValue, Context, NodeFactory, Property } from '@sage/xtrem-core';
import { ConversionResultType, GenericConversionResult } from '@sage/xtrem-ts-to-sql';
export interface ConversionResult extends GenericConversionResult<NodeFactory, Property> {
    compositePath?: string[];
    childDenormalizedIndex?: number;
    denormalizeChildSlots?: ConversionResult[];
}
export interface UserAccessCode {
    accessCode: string;
    modification: boolean;
    execution: boolean;
    inquiry: boolean;
}
export interface X3AccessRightsManager extends AccessRightsManager {
    (context: Context): Promise<UserAccessCode[] | null>;
    getUserAccessCodes(context: Context): Promise<UserAccessCode[] | null>;
}
export interface OutputColumn extends ConversionResult {
    payloadPath?: string[];
}
export interface AggregateResult {
    joinConditions?: string;
    groups?: ConversionResult[];
    values?: ConversionResult[];
}
/**
 * Describes a SQL statement parameter
 */
export interface SqlParameter {
    /** The path to the parameter's value */
    valuePath: string;
    /** The type of the parameter's value */
    type: ConversionResultType | 'encryptedString';
    sql: string;
    /** Optional factory name, if the value is a reference */
    factoryName?: string;
    property?: Property;
    /** Sub-path for composite value like regex */
    subPath?: string;
    /** Is the value an array ? */
    isArray?: boolean;
    /** Value, only for literals */
    literalValue?: AnyValue;
}
//# sourceMappingURL=sql-converter.d.ts.map