/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.WebServiceResponse=void 0;const xtrem_core_1=require("@sage/xtrem-core"),jsxml=require("js-xml"),_=require("lodash"),index_1=require("../../index"),web_service_mapping_1=require("./web-service-mapping"),logger=xtrem_core_1.Logger.getLogger(__filename,"web-service");class WebServiceResponse{static buildWebServiceResponse(e,s,r){return{statusCode:e,results:s,messages:r}}static buildErrorWebServiceResponse(e){return{statusCode:0,results:{},messages:{errors:[e]}}}static processReceivedData(e,s){let r,i,t,o=false,a=0;if(s.headers.isMock)return s.data;if(s.data.indexOf("<!doctype html>")<0)r=jsxml.parse(s.data);else o=true;if(!o&&_.indexOf(index_1.data.availableActionTypes,e||"")>=0&&index_1.data){logger.verbose(()=>`DATA \n ${JSON.stringify(r)}`);const s=r["soapenv:Envelope"]["soapenv:Body"],o=s[`wss:${e}Response`][`${e}Return`];let n=s.multiRef,c={};if(n){const e=[],s=[],r=[];if(!Array.isArray(n))n=[n];n.forEach(i=>{if(i.type>2)e.push(i.message);else if(2===i.type)s.push(i.message);else r.push(i.message)}),c={errors:e,warnings:s,info:r}}else if(r.messages&&r.messages.errors)if(!Array.isArray(r.messages.errors))c={errors:[r.messages.errors]};else c={errors:r.messages.errors};if(o.resultXml.$cdata)if(a=o.status.$value,i=_.indexOf(index_1.data.availableActionTypesWithNonJSONReturn,e)>=0?jsxml.parse(o.resultXml.$cdata):JSON.parse(o.resultXml.$cdata),Object.keys(c).length>0)t=WebServiceResponse.buildWebServiceResponse(a,i,c);else if(0===a)t=WebServiceResponse.buildErrorWebServiceResponse(index_1.data.errorsMessages.unknownError);else t=WebServiceResponse.buildWebServiceResponse(a,i);else if(Object.keys(c).length>0)if(i=s,c.errors&&c.errors.length>0)t=WebServiceResponse.buildWebServiceResponse(0,{},c);else t=WebServiceResponse.buildWebServiceResponse(1,i,c);else t=WebServiceResponse.buildErrorWebServiceResponse(index_1.data.errorsMessages.unknownError)}else if(o)t=WebServiceResponse.buildErrorWebServiceResponse(index_1.data.errorsMessages.wrongCredentials);else t=WebServiceResponse.buildErrorWebServiceResponse(index_1.data.errorsMessages.undefinedAction);return t}static legacyToXtremCompatibleErrorMessage(e,s,r){if(0===e.statusCode)e.messages?.errors?.forEach((i,t)=>{const o={},a=i.match(/\[([^\s]+)/g);let n,c,l=1;if(a){const e=a[0].match(/\(.\)/g);if(e)l=Number(e[0].replace(/[\(\)']+/g,"")),c=a[0].match(/\]([^\s]+)\(/g);else c=a[0].match(/\]([^\s]+)/g);if(c)n=c[0].replace(/[\]\(']+/g,""),Object.keys(s||{}).forEach(e=>{const i=r.payload[e];Object.keys(s[e]||{}).forEach(r=>{if(i&&r===n){const t=s[e][r].substr(1);if("Table"===i.type)(i.lines||[]).forEach(i=>{if(Number(i.lineNumber)===l||1===l){const{collectionName:a}=s[e],n=s[e].lineNumber;o[a]={[t]:i.fields[r],[n]:l}}});else if("List"===i.type)o[t]=i.fields[r]}})})}if(0===Object.keys(o||{}).length)o.description=i;else o.description=i.replace(/\&(.*)/g,"");e.messages.errors[t]=JSON.stringify(o)})}static buildXtremResponse(e,s){const r=e.results,i={};if(!r)throw new Error("The web service service responds with an empty results.");return(Object.keys(e.results)||{}).forEach(e=>{if("ADXTEC"!==e){const t=r[e];if(!Array.isArray(t))(Object.keys(t)||{}).forEach(r=>{let o=s[e][r];if(o)o=web_service_mapping_1.WebServiceMapping.removeStatusFromMapping(o),i[o.split(".")[0]]=t[r]});else{const r=s[e]?.collectionName,o=s[e]?.lineNumber;if(!r)throw new Error(`The collection name of the group ${e} is missing is the mapping file.`);if(!o)throw new Error(`The lineNumber name of the group ${e} is missing is the mapping file.`);i[r]=[],(t||[]).forEach((a,n)=>{i[r][n]={},i[r][n][o]=n,(Object.keys(a)||{}).forEach(o=>{let a=s[e][o];if(a)a=web_service_mapping_1.WebServiceMapping.removeStatusFromMapping(a),i[r][n][a.split(".")[0]]=t[n][o]})})}}}),i}}exports.WebServiceResponse=WebServiceResponse;
//# sourceMappingURL=web-service-response.js.map