/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.WebServiceRequest=void 0;const xtrem_core_1=require("@sage/xtrem-core"),fs=require("fs"),_=require("lodash"),path=require("path"),graphql_payload_to_legacy_import_processing_1=require("./graphql-payload-to-legacy-import-processing"),web_service_mapping_1=require("./web-service-mapping"),web_service_response_1=require("./web-service-response"),logger=xtrem_core_1.Logger.getLogger(__filename,"web-service");class WebServiceRequest{static buildWebServiceInputXML(e,t){const i=[],sanitizeField=e=>e.replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;").replace(/"/g,"&quot;").replace(/'/g,"&apos;");if(Object.keys(e||{}).forEach(t=>{const s=e[t];if("Table"===s.type){const e=s.lines||[];let r=false;if(!_.isEmpty(e))if(i.push(`<TAB ID="${t}">`),e.forEach((e,t)=>{let s=false;if(i.push(`<LIN NUM="${e.lineNumber?e.lineNumber:t+1}">`),Object.keys(e.fields||{}).forEach(t=>{const a=e.fields[t].toString();if(""!==a){s=true,r=true;const e=sanitizeField(a);i.push(`<FLD NAME="${t}">${e}</FLD>`)}}),s)i.push("</LIN>");else i.pop()}),r)i.push("</TAB>");else i.pop()}if("List"===s.type){const e=s.fields||{};let r=false;if(i.push(`<GRP ID="${t}">`),Object.keys(e||{}).forEach(t=>{const s=e[t].toString();if(""!==s){r=true;const e=sanitizeField(s);i.push(`<FLD NAME="${t}">${e}</FLD>`)}}),r)i.push("</GRP>");else i.pop()}return null}),!t)return`\n            <objectXml xsi:type="xsd:string">\n                <![CDATA[<?xml version="1.0" encoding="UTF-8"?>\n                    <PARAM>\n                        ${i.join(" ")}\n                    </PARAM>\n                ]]>\n            </objectXml>`;return`\n            <inputXml xsi:type="xsd:string">\n                <![CDATA[<?xml version="1.0" encoding="UTF-8"?>\n                    <PARAM>\n                        ${i.join(" ")}\n                    </PARAM>\n                ]]>\n            </inputXml>`}static buildWebServiceKeysXML(e){const t=[];return Object.keys(e||{}).forEach(i=>{if(!_.isEmpty(_.toString(e[i])))t.push(`<item>\n                <key>${i}</key>\n                <value>${e[i]}</value>\n            </item>`)}),`<objectKeys xsi:type="wss:ArrayOfCAdxParamKeyValue" soapenc:arrayType="wss:CAdxParamKeyValue[]">\n            ${t.join(" ")}\n        </objectKeys>`}static buildWebServiceRequestXML(e,t,i){const{codeLang:s,poolAlias:r}=e.webServicePoolParameters;return`\n            <soapenv:Envelope xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" xmlns:wss="http://www.adonix.com/WSS" xmlns:soapenc="http://schemas.xmlsoap.org/soap/encoding/">\n                <soap:Header/>\n                    <soapenv:Body>\n                        <wss:${t} soapenv:encodingStyle="http://schemas.xmlsoap.org/soap/encoding/">\n                            <callContext xsi:type="wss:WebServicePoolParameters">\n                                <codeLang xsi:type="xsd:string">${s}</codeLang>\n                                <poolAlias xsi:type="xsd:string">${r}</poolAlias>\n                                <poolId xsi:type="xsd:string"></poolId>\n                                <requestConfig xsi:type="xsd:string">adxwss.optreturn=JSON&adxwss.request.origin=xtreem</requestConfig>\n                            </callContext>\n                            <publicName xsi:type="xsd:string">${e.webServiceName}</publicName>\n                            ${i}\n                        </wss:${t}>\n                    </soapenv:Body>\n            </soapenv:Envelope>\n            `}static buildXML(e,t,i){switch(t){case"modify":return WebServiceRequest.buildWebServiceRequestXML(e,"modify",WebServiceRequest.buildWebServiceKeysXML(i.keys)+WebServiceRequest.buildWebServiceInputXML(i.payload));case"save":return WebServiceRequest.buildWebServiceRequestXML(e,"save",WebServiceRequest.buildWebServiceInputXML(i.payload));case"run":return WebServiceRequest.buildWebServiceRequestXML(e,"run",WebServiceRequest.buildWebServiceInputXML(i.payload,true));default:throw new Error(`invalid action: ${t}`)}}static isMappedValueValidated(e,t,i,s){if("+"!==e.mapping[i][s][0]&&"!"!==e.mapping[i][s][0]){const r=t.package.dir,a=path.resolve(r,"data/gateway",`${e.webServiceName}-mapping.json`);throw new Error(`Please validate the mapping value of "${s}" in the group "${i}".\n                The mapping file is located in ${a}.\n                If it is already valid change '^' by '+' (like that: '${s}': '+${e.mapping[i]?.[s]}').\n                All the mapped value must begin with '+' instead of '^'.\n                If you don't want to send the value to the web service, put '!' instead of '+'.\n                Restarting the server after the changes is required.`)}}static graphqlToLegacyPayloadBuild(e,t,i,s){const r={payload:{},keys:{}};if(e.isImportBasedWebService){const t=graphql_payload_to_legacy_import_processing_1.GraphqlPayloadToLegacyImportProcessing.processing(e.mapping);r.payload={GRP1:{type:"List",fields:{I_MODIMP:e.importModelName,I_AOWSTA:"NO",I_EXEC:"REALTIME",I_RECORDSEP:t.eol,I_FILE:`${t.parseGraphqlPayload(s)}END`}}}}else Object.keys(e.mapping||{}).forEach(i=>{const a=[];if(e.mapping[i]?.collectionName){WebServiceRequest.isMappedValueValidated(e,t,i,"collectionName");(_.get(s,web_service_mapping_1.WebServiceMapping.removeStatusFromMapping(e.mapping[i].collectionName))||[]).forEach((s,r)=>{let o=r;const n={};Object.keys(e.mapping[i]||{}).forEach(r=>{if("!"!==e.mapping[i][r][0]){if("lineNumber"!==r&&"collectionName"!==r){WebServiceRequest.isMappedValueValidated(e,t,i,r);const a=_.get(s,web_service_mapping_1.WebServiceMapping.removeStatusFromMapping(e.mapping[i][r]));if(a)n[r]=web_service_mapping_1.WebServiceMapping.xtremToLegacyDataFormatting(a)}if("lineNumber"===r)WebServiceRequest.isMappedValueValidated(e,t,i,r),o=_.get(s,web_service_mapping_1.WebServiceMapping.removeStatusFromMapping(e.mapping[i].lineNumber))}}),a.push({fields:n,lineNumber:o})}),r.payload[i]={type:e.mapping[i]?.collectionName?"Table":"List",lines:a}}else{const a={};if(Object.keys(e.mapping[i]||{}).forEach(r=>{if("!"!==e.mapping[i][r][0]){WebServiceRequest.isMappedValueValidated(e,t,i,r);const o=_.get(s,web_service_mapping_1.WebServiceMapping.removeStatusFromMapping(e.mapping[i][r]));if(o)a[r]=web_service_mapping_1.WebServiceMapping.xtremToLegacyDataFormatting(o)}}),"keys"===i)r.keys=a;else r.payload[i]={type:e.mapping[i]?.collectionName?"Table":"List",fields:a}}});return e.soapPayload=r,{xmlPayload:WebServiceRequest.buildXML(e,i,r),jsonPayload:r}}static writeAxiosMockData(e,t,i,s){if(e.headers?.Authorization)delete e.headers.Authorization;let r;if(!fs.existsSync(path.join(i,"axios")))fs.mkdirSync(path.join(i,"axios"));if(!fs.existsSync(path.join(i,"axios",`${s}.json`)))r=[];else r=JSON.parse(fs.readFileSync(path.join(i,"axios",`${s}.json`),"utf8").toString());r.push({request:e,response:{headers:{isMock:true},data:t}}),fs.writeFileSync(path.join(i,"axios",`${s}.json`),JSON.stringify(r,null,4))}static async x3WebServiceRequest(e,t,i){const{userName:s,password:r}=e.webServicePoolParameters.userCredentials,{webServiceURL:a,token:o,timeout:n}=e.webServicePoolParameters;let p=`Basic ${Buffer.from(`${s}:${r}`).toString("base64")}`;if(o)p=`Bearer ${o}`;const c={"Content-Type":"text/xml;charset=UTF-8",Authorization:p,SOAPAction:"SOAPAction",Connection:"Keep-Alive"},l=xtrem_core_1.Mocker.get("axios",require),u={method:"post",url:a,headers:c,data:t,timeout:n},g=3,d=1e3;let m,b=0;if(l.interceptors)m=l.interceptors.response.use(void 0,e=>{if(b+=1,logger.info(`SOAP Request Error: Retry  ${b} /${g}  action:  ${i}`),b<g)return new Promise(e=>{setTimeout(()=>{e(l(u))},d)});return Promise.reject(e instanceof Error?e:new Error(String(e)))});logger.verbose(()=>`XML REQUEST ${t}`);const v=web_service_response_1.WebServiceResponse.processReceivedData(i,await l(u)),{context:f}=e;if(f.testMode&&f.testConfig){const{directory:e,testAttributes:t,mocks:i,scenario:s}=f.testConfig;if(t?.createMockData){if(!e||!s)throw new Error("Cannot generate axios mock data, both directory and scenario must be specified for test");if(i?.includes("axios"))throw new Error("Cannot generate axios mock data, while mocking axios");WebServiceRequest.writeAxiosMockData(u,v,e,s)}}if(logger.verbose(()=>`JSON RESPONSE \n ${JSON.stringify(v)}`),l.interceptors)l.interceptors.response.eject(m);return v}}exports.WebServiceRequest=WebServiceRequest;
//# sourceMappingURL=web-service-request.js.map