/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.WebServiceConfig=void 0;const xtrem_core_1=require("@sage/xtrem-core"),xtrem_x3_config_manager_1=require("@sage/xtrem-x3-config-manager"),folder_manager_1=require("../../storage/folder-manager"),logger=xtrem_core_1.Logger.getLogger(__filename,"web-service");class WebServiceConfig{static async loadWebServiceConfiguration(e){let r,o,i;const{context:a}=e,t=folder_manager_1.FolderManager.getFolderName({context:a});try{r=a.getContextValue("token"),o=a.getContextValue("soapUrl"),i=a.getContextValue("soapPoolAlias")}catch(e){r=void 0,o=void 0,i=void 0}if(o||i||r){let a;if(!r)throw a="Token is mandatory",new Error(a);if(!o)throw a="URL is mandatory",new Error(a);if(!i)throw a="Alias is mandatory",new Error(a);if(!t)throw a="Folder name is mandatory",new Error(a);return e.webServicePoolParameters={userCredentials:{userName:"",password:""},token:r,webServiceURL:o,poolAlias:i,timeout:1e6,codeLang:"ENG",folderName:t},e.webServicePoolParameters.codeLang=await e.codeLang||"ENG",void logger.info("Web service config loaded from Syracuse")}const n=xtrem_x3_config_manager_1.X3ConfigManager.current;if("development"===n.deploymentMode&&n.x3?.development?.soap){const r=n.x3.development.soap;if(!n.x3.development.folderName)throw new Error("Folder name missing from the web service config");if(!r.webServiceURL)throw new Error("URL is missing from web service config");if(!r.userCredentials||!r.userCredentials.userName||!r.userCredentials.password)throw new Error("User credential is missing from web service config");if(!r.userCredentials.userName||!r.userCredentials.password)throw new Error("User credential is missing from web service config, both userName and password must be supplied ");return void(e.webServicePoolParameters={...n.x3.development.soap,folderName:n.x3.development.folderName})}throw new Error("Failed to load web service config")}}exports.WebServiceConfig=WebServiceConfig;
//# sourceMappingURL=web-service-config.js.map