/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.WebServiceCall=void 0;const xtrem_core_1=require("@sage/xtrem-core"),xtrem_shared_1=require("@sage/xtrem-shared"),xtrem_x3_config_manager_1=require("@sage/xtrem-x3-config-manager"),fs=require("fs"),_=require("lodash"),fsp=require("path"),index_1=require("../index"),web_service_config_1=require("./web-service-config"),web_service_mapping_1=require("./web-service-mapping"),web_service_request_1=require("./web-service-request"),web_service_response_1=require("./web-service-response"),logger=xtrem_core_1.Logger.getLogger(__filename,"web-service");class WebServiceCall{constructor(e,r,s){this._nodeContext=e,this._webServiceName=r,this.options=s,this._isImportBasedWebService=false,this._deploymentMode=xtrem_x3_config_manager_1.X3ConfigManager.current.deploymentMode}static create(e,r,s){return new WebServiceCall(e,r,s).init()}async init(){if(await web_service_config_1.WebServiceConfig.loadWebServiceConfiguration(this),await this.setDescription(),this.checkIfObjectWebService(),this._webServiceInputDataSchema=this.getWebServiceInputsDataSchema(),this._isObjectBasedWebService)this._webServiceKeysDataSchema=this.getWebServiceKeysDataSchema(),this._webServiceInputsAndKeysDataSchema=this.getWebServiceInputsAndKeysDataSchema();return this}static async getLanguageFromLocale(e,r){if(!xtrem_core_1.Context.localizationManager.getLanguageFromLocale||true===e.globals.localizationManagerBusy)return"ENG";e.globals.localizationManagerBusy=true;const s=await xtrem_core_1.Context.localizationManager.getLanguageFromLocale(e,e.currentLocale,r.toUpperCase())||"ENG";return e.globals.localizationManagerBusy=false,s}get codeLang(){return(async()=>{if(!this._codeLang)if(this.options.languageRequest||this.options.folderRequest)this._codeLang="ENG";else this._codeLang=await WebServiceCall.getLanguageFromLocale(this._nodeContext,this.webServicePoolParameters.folderName);return this._codeLang})()}static connectTo(e,r,s){return WebServiceCall.create(e,r,s)}async doCreate(e,r,s){this.isObjectBasedWebServiceAllowedAction(),await web_service_mapping_1.WebServiceMapping.getWebServiceMapping(this,r,s);const i=web_service_request_1.WebServiceRequest.graphqlToLegacyPayloadBuild(this,r,"save",e);return this.createWithRawXmlPayload(i.xmlPayload)}createWithRawXmlPayload(e){return this.isObjectBasedWebServiceAllowedAction(),web_service_request_1.WebServiceRequest.x3WebServiceRequest(this,e,"save")}createWithPayload(e){return this.isObjectBasedWebServiceAllowedAction(),web_service_request_1.WebServiceRequest.x3WebServiceRequest(this,web_service_request_1.WebServiceRequest.buildWebServiceRequestXML(this,"save",web_service_request_1.WebServiceRequest.buildWebServiceInputXML(e)),"save")}async doUpdate(e,r,s){this.isObjectBasedWebServiceAllowedAction(),await web_service_mapping_1.WebServiceMapping.getWebServiceMapping(this,r,s);const i=web_service_request_1.WebServiceRequest.graphqlToLegacyPayloadBuild(this,r,"modify",e);return this.updateWithRawXmlPayload(i.xmlPayload)}updateWithRawXmlPayload(e){return this.isObjectBasedWebServiceAllowedAction(),web_service_request_1.WebServiceRequest.x3WebServiceRequest(this,e,"modify")}updateWithPayload(e,r){this.isObjectBasedWebServiceAllowedAction();const s=web_service_request_1.WebServiceRequest.buildWebServiceRequestXML(this,"modify",web_service_request_1.WebServiceRequest.buildWebServiceKeysXML(e)+web_service_request_1.WebServiceRequest.buildWebServiceInputXML(r));return web_service_request_1.WebServiceRequest.x3WebServiceRequest(this,s,"modify")}async runSubProgram(e,r,s){this.isSubProgramBasedWebServiceAllowedAction(),await web_service_mapping_1.WebServiceMapping.getWebServiceMapping(this,r,s);const i=web_service_request_1.WebServiceRequest.graphqlToLegacyPayloadBuild(this,r,"run",e);return this.runSubProgramWithRawXmlPayload(i.xmlPayload)}runSubProgramWithRawXmlPayload(e){return this.isSubProgramBasedWebServiceAllowedAction(),web_service_request_1.WebServiceRequest.x3WebServiceRequest(this,e,"run")}runSubProgramWithPayload(e){return this.isSubProgramBasedWebServiceAllowedAction(),web_service_request_1.WebServiceRequest.x3WebServiceRequest(this,web_service_request_1.WebServiceRequest.buildWebServiceRequestXML(this,"run",web_service_request_1.WebServiceRequest.buildWebServiceInputXML(e,true)),"run")}async createWithImport(e,r,s){if(this.isSubProgramBasedWebServiceAllowedAction(),!this._importModelName)this._importModelName=e,this._isImportBasedWebService=true;return await web_service_mapping_1.WebServiceMapping.getWebServiceMapping(this,r),this.runSubProgramWithRawXmlPayload(web_service_request_1.WebServiceRequest.graphqlToLegacyPayloadBuild(this,r,"run",s).xmlPayload)}isObjectBasedWebServiceAllowedAction(){if(!this._isObjectBasedWebService)throw new Error(index_1.data.errorsMessages.isNotObjectBasedWebServiceError)}isSubProgramBasedWebServiceAllowedAction(){if(this._isObjectBasedWebService)throw new Error(index_1.data.errorsMessages.isNotSubProgramBasedWebServiceError)}checkIfObjectWebService(){if(this.webServiceDescription?.results?.ADXDOC?.$?.OBJ)this._isObjectBasedWebService=true;else this._isObjectBasedWebService=false}async setDescription(){this._webServiceDescription=await this.context.getCachedValue({category:"WebServiceDescription",key:this._webServiceName,getValue:async()=>{if(this._nodeContext.testMode&&"AOWSIMPORT"===this._webServiceName){const e=fs.readFileSync(fsp.join(__dirname,-1===process.cwd().indexOf("xtrem-x3-gateway")?"../../../../test/metadata":"../../../test/metadata",`${this._webServiceName}.json`),"utf8");return{value:(0,xtrem_shared_1.tryJsonParse)(e)}}const e=web_service_request_1.WebServiceRequest.buildWebServiceRequestXML(this,"getDescription",""),r=await web_service_request_1.WebServiceRequest.x3WebServiceRequest(this,e,"getDescription");if(!_.isEmpty(r.messages?.errors)||0===r.statusCode)throw new Error(`Failed to get description for web service '${this.webServiceName}': ${r.messages?.errors?.join(" & ")}`);return{value:r}},cacheInMemory:true,ttlInSeconds:60})}async read(e,r){if(this._isObjectBasedWebService){const s=`\n                    ${web_service_request_1.WebServiceRequest.buildWebServiceKeysXML(r)}\n                    <listSize xsi:type="xsd:int">\n                      ${e}\n                    </listSize>\n                `,i=web_service_request_1.WebServiceRequest.buildWebServiceRequestXML(this,"read",s);return web_service_request_1.WebServiceRequest.x3WebServiceRequest(this,i,"read")}return web_service_response_1.WebServiceResponse.buildErrorWebServiceResponse(index_1.data.errorsMessages.isNotObjectBasedWebServiceError)}async query(e,r){if(this._isObjectBasedWebService){const s=`\n                    ${web_service_request_1.WebServiceRequest.buildWebServiceKeysXML(r)}\n                    <listSize xsi:type="xsd:int">\n                      ${e}\n                    </listSize>\n                    `,i=web_service_request_1.WebServiceRequest.buildWebServiceRequestXML(this,"query",s);return web_service_request_1.WebServiceRequest.x3WebServiceRequest(this,i,"query")}return web_service_response_1.WebServiceResponse.buildErrorWebServiceResponse(index_1.data.errorsMessages.isNotObjectBasedWebServiceError)}manageWebServiceResponseMessages(e,r,s){if(web_service_response_1.WebServiceResponse.legacyToXtremCompatibleErrorMessage(e,r,s),this.options.validationContext)e.messages?.errors?.forEach(e=>{this.options.validationContext.addDiagnose(xtrem_shared_1.ValidationSeverity.error,e)}),e.messages?.warnings?.forEach(e=>{this.options.validationContext.addDiagnose(xtrem_shared_1.ValidationSeverity.warn,e)}),e.messages?.info?.forEach(e=>{this.options.validationContext.addDiagnose(xtrem_shared_1.ValidationSeverity.info,e)});else if(e.messages){if(e.messages.info)e.messages.info.forEach(e=>{logger.verbose(()=>e)});if(e.messages.warnings)e.messages.warnings.forEach(e=>{logger.warn(()=>e)});if(e.messages.errors&&e.messages.errors.length>0)throw new Error(e.messages.errors.join("\n"))}}getXtremCompatibleResponse(e,r){return web_service_response_1.WebServiceResponse.buildXtremResponse(e,r)}getWebServiceInputsDataSchema(){return web_service_mapping_1.WebServiceMapping.getWebServiceKeysAndInputsParameters("objectInput",this.webServiceDescription)}getWebServiceKeysDataSchema(){if(this._isObjectBasedWebService)return web_service_mapping_1.WebServiceMapping.getWebServiceKeysAndInputsParameters("objectKeys",this.webServiceDescription);return web_service_response_1.WebServiceResponse.buildErrorWebServiceResponse(index_1.data.errorsMessages.isNotObjectBasedWebServiceError)}getWebServiceInputsAndKeysDataSchema(){if(this._isObjectBasedWebService){const e={payload:this._webServiceInputDataSchema.results.payload,keys:this._webServiceKeysDataSchema.results.keys};return web_service_response_1.WebServiceResponse.buildWebServiceResponse(1,e)}return web_service_response_1.WebServiceResponse.buildErrorWebServiceResponse(index_1.data.errorsMessages.isNotObjectBasedWebServiceError)}get webServicePoolParameters(){return this._webServicePoolParameters}set webServicePoolParameters(e){this._webServicePoolParameters=e}get webServiceDescription(){return this._webServiceDescription}get isObjectBasedWebService(){return this._isObjectBasedWebService}get webServiceInputDataSchema(){return this._webServiceInputDataSchema}get webServiceKeysDataSchema(){if(this._isObjectBasedWebService)return this._webServiceKeysDataSchema;return web_service_response_1.WebServiceResponse.buildErrorWebServiceResponse(index_1.data.errorsMessages.isNotObjectBasedWebServiceError)}get webServiceInputsAndKeysDataSchema(){if(this._isObjectBasedWebService)return this._webServiceInputsAndKeysDataSchema;return web_service_response_1.WebServiceResponse.buildErrorWebServiceResponse(index_1.data.errorsMessages.isNotObjectBasedWebServiceError)}get webServiceName(){return this._webServiceName}get deploymentMode(){return this._deploymentMode}get mapping(){return this._mapping}set mapping(e){this._mapping=e}get context(){return this._nodeContext}get importModelName(){return this._importModelName}get isImportBasedWebService(){return this._isImportBasedWebService}get soapPayload(){return this._soapPayload}set soapPayload(e){this._soapPayload=e}}exports.WebServiceCall=WebServiceCall;
//# sourceMappingURL=web-service-call.js.map