/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.ApiHelper=void 0;const xtrem_core_1=require("@sage/xtrem-core"),xtrem_date_time_1=require("@sage/xtrem-date-time"),xtrem_decimal_1=require("@sage/xtrem-decimal"),xtrem_x3_config_manager_1=require("@sage/xtrem-x3-config-manager"),fs=require("fs"),_=require("lodash"),fsp=require("path"),sql_resolver_1=require("../sql-mapper/sql-resolver"),folder_manager_1=require("../storage/folder-manager"),x3_storage_manager_1=require("../storage/x3-storage-manager"),logger=xtrem_core_1.Logger.getLogger(__filename,"api-helper");class ApiHelper{static getConfig(e){let t,r,a,n,i="rest";const o=folder_manager_1.FolderManager.getFolderName({context:e}),s=xtrem_x3_config_manager_1.X3ConfigManager.current;try{t=e.getContextValue("token"),r=e.getContextValue("apiUrl"),a=e.getContextValue("session"),n=e.getContextValue("x3Cookies"),i=e.getContextValue("origin")??i}catch(e){t=void 0,r=void 0,a=void 0}const c=1e3*(s.graphql?.timeLimitInSeconds??60);if(r||t){let e;if(!t)throw e="Token is mandatory",new Error(e);if(!r)throw e="URL is mandatory",new Error(e);if(!o)throw e="Folder name is mandatory",new Error(e);return{folderName:o,apiUrl:r,token:t,session:a,requestTimeout:c,cookies:n,origin:i}}const u=s.x3;if("development"===s.deploymentMode&&u?.development?.api){const e=u.development.api;if(!u.development.folderName)throw new Error("Folder name missing from the web service config");if(!e.url)throw new Error("URL is missing from web service config");if(!e.userCredentials||!e.userCredentials.userName||!e.userCredentials.password)throw new Error("User credential is missing from web service config");return{folderName:u.development.folderName,apiUrl:e.url,userCredentials:e.userCredentials,requestTimeout:c,origin:e.origin??i}}throw new Error("Failed to load API config")}static makeParameter(e){if("string"==typeof e)return{type:e};return e}static parseScalarReturnValue(e,t,r,a){switch(r){case"boolean":return 2===a;case"decimal":return xtrem_decimal_1.Decimal.make(a);case"date":return xtrem_date_time_1.DateValue.parse(a);case"integer":case"string":return a;case"dateRange":return xtrem_date_time_1.DateRange.parse(a);case"datetimeRange":return xtrem_date_time_1.DatetimeRange.parse(a);case"time":return xtrem_date_time_1.Time.parse(a);case"datetime":return xtrem_date_time_1.Datetime.parse(a);case"binaryStream":return xtrem_core_1.BinaryStream.fromBuffer(Buffer.from(a));case"textStream":return xtrem_core_1.TextStream.fromString(a);default:throw new Error(`${e}.${t}: invalid return type ${r}:${a}`)}}static parsePropertyReturnValue(e,t,r,a){if(null==a)return null;const n=sql_resolver_1.SqlResolver.getPropertyType(r);switch(n){case"boolean":case"decimal":case"date":case"integer":case"string":case"dateRange":case"datetimeRange":case"time":case"datetime":case"binaryStream":case"textStream":return this.parseScalarReturnValue(e,t,n,a);case"enum":if(Number.isFinite(Number(a))){const n=r.dataType;if(!n)throw new Error(`${e}.${t}: dataType missing on return enum`);return n.stringValue(a)}throw new Error(`${e}.${t}: invalid enum return value`);default:throw new Error(`${e}.${t}: invalid return type ${n}:${a}`)}}static parseOperationReturnValue(e,t,r,a,n){if(null==n)return null;const i=this.makeParameter(a);switch(i.type){case"boolean":case"decimal":case"date":case"integer":case"string":case"dateRange":case"datetimeRange":case"time":case"datetime":case"binaryStream":case"textStream":return this.parseScalarReturnValue(t.name,r,i.type,n);case"enum":if(Number.isFinite(Number(n))){const e=i.dataType?i.dataType():void 0;if(!e)throw new Error(`${t.name}.${r}: dataType missing on return enum`);return e.stringValue(n)}throw new Error(`${t.name}.${r}: invalid enum return value`);case"object":if("object"!=typeof n)throw new Error(`${t.name}.${r}: invalid value for object return value. ${n}`);if(i.properties)return Object.keys(n).reduce((a,o)=>{const s=i.properties[o];if(!s)return a;const c=n[o];return a[o]=this.parseOperationReturnValue(e,t,r,s,c),a},{});return n;case"array":if(!Array.isArray(n))throw new Error(`${t.name}.${r}: invalid array return value`);if(i.item){const a=i.item;return n.map(n=>this.parseOperationReturnValue(e,t,r,a,n))}return n;case"instance":{const t=e.application.getFactoryByConstructor(i.node()),a=this.parseNodeOutputData(e,t.name,r,n);return e.tryRead(t.nodeConstructor,a)}default:throw new Error(`${t.name}.${r}: invalid return type ${i.type}:${n}`)}}static parseNodeOutputData(e,t,r,a){if("delete"===r)return a;return e.application.getFactoryByName(t).keyProperties.reduce((e,n)=>(e[n.name]=this.parsePropertyReturnValue(t,r,n,a[n.name]),e),{})}static parseOutputData(e,t,r,a){const n=e.application.getFactoryByName(t),i=[...n.queries,...n.mutations].find(e=>e.name===r);if(!i){if(["create","update","delete"].includes(r)){if("delete"===r)return a;return this.parseNodeOutputData(e,t,r,a)}throw new Error(`${t}.${r}: missing operation`)}return this.parseOperationReturnValue(e,n,i.name,i.return,a)}static processResponse(e,t,r,a,n){const i=a.data,o=[];if(i.$diagnoses&&i.$diagnoses.length)i.$diagnoses.forEach(t=>{let r=xtrem_core_1.ValidationSeverity.info;if("error"===t.$severity)r=xtrem_core_1.ValidationSeverity.error,o.push(t.$message);if("warning"===t.$severity)r=xtrem_core_1.ValidationSeverity.warn;if(n)n.addDiagnose(r,t.$message);else e.addDiagnoseAtPath(r,[],t.$message)});if(o.length>0)throw new xtrem_core_1.BusinessRuleError(o.join("\n"));return i.$payloadxtrem?this.parseOutputData(e,t,r,i.$payloadxtrem[0]):null}static writeAxiosMockData(e,t,r,a){if(e.headers?.Authorization)delete e.headers.Authorization;let n;if(!fs.existsSync(fsp.join(r,"axios")))fs.mkdirSync(fsp.join(r,"axios"));if(!fs.existsSync(fsp.join(r,"axios",`${a}.json`)))n=[];else n=JSON.parse(fs.readFileSync(fsp.join(r,"axios",`${a}.json`),"utf8").toString());n.push({request:e,response:{...t,headers:{isMock:true}}}),fs.writeFileSync(fsp.join(r,"axios",`${a}.json`),JSON.stringify(n,null,4))}static getNodeKeyValue(e){const{factory:t}=e.$;if(!t.naturalKey)throw t.logicError("no natural key");const r=t.naturalKey.filter(e=>"_sortValue"!==e).reduce((t,r)=>(t[r]=e.$.getRawPropertyValue(r),t),{});if(t.propertiesByName.denormalizedIndex)r.denormalizedIndex=e.$.getRawPropertyValue("denormalizedIndex");return r}static async parseCollectionInputData(e,t,r,a,n){const i=await x3_storage_manager_1.X3StorageManager.tryGet(r,t.name),o=t.targetFactory.externalStorageManager,s=[],c=n?.nodeMap??{};let u=[];if(i)if(u=await i.map(async r=>{c[a]=true;const i=await this.parseNodeInputData(e,t.targetFactory,r,{...n,nodeMap:c});return s.push(String(r._id)),i}).toArray(),r.$.status!==xtrem_core_1.NodeStatus.added&&!o.isDenormalized){const a=await x3_storage_manager_1.X3StorageManager.tryGet(await r.$.old,t.name);if(null!=a)await a.filter(e=>!s.includes(String(e._id))).forEach(e=>{const t=this.getNodeKeyValue(e);t._nodeStatus="D",u.push(t)});const n=t.targetFactory.indexes?.find(e=>e.isNaturalKey);if(u.length>0&&n)u=await xtrem_core_1.RecordPaging.applyOrderBy(e,t.targetFactory,u,n.orderBy,(e,t,r)=>r[t.name]),u=u.sort((e,t)=>{if("C"===e._nodeStatus)return 1;if("C"===t._nodeStatus)return-1;return 0})}return u}static async getPropertiesOldValue(e,t){return e.$.status!==xtrem_core_1.NodeStatus.added?(await e.$.old).$.getRawPropertyValue(t.name):void 0}static getNodeOperationName(e,t){let r=t;if(e.$.status===xtrem_core_1.NodeStatus.added)r="create";if(e.$.status===xtrem_core_1.NodeStatus.modified)r="update";return r}static async parseNodeInputData(e,t,r,a){const n={},i=a?.nodeMap??{},o=`${t.name}~${r._id}`;if(i[o])return t.keyPropertyNames.reduce((e,t)=>(e[t]=r.$.getRawPropertyValue(t),e),{});switch(await(0,xtrem_core_1.asyncArray)(t.properties).forEach(async t=>{if(!await t.isAuthorized(e))return;if(t.isReferenceProperty())if(t.isMutable){let s=await x3_storage_manager_1.X3StorageManager.tryGet(r,t.name);if(!s)s=r.$.getRawPropertyValue(t.name);if(null==s){const i=await ApiHelper.getPropertiesOldValue(r,t);let o=a?.operationName;if(r.$.status===xtrem_core_1.NodeStatus.added)o="create";if(r.$.status===xtrem_core_1.NodeStatus.modified)o="update";n[t.name]=this.parseScalarInputValue(e,t,null,{...a,operationName:o,oldValue:i})}else i[o]=true,n[t.name]=await this.parseNodeInputData(e,t.targetFactory,s,{...a,nodeMap:i})}else if(null==r.$.getRawPropertyValue(t.name)){const i=await ApiHelper.getPropertiesOldValue(r,t),o=ApiHelper.getNodeOperationName(r,a?.operationName??"");n[t.name]=this.parseScalarInputValue(e,t,null,{...a,operationName:o,oldValue:i})}else{const i=await ApiHelper.getPropertiesOldValue(r,t),o=ApiHelper.getNodeOperationName(r,a?.operationName??"");n[t.name]=this.parseScalarInputValue(e,t,r.$.getRawPropertyValue(t.name),{...a,oldValue:i,operationName:o})}else if(t.isMutable&&t.isReferenceArrayProperty()){let s=await x3_storage_manager_1.X3StorageManager.tryGet(r,t.name);if(!s)s=r.$.getRawPropertyValue(t.name);if(null==s)n[t.name]=[];else n[t.name]=await(0,xtrem_core_1.asyncArray)(s).map(r=>(i[o]=true,this.parseNodeInputData(e,t.targetFactory,r,{...a,nodeMap:i}))).toArray();n[t.name]=r.$.getRawPropertyValue(t.name)}else if(t.isMutable&&t.isCollectionProperty())n[t.name]=await this.parseCollectionInputData(e,t,r,o,{...a,nodeMap:i});else if(void 0!==r.$.getRawPropertyValue(t.name)||t.computeValue||t.getValue){let i=await x3_storage_manager_1.X3StorageManager.tryGet(r,t.name);if(!i)i=r.$.getRawPropertyValue(t.name);const o=ApiHelper.getNodeOperationName(r,a?.operationName??""),s=await ApiHelper.getPropertiesOldValue(r,t);n[t.name]=this.parseScalarInputValue(e,t,i??null,{...a,oldValue:s,operationName:o})}else{const i=await ApiHelper.getPropertiesOldValue(r,t),o=ApiHelper.getNodeOperationName(r,a?.operationName??"");n[t.name]=this.parseScalarInputValue(e,t,null,{...a,oldValue:i,operationName:o})}}),r.$.status){case xtrem_core_1.NodeStatus.added:n._nodeStatus="C";break;case xtrem_core_1.NodeStatus.unchanged:n._nodeStatus="R";break;case xtrem_core_1.NodeStatus.modified:n._nodeStatus="U";break;case xtrem_core_1.NodeStatus.deleted:n._nodeStatus="D"}delete i[o];const s=x3_storage_manager_1.X3StorageManager.removeTransientKeyValues(t,n);return t.keyProperties.forEach(e=>{if(void 0===s[e.name])s[e.name]=null}),s}static isLocalizedValue(e,t){return e instanceof xtrem_core_1.Property&&e.isLocalized&&"object"==typeof t}static parseScalarInputDateValue(e,t,r){switch(t){case"update":if(null===e&&null!==r)return"0000-00-00";if(e instanceof xtrem_date_time_1.DateValue)return e.toString();if(null===e)return null;return String(e);case"create":if(e instanceof xtrem_date_time_1.DateValue&&"1000-01-01"===e.toString())return null;if(null===e)return"0000-00-00";return e instanceof xtrem_date_time_1.DateValue?e.toString():String(e);default:if(null===e)return null;return e instanceof xtrem_date_time_1.DateValue?e.toString():String(e)}}static parseScalarInputValue(e,t,r,a){const n=t instanceof xtrem_core_1.Property?sql_resolver_1.SqlResolver.getPropertyType(t):t.type;if(null==r&&"date"!==n)return null;switch(n){case"boolean":return r?2:1;case"integer":return r;case"string":if(this.isLocalizedValue(t,r))return r[e.currentLocale];return String(r).replaceAll(x3_storage_manager_1.X3StorageManager.hashtagPlaceholder,"#");case"decimal":return r instanceof xtrem_decimal_1.Decimal?r.toString():String(r);case"date":return ApiHelper.parseScalarInputDateValue(r,a?.operationName,a?.oldValue);case"dateRange":return r instanceof xtrem_date_time_1.DateRange?r.toString():String(r);case"datetimeRange":return r instanceof xtrem_date_time_1.DatetimeRange?r.toString():String(r);case"time":return r instanceof xtrem_date_time_1.Time?r.toString():String(r);case"datetime":return r instanceof xtrem_date_time_1.Datetime?r.toString():String(r);case"binaryStream":return r instanceof xtrem_core_1.BinaryStream?r.toString():r;case"textStream":return r instanceof xtrem_core_1.TextStream?r.toString():r;case"enum":{const e="enum"===t.type?t.dataType:void 0;if(e){const t=e.numberValue(r);return-1===t?0:t}throw new Error(`${t.name}: missing enum datatype`)}default:throw new Error(`${n}: invalid parameter type`)}}static parseParameterInputValue(e,t,r){if(null==r)return this.parseScalarInputValue(e,t,null);switch(t.type){case"instance":case"reference":{const a=e.application.getFactoryByConstructor(t.node());return this.parseNodeInputData(e,a,r)}case"enum":if("number"==typeof r)return r;if(!t.dataType)throw new Error(`${t.name}: enum property missing dataType`);if("string"==typeof r)return t.dataType().numberValue(r);throw new Error(`${t.name}: invalid enum value ${r}`);default:return this.parseScalarInputValue(e,t,r)}}static parseParameterValue(e,t,r,a,n){switch(a.type){case"boolean":case"integer":case"string":case"decimal":case"date":case"dateRange":case"datetimeRange":case"time":case"datetime":case"binaryStream":case"textStream":case"instance":case"reference":case"enum":return this.parseParameterInputValue(e,a,n);case"object":{if(null==n)return null;if("object"!=typeof n)throw new Error(`${t.name}.${r.name}.${a.name}: invalid value for object`);const i=n;return(0,xtrem_core_1.asyncArray)(Object.keys(n)).reduce(async(n,o)=>{const s=a.properties[o],c=await i[o];return n[o]=await this.parseParameterValue(e,t,r,this.makeParameter(s),c),n},{})}case"array":if(null==n)return null;if(!Array.isArray(n))throw new Error(`${t.name}.${r.name}.${a.name}: invalid array value`);return(0,xtrem_core_1.asyncArray)(n).map(n=>this.parseParameterValue(e,t,r,this.makeParameter(a.item),n)).toArray();default:throw new Error(`${t.name}.${r.name}: invalid parameter type`)}}static parseOperationInputData(e,t,r,a){const{parameters:n}=r,i=n[0];if("object"===i.type&&"parameters"===i.name)return(0,xtrem_core_1.asyncArray)(Object.keys(i.properties)).reduce(async(n,o)=>{if(!a)return n;const s=this.makeParameter(i.properties[o]),c=await a[o];return n[o]=await this.parseParameterValue(e,t,r,s,c),n},{});throw new Error(`${t}.${r.name}: invalid operation parameters defintion, root parameter must an object with the name 'parameters'.`)}static parseInputData(e,t,r,a,n){const i=e.application.getFactoryByName(t);switch(a){case"SCRIPT":{const a=[...i.queries,...i.mutations].find(e=>e.name===r);if(!a)throw new Error(`${t}.${r}: invalid script operation`);return this.parseOperationInputData(e,i,a,n)}case"CRUD":case"IMPORT":if(n instanceof xtrem_core_1.Node)return this.parseNodeInputData(e,i,n,{nodeName:t,operationName:r});throw new Error(`${t}.${r}: input is not an instance of node`);default:throw new Error(`${t}.${r}: invalid operation method ${a}`)}}static async getXtremContextHeader(e,t){if(e.testMode)return Buffer.from(JSON.stringify(t)).toString("base64");const r=xtrem_x3_config_manager_1.X3ConfigManager.current,{x3:a,deploymentMode:n}=r,i="development"===n?a?.development?.api?.secret:void 0;return Buffer.from(JSON.stringify(await xtrem_x3_config_manager_1.X3ConfigManager.encrypt(t,{secret:i}))).toString("base64")}static async sendRequest(e,t,r,a,n,i){const o=this.getConfig(e),{apiUrl:s,token:c,userCredentials:u,session:l,cookies:m,origin:p}=o;let d="";if(c)d=`Bearer ${c}`;else{d=`Basic ${Buffer.from(`${u?.userName||""}:${u?.password}`).toString("base64")}`}const g={session:l,service:i,params:{name:t,operationName:["create","update","delete"].includes(t)?"":a,node:r,origin:p}},f={"Content-Type":"text/plain",Authorization:d,Connection:"Keep-Alive","accept-language":"base"===e.currentLocale?"en-US":e.currentLocale,"x-xtrem-context":await this.getXtremContextHeader(e,g)};if(m)f.Cookie=m;logger.verbose(()=>`API Request ${t}/${r}.${a}: context header ${JSON.stringify(g)}`);const y=xtrem_core_1.Mocker.get("axios",require),w={method:"post",url:s,headers:f,data:n,timeout:o.requestTimeout};logger.verbose(()=>`API Request ${t}/${r}.${a}: ${JSON.stringify(w)}`);const h=await y(w);if(logger.verbose(()=>`Raw API response \n ${JSON.stringify(h.data)}`),e.testMode&&e.testConfig){const{directory:t,testAttributes:r,mocks:a,scenario:n}=e.testConfig;if(r?.createMockData){if(!t||!n)throw new Error("Cannot generate axios mock data, both directory and scenario must be specified for test");if(a?.includes("axios"))throw new Error("Cannot generate axios mock data, while mocking axios");this.writeAxiosMockData(w,_.omit(h,["request"]),t,n)}}return h}static async sendOperation(e,t,r,a,n,i){const o=await this.sendRequest(e,t,r,a,n),s=this.processResponse(e,r,a,o,i);return logger.verbose(()=>`API response \n ${JSON.stringify(s)}`),s}static async executeOperation(e,t,r,a,n,i,o){const s=await this.parseInputData(e,a,n,r,i);return this.sendOperation(e,t,a,n,s,o)}static async refreshNodeState(e,t){e.$.clearCaches();const{factory:r}=e.$,{keyPropertyNames:a}=r,n=_.pick(t,a);if(Object.keys(n).length===a.length){const i=(await(0,xtrem_core_1.asyncArray)(r.properties).filter(async t=>{const r=await t.isEnabledByServiceOptions(e.$.context);return t.isStored&&!a.includes(t.name)&&r}).toArray()).reduce((e,t)=>(e[t.name]=true,e),{}),o=await e.$.context.select(e.$.factory.nodeConstructor,i,{filter:n});if(o.length>0)_.merge(t,o[0])}}static async insert(e,t,r){const a=await ApiHelper.executeOperation(t.$.context,"create","CRUD",e.factory.name,"create",t,r);return a._id=e.getId(t.$.context,{...t.$.getRawPropertyValues(),...a}),await this.refreshNodeState(t,a),a}static async update(e,t,r){const a={...await ApiHelper.executeOperation(t.$.context,"update","CRUD",e.factory.name,"update",t,r),_id:String(t._id)};return await this.refreshNodeState(t,a),[_.omit(a,["_id"])]}static async delete(e,t,r){return await ApiHelper.executeOperation(t.$.context,"delete","CRUD",e.factory.name,"delete",t,r),1}}exports.ApiHelper=ApiHelper;
//# sourceMappingURL=api-helper.js.map