**# @sage/xtrem-x3-gateway**

**NPM Package that call X3 SOAP from XTREM**

**X3 gateway Web Service CALL Actions**

The X3 SOAP Gateway web service can be addressed to an X3 Object or an X3 Subprogram.

**HOW TO GUIDE :**

**1- Package configuration**

Create a yaml config file called web-service-config.yml on the root of em-core and fill it as follow :

```yaml
webServiceURL: http://scmx3-dev-YOUR_SCM_NAME.sagefr.adinternal.com:8124/soap-generic/syracuse/collaboration/syracuse/CAdxWebServiceXmlCC

userCredentials:
    userName: 'your-username'
    password: 'your-password'
codeLang: 'ENG'
poolAlias: 'YOUR_POOL_ALIAS'
timeout: 50000
```

**2- Import and Instantiate a X3 SOAP Gateway client**

```ts
import * as x3Gateway from '@sage/xtrem-x3-gateway';
import { Context } from '@sage/xtrem-core';
@decorators.node<MyNODE>({
    .
    .
    .
    persistHooks: {
        /**
        * Save method es used for graphql mutation especially, create and update method.
        */
        async save() {
            /**
            * Web service Name
            */
            const  webServiceName  =  'myWebServiceName';

            /**
            * Get GraphQL Payload
            */
            const  graphQLPayload  =  this.$.payload();

            /**
            * Get the node context
            */
            const  nodeContext: Context  =  this.$.context;

            /**
            * Set the current node (must be typeof node)
            * ex : StockMovementHeader
            */
            const currentNode: typeof Node = MyNODE;

            /**
            * Call the web service
            */
            // instantiate a web service call. See (Import and Instantiate a call client)
            let webServiceInstance = await x3GatewayWebServiceCall.connectTo(nodeContext, currentwebServiceName);

            ...
        }
    }
})
```

**4- Object's based web services operations :**

X3 Object based web service supports these actions :

-   create
-   modify
-   query
-   read

**- Create**

```ts
const response = await webServiceInstance.create(graphQLPayload);
console.log('CREATE', response);
```

**- Create with import**
You can use the standard web service for import AWSIMPORT

```ts
const response = await webServiceInstance.createWithImport(importModelName, graphqlPayload);
console.log('IMPORT', response);
```

**- Update**

```ts
const response = await webServiceInstance.update(graphQLPayload);
console.log('UPDATE', response);
```

**5- Subprogram's operations :**  
Refers to the previous section (Object’s based web services operations ) for the request preparation.

X3 Subprogramm based web service support only these actions :

-   runSubProgram
-   createWithImport

**3- Package actions Inputs, Keys and Output**

All the actions require at most three parameters :

-   **Input** : ObjectXml in the X3 SOAP terminology. These are all the web service inputs.
-   **Keys** : ObjectKeys in the X3 SOAP terminology. These are used the table's keys.
-   **List size** : Number that specify the length of returned query

**3.a- Action's output format**

All the actions outputs are as follow :

```json
{
	statusCode: Number, // is equal to : 0 if success 1 if error
	results: Object, // the return of the web service if success.
	errors: {
		message: String, all the errors messages
	}
}
```

**3.b- Get the Web Service Input Schema**

The function will return the expected object based web service input schema (Payload) for all actions.

```ts
const response = webServiceInstance.webServiceInputsDataSchema;
if (response.statusCode === 0) {
    throw response.errors.message;
}
console.log('RESULT', response.results);
```

**3.c- Get the Web Service Keys Schema**

The function will return the expected object based web service keys schema for Read, Query and modify actions.

```ts
const response = webServiceInstance.webServiceKeysDataSchema;
if (response.statusCode === 0) {
    throw response.errors.message;
}
console.log('KEYS', response.results);
```

**4- Object's based web services operations :**

You can perform the creation and the update with two ways, manual and automatic mapping.

**Automapping :**
The auto mapping, generate the web service payload directly from the graphql ones.

**_Prepare the auto-mapping_**

```ts
@decorators.node<NodeName>({
    .
    .
    .
    persistHooks: {
        /**
        * Save method es used for graphql mutation especially, create and update method.
        */
        async save() {
            /**
            * Get GraphQL Payload
            */
            const  graphQLPayload  = await this.$.payload();

            /**
            * Get the node context
            */
            const  nodeContext  =  this.$.context;

            /**
            * Set the current node (must be typeOf node)
            * ex : StockMovementHeader
            */
            const currentNode = currentNode;

            /**
            * Call the web service
            */
            // instantiate a web service call. See (Import and Instantiate a call client)
            ...
        }
    }
})
```

**- Run Subprogram**

```ts
const response = await webServiceInstance.runSubProgram(graphQLPayload);
console.log('RUN SUB-PROGRAM', response);
```

**Manual Mapping**

**_Prepare the payload_**

```ts
/**
* This will return the the web service input payload and keys payload
*/
const  webServicePayload = await webServiceInstance.getWebServiceRequestData(context,currentgraphQLPayload);
/**
* Call the web service
*/
....
```

**- Create**

```ts
const response = await webServiceInstance.createWithRawXmlPayload(webServicePayload['payload']);
if (response.statusCode === 0) {
    return webServiceInstance.getWebServiceResponseErrors(response, webServicePayload);
}

compaticleXtremWebServiceResponse = webServiceInstance.getXtremCompatibleResponse(
    response,
    webServicePayload['mapping'],
);

console.log('UPDATE', compaticleXtremWebServiceResponse);
```

**- Update**

```ts
const response = await webServiceInstance.updateWithRawXmlPayload(
    webServicePayload['keys'],
    webServicePayload['payload'],
);
if (response.statusCode === 0) {
    return webServiceInstance.getWebServiceResponseErrors(response, webServicePayload);
}

compaticleXtremWebServiceResponse = webServiceInstance.getXtremCompatibleResponse(
    response,
    webServicePayload['mapping'],
);

console.log('UPDATE', compaticleXtremWebServiceResponse);
```

**- Read**

```ts
const response = await webServiceInstance.read(listSize, webServiceKeys);
if (response.statusCode === 0) {
    throw response.errors.message;
}
console.log('READ', response.results);
```

**- Query**

```ts
const response = await webServiceInstance.query(listSize, webServiceKeys);
if (response.statusCode === 0) {
    throw response.errors.message;
}
console.log('READ', response.results);
```

**5- Subprogram's operations :**  
Refers to the previous section (Object’s based web services operations ) for the request preparation.

For the automapping, use :

```ts
const response = await webServiceInstance.runSubProgramWithRawXmlPayload(context, currentgraphQLPayload);
```

For the manual mapping use :

```ts
const response = await webServiceInstance.runSubProgram(webServicePayload['payload']);
```
