declare module '@sage/wh-stock-data-api-partial' {
    import type {
        Depositor,
        Location,
        Package as SageWhMasterData$Package,
        SerialGroup,
        StockCountClass,
        StockNature,
        Store,
        UnitOfMeasure,
    } from '@sage/wh-master-data-api';
    import type {
        Family,
        Group,
        HazardousMaterialsClass,
        IcpeClasses,
        InputMode,
        OnuCode,
        Origin,
        OutputMode,
        Package as SageWhProductData$Package,
        Product,
        ProductActiveMatters,
        ProductActiveMattersBinding,
        ProductActiveMattersInput,
        ProductContainer,
        ProductIsPrintableDescriptions,
        ProductIsPrintableDescriptionsBinding,
        ProductIsPrintableDescriptionsInput,
        ProductPercentageActiveMatters,
        ProductPercentageActiveMattersBinding,
        ProductPercentageActiveMattersInput,
        Risk,
        SubFamily,
        SubGroup,
        SupplierUpc,
        TransportCategory,
    } from '@sage/wh-product-data-api';
    import type { Package as SageWhStructure$Package } from '@sage/wh-structure-api';
    import type { Package as SageWhSystem$Package, Site } from '@sage/wh-system-api';
    import type { Package as SageXtremAppMetadata$Package } from '@sage/xtrem-app-metadata-api';
    import type { Package as SageXtremX3SystemUtils$Package, SysUser } from '@sage/xtrem-x3-system-utils-api';
    import type {
        AggregateQueryOperation,
        AggregateReadOperation,
        BinaryStream,
        ClientCollection,
        ClientNode,
        ClientNodeInput,
        GetDefaultsOperation,
        QueryOperation,
        ReadOperation,
        VitalClientNode,
        VitalClientNodeInput,
        decimal,
        integer,
    } from '@sage/xtrem-client';
    export interface SerialNumber extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        depositor: Depositor;
        product: Product;
        code: string;
        double: integer;
        occurrence: integer;
        linePointerNumber: integer;
        receiptDate: string;
        deliveryOrderLineNumber: integer;
        outputDate: string;
        transmittedToL3: integer;
        stockObject: StockObject;
        serialGroup: SerialGroup;
        validatedStoringList: integer;
        validatedPreparationOrder: integer;
        serialParentGroup: SerialGroup;
        transferDate: string;
        free1: string;
        free2: string;
        free3: string;
        free4: string;
        free5: string;
        voided: integer;
        postponed: integer;
        displayCode: string;
        keyCodeForDuplicates: string;
    }
    export interface SerialNumberInput extends ClientNodeInput {
        site?: string;
        depositor?: string;
        product?: string;
        code?: string;
        double?: integer | string;
        occurrence?: integer | string;
        linePointerNumber?: integer | string;
        receiptDate?: string;
        deliveryOrderLineNumber?: integer | string;
        outputDate?: string;
        transmittedToL3?: integer | string;
        stockObject?: string;
        serialGroup?: string;
        validatedStoringList?: integer | string;
        validatedPreparationOrder?: integer | string;
        serialParentGroup?: string;
        transferDate?: string;
        free1?: string;
        free2?: string;
        free3?: string;
        free4?: string;
        free5?: string;
        voided?: integer | string;
        postponed?: integer | string;
        actionImport?: string;
    }
    export interface SerialNumberBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        depositor: Depositor;
        product: Product;
        code: string;
        double: integer;
        occurrence: integer;
        linePointerNumber: integer;
        receiptDate: string;
        deliveryOrderLineNumber: integer;
        outputDate: string;
        transmittedToL3: integer;
        stockObject: StockObject;
        serialGroup: SerialGroup;
        validatedStoringList: integer;
        validatedPreparationOrder: integer;
        serialParentGroup: SerialGroup;
        transferDate: string;
        free1: string;
        free2: string;
        free3: string;
        free4: string;
        free5: string;
        voided: integer;
        postponed: integer;
        displayCode: string;
        keyCodeForDuplicates: string;
        actionImport: string;
    }
    export interface SerialNumber$Lookups {
        site: QueryOperation<Site>;
        depositor: QueryOperation<Depositor>;
        product: QueryOperation<Product>;
        stockObject: QueryOperation<StockObject>;
        serialGroup: QueryOperation<SerialGroup>;
        serialParentGroup: QueryOperation<SerialGroup>;
    }
    export interface SerialNumber$Operations {
        query: QueryOperation<SerialNumber>;
        read: ReadOperation<SerialNumber>;
        aggregate: {
            read: AggregateReadOperation<SerialNumber>;
            query: AggregateQueryOperation<SerialNumber>;
        };
        lookups(dataOrId: string | { data: SerialNumberInput }): SerialNumber$Lookups;
        getDefaults: GetDefaultsOperation<SerialNumber>;
    }
    export interface SerialTraceability extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        depositor: Depositor;
        product: string;
        serialNumber: string;
        double: integer;
        occurrence: integer;
        code: string;
        operationType: SerialAction;
        directInputNumber: string;
        directInputLineNumber: integer;
        receiptDate: string;
        deliveryOrderNumber: string;
        deliveryOrderLineNumber: integer;
        outputDate: string;
        inputAdjustmentNumber: string;
        outputAdjustmentNumber: string;
        inputMovementNumber: string;
        outputMovementNumber: string;
        replenishmentNumber: string;
        transferMovementNumber: string;
        stockObjectNumber: string;
        originStockObject: string;
        serialGroup: string;
        parentGroup: string;
        replenishmentDate: string;
        free1: string;
        free2: string;
        free3: string;
        free4: string;
        free5: string;
    }
    export interface SerialTraceabilityInput extends ClientNodeInput {
        site?: string;
        depositor?: string;
        product?: string;
        serialNumber?: string;
        double?: integer | string;
        occurrence?: integer | string;
        code?: string;
        operationType?: SerialAction;
        directInputNumber?: string;
        directInputLineNumber?: integer | string;
        receiptDate?: string;
        deliveryOrderNumber?: string;
        deliveryOrderLineNumber?: integer | string;
        outputDate?: string;
        inputAdjustmentNumber?: string;
        outputAdjustmentNumber?: string;
        inputMovementNumber?: string;
        outputMovementNumber?: string;
        replenishmentNumber?: string;
        transferMovementNumber?: string;
        stockObjectNumber?: string;
        originStockObject?: string;
        serialGroup?: string;
        parentGroup?: string;
        replenishmentDate?: string;
        free1?: string;
        free2?: string;
        free3?: string;
        free4?: string;
        free5?: string;
    }
    export interface SerialTraceabilityBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        depositor: Depositor;
        product: string;
        serialNumber: string;
        double: integer;
        occurrence: integer;
        code: string;
        operationType: SerialAction;
        directInputNumber: string;
        directInputLineNumber: integer;
        receiptDate: string;
        deliveryOrderNumber: string;
        deliveryOrderLineNumber: integer;
        outputDate: string;
        inputAdjustmentNumber: string;
        outputAdjustmentNumber: string;
        inputMovementNumber: string;
        outputMovementNumber: string;
        replenishmentNumber: string;
        transferMovementNumber: string;
        stockObjectNumber: string;
        originStockObject: string;
        serialGroup: string;
        parentGroup: string;
        replenishmentDate: string;
        free1: string;
        free2: string;
        free3: string;
        free4: string;
        free5: string;
    }
    export interface SerialTraceability$Lookups {
        site: QueryOperation<Site>;
        depositor: QueryOperation<Depositor>;
    }
    export interface SerialTraceability$Operations {
        query: QueryOperation<SerialTraceability>;
        read: ReadOperation<SerialTraceability>;
        aggregate: {
            read: AggregateReadOperation<SerialTraceability>;
            query: AggregateQueryOperation<SerialTraceability>;
        };
        lookups(dataOrId: string | { data: SerialTraceabilityInput }): SerialTraceability$Lookups;
        getDefaults: GetDefaultsOperation<SerialTraceability>;
    }
    export interface StockObjectContainerLevels extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        code: string;
        containerLevel: ProductContainer;
        quantityOfConsumptionUnitPerLevel: string;
    }
    export interface StockObjectContainerLevelsInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        site?: string;
        code?: string;
        containerLevel?: string;
        quantityOfConsumptionUnitPerLevel?: decimal | string;
    }
    export interface StockObjectContainerLevelsBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        code: string;
        containerLevel: ProductContainer;
        quantityOfConsumptionUnitPerLevel: string;
    }
    export interface StockObjectContainerLevels$Lookups {
        containerLevel: QueryOperation<ProductContainer>;
    }
    export interface StockObjectContainerLevels$Operations {
        query: QueryOperation<StockObjectContainerLevels>;
        read: ReadOperation<StockObjectContainerLevels>;
        aggregate: {
            read: AggregateReadOperation<StockObjectContainerLevels>;
            query: AggregateQueryOperation<StockObjectContainerLevels>;
        };
        lookups(dataOrId: string | { data: StockObjectContainerLevelsInput }): StockObjectContainerLevels$Lookups;
        getDefaults: GetDefaultsOperation<StockObjectContainerLevels>;
    }
    export interface StockObject extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        code: string;
        depositor: Depositor;
        product: Product;
        store: Store;
        location: Location;
        storeType: StoreType;
        locationType: LocationType;
        containerNumber: string;
        lotNumber: string;
        supportNumber: string;
        container: ProductContainer;
        containerCoefficient: string;
        numberOfConsumptionUnit: string;
        numberOfContainer: string;
        numberOfConsumptionUnitInPendingInput: string;
        numberOfConsumptionUnitInPendingOutput: string;
        stockStatus: StockNature;
        reservationNumber: string;
        source: Origin;
        stockObjectLinkNumber: string;
        fifoDate: string;
        receiptDate: string;
        manufacturedDate: string;
        detentionDate: string;
        sellByDate: string;
        useByDate: string;
        shipByDate: string;
        unStockingAllocationSequence: integer;
        storingDate: string;
        storingTime: integer;
        homogeneousContainer: ProductContainer;
        homogeneousContainerCoefficient: string;
        homogeneousQuantity: string;
        quantityInContainerCorrespondence: string;
        serialNumbers: ClientCollection<SerialNumber>;
        containerLevels: ClientCollection<StockObjectContainerLevels>;
    }
    export interface StockObjectInput extends ClientNodeInput {
        site?: string;
        code?: string;
        depositor?: string;
        product?: string;
        store?: string;
        location?: string;
        storeType?: StoreType;
        locationType?: LocationType;
        containerNumber?: string;
        lotNumber?: string;
        supportNumber?: string;
        container?: string;
        containerCoefficient?: decimal | string;
        numberOfConsumptionUnit?: decimal | string;
        numberOfContainer?: decimal | string;
        numberOfConsumptionUnitInPendingInput?: decimal | string;
        numberOfConsumptionUnitInPendingOutput?: decimal | string;
        stockStatus?: string;
        reservationNumber?: string;
        source?: string;
        stockObjectLinkNumber?: string;
        fifoDate?: string;
        receiptDate?: string;
        manufacturedDate?: string;
        detentionDate?: string;
        sellByDate?: string;
        useByDate?: string;
        shipByDate?: string;
        unStockingAllocationSequence?: integer | string;
        storingDate?: string;
        storingTime?: integer | string;
        homogeneousContainer?: string;
        homogeneousContainerCoefficient?: decimal | string;
        homogeneousQuantity?: decimal | string;
        quantityInContainerCorrespondence?: decimal | string;
        serialNumbers?: Partial<SerialNumberInput>[];
        containerLevels?: Partial<StockObjectContainerLevelsInput>[];
    }
    export interface StockObjectBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        code: string;
        depositor: Depositor;
        product: Product;
        store: Store;
        location: Location;
        storeType: StoreType;
        locationType: LocationType;
        containerNumber: string;
        lotNumber: string;
        supportNumber: string;
        container: ProductContainer;
        containerCoefficient: string;
        numberOfConsumptionUnit: string;
        numberOfContainer: string;
        numberOfConsumptionUnitInPendingInput: string;
        numberOfConsumptionUnitInPendingOutput: string;
        stockStatus: StockNature;
        reservationNumber: string;
        source: Origin;
        stockObjectLinkNumber: string;
        fifoDate: string;
        receiptDate: string;
        manufacturedDate: string;
        detentionDate: string;
        sellByDate: string;
        useByDate: string;
        shipByDate: string;
        unStockingAllocationSequence: integer;
        storingDate: string;
        storingTime: integer;
        homogeneousContainer: ProductContainer;
        homogeneousContainerCoefficient: string;
        homogeneousQuantity: string;
        quantityInContainerCorrespondence: string;
        serialNumbers: ClientCollection<SerialNumber>;
        containerLevels: ClientCollection<StockObjectContainerLevelsBinding>;
    }
    export interface StockObject$Lookups {
        site: QueryOperation<Site>;
        depositor: QueryOperation<Depositor>;
        product: QueryOperation<Product>;
        store: QueryOperation<Store>;
        location: QueryOperation<Location>;
        container: QueryOperation<ProductContainer>;
        stockStatus: QueryOperation<StockNature>;
        source: QueryOperation<Origin>;
        homogeneousContainer: QueryOperation<ProductContainer>;
    }
    export interface StockObject$Operations {
        query: QueryOperation<StockObject>;
        read: ReadOperation<StockObject>;
        aggregate: {
            read: AggregateReadOperation<StockObject>;
            query: AggregateQueryOperation<StockObject>;
        };
        lookups(dataOrId: string | { data: StockObjectInput }): StockObject$Lookups;
        getDefaults: GetDefaultsOperation<StockObject>;
    }
    export interface ProductExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        depositor: Depositor;
        code: string;
        otherCode: string;
        localizedDescription: string;
        localizedDescription2: string;
        localizedShortDescription: string;
        family: Family;
        subFamily: SubFamily;
        group: Group;
        subGroup: SubGroup;
        isKeyInSerialNumber: boolean;
        stockCountClass: StockCountClass;
        numberStockCount: integer;
        isBlockedInInput: boolean;
        isBlockedInOutput: boolean;
        isBlockedInInput2: boolean;
        isBlockedInOutput2: boolean;
        isKeyInLotNumber: boolean;
        isSingleLot: boolean;
        isCrossDocking: boolean;
        isHazardousMaterials: boolean;
        isKeyInControlCode: boolean;
        fifoDateNature: FifoDate;
        source: Origin;
        inputMode: InputMode;
        outputMode: OutputMode;
        autoTransferMode: MovementType;
        detentionLength: integer;
        detentionUnit: UnitLength;
        useByDateLength: integer;
        useByDateUnit: UnitLength;
        sendByDateLength: integer;
        sendByDateUnit: UnitLength;
        sellByDateLength: integer;
        sellByDateUnit: UnitLength;
        fifoTolerance: integer;
        fifoGapUnit: UnitLength;
        netWeight: string;
        netVolume: string;
        pureAlcoholVolume: string;
        price: string;
        material: Risk;
        minimumStock: string;
        alertStock: string;
        maximumStock: string;
        firstArrival: string;
        lastReceipt: string;
        lastOutput: string;
        lastStockCount: string;
        defaultContainer: ProductContainer;
        defaultContainerLevel: ContainerLevel;
        transmittedFromL3: TransmissionL3;
        endOfLife: string;
        isQualityControlManagement: boolean;
        stockStatus: StockNature;
        isSingleLotControl: boolean;
        samplingType: SamplingType;
        generalLevelOfInspection: string;
        aql: string;
        freezingPoint: integer;
        freezingReversibility: ReversibleFreezing;
        ammNo: string;
        referredQuantity: string;
        referredUnit: UnitOfMeasure;
        icpeClass: IcpeClasses;
        flashPoint: integer;
        transportCategory: TransportCategory;
        hazardousMaterialClass: HazardousMaterialsClass;
        tunnelRestriction: string;
        classificationCode: string;
        packagingGroup: PackagingGroup;
        onuCodes: OnuCode;
        solventCode: string;
        technicalField: string;
        isActive: boolean;
        isStockUnitManagement: boolean;
        stockUnit: UnitOfMeasure;
        siteDepositorIdentifier: string;
        suppliersUpcs: ClientCollection<SupplierUpc>;
        productContainers: ClientCollection<ProductContainer>;
        picture: BinaryStream;
        activeMatters: ClientCollection<ProductActiveMatters>;
        isPrintableDescriptions: ClientCollection<ProductIsPrintableDescriptions>;
        percentageActiveMatters: ClientCollection<ProductPercentageActiveMatters>;
        stockObjects: ClientCollection<StockObject>;
    }
    export interface ProductInputExtension {
        site?: string;
        depositor?: string;
        code?: string;
        otherCode?: string;
        localizedDescription?: string;
        localizedDescription2?: string;
        localizedShortDescription?: string;
        family?: string;
        subFamily?: string;
        group?: string;
        subGroup?: string;
        isKeyInSerialNumber?: boolean | string;
        stockCountClass?: string;
        numberStockCount?: integer | string;
        isBlockedInInput?: boolean | string;
        isBlockedInOutput?: boolean | string;
        isBlockedInInput2?: boolean | string;
        isBlockedInOutput2?: boolean | string;
        isKeyInLotNumber?: boolean | string;
        isSingleLot?: boolean | string;
        isCrossDocking?: boolean | string;
        isHazardousMaterials?: boolean | string;
        isKeyInControlCode?: boolean | string;
        fifoDateNature?: FifoDate;
        source?: string;
        inputMode?: string;
        outputMode?: string;
        autoTransferMode?: MovementType;
        detentionLength?: integer | string;
        detentionUnit?: UnitLength;
        useByDateLength?: integer | string;
        useByDateUnit?: UnitLength;
        sendByDateLength?: integer | string;
        sendByDateUnit?: UnitLength;
        sellByDateLength?: integer | string;
        sellByDateUnit?: UnitLength;
        fifoTolerance?: integer | string;
        fifoGapUnit?: UnitLength;
        netWeight?: decimal | string;
        netVolume?: decimal | string;
        pureAlcoholVolume?: decimal | string;
        price?: decimal | string;
        material?: string;
        minimumStock?: decimal | string;
        alertStock?: decimal | string;
        maximumStock?: decimal | string;
        firstArrival?: string;
        lastReceipt?: string;
        lastOutput?: string;
        lastStockCount?: string;
        defaultContainer?: string;
        defaultContainerLevel?: ContainerLevel;
        transmittedFromL3?: TransmissionL3;
        endOfLife?: string;
        isQualityControlManagement?: boolean | string;
        stockStatus?: string;
        isSingleLotControl?: boolean | string;
        samplingType?: SamplingType;
        generalLevelOfInspection?: string;
        aql?: decimal | string;
        freezingPoint?: integer | string;
        freezingReversibility?: ReversibleFreezing;
        ammNo?: string;
        referredQuantity?: decimal | string;
        referredUnit?: string;
        icpeClass?: string;
        flashPoint?: integer | string;
        transportCategory?: string;
        hazardousMaterialClass?: string;
        tunnelRestriction?: string;
        classificationCode?: string;
        packagingGroup?: PackagingGroup;
        onuCodes?: string;
        solventCode?: string;
        technicalField?: string;
        isActive?: boolean | string;
        isStockUnitManagement?: boolean | string;
        stockUnit?: string;
        siteDepositorIdentifier?: string;
        picture?: BinaryStream;
        activeMatters?: Partial<ProductActiveMattersInput>[];
        isPrintableDescriptions?: Partial<ProductIsPrintableDescriptionsInput>[];
        percentageActiveMatters?: Partial<ProductPercentageActiveMattersInput>[];
    }
    export interface ProductBindingExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        depositor: Depositor;
        code: string;
        otherCode: string;
        localizedDescription: string;
        localizedDescription2: string;
        localizedShortDescription: string;
        family: Family;
        subFamily: SubFamily;
        group: Group;
        subGroup: SubGroup;
        isKeyInSerialNumber: boolean;
        stockCountClass: StockCountClass;
        numberStockCount: integer;
        isBlockedInInput: boolean;
        isBlockedInOutput: boolean;
        isBlockedInInput2: boolean;
        isBlockedInOutput2: boolean;
        isKeyInLotNumber: boolean;
        isSingleLot: boolean;
        isCrossDocking: boolean;
        isHazardousMaterials: boolean;
        isKeyInControlCode: boolean;
        fifoDateNature: FifoDate;
        source: Origin;
        inputMode: InputMode;
        outputMode: OutputMode;
        autoTransferMode: MovementType;
        detentionLength: integer;
        detentionUnit: UnitLength;
        useByDateLength: integer;
        useByDateUnit: UnitLength;
        sendByDateLength: integer;
        sendByDateUnit: UnitLength;
        sellByDateLength: integer;
        sellByDateUnit: UnitLength;
        fifoTolerance: integer;
        fifoGapUnit: UnitLength;
        netWeight: string;
        netVolume: string;
        pureAlcoholVolume: string;
        price: string;
        material: Risk;
        minimumStock: string;
        alertStock: string;
        maximumStock: string;
        firstArrival: string;
        lastReceipt: string;
        lastOutput: string;
        lastStockCount: string;
        defaultContainer: ProductContainer;
        defaultContainerLevel: ContainerLevel;
        transmittedFromL3: TransmissionL3;
        endOfLife: string;
        isQualityControlManagement: boolean;
        stockStatus: StockNature;
        isSingleLotControl: boolean;
        samplingType: SamplingType;
        generalLevelOfInspection: string;
        aql: string;
        freezingPoint: integer;
        freezingReversibility: ReversibleFreezing;
        ammNo: string;
        referredQuantity: string;
        referredUnit: UnitOfMeasure;
        icpeClass: IcpeClasses;
        flashPoint: integer;
        transportCategory: TransportCategory;
        hazardousMaterialClass: HazardousMaterialsClass;
        tunnelRestriction: string;
        classificationCode: string;
        packagingGroup: PackagingGroup;
        onuCodes: OnuCode;
        solventCode: string;
        technicalField: string;
        isActive: boolean;
        isStockUnitManagement: boolean;
        stockUnit: UnitOfMeasure;
        siteDepositorIdentifier: string;
        suppliersUpcs: ClientCollection<SupplierUpc>;
        productContainers: ClientCollection<ProductContainer>;
        picture: BinaryStream;
        activeMatters: ClientCollection<ProductActiveMattersBinding>;
        isPrintableDescriptions: ClientCollection<ProductIsPrintableDescriptionsBinding>;
        percentageActiveMatters: ClientCollection<ProductPercentageActiveMattersBinding>;
        stockObjects: ClientCollection<StockObject>;
    }
    export interface Package {
        '@sage/wh-stock-data/SerialNumber': SerialNumber$Operations;
        '@sage/wh-stock-data/SerialTraceability': SerialTraceability$Operations;
        '@sage/wh-stock-data/StockObjectContainerLevels': StockObjectContainerLevels$Operations;
        '@sage/wh-stock-data/StockObject': StockObject$Operations;
    }
    export interface GraphApi
        extends Package,
            SageWhMasterData$Package,
            SageWhProductData$Package,
            SageWhStructure$Package,
            SageWhSystem$Package,
            SageXtremAppMetadata$Package,
            SageXtremX3SystemUtils$Package {}
}
declare module '@sage/wh-stock-data-api' {
    export type * from '@sage/wh-stock-data-api-partial';
}
declare module '@sage/wh-master-data-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/wh-stock-data-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/wh-product-data-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/wh-stock-data-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/wh-structure-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/wh-stock-data-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/wh-system-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/wh-stock-data-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/xtrem-app-metadata-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/wh-stock-data-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/xtrem-x3-system-utils-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/wh-stock-data-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/wh-product-data-api-partial' {
    import type { ProductBindingExtension, ProductExtension, ProductInputExtension } from '@sage/wh-stock-data-api';
    export interface Product extends ProductExtension {}
    export interface ProductBinding extends ProductBindingExtension {}
    export interface ProductInput extends ProductInputExtension {}
}
