"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const rule = {
    defaultOptions: [],
    meta: {
        type: 'problem',
        docs: {
            url: '',
            description: 'check the executionMode setting in graphql parameters.json files',
            // recommended: 'strict',
        },
        schema: [
        // fill in your schema
        ],
        messages: {
            executionModeOnly: 'executionMode must not be set to only',
        },
    },
    create(context) {
        const selector = 'ObjectExpression > Property[key.value="executionMode"][value.value="only"]';
        return {
            [selector](node) {
                context.report({
                    node,
                    messageId: 'executionModeOnly',
                });
            },
        };
    },
};
exports.default = rule;
//# sourceMappingURL=no-exclusive-graphql-tests.js.map