"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.buildComplexDataUpdateActionMemberError = buildComplexDataUpdateActionMemberError;
/**
 * @fileoverview Check dataUpdateActions
 * @author Sage
 */
const xtrem_ts_to_sql_1 = require("@sage/xtrem-ts-to-sql");
function buildComplexDataUpdateActionMemberError(memberName) {
    return `The member ${memberName} is too complex to be converted into a SQL statement.`;
}
function checkIsParseable(context, memberFunction) {
    const memberName = memberFunction.parent.key.name;
    try {
        new xtrem_ts_to_sql_1.EsLintConverter(context).convertFunctionExpression(memberFunction);
    }
    catch {
        // ts-to-sql can't parse this function
        context.report({
            node: memberFunction.parent, // Select the whole property
            messageId: 'error',
            data: {
                error: buildComplexDataUpdateActionMemberError(memberName),
            },
        });
    }
}
const rule = {
    defaultOptions: [],
    meta: {
        type: 'problem',
        docs: {
            url: '',
            description: 'Check dataUpdateActions',
            // recommended: 'strict',
        },
        fixable: undefined, // or "code" or "whitespace"
        schema: [
        // fill in your schema
        ],
        messages: {
            error: '{{error}}',
        },
    },
    create(context) {
        // A dataAction looks like:
        //        export const addSalesUnitOfMeasure = new DataUpdateAction({
        //            description: 'SalesUnitOfMeasure field from item node: data upgrade (->1.3.11)',
        //            node: () => xtremMasterData.nodes.Item,
        //            set: {
        //                salesUnitOfMeasure() {
        //                    return this.stockUnit;
        //                },
        //            },
        //        });
        const membersSelector = 'NewExpression[callee.name="DataUpdateAction"] > ObjectExpression > Property[key.name="set"] > ObjectExpression > Property > FunctionExpression';
        return {
            // All the members (salesUnitOfMeasure, ...) must be ts-to-sql-compliant
            [`${membersSelector}`](functionExpression) {
                checkIsParseable(context, functionExpression);
            },
        };
    },
};
exports.default = rule;
//# sourceMappingURL=check-data-update-actions.js.map