"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const rule = {
    defaultOptions: [],
    meta: {
        type: 'problem',
        docs: {
            url: '',
            description: "Force call to super when inside a data type's controlValue method",
            // recommended: 'strict',
        },
        fixable: undefined, // or "code" or "whitespace"
        schema: [],
        messages: {
            mustCallSuper: 'Mandatory call to super.controlValue: {{error}}.',
        },
    },
    create(context) {
        const inheritFromDataType = ['DataType'];
        const hasSuperClassSelector = 'ClassDeclaration[superClass]';
        const controlValueSelector = 'ClassDeclaration[superClass]:has(' +
            " MethodDefinition[key.name='controlValue']" +
            " FunctionExpression:not(:has(CallExpression[callee.object.type='Super'][callee.property.name='controlValue'])))";
        return {
            [hasSuperClassSelector](node) {
                const name = node.name;
                const superClassName = node.superClass.name;
                if (inheritFromDataType.includes(superClassName))
                    inheritFromDataType.push(name);
            },
            [controlValueSelector](node) {
                if (inheritFromDataType.includes(node.name)) {
                    context.report({
                        node,
                        messageId: 'mustCallSuper',
                        data: {
                            error: 'DataType: controlValue must call super.controlValue',
                        },
                    });
                }
            },
        };
    },
};
exports.default = rule;
//# sourceMappingURL=call-super-in-control.js.map