"use strict";
/**
 * @fileoverview AST explorer
 * @author Sage
 */
Object.defineProperty(exports, "__esModule", { value: true });
const rule = {
    defaultOptions: [],
    meta: {
        type: 'suggestion',
        docs: {
            url: '',
            description: 'ast explorer',
            // deprecated in eslint v9
            // recommended: 'stylistic',
        },
        fixable: undefined, // or "code" or "whitespace"
        schema: [],
        messages: {},
    },
    create(context) {
        const selectAll = '*';
        let currentFilename = '';
        // eslint-disable-next-line no-console
        const log = console.log;
        const logAttributes = (ident, item) => {
            Object.keys(item).forEach((key) => {
                if (!/^(async|body|computed|declare|generator|kind|literal|loc|method|parent|range|raw|shorthand|source|static|specifiers|tokens|type|typeAnnotation|typeParameters)$/.test(key)) {
                    if (item[key] && typeof item[key] === 'object') {
                        if (Array.isArray(item[key])) {
                            log(`${ident}  ${key}.length: ${item[key].length}`); // Stop here!
                        }
                        else {
                            log(`${ident}  ${key}`);
                            logAttributes(`${ident} `, item[key]);
                        }
                    }
                    else if (item[key])
                        log(`${ident}  ${key}: ${item[key]}`);
                }
            });
        };
        return {
            [selectAll]: (node) => {
                const filename = context.getFilename();
                if (currentFilename !== filename) {
                    currentFilename = filename;
                    log(`${Array(121).join('-')}\nFile ${filename}:`);
                }
                let ident = '';
                for (let parent = node; parent; parent = parent.parent, ident += '   ')
                    ;
                const position = node.loc.start;
                log(`${ident}> ${node.type} (${position.line}:${position.column + 1})`);
                logAttributes(ident, node);
            },
        };
    },
};
exports.default = rule;
//# sourceMappingURL=ast-explorer.js.map