"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.rules = exports.configs = void 0;
/**
 * @fileoverview Lint rules for Xtrem development
 * @author Sage
 */
const eslint_config_xtrem_1 = __importDefault(require("@sage/eslint-config-xtrem"));
const lodash_1 = require("lodash");
const node_path_1 = __importDefault(require("node:path"));
// eslint-disable-next-line @typescript-eslint/no-require-imports
const requireIndex = require('requireindex');
// import all rules in lib/rules
const transformDir = (dir) => (0, lodash_1.transform)(requireIndex(node_path_1.default.join(__dirname, dir)), (result, val, key) => {
    result[key] = val.default;
});
const rules = transformDir('rules');
exports.rules = rules;
const configs = {
    ...eslint_config_xtrem_1.default,
    'recommended-json': {
        rules: {
            '@sage/xtrem/no-exclusive-graphql-tests': 'error',
            '@typescript-eslint/*': 'off',
            '@typescript-eslint/semi': 'off',
            '@typescript-eslint/comma-dangle': 'off',
            '@typescript-eslint/no-unused-expressions': 'off',
        },
    },
    'recommended-ts': {
        rules: {
            // Enabled for debug
            // '@sage/xtrem/ast-explorer': 'error',
            '@sage/xtrem/check-nullable-property': 'warn',
            '@sage/xtrem/property-decorators-errors': 'error',
            '@sage/xtrem/property-decorators-warnings': 'warn',
            '@sage/xtrem/check-data-update-actions': 'error',
            '@sage/xtrem/sql-compatible': 'error',
            '@sage/xtrem/call-super-in-control': 'error',
        },
    },
    'ast-explorer-ts': {
        rules: {
            '@sage/xtrem/ast-explorer': 'warn',
        },
    },
    stylistic: {
        rules: {
            '@sage/xtrem/ast-explorer': 'warn',
        },
    },
    recommended: {},
};
exports.configs = configs;
configs.recommended = [
    {
        files: ['lib/**/*.{ts,cts,mts}', 'test/**/*.{ts,cts,mts}'],
        ...configs['recommended-ts'],
    },
    {
        files: ['test/graphql/**/*.json'],
        ...configs['recommended-json'],
    },
];
//# sourceMappingURL=index.js.map