declare const rules: any;
declare const configs: {
    'recommended-json': {
        rules: {
            '@sage/xtrem/no-exclusive-graphql-tests': string;
            '@typescript-eslint/*': string;
            '@typescript-eslint/semi': string;
            '@typescript-eslint/comma-dangle': string;
            '@typescript-eslint/no-unused-expressions': string;
        };
    };
    'recommended-ts': {
        rules: {
            '@sage/xtrem/check-nullable-property': string;
            '@sage/xtrem/property-decorators-errors': string;
            '@sage/xtrem/property-decorators-warnings': string;
            '@sage/xtrem/check-data-update-actions': string;
            '@sage/xtrem/sql-compatible': string;
            '@sage/xtrem/call-super-in-control': string;
        };
    };
    'ast-explorer-ts': {
        rules: {
            '@sage/xtrem/ast-explorer': string;
        };
    };
    stylistic: {
        rules: {
            '@sage/xtrem/ast-explorer': string;
        };
    };
    recommended: {};
    configs: {
        airbnb: {
            rules: {
                "accessor-pairs": string;
                "array-callback-return": (string | {
                    allowImplicit: boolean;
                })[];
                "block-scoped-var": string;
                complexity: (string | number)[];
                "class-methods-use-this": (string | {
                    exceptMethods: string[];
                })[];
                "consistent-return": string;
                "default-case": (string | {
                    commentPattern: string;
                })[];
                "default-case-last": string;
                "default-param-last": string;
                "dot-notation": (string | {
                    allowKeywords: boolean;
                })[];
                eqeqeq: (string | {
                    null: string;
                })[];
                "grouped-accessor-pairs": string;
                "guard-for-in": string;
                "max-classes-per-file": (string | number)[];
                "no-alert": string;
                "no-caller": string;
                "no-case-declarations": string;
                "no-constructor-return": string;
                "no-div-regex": string;
                "no-else-return": (string | {
                    allowElseIf: boolean;
                })[];
                "no-empty-function": (string | {
                    allow: string[];
                })[];
                "no-empty-pattern": string;
                "no-eq-null": string;
                "no-eval": string;
                "no-extend-native": string;
                "no-extra-bind": string;
                "no-extra-label": string;
                "no-fallthrough": string;
                "no-global-assign": (string | {
                    exceptions: never[];
                })[];
                "no-native-reassign": string;
                "no-implicit-coercion": (string | {
                    boolean: boolean;
                    number: boolean;
                    string: boolean;
                    allow: never[];
                })[];
                "no-implicit-globals": string;
                "no-implied-eval": string;
                "no-invalid-this": string;
                "no-iterator": string;
                "no-labels": (string | {
                    allowLoop: boolean;
                    allowSwitch: boolean;
                })[];
                "no-lone-blocks": string;
                "no-loop-func": string;
                "no-magic-numbers": (string | {
                    ignore: never[];
                    ignoreArrayIndexes: boolean;
                    enforceConst: boolean;
                    detectObjects: boolean;
                })[];
                "no-multi-str": string;
                "no-new": string;
                "no-new-func": string;
                "no-new-wrappers": string;
                "no-nonoctal-decimal-escape": string;
                "no-octal": string;
                "no-octal-escape": string;
                "no-param-reassign": (string | {
                    props: boolean;
                    ignorePropertyModificationsFor: string[];
                })[];
                "no-proto": string;
                "no-redeclare": string;
                "no-restricted-properties": (string | {
                    object: string;
                    property: string;
                    message: string;
                } | {
                    property: string;
                    message: string;
                    object?: undefined;
                })[];
                "no-return-assign": string[];
                "no-script-url": string;
                "no-self-assign": (string | {
                    props: boolean;
                })[];
                "no-self-compare": string;
                "no-sequences": string;
                "no-throw-literal": string;
                "no-unmodified-loop-condition": string;
                "no-unused-expressions": (string | {
                    allowShortCircuit: boolean;
                    allowTernary: boolean;
                    allowTaggedTemplates: boolean;
                })[];
                "no-unused-labels": string;
                "no-useless-call": string;
                "no-useless-catch": string;
                "no-useless-concat": string;
                "no-useless-escape": string;
                "no-useless-return": string;
                "no-void": string;
                "no-warning-comments": (string | {
                    terms: string[];
                    location: string;
                })[];
                "no-with": string;
                "prefer-promise-reject-errors": (string | {
                    allowEmptyReject: boolean;
                })[];
                "prefer-named-capture-group": string;
                "prefer-regex-literals": (string | {
                    disallowRedundantWrapping: boolean;
                })[];
                radix: string;
                "require-await": string;
                "require-unicode-regexp": string;
                "vars-on-top": string;
                yoda: string;
                "for-direction": string;
                "getter-return": (string | {
                    allowImplicit: boolean;
                })[];
                "no-async-promise-executor": string;
                "no-await-in-loop": string;
                "no-compare-neg-zero": string;
                "no-cond-assign": string[];
                "no-console": string;
                "no-constant-condition": string;
                "no-control-regex": string;
                "no-debugger": string;
                "no-dupe-args": string;
                "no-dupe-else-if": string;
                "no-dupe-keys": string;
                "no-duplicate-case": string;
                "no-empty": string;
                "no-empty-character-class": string;
                "no-ex-assign": string;
                "no-extra-boolean-cast": string;
                "no-func-assign": string;
                "no-import-assign": string;
                "no-inner-declarations": string;
                "no-invalid-regexp": string;
                "no-irregular-whitespace": string;
                "no-misleading-character-class": string;
                "no-obj-calls": string;
                "no-promise-executor-return": string;
                "no-prototype-builtins": string;
                "no-regex-spaces": string;
                "no-setter-return": string;
                "no-sparse-arrays": string;
                "no-template-curly-in-string": string;
                "no-unreachable": string;
                "no-unreachable-loop": (string | {
                    ignore: never[];
                })[];
                "no-unsafe-finally": string;
                "no-unsafe-negation": string;
                "no-unsafe-optional-chaining": (string | {
                    disallowArithmeticOperators: boolean;
                })[];
                "no-unused-private-class-members": string;
                "no-useless-backreference": string;
                "no-negated-in-lhs": string;
                "require-atomic-updates": string;
                "use-isnan": string;
                "valid-jsdoc": string;
                "valid-typeof": (string | {
                    requireStringLiterals: boolean;
                })[];
                "callback-return": string;
                "global-require": string;
                "handle-callback-err": string;
                "no-mixed-requires": (string | boolean)[];
                "n/no-deprecated-api": string;
                "n/no-path-concat": string;
                "no-process-env": string;
                "no-process-exit": string;
                "no-restricted-modules": string;
                "no-sync": string;
                camelcase: (string | {
                    properties: string;
                    ignoreDestructuring: boolean;
                })[];
                "capitalized-comments": (string | {
                    line: {
                        ignorePattern: string;
                        ignoreInlineComments: boolean;
                        ignoreConsecutiveComments: boolean;
                    };
                    block: {
                        ignorePattern: string;
                        ignoreInlineComments: boolean;
                        ignoreConsecutiveComments: boolean;
                    };
                })[];
                "consistent-this": string;
                "func-name-matching": (string | {
                    includeCommonJSModuleExports: boolean;
                    considerPropertyDescriptor: boolean;
                })[];
                "func-names": string;
                "func-style": string[];
                "id-denylist": string;
                "id-length": string;
                "id-match": string;
                "line-comment-position": (string | {
                    position: string;
                    ignorePattern: string;
                    applyDefaultPatterns: boolean;
                })[];
                "max-depth": (string | number)[];
                "max-lines": (string | {
                    max: number;
                    skipBlankLines: boolean;
                    skipComments: boolean;
                })[];
                "max-lines-per-function": (string | {
                    max: number;
                    skipBlankLines: boolean;
                    skipComments: boolean;
                    IIFEs: boolean;
                })[];
                "max-nested-callbacks": string;
                "max-params": (string | number)[];
                "max-statements": (string | number)[];
                "multiline-comment-style": string[];
                "new-cap": (string | {
                    newIsCap: boolean;
                    newIsCapExceptions: never[];
                    capIsNew: boolean;
                    capIsNewExceptions: string[];
                })[];
                "newline-after-var": string;
                "newline-before-return": string;
                "no-array-constructor": string;
                "no-bitwise": string;
                "no-continue": string;
                "no-inline-comments": string;
                "no-lonely-if": string;
                "no-multi-assign": string[];
                "no-negated-condition": string;
                "no-nested-ternary": string;
                "no-object-constructor": string;
                "no-plusplus": string;
                "no-restricted-syntax": (string | {
                    selector: string;
                    message: string;
                })[];
                "no-ternary": string;
                "no-underscore-dangle": (string | {
                    allow: string[];
                    allowAfterThis: boolean;
                    allowAfterSuper: boolean;
                    enforceInMethodNames: boolean;
                })[];
                "no-unneeded-ternary": (string | {
                    defaultAssignment: boolean;
                })[];
                "one-var": string[];
                "operator-assignment": string[];
                "padding-line-between-statements": string;
                "prefer-exponentiation-operator": string;
                "prefer-object-spread": string;
                "require-jsdoc": string;
                "sort-keys": (string | {
                    caseSensitive: boolean;
                    natural: boolean;
                })[];
                "sort-vars": string;
                "@stylistic/spaced-comment": (string | {
                    line: {
                        exceptions: string[];
                        markers: string[];
                    };
                    block: {
                        exceptions: string[];
                        markers: string[];
                        balanced: boolean;
                    };
                })[];
                "unicode-bom": string[];
                "init-declarations": string;
                "no-catch-shadow": string;
                "no-delete-var": string;
                "no-label-var": string;
                "no-restricted-globals": (string | {
                    name: string;
                    message: string;
                })[];
                "no-shadow": string;
                "no-shadow-restricted-names": string;
                "no-undef": string;
                "no-undef-init": string;
                "no-undefined": string;
                "no-unused-vars": (string | {
                    vars: string;
                    args: string;
                    ignoreRestSiblings: boolean;
                })[];
                "no-use-before-define": (string | {
                    functions: boolean;
                    classes: boolean;
                    variables: boolean;
                })[];
                "arrow-body-style": (string | {
                    requireReturnForObjectLiteral: boolean;
                })[];
                "constructor-super": string;
                "no-class-assign": string;
                "no-const-assign": string;
                "no-dupe-class-members": string;
                "no-duplicate-imports": string;
                "no-new-native-nonconstructor": string;
                "no-restricted-exports": (string | {
                    restrictedNamedExports: string[];
                })[];
                "no-restricted-imports": (string | {
                    paths: never[];
                    patterns: never[];
                })[];
                "no-this-before-super": string;
                "no-useless-computed-key": string;
                "no-useless-constructor": string;
                "no-useless-rename": (string | {
                    ignoreDestructuring: boolean;
                    ignoreImport: boolean;
                    ignoreExport: boolean;
                })[];
                "no-var": string;
                "object-shorthand": (string | {
                    ignoreConstructors: boolean;
                    avoidQuotes: boolean;
                })[];
                "prefer-arrow-callback": (string | {
                    allowNamedFunctions: boolean;
                    allowUnboundThis: boolean;
                })[];
                "prefer-const": (string | {
                    destructuring: string;
                    ignoreReadBeforeAssign: boolean;
                })[];
                "prefer-destructuring": (string | {
                    VariableDeclarator: {
                        array: boolean;
                        object: boolean;
                    };
                    AssignmentExpression: {
                        array: boolean;
                        object: boolean;
                    };
                    enforceForRenamedProperties?: undefined;
                } | {
                    enforceForRenamedProperties: boolean;
                    VariableDeclarator?: undefined;
                    AssignmentExpression?: undefined;
                })[];
                "prefer-numeric-literals": string;
                "prefer-reflect": string;
                "prefer-rest-params": string;
                "prefer-spread": string;
                "prefer-template": string;
                "require-yield": string;
                "sort-imports": (string | {
                    ignoreCase: boolean;
                    ignoreDeclarationSort: boolean;
                    ignoreMemberSort: boolean;
                    memberSyntaxSortOrder: string[];
                })[];
                "symbol-description": string;
                "import/no-unresolved": (string | {
                    commonjs: boolean;
                    caseSensitive: boolean;
                })[];
                "import/named": string;
                "import/default": string;
                "import/namespace": string;
                "import/export": string;
                "import/no-named-as-default": string;
                "import/no-named-as-default-member": string;
                "import/no-deprecated": string;
                "import/no-extraneous-dependencies": (string | {
                    devDependencies: string[];
                    optionalDependencies: boolean;
                })[];
                "import/no-mutable-exports": string;
                "import/no-commonjs": string;
                "import/no-amd": string;
                "import/no-nodejs-modules": string;
                "import/first": string;
                "import/imports-first": string;
                "import/no-duplicates": string;
                "import/no-namespace": string;
                "import/extensions": (string | {
                    js: string;
                    mjs: string;
                    jsx: string;
                })[];
                "import/order": (string | {
                    groups: string[][];
                })[];
                "import/newline-after-import": string;
                "import/prefer-default-export": string;
                "import/no-restricted-paths": string;
                "import/max-dependencies": (string | {
                    max: number;
                })[];
                "import/no-absolute-path": string;
                "import/no-dynamic-require": string;
                "import/no-internal-modules": (string | {
                    allow: never[];
                })[];
                "import/unambiguous": string;
                "import/no-webpack-loader-syntax": string;
                "import/no-unassigned-import": string;
                "import/no-named-default": string;
                "import/no-anonymous-default-export": (string | {
                    allowArray: boolean;
                    allowArrowFunction: boolean;
                    allowAnonymousClass: boolean;
                    allowAnonymousFunction: boolean;
                    allowLiteral: boolean;
                    allowObject: boolean;
                })[];
                "import/exports-last": string;
                "import/group-exports": string;
                "import/no-default-export": string;
                "import/no-named-export": string;
                "import/no-self-import": string;
                "import/no-cycle": (string | {
                    maxDepth: number;
                })[];
                "import/no-useless-path-segments": (string | {
                    commonjs: boolean;
                })[];
                "import/dynamic-import-chunkname": (string | {
                    importFunctions: never[];
                    webpackChunknameFormat: string;
                })[];
                "import/no-relative-parent-imports": string;
                "import/no-unused-modules": (string | {
                    ignoreExports: never[];
                    missingExports: boolean;
                    unusedExports: boolean;
                })[];
                "import/no-import-module-exports": (string | {
                    exceptions: never[];
                })[];
                "import/no-relative-packages": string;
                strict: string[];
                "react/display-name": (string | {
                    ignoreTranspilerName: boolean;
                })[];
                "react/forbid-prop-types": (string | {
                    forbid: string[];
                    checkContextTypes: boolean;
                    checkChildContextTypes: boolean;
                })[];
                "react/forbid-dom-props": (string | {
                    forbid: never[];
                })[];
                "react/jsx-boolean-value": (string | {
                    always: never[];
                })[];
                "react/jsx-handler-names": (string | {
                    eventHandlerPrefix: string;
                    eventHandlerPropPrefix: string;
                })[];
                "react/jsx-key": string;
                "react/jsx-no-bind": (string | {
                    ignoreRefs: boolean;
                    allowArrowFunctions: boolean;
                    allowFunctions: boolean;
                    allowBind: boolean;
                    ignoreDOMComponents: boolean;
                })[];
                "react/jsx-no-duplicate-props": (string | {
                    ignoreCase: boolean;
                })[];
                "react/jsx-no-literals": (string | {
                    noStrings: boolean;
                })[];
                "react/jsx-no-undef": string;
                "react/jsx-pascal-case": (string | {
                    allowAllCaps: boolean;
                    ignore: never[];
                })[];
                "react/sort-prop-types": (string | {
                    ignoreCase: boolean;
                    callbacksLast: boolean;
                    requiredFirst: boolean;
                    sortShapeProp: boolean;
                })[];
                "react/jsx-sort-prop-types": string;
                "react/jsx-sort-props": (string | {
                    ignoreCase: boolean;
                    callbacksLast: boolean;
                    shorthandFirst: boolean;
                    shorthandLast: boolean;
                    noSortAlphabetically: boolean;
                    reservedFirst: boolean;
                })[];
                "react/jsx-sort-default-props": (string | {
                    ignoreCase: boolean;
                })[];
                "react/jsx-uses-react": string[];
                "react/jsx-uses-vars": string;
                "react/no-danger": string;
                "react/no-deprecated": string[];
                "react/no-did-mount-set-state": string;
                "react/no-did-update-set-state": string;
                "react/no-will-update-set-state": string;
                "react/no-direct-mutation-state": string;
                "react/no-is-mounted": string;
                "react/no-multi-comp": string;
                "react/no-set-state": string;
                "react/no-string-refs": string;
                "react/no-unknown-property": string;
                "react/prefer-es6-class": string[];
                "react/prefer-stateless-function": (string | {
                    ignorePureComponents: boolean;
                })[];
                "react/prop-types": (string | {
                    ignore: never[];
                    customValidators: never[];
                    skipUndeclared: boolean;
                })[];
                "react/react-in-jsx-scope": string;
                "react/require-render-return": string;
                "react/self-closing-comp": string;
                "react/sort-comp": (string | {
                    order: string[];
                    groups: {
                        lifecycle: string[];
                        rendering: string[];
                    };
                })[];
                "react/jsx-no-target-blank": (string | {
                    enforceDynamicLinks: string;
                })[];
                "react/jsx-filename-extension": (string | {
                    extensions: string[];
                })[];
                "react/jsx-no-comment-textnodes": string;
                "react/no-render-return-value": string;
                "react/require-optimization": (string | {
                    allowDecorators: never[];
                })[];
                "react/no-find-dom-node": string;
                "react/forbid-component-props": (string | {
                    forbid: never[];
                })[];
                "react/forbid-elements": (string | {
                    forbid: never[];
                })[];
                "react/no-danger-with-children": string;
                "react/no-unused-prop-types": (string | {
                    customValidators: never[];
                    skipShapeProps: boolean;
                })[];
                "react/style-prop-object": string;
                "react/no-unescaped-entities": string;
                "react/no-children-prop": string;
                "react/no-array-index-key": string;
                "react/require-default-props": (string | {
                    forbidDefaultForRequired: boolean;
                })[];
                "react/forbid-foreign-prop-types": (string | {
                    allowInPropTypes: boolean;
                })[];
                "react/void-dom-elements-no-children": string;
                "react/default-props-match-prop-types": (string | {
                    allowRequiredDefaults: boolean;
                })[];
                "react/no-redundant-should-component-update": string;
                "react/no-unused-state": string;
                "react/boolean-prop-naming": (string | {
                    propTypeNames: string[];
                    rule: string;
                })[];
                "react/no-typos": string;
                "react/jsx-curly-brace-presence": (string | {
                    props: string;
                    children: string;
                })[];
                "react/destructuring-assignment": string[];
                "react/no-access-state-in-setstate": string;
                "react/button-has-type": (string | {
                    button: boolean;
                    submit: boolean;
                    reset: boolean;
                })[];
                "react/no-this-in-sfc": string;
                "react/jsx-max-depth": string;
                "react/no-unsafe": string;
                "react/jsx-fragments": string[];
                "react/state-in-constructor": string[];
                "react/static-property-placement": string[];
                "react/jsx-props-no-spreading": (string | {
                    html: string;
                    custom: string;
                    explicitSpread: string;
                    exceptions: never[];
                })[];
                "react/prefer-read-only-props": string;
                "react/jsx-no-script-url": (string | {
                    name: string;
                    props: string[];
                }[])[];
                "react/jsx-no-useless-fragment": string;
                "react/no-adjacent-inline-elements": string;
                "react/function-component-definition": (string | {
                    namedComponents: string[];
                    unnamedComponents: string;
                })[];
                "react/jsx-no-constructed-context-values": string;
                "react/no-unstable-nested-components": string;
                "react/no-namespace": string;
                "react/prefer-exact-props": string;
                "react/no-arrow-function-lifecycle": string;
                "react/no-invalid-html-attribute": string;
                "react/no-unused-class-component-methods": string;
                "jsx-a11y/accessible-emoji": string;
                "jsx-a11y/alt-text": (string | {
                    elements: string[];
                    img: never[];
                    object: never[];
                    area: never[];
                    "input[type=\"image\"]": never[];
                })[];
                "jsx-a11y/anchor-has-content": (string | {
                    components: never[];
                })[];
                "jsx-a11y/anchor-is-valid": (string | {
                    components: string[];
                    specialLink: string[];
                    aspects: string[];
                })[];
                "jsx-a11y/aria-activedescendant-has-tabindex": string;
                "jsx-a11y/aria-props": string;
                "jsx-a11y/aria-proptypes": string;
                "jsx-a11y/aria-role": (string | {
                    ignoreNonDOM: boolean;
                })[];
                "jsx-a11y/aria-unsupported-elements": string;
                "jsx-a11y/autocomplete-valid": (string | {
                    inputComponents: never[];
                })[];
                "jsx-a11y/click-events-have-key-events": string;
                "jsx-a11y/control-has-associated-label": (string | {
                    labelAttributes: string[];
                    controlComponents: never[];
                    ignoreElements: string[];
                    ignoreRoles: string[];
                    depth: number;
                })[];
                "jsx-a11y/heading-has-content": (string | {
                    components: string[];
                })[];
                "jsx-a11y/html-has-lang": string;
                "jsx-a11y/iframe-has-title": string;
                "jsx-a11y/img-redundant-alt": string;
                "jsx-a11y/interactive-supports-focus": string;
                "jsx-a11y/label-has-associated-control": (string | {
                    labelComponents: never[];
                    labelAttributes: never[];
                    controlComponents: never[];
                    assert: string;
                    depth: number;
                })[];
                "jsx-a11y/lang": string;
                "jsx-a11y/media-has-caption": (string | {
                    audio: never[];
                    video: never[];
                    track: never[];
                })[];
                "jsx-a11y/mouse-events-have-key-events": string;
                "jsx-a11y/no-access-key": string;
                "jsx-a11y/no-autofocus": (string | {
                    ignoreNonDOM: boolean;
                })[];
                "jsx-a11y/no-distracting-elements": (string | {
                    elements: string[];
                })[];
                "jsx-a11y/no-interactive-element-to-noninteractive-role": (string | {
                    tr: string[];
                })[];
                "jsx-a11y/no-noninteractive-element-interactions": (string | {
                    handlers: string[];
                })[];
                "jsx-a11y/no-noninteractive-element-to-interactive-role": (string | {
                    ul: string[];
                    ol: string[];
                    li: string[];
                    table: string[];
                    td: string[];
                })[];
                "jsx-a11y/no-noninteractive-tabindex": (string | {
                    tags: never[];
                    roles: string[];
                })[];
                "jsx-a11y/no-onchange": string;
                "jsx-a11y/no-redundant-roles": string;
                "jsx-a11y/no-static-element-interactions": (string | {
                    handlers: string[];
                })[];
                "jsx-a11y/role-has-required-aria-props": string;
                "jsx-a11y/role-supports-aria-props": string;
                "jsx-a11y/scope": string;
                "jsx-a11y/tabindex-no-positive": string;
                "jsx-a11y/label-has-for": (string | {
                    components: never[];
                    required: {
                        every: string[];
                    };
                    allowChildren: boolean;
                })[];
            };
        };
        "airbnb-typescript": {
            rules: {
                camelcase: string;
                "@typescript-eslint/naming-convention": (string | {
                    selector: string;
                    format: string[];
                })[];
                "default-param-last": string;
                "@typescript-eslint/default-param-last": string;
                "dot-notation": string;
                "@typescript-eslint/dot-notation": (string | {
                    allowKeywords: boolean;
                })[];
                "@stylistic/lines-between-class-members": (string | {
                    exceptAfterSingleLine: boolean;
                })[];
                "no-array-constructor": string;
                "@typescript-eslint/no-array-constructor": string;
                "no-dupe-class-members": string;
                "@typescript-eslint/no-dupe-class-members": string;
                "no-empty-function": string;
                "@typescript-eslint/no-empty-function": (string | {
                    allow: string[];
                })[];
                "no-implied-eval": string;
                "no-new-func": string;
                "@typescript-eslint/no-implied-eval": string;
                "no-loop-func": string;
                "@typescript-eslint/no-loop-func": string;
                "no-magic-numbers": string;
                "@typescript-eslint/no-magic-numbers": (string | {
                    ignore: never[];
                    ignoreArrayIndexes: boolean;
                    enforceConst: boolean;
                    detectObjects: boolean;
                })[];
                "no-redeclare": string;
                "@typescript-eslint/no-redeclare": string;
                "no-shadow": string;
                "@typescript-eslint/no-shadow": string;
                "no-throw-literal": string;
                "no-unused-expressions": string;
                "@typescript-eslint/no-unused-expressions": (string | {
                    allowShortCircuit: boolean;
                    allowTernary: boolean;
                    allowTaggedTemplates: boolean;
                })[];
                "no-unused-vars": string;
                "@typescript-eslint/no-unused-vars": (string | {
                    vars: string;
                    args: string;
                    ignoreRestSiblings: boolean;
                })[];
                "no-use-before-define": string;
                "@typescript-eslint/no-use-before-define": (string | {
                    functions: boolean;
                    classes: boolean;
                    variables: boolean;
                })[];
                "no-useless-constructor": string;
                "@typescript-eslint/no-useless-constructor": string;
                "require-await": string;
                "@typescript-eslint/require-await": string;
                "@typescript-eslint/return-await": string[];
                "import/extensions": (string | {
                    js: string;
                    mjs: string;
                    jsx: string;
                    ts: string;
                    tsx: string;
                })[];
                "import/no-extraneous-dependencies": (string | {
                    devDependencies: string[];
                    optionalDependencies: boolean;
                })[];
            };
        };
        recommended: ({
            rules: {
                "accessor-pairs": string;
                "array-callback-return": (string | {
                    allowImplicit: boolean;
                })[];
                "block-scoped-var": string;
                complexity: (string | number)[];
                "class-methods-use-this": (string | {
                    exceptMethods: string[];
                })[];
                "consistent-return": string;
                "default-case": (string | {
                    commentPattern: string;
                })[];
                "default-case-last": string;
                "default-param-last": string;
                "dot-notation": (string | {
                    allowKeywords: boolean;
                })[];
                eqeqeq: (string | {
                    null: string;
                })[];
                "grouped-accessor-pairs": string;
                "guard-for-in": string;
                "max-classes-per-file": (string | number)[];
                "no-alert": string;
                "no-caller": string;
                "no-case-declarations": string;
                "no-constructor-return": string;
                "no-div-regex": string;
                "no-else-return": (string | {
                    allowElseIf: boolean;
                })[];
                "no-empty-function": (string | {
                    allow: string[];
                })[];
                "no-empty-pattern": string;
                "no-eq-null": string;
                "no-eval": string;
                "no-extend-native": string;
                "no-extra-bind": string;
                "no-extra-label": string;
                "no-fallthrough": string;
                "no-global-assign": (string | {
                    exceptions: never[];
                })[];
                "no-native-reassign": string;
                "no-implicit-coercion": (string | {
                    boolean: boolean;
                    number: boolean;
                    string: boolean;
                    allow: never[];
                })[];
                "no-implicit-globals": string;
                "no-implied-eval": string;
                "no-invalid-this": string;
                "no-iterator": string;
                "no-labels": (string | {
                    allowLoop: boolean;
                    allowSwitch: boolean;
                })[];
                "no-lone-blocks": string;
                "no-loop-func": string;
                "no-magic-numbers": (string | {
                    ignore: never[];
                    ignoreArrayIndexes: boolean;
                    enforceConst: boolean;
                    detectObjects: boolean;
                })[];
                "no-multi-str": string;
                "no-new": string;
                "no-new-func": string;
                "no-new-wrappers": string;
                "no-nonoctal-decimal-escape": string;
                "no-octal": string;
                "no-octal-escape": string;
                "no-param-reassign": (string | {
                    props: boolean;
                    ignorePropertyModificationsFor: string[];
                })[];
                "no-proto": string;
                "no-redeclare": string;
                "no-restricted-properties": (string | {
                    object: string;
                    property: string;
                    message: string;
                } | {
                    property: string;
                    message: string;
                    object?: undefined;
                })[];
                "no-return-assign": string[];
                "no-script-url": string;
                "no-self-assign": (string | {
                    props: boolean;
                })[];
                "no-self-compare": string;
                "no-sequences": string;
                "no-throw-literal": string;
                "no-unmodified-loop-condition": string;
                "no-unused-expressions": (string | {
                    allowShortCircuit: boolean;
                    allowTernary: boolean;
                    allowTaggedTemplates: boolean;
                })[];
                "no-unused-labels": string;
                "no-useless-call": string;
                "no-useless-catch": string;
                "no-useless-concat": string;
                "no-useless-escape": string;
                "no-useless-return": string;
                "no-void": string;
                "no-warning-comments": (string | {
                    terms: string[];
                    location: string;
                })[];
                "no-with": string;
                "prefer-promise-reject-errors": (string | {
                    allowEmptyReject: boolean;
                })[];
                "prefer-named-capture-group": string;
                "prefer-regex-literals": (string | {
                    disallowRedundantWrapping: boolean;
                })[];
                radix: string;
                "require-await": string;
                "require-unicode-regexp": string;
                "vars-on-top": string;
                yoda: string;
                "for-direction": string;
                "getter-return": (string | {
                    allowImplicit: boolean;
                })[];
                "no-async-promise-executor": string;
                "no-await-in-loop": string;
                "no-compare-neg-zero": string;
                "no-cond-assign": string[];
                "no-console": string;
                "no-constant-condition": string;
                "no-control-regex": string;
                "no-debugger": string;
                "no-dupe-args": string;
                "no-dupe-else-if": string;
                "no-dupe-keys": string;
                "no-duplicate-case": string;
                "no-empty": string;
                "no-empty-character-class": string;
                "no-ex-assign": string;
                "no-extra-boolean-cast": string;
                "no-func-assign": string;
                "no-import-assign": string;
                "no-inner-declarations": string;
                "no-invalid-regexp": string;
                "no-irregular-whitespace": string;
                "no-misleading-character-class": string;
                "no-obj-calls": string;
                "no-promise-executor-return": string;
                "no-prototype-builtins": string;
                "no-regex-spaces": string;
                "no-setter-return": string;
                "no-sparse-arrays": string;
                "no-template-curly-in-string": string;
                "no-unreachable": string;
                "no-unreachable-loop": (string | {
                    ignore: never[];
                })[];
                "no-unsafe-finally": string;
                "no-unsafe-negation": string;
                "no-unsafe-optional-chaining": (string | {
                    disallowArithmeticOperators: boolean;
                })[];
                "no-unused-private-class-members": string;
                "no-useless-backreference": string;
                "no-negated-in-lhs": string;
                "require-atomic-updates": string;
                "use-isnan": string;
                "valid-jsdoc": string;
                "valid-typeof": (string | {
                    requireStringLiterals: boolean;
                })[];
                "callback-return": string;
                "global-require": string;
                "handle-callback-err": string;
                "no-mixed-requires": (string | boolean)[];
                "n/no-deprecated-api": string;
                "n/no-path-concat": string;
                "no-process-env": string;
                "no-process-exit": string;
                "no-restricted-modules": string;
                "no-sync": string;
                camelcase: (string | {
                    properties: string;
                    ignoreDestructuring: boolean;
                })[];
                "capitalized-comments": (string | {
                    line: {
                        ignorePattern: string;
                        ignoreInlineComments: boolean;
                        ignoreConsecutiveComments: boolean;
                    };
                    block: {
                        ignorePattern: string;
                        ignoreInlineComments: boolean;
                        ignoreConsecutiveComments: boolean;
                    };
                })[];
                "consistent-this": string;
                "func-name-matching": (string | {
                    includeCommonJSModuleExports: boolean;
                    considerPropertyDescriptor: boolean;
                })[];
                "func-names": string;
                "func-style": string[];
                "id-denylist": string;
                "id-length": string;
                "id-match": string;
                "line-comment-position": (string | {
                    position: string;
                    ignorePattern: string;
                    applyDefaultPatterns: boolean;
                })[];
                "max-depth": (string | number)[];
                "max-lines": (string | {
                    max: number;
                    skipBlankLines: boolean;
                    skipComments: boolean;
                })[];
                "max-lines-per-function": (string | {
                    max: number;
                    skipBlankLines: boolean;
                    skipComments: boolean;
                    IIFEs: boolean;
                })[];
                "max-nested-callbacks": string;
                "max-params": (string | number)[];
                "max-statements": (string | number)[];
                "multiline-comment-style": string[];
                "new-cap": (string | {
                    newIsCap: boolean;
                    newIsCapExceptions: never[];
                    capIsNew: boolean;
                    capIsNewExceptions: string[];
                })[];
                "newline-after-var": string;
                "newline-before-return": string;
                "no-array-constructor": string;
                "no-bitwise": string;
                "no-continue": string;
                "no-inline-comments": string;
                "no-lonely-if": string;
                "no-multi-assign": string[];
                "no-negated-condition": string;
                "no-nested-ternary": string;
                "no-object-constructor": string;
                "no-plusplus": string;
                "no-restricted-syntax": (string | {
                    selector: string;
                    message: string;
                })[];
                "no-ternary": string;
                "no-underscore-dangle": (string | {
                    allow: string[];
                    allowAfterThis: boolean;
                    allowAfterSuper: boolean;
                    enforceInMethodNames: boolean;
                })[];
                "no-unneeded-ternary": (string | {
                    defaultAssignment: boolean;
                })[];
                "one-var": string[];
                "operator-assignment": string[];
                "padding-line-between-statements": string;
                "prefer-exponentiation-operator": string;
                "prefer-object-spread": string;
                "require-jsdoc": string;
                "sort-keys": (string | {
                    caseSensitive: boolean;
                    natural: boolean;
                })[];
                "sort-vars": string;
                "@stylistic/spaced-comment": (string | {
                    line: {
                        exceptions: string[];
                        markers: string[];
                    };
                    block: {
                        exceptions: string[];
                        markers: string[];
                        balanced: boolean;
                    };
                })[];
                "unicode-bom": string[];
                "init-declarations": string;
                "no-catch-shadow": string;
                "no-delete-var": string;
                "no-label-var": string;
                "no-restricted-globals": (string | {
                    name: string;
                    message: string;
                })[];
                "no-shadow": string;
                "no-shadow-restricted-names": string;
                "no-undef": string;
                "no-undef-init": string;
                "no-undefined": string;
                "no-unused-vars": (string | {
                    vars: string;
                    args: string;
                    ignoreRestSiblings: boolean;
                })[];
                "no-use-before-define": (string | {
                    functions: boolean;
                    classes: boolean;
                    variables: boolean;
                })[];
                "arrow-body-style": (string | {
                    requireReturnForObjectLiteral: boolean;
                })[];
                "constructor-super": string;
                "no-class-assign": string;
                "no-const-assign": string;
                "no-dupe-class-members": string;
                "no-duplicate-imports": string;
                "no-new-native-nonconstructor": string;
                "no-restricted-exports": (string | {
                    restrictedNamedExports: string[];
                })[];
                "no-restricted-imports": (string | {
                    paths: never[];
                    patterns: never[];
                })[];
                "no-this-before-super": string;
                "no-useless-computed-key": string;
                "no-useless-constructor": string;
                "no-useless-rename": (string | {
                    ignoreDestructuring: boolean;
                    ignoreImport: boolean;
                    ignoreExport: boolean;
                })[];
                "no-var": string;
                "object-shorthand": (string | {
                    ignoreConstructors: boolean;
                    avoidQuotes: boolean;
                })[];
                "prefer-arrow-callback": (string | {
                    allowNamedFunctions: boolean;
                    allowUnboundThis: boolean;
                })[];
                "prefer-const": (string | {
                    destructuring: string;
                    ignoreReadBeforeAssign: boolean;
                })[];
                "prefer-destructuring": (string | {
                    VariableDeclarator: {
                        array: boolean;
                        object: boolean;
                    };
                    AssignmentExpression: {
                        array: boolean;
                        object: boolean;
                    };
                    enforceForRenamedProperties?: undefined;
                } | {
                    enforceForRenamedProperties: boolean;
                    VariableDeclarator?: undefined;
                    AssignmentExpression?: undefined;
                })[];
                "prefer-numeric-literals": string;
                "prefer-reflect": string;
                "prefer-rest-params": string;
                "prefer-spread": string;
                "prefer-template": string;
                "require-yield": string;
                "sort-imports": (string | {
                    ignoreCase: boolean;
                    ignoreDeclarationSort: boolean;
                    ignoreMemberSort: boolean;
                    memberSyntaxSortOrder: string[];
                })[];
                "symbol-description": string;
                "import/no-unresolved": (string | {
                    commonjs: boolean;
                    caseSensitive: boolean;
                })[];
                "import/named": string;
                "import/default": string;
                "import/namespace": string;
                "import/export": string;
                "import/no-named-as-default": string;
                "import/no-named-as-default-member": string;
                "import/no-deprecated": string;
                "import/no-extraneous-dependencies": (string | {
                    devDependencies: string[];
                    optionalDependencies: boolean;
                })[];
                "import/no-mutable-exports": string;
                "import/no-commonjs": string;
                "import/no-amd": string;
                "import/no-nodejs-modules": string;
                "import/first": string;
                "import/imports-first": string;
                "import/no-duplicates": string;
                "import/no-namespace": string;
                "import/extensions": (string | {
                    js: string;
                    mjs: string;
                    jsx: string;
                })[];
                "import/order": (string | {
                    groups: string[][];
                })[];
                "import/newline-after-import": string;
                "import/prefer-default-export": string;
                "import/no-restricted-paths": string;
                "import/max-dependencies": (string | {
                    max: number;
                })[];
                "import/no-absolute-path": string;
                "import/no-dynamic-require": string;
                "import/no-internal-modules": (string | {
                    allow: never[];
                })[];
                "import/unambiguous": string;
                "import/no-webpack-loader-syntax": string;
                "import/no-unassigned-import": string;
                "import/no-named-default": string;
                "import/no-anonymous-default-export": (string | {
                    allowArray: boolean;
                    allowArrowFunction: boolean;
                    allowAnonymousClass: boolean;
                    allowAnonymousFunction: boolean;
                    allowLiteral: boolean;
                    allowObject: boolean;
                })[];
                "import/exports-last": string;
                "import/group-exports": string;
                "import/no-default-export": string;
                "import/no-named-export": string;
                "import/no-self-import": string;
                "import/no-cycle": (string | {
                    maxDepth: number;
                })[];
                "import/no-useless-path-segments": (string | {
                    commonjs: boolean;
                })[];
                "import/dynamic-import-chunkname": (string | {
                    importFunctions: never[];
                    webpackChunknameFormat: string;
                })[];
                "import/no-relative-parent-imports": string;
                "import/no-unused-modules": (string | {
                    ignoreExports: never[];
                    missingExports: boolean;
                    unusedExports: boolean;
                })[];
                "import/no-import-module-exports": (string | {
                    exceptions: never[];
                })[];
                "import/no-relative-packages": string;
                strict: string[];
                "react/display-name": (string | {
                    ignoreTranspilerName: boolean;
                })[];
                "react/forbid-prop-types": (string | {
                    forbid: string[];
                    checkContextTypes: boolean;
                    checkChildContextTypes: boolean;
                })[];
                "react/forbid-dom-props": (string | {
                    forbid: never[];
                })[];
                "react/jsx-boolean-value": (string | {
                    always: never[];
                })[];
                "react/jsx-handler-names": (string | {
                    eventHandlerPrefix: string;
                    eventHandlerPropPrefix: string;
                })[];
                "react/jsx-key": string;
                "react/jsx-no-bind": (string | {
                    ignoreRefs: boolean;
                    allowArrowFunctions: boolean;
                    allowFunctions: boolean;
                    allowBind: boolean;
                    ignoreDOMComponents: boolean;
                })[];
                "react/jsx-no-duplicate-props": (string | {
                    ignoreCase: boolean;
                })[];
                "react/jsx-no-literals": (string | {
                    noStrings: boolean;
                })[];
                "react/jsx-no-undef": string;
                "react/jsx-pascal-case": (string | {
                    allowAllCaps: boolean;
                    ignore: never[];
                })[];
                "react/sort-prop-types": (string | {
                    ignoreCase: boolean;
                    callbacksLast: boolean;
                    requiredFirst: boolean;
                    sortShapeProp: boolean;
                })[];
                "react/jsx-sort-prop-types": string;
                "react/jsx-sort-props": (string | {
                    ignoreCase: boolean;
                    callbacksLast: boolean;
                    shorthandFirst: boolean;
                    shorthandLast: boolean;
                    noSortAlphabetically: boolean;
                    reservedFirst: boolean;
                })[];
                "react/jsx-sort-default-props": (string | {
                    ignoreCase: boolean;
                })[];
                "react/jsx-uses-react": string[];
                "react/jsx-uses-vars": string;
                "react/no-danger": string;
                "react/no-deprecated": string[];
                "react/no-did-mount-set-state": string;
                "react/no-did-update-set-state": string;
                "react/no-will-update-set-state": string;
                "react/no-direct-mutation-state": string;
                "react/no-is-mounted": string;
                "react/no-multi-comp": string;
                "react/no-set-state": string;
                "react/no-string-refs": string;
                "react/no-unknown-property": string;
                "react/prefer-es6-class": string[];
                "react/prefer-stateless-function": (string | {
                    ignorePureComponents: boolean;
                })[];
                "react/prop-types": (string | {
                    ignore: never[];
                    customValidators: never[];
                    skipUndeclared: boolean;
                })[];
                "react/react-in-jsx-scope": string;
                "react/require-render-return": string;
                "react/self-closing-comp": string;
                "react/sort-comp": (string | {
                    order: string[];
                    groups: {
                        lifecycle: string[];
                        rendering: string[];
                    };
                })[];
                "react/jsx-no-target-blank": (string | {
                    enforceDynamicLinks: string;
                })[];
                "react/jsx-filename-extension": (string | {
                    extensions: string[];
                })[];
                "react/jsx-no-comment-textnodes": string;
                "react/no-render-return-value": string;
                "react/require-optimization": (string | {
                    allowDecorators: never[];
                })[];
                "react/no-find-dom-node": string;
                "react/forbid-component-props": (string | {
                    forbid: never[];
                })[];
                "react/forbid-elements": (string | {
                    forbid: never[];
                })[];
                "react/no-danger-with-children": string;
                "react/no-unused-prop-types": (string | {
                    customValidators: never[];
                    skipShapeProps: boolean;
                })[];
                "react/style-prop-object": string;
                "react/no-unescaped-entities": string;
                "react/no-children-prop": string;
                "react/no-array-index-key": string;
                "react/require-default-props": (string | {
                    forbidDefaultForRequired: boolean;
                })[];
                "react/forbid-foreign-prop-types": (string | {
                    allowInPropTypes: boolean;
                })[];
                "react/void-dom-elements-no-children": string;
                "react/default-props-match-prop-types": (string | {
                    allowRequiredDefaults: boolean;
                })[];
                "react/no-redundant-should-component-update": string;
                "react/no-unused-state": string;
                "react/boolean-prop-naming": (string | {
                    propTypeNames: string[];
                    rule: string;
                })[];
                "react/no-typos": string;
                "react/jsx-curly-brace-presence": (string | {
                    props: string;
                    children: string;
                })[];
                "react/destructuring-assignment": string[];
                "react/no-access-state-in-setstate": string;
                "react/button-has-type": (string | {
                    button: boolean;
                    submit: boolean;
                    reset: boolean;
                })[];
                "react/no-this-in-sfc": string;
                "react/jsx-max-depth": string;
                "react/no-unsafe": string;
                "react/jsx-fragments": string[];
                "react/state-in-constructor": string[];
                "react/static-property-placement": string[];
                "react/jsx-props-no-spreading": (string | {
                    html: string;
                    custom: string;
                    explicitSpread: string;
                    exceptions: never[];
                })[];
                "react/prefer-read-only-props": string;
                "react/jsx-no-script-url": (string | {
                    name: string;
                    props: string[];
                }[])[];
                "react/jsx-no-useless-fragment": string;
                "react/no-adjacent-inline-elements": string;
                "react/function-component-definition": (string | {
                    namedComponents: string[];
                    unnamedComponents: string;
                })[];
                "react/jsx-no-constructed-context-values": string;
                "react/no-unstable-nested-components": string;
                "react/no-namespace": string;
                "react/prefer-exact-props": string;
                "react/no-arrow-function-lifecycle": string;
                "react/no-invalid-html-attribute": string;
                "react/no-unused-class-component-methods": string;
                "jsx-a11y/accessible-emoji": string;
                "jsx-a11y/alt-text": (string | {
                    elements: string[];
                    img: never[];
                    object: never[];
                    area: never[];
                    "input[type=\"image\"]": never[];
                })[];
                "jsx-a11y/anchor-has-content": (string | {
                    components: never[];
                })[];
                "jsx-a11y/anchor-is-valid": (string | {
                    components: string[];
                    specialLink: string[];
                    aspects: string[];
                })[];
                "jsx-a11y/aria-activedescendant-has-tabindex": string;
                "jsx-a11y/aria-props": string;
                "jsx-a11y/aria-proptypes": string;
                "jsx-a11y/aria-role": (string | {
                    ignoreNonDOM: boolean;
                })[];
                "jsx-a11y/aria-unsupported-elements": string;
                "jsx-a11y/autocomplete-valid": (string | {
                    inputComponents: never[];
                })[];
                "jsx-a11y/click-events-have-key-events": string;
                "jsx-a11y/control-has-associated-label": (string | {
                    labelAttributes: string[];
                    controlComponents: never[];
                    ignoreElements: string[];
                    ignoreRoles: string[];
                    depth: number;
                })[];
                "jsx-a11y/heading-has-content": (string | {
                    components: string[];
                })[];
                "jsx-a11y/html-has-lang": string;
                "jsx-a11y/iframe-has-title": string;
                "jsx-a11y/img-redundant-alt": string;
                "jsx-a11y/interactive-supports-focus": string;
                "jsx-a11y/label-has-associated-control": (string | {
                    labelComponents: never[];
                    labelAttributes: never[];
                    controlComponents: never[];
                    assert: string;
                    depth: number;
                })[];
                "jsx-a11y/lang": string;
                "jsx-a11y/media-has-caption": (string | {
                    audio: never[];
                    video: never[];
                    track: never[];
                })[];
                "jsx-a11y/mouse-events-have-key-events": string;
                "jsx-a11y/no-access-key": string;
                "jsx-a11y/no-autofocus": (string | {
                    ignoreNonDOM: boolean;
                })[];
                "jsx-a11y/no-distracting-elements": (string | {
                    elements: string[];
                })[];
                "jsx-a11y/no-interactive-element-to-noninteractive-role": (string | {
                    tr: string[];
                })[];
                "jsx-a11y/no-noninteractive-element-interactions": (string | {
                    handlers: string[];
                })[];
                "jsx-a11y/no-noninteractive-element-to-interactive-role": (string | {
                    ul: string[];
                    ol: string[];
                    li: string[];
                    table: string[];
                    td: string[];
                })[];
                "jsx-a11y/no-noninteractive-tabindex": (string | {
                    tags: never[];
                    roles: string[];
                })[];
                "jsx-a11y/no-onchange": string;
                "jsx-a11y/no-redundant-roles": string;
                "jsx-a11y/no-static-element-interactions": (string | {
                    handlers: string[];
                })[];
                "jsx-a11y/role-has-required-aria-props": string;
                "jsx-a11y/role-supports-aria-props": string;
                "jsx-a11y/scope": string;
                "jsx-a11y/tabindex-no-positive": string;
                "jsx-a11y/label-has-for": (string | {
                    components: never[];
                    required: {
                        every: string[];
                    };
                    allowChildren: boolean;
                })[];
            };
            files: string[];
        } | {
            files: string[];
            rules: {
                camelcase: string;
                "@typescript-eslint/naming-convention": (string | {
                    selector: string;
                    format: string[];
                })[];
                "default-param-last": string;
                "@typescript-eslint/default-param-last": string;
                "dot-notation": string;
                "@typescript-eslint/dot-notation": (string | {
                    allowKeywords: boolean;
                })[];
                "@stylistic/lines-between-class-members": (string | {
                    exceptAfterSingleLine: boolean;
                })[];
                "no-array-constructor": string;
                "@typescript-eslint/no-array-constructor": string;
                "no-dupe-class-members": string;
                "@typescript-eslint/no-dupe-class-members": string;
                "no-empty-function": string;
                "@typescript-eslint/no-empty-function": (string | {
                    allow: string[];
                })[];
                "no-implied-eval": string;
                "no-new-func": string;
                "@typescript-eslint/no-implied-eval": string;
                "no-loop-func": string;
                "@typescript-eslint/no-loop-func": string;
                "no-magic-numbers": string;
                "@typescript-eslint/no-magic-numbers": (string | {
                    ignore: never[];
                    ignoreArrayIndexes: boolean;
                    enforceConst: boolean;
                    detectObjects: boolean;
                })[];
                "no-redeclare": string;
                "@typescript-eslint/no-redeclare": string;
                "no-shadow": string;
                "@typescript-eslint/no-shadow": string;
                "no-throw-literal": string;
                "no-unused-expressions": string;
                "@typescript-eslint/no-unused-expressions": (string | {
                    allowShortCircuit: boolean;
                    allowTernary: boolean;
                    allowTaggedTemplates: boolean;
                })[];
                "no-unused-vars": string;
                "@typescript-eslint/no-unused-vars": (string | {
                    vars: string;
                    args: string;
                    ignoreRestSiblings: boolean;
                })[];
                "no-use-before-define": string;
                "@typescript-eslint/no-use-before-define": (string | {
                    functions: boolean;
                    classes: boolean;
                    variables: boolean;
                })[];
                "no-useless-constructor": string;
                "@typescript-eslint/no-useless-constructor": string;
                "require-await": string;
                "@typescript-eslint/require-await": string;
                "@typescript-eslint/return-await": string[];
                "import/extensions": (string | {
                    js: string;
                    mjs: string;
                    jsx: string;
                    ts: string;
                    tsx: string;
                })[];
                "import/no-extraneous-dependencies": (string | {
                    devDependencies: string[];
                    optionalDependencies: boolean;
                })[];
                "accessor-pairs": string;
                "array-callback-return": (string | {
                    allowImplicit: boolean;
                })[];
                "block-scoped-var": string;
                complexity: (string | number)[];
                "class-methods-use-this": (string | {
                    exceptMethods: string[];
                })[];
                "consistent-return": string;
                "default-case": (string | {
                    commentPattern: string;
                })[];
                "default-case-last": string;
                eqeqeq: (string | {
                    null: string;
                })[];
                "grouped-accessor-pairs": string;
                "guard-for-in": string;
                "max-classes-per-file": (string | number)[];
                "no-alert": string;
                "no-caller": string;
                "no-case-declarations": string;
                "no-constructor-return": string;
                "no-div-regex": string;
                "no-else-return": (string | {
                    allowElseIf: boolean;
                })[];
                "no-empty-pattern": string;
                "no-eq-null": string;
                "no-eval": string;
                "no-extend-native": string;
                "no-extra-bind": string;
                "no-extra-label": string;
                "no-fallthrough": string;
                "no-global-assign": (string | {
                    exceptions: never[];
                })[];
                "no-native-reassign": string;
                "no-implicit-coercion": (string | {
                    boolean: boolean;
                    number: boolean;
                    string: boolean;
                    allow: never[];
                })[];
                "no-implicit-globals": string;
                "no-invalid-this": string;
                "no-iterator": string;
                "no-labels": (string | {
                    allowLoop: boolean;
                    allowSwitch: boolean;
                })[];
                "no-lone-blocks": string;
                "no-multi-str": string;
                "no-new": string;
                "no-new-wrappers": string;
                "no-nonoctal-decimal-escape": string;
                "no-octal": string;
                "no-octal-escape": string;
                "no-param-reassign": (string | {
                    props: boolean;
                    ignorePropertyModificationsFor: string[];
                })[];
                "no-proto": string;
                "no-restricted-properties": (string | {
                    object: string;
                    property: string;
                    message: string;
                } | {
                    property: string;
                    message: string;
                    object?: undefined;
                })[];
                "no-return-assign": string[];
                "no-script-url": string;
                "no-self-assign": (string | {
                    props: boolean;
                })[];
                "no-self-compare": string;
                "no-sequences": string;
                "no-unmodified-loop-condition": string;
                "no-unused-labels": string;
                "no-useless-call": string;
                "no-useless-catch": string;
                "no-useless-concat": string;
                "no-useless-escape": string;
                "no-useless-return": string;
                "no-void": string;
                "no-warning-comments": (string | {
                    terms: string[];
                    location: string;
                })[];
                "no-with": string;
                "prefer-promise-reject-errors": (string | {
                    allowEmptyReject: boolean;
                })[];
                "prefer-named-capture-group": string;
                "prefer-regex-literals": (string | {
                    disallowRedundantWrapping: boolean;
                })[];
                radix: string;
                "require-unicode-regexp": string;
                "vars-on-top": string;
                yoda: string;
                "for-direction": string;
                "getter-return": (string | {
                    allowImplicit: boolean;
                })[];
                "no-async-promise-executor": string;
                "no-await-in-loop": string;
                "no-compare-neg-zero": string;
                "no-cond-assign": string[];
                "no-console": string;
                "no-constant-condition": string;
                "no-control-regex": string;
                "no-debugger": string;
                "no-dupe-args": string;
                "no-dupe-else-if": string;
                "no-dupe-keys": string;
                "no-duplicate-case": string;
                "no-empty": string;
                "no-empty-character-class": string;
                "no-ex-assign": string;
                "no-extra-boolean-cast": string;
                "no-func-assign": string;
                "no-import-assign": string;
                "no-inner-declarations": string;
                "no-invalid-regexp": string;
                "no-irregular-whitespace": string;
                "no-misleading-character-class": string;
                "no-obj-calls": string;
                "no-promise-executor-return": string;
                "no-prototype-builtins": string;
                "no-regex-spaces": string;
                "no-setter-return": string;
                "no-sparse-arrays": string;
                "no-template-curly-in-string": string;
                "no-unreachable": string;
                "no-unreachable-loop": (string | {
                    ignore: never[];
                })[];
                "no-unsafe-finally": string;
                "no-unsafe-negation": string;
                "no-unsafe-optional-chaining": (string | {
                    disallowArithmeticOperators: boolean;
                })[];
                "no-unused-private-class-members": string;
                "no-useless-backreference": string;
                "no-negated-in-lhs": string;
                "require-atomic-updates": string;
                "use-isnan": string;
                "valid-jsdoc": string;
                "valid-typeof": (string | {
                    requireStringLiterals: boolean;
                })[];
                "callback-return": string;
                "global-require": string;
                "handle-callback-err": string;
                "no-mixed-requires": (string | boolean)[];
                "n/no-deprecated-api": string;
                "n/no-path-concat": string;
                "no-process-env": string;
                "no-process-exit": string;
                "no-restricted-modules": string;
                "no-sync": string;
                "capitalized-comments": (string | {
                    line: {
                        ignorePattern: string;
                        ignoreInlineComments: boolean;
                        ignoreConsecutiveComments: boolean;
                    };
                    block: {
                        ignorePattern: string;
                        ignoreInlineComments: boolean;
                        ignoreConsecutiveComments: boolean;
                    };
                })[];
                "consistent-this": string;
                "func-name-matching": (string | {
                    includeCommonJSModuleExports: boolean;
                    considerPropertyDescriptor: boolean;
                })[];
                "func-names": string;
                "func-style": string[];
                "id-denylist": string;
                "id-length": string;
                "id-match": string;
                "line-comment-position": (string | {
                    position: string;
                    ignorePattern: string;
                    applyDefaultPatterns: boolean;
                })[];
                "max-depth": (string | number)[];
                "max-lines": (string | {
                    max: number;
                    skipBlankLines: boolean;
                    skipComments: boolean;
                })[];
                "max-lines-per-function": (string | {
                    max: number;
                    skipBlankLines: boolean;
                    skipComments: boolean;
                    IIFEs: boolean;
                })[];
                "max-nested-callbacks": string;
                "max-params": (string | number)[];
                "max-statements": (string | number)[];
                "multiline-comment-style": string[];
                "new-cap": (string | {
                    newIsCap: boolean;
                    newIsCapExceptions: never[];
                    capIsNew: boolean;
                    capIsNewExceptions: string[];
                })[];
                "newline-after-var": string;
                "newline-before-return": string;
                "no-bitwise": string;
                "no-continue": string;
                "no-inline-comments": string;
                "no-lonely-if": string;
                "no-multi-assign": string[];
                "no-negated-condition": string;
                "no-nested-ternary": string;
                "no-object-constructor": string;
                "no-plusplus": string;
                "no-restricted-syntax": (string | {
                    selector: string;
                    message: string;
                })[];
                "no-ternary": string;
                "no-underscore-dangle": (string | {
                    allow: string[];
                    allowAfterThis: boolean;
                    allowAfterSuper: boolean;
                    enforceInMethodNames: boolean;
                })[];
                "no-unneeded-ternary": (string | {
                    defaultAssignment: boolean;
                })[];
                "one-var": string[];
                "operator-assignment": string[];
                "padding-line-between-statements": string;
                "prefer-exponentiation-operator": string;
                "prefer-object-spread": string;
                "require-jsdoc": string;
                "sort-keys": (string | {
                    caseSensitive: boolean;
                    natural: boolean;
                })[];
                "sort-vars": string;
                "@stylistic/spaced-comment": (string | {
                    line: {
                        exceptions: string[];
                        markers: string[];
                    };
                    block: {
                        exceptions: string[];
                        markers: string[];
                        balanced: boolean;
                    };
                })[];
                "unicode-bom": string[];
                "init-declarations": string;
                "no-catch-shadow": string;
                "no-delete-var": string;
                "no-label-var": string;
                "no-restricted-globals": (string | {
                    name: string;
                    message: string;
                })[];
                "no-shadow-restricted-names": string;
                "no-undef": string;
                "no-undef-init": string;
                "no-undefined": string;
                "arrow-body-style": (string | {
                    requireReturnForObjectLiteral: boolean;
                })[];
                "constructor-super": string;
                "no-class-assign": string;
                "no-const-assign": string;
                "no-duplicate-imports": string;
                "no-new-native-nonconstructor": string;
                "no-restricted-exports": (string | {
                    restrictedNamedExports: string[];
                })[];
                "no-restricted-imports": (string | {
                    paths: never[];
                    patterns: never[];
                })[];
                "no-this-before-super": string;
                "no-useless-computed-key": string;
                "no-useless-rename": (string | {
                    ignoreDestructuring: boolean;
                    ignoreImport: boolean;
                    ignoreExport: boolean;
                })[];
                "no-var": string;
                "object-shorthand": (string | {
                    ignoreConstructors: boolean;
                    avoidQuotes: boolean;
                })[];
                "prefer-arrow-callback": (string | {
                    allowNamedFunctions: boolean;
                    allowUnboundThis: boolean;
                })[];
                "prefer-const": (string | {
                    destructuring: string;
                    ignoreReadBeforeAssign: boolean;
                })[];
                "prefer-destructuring": (string | {
                    VariableDeclarator: {
                        array: boolean;
                        object: boolean;
                    };
                    AssignmentExpression: {
                        array: boolean;
                        object: boolean;
                    };
                    enforceForRenamedProperties?: undefined;
                } | {
                    enforceForRenamedProperties: boolean;
                    VariableDeclarator?: undefined;
                    AssignmentExpression?: undefined;
                })[];
                "prefer-numeric-literals": string;
                "prefer-reflect": string;
                "prefer-rest-params": string;
                "prefer-spread": string;
                "prefer-template": string;
                "require-yield": string;
                "sort-imports": (string | {
                    ignoreCase: boolean;
                    ignoreDeclarationSort: boolean;
                    ignoreMemberSort: boolean;
                    memberSyntaxSortOrder: string[];
                })[];
                "symbol-description": string;
                "import/no-unresolved": (string | {
                    commonjs: boolean;
                    caseSensitive: boolean;
                })[];
                "import/named": string;
                "import/default": string;
                "import/namespace": string;
                "import/export": string;
                "import/no-named-as-default": string;
                "import/no-named-as-default-member": string;
                "import/no-deprecated": string;
                "import/no-mutable-exports": string;
                "import/no-commonjs": string;
                "import/no-amd": string;
                "import/no-nodejs-modules": string;
                "import/first": string;
                "import/imports-first": string;
                "import/no-duplicates": string;
                "import/no-namespace": string;
                "import/order": (string | {
                    groups: string[][];
                })[];
                "import/newline-after-import": string;
                "import/prefer-default-export": string;
                "import/no-restricted-paths": string;
                "import/max-dependencies": (string | {
                    max: number;
                })[];
                "import/no-absolute-path": string;
                "import/no-dynamic-require": string;
                "import/no-internal-modules": (string | {
                    allow: never[];
                })[];
                "import/unambiguous": string;
                "import/no-webpack-loader-syntax": string;
                "import/no-unassigned-import": string;
                "import/no-named-default": string;
                "import/no-anonymous-default-export": (string | {
                    allowArray: boolean;
                    allowArrowFunction: boolean;
                    allowAnonymousClass: boolean;
                    allowAnonymousFunction: boolean;
                    allowLiteral: boolean;
                    allowObject: boolean;
                })[];
                "import/exports-last": string;
                "import/group-exports": string;
                "import/no-default-export": string;
                "import/no-named-export": string;
                "import/no-self-import": string;
                "import/no-cycle": (string | {
                    maxDepth: number;
                })[];
                "import/no-useless-path-segments": (string | {
                    commonjs: boolean;
                })[];
                "import/dynamic-import-chunkname": (string | {
                    importFunctions: never[];
                    webpackChunknameFormat: string;
                })[];
                "import/no-relative-parent-imports": string;
                "import/no-unused-modules": (string | {
                    ignoreExports: never[];
                    missingExports: boolean;
                    unusedExports: boolean;
                })[];
                "import/no-import-module-exports": (string | {
                    exceptions: never[];
                })[];
                "import/no-relative-packages": string;
                strict: string[];
                "react/display-name": (string | {
                    ignoreTranspilerName: boolean;
                })[];
                "react/forbid-prop-types": (string | {
                    forbid: string[];
                    checkContextTypes: boolean;
                    checkChildContextTypes: boolean;
                })[];
                "react/forbid-dom-props": (string | {
                    forbid: never[];
                })[];
                "react/jsx-boolean-value": (string | {
                    always: never[];
                })[];
                "react/jsx-handler-names": (string | {
                    eventHandlerPrefix: string;
                    eventHandlerPropPrefix: string;
                })[];
                "react/jsx-key": string;
                "react/jsx-no-bind": (string | {
                    ignoreRefs: boolean;
                    allowArrowFunctions: boolean;
                    allowFunctions: boolean;
                    allowBind: boolean;
                    ignoreDOMComponents: boolean;
                })[];
                "react/jsx-no-duplicate-props": (string | {
                    ignoreCase: boolean;
                })[];
                "react/jsx-no-literals": (string | {
                    noStrings: boolean;
                })[];
                "react/jsx-no-undef": string;
                "react/jsx-pascal-case": (string | {
                    allowAllCaps: boolean;
                    ignore: never[];
                })[];
                "react/sort-prop-types": (string | {
                    ignoreCase: boolean;
                    callbacksLast: boolean;
                    requiredFirst: boolean;
                    sortShapeProp: boolean;
                })[];
                "react/jsx-sort-prop-types": string;
                "react/jsx-sort-props": (string | {
                    ignoreCase: boolean;
                    callbacksLast: boolean;
                    shorthandFirst: boolean;
                    shorthandLast: boolean;
                    noSortAlphabetically: boolean;
                    reservedFirst: boolean;
                })[];
                "react/jsx-sort-default-props": (string | {
                    ignoreCase: boolean;
                })[];
                "react/jsx-uses-react": string[];
                "react/jsx-uses-vars": string;
                "react/no-danger": string;
                "react/no-deprecated": string[];
                "react/no-did-mount-set-state": string;
                "react/no-did-update-set-state": string;
                "react/no-will-update-set-state": string;
                "react/no-direct-mutation-state": string;
                "react/no-is-mounted": string;
                "react/no-multi-comp": string;
                "react/no-set-state": string;
                "react/no-string-refs": string;
                "react/no-unknown-property": string;
                "react/prefer-es6-class": string[];
                "react/prefer-stateless-function": (string | {
                    ignorePureComponents: boolean;
                })[];
                "react/prop-types": (string | {
                    ignore: never[];
                    customValidators: never[];
                    skipUndeclared: boolean;
                })[];
                "react/react-in-jsx-scope": string;
                "react/require-render-return": string;
                "react/self-closing-comp": string;
                "react/sort-comp": (string | {
                    order: string[];
                    groups: {
                        lifecycle: string[];
                        rendering: string[];
                    };
                })[];
                "react/jsx-no-target-blank": (string | {
                    enforceDynamicLinks: string;
                })[];
                "react/jsx-filename-extension": (string | {
                    extensions: string[];
                })[];
                "react/jsx-no-comment-textnodes": string;
                "react/no-render-return-value": string;
                "react/require-optimization": (string | {
                    allowDecorators: never[];
                })[];
                "react/no-find-dom-node": string;
                "react/forbid-component-props": (string | {
                    forbid: never[];
                })[];
                "react/forbid-elements": (string | {
                    forbid: never[];
                })[];
                "react/no-danger-with-children": string;
                "react/no-unused-prop-types": (string | {
                    customValidators: never[];
                    skipShapeProps: boolean;
                })[];
                "react/style-prop-object": string;
                "react/no-unescaped-entities": string;
                "react/no-children-prop": string;
                "react/no-array-index-key": string;
                "react/require-default-props": (string | {
                    forbidDefaultForRequired: boolean;
                })[];
                "react/forbid-foreign-prop-types": (string | {
                    allowInPropTypes: boolean;
                })[];
                "react/void-dom-elements-no-children": string;
                "react/default-props-match-prop-types": (string | {
                    allowRequiredDefaults: boolean;
                })[];
                "react/no-redundant-should-component-update": string;
                "react/no-unused-state": string;
                "react/boolean-prop-naming": (string | {
                    propTypeNames: string[];
                    rule: string;
                })[];
                "react/no-typos": string;
                "react/jsx-curly-brace-presence": (string | {
                    props: string;
                    children: string;
                })[];
                "react/destructuring-assignment": string[];
                "react/no-access-state-in-setstate": string;
                "react/button-has-type": (string | {
                    button: boolean;
                    submit: boolean;
                    reset: boolean;
                })[];
                "react/no-this-in-sfc": string;
                "react/jsx-max-depth": string;
                "react/no-unsafe": string;
                "react/jsx-fragments": string[];
                "react/state-in-constructor": string[];
                "react/static-property-placement": string[];
                "react/jsx-props-no-spreading": (string | {
                    html: string;
                    custom: string;
                    explicitSpread: string;
                    exceptions: never[];
                })[];
                "react/prefer-read-only-props": string;
                "react/jsx-no-script-url": (string | {
                    name: string;
                    props: string[];
                }[])[];
                "react/jsx-no-useless-fragment": string;
                "react/no-adjacent-inline-elements": string;
                "react/function-component-definition": (string | {
                    namedComponents: string[];
                    unnamedComponents: string;
                })[];
                "react/jsx-no-constructed-context-values": string;
                "react/no-unstable-nested-components": string;
                "react/no-namespace": string;
                "react/prefer-exact-props": string;
                "react/no-arrow-function-lifecycle": string;
                "react/no-invalid-html-attribute": string;
                "react/no-unused-class-component-methods": string;
                "jsx-a11y/accessible-emoji": string;
                "jsx-a11y/alt-text": (string | {
                    elements: string[];
                    img: never[];
                    object: never[];
                    area: never[];
                    "input[type=\"image\"]": never[];
                })[];
                "jsx-a11y/anchor-has-content": (string | {
                    components: never[];
                })[];
                "jsx-a11y/anchor-is-valid": (string | {
                    components: string[];
                    specialLink: string[];
                    aspects: string[];
                })[];
                "jsx-a11y/aria-activedescendant-has-tabindex": string;
                "jsx-a11y/aria-props": string;
                "jsx-a11y/aria-proptypes": string;
                "jsx-a11y/aria-role": (string | {
                    ignoreNonDOM: boolean;
                })[];
                "jsx-a11y/aria-unsupported-elements": string;
                "jsx-a11y/autocomplete-valid": (string | {
                    inputComponents: never[];
                })[];
                "jsx-a11y/click-events-have-key-events": string;
                "jsx-a11y/control-has-associated-label": (string | {
                    labelAttributes: string[];
                    controlComponents: never[];
                    ignoreElements: string[];
                    ignoreRoles: string[];
                    depth: number;
                })[];
                "jsx-a11y/heading-has-content": (string | {
                    components: string[];
                })[];
                "jsx-a11y/html-has-lang": string;
                "jsx-a11y/iframe-has-title": string;
                "jsx-a11y/img-redundant-alt": string;
                "jsx-a11y/interactive-supports-focus": string;
                "jsx-a11y/label-has-associated-control": (string | {
                    labelComponents: never[];
                    labelAttributes: never[];
                    controlComponents: never[];
                    assert: string;
                    depth: number;
                })[];
                "jsx-a11y/lang": string;
                "jsx-a11y/media-has-caption": (string | {
                    audio: never[];
                    video: never[];
                    track: never[];
                })[];
                "jsx-a11y/mouse-events-have-key-events": string;
                "jsx-a11y/no-access-key": string;
                "jsx-a11y/no-autofocus": (string | {
                    ignoreNonDOM: boolean;
                })[];
                "jsx-a11y/no-distracting-elements": (string | {
                    elements: string[];
                })[];
                "jsx-a11y/no-interactive-element-to-noninteractive-role": (string | {
                    tr: string[];
                })[];
                "jsx-a11y/no-noninteractive-element-interactions": (string | {
                    handlers: string[];
                })[];
                "jsx-a11y/no-noninteractive-element-to-interactive-role": (string | {
                    ul: string[];
                    ol: string[];
                    li: string[];
                    table: string[];
                    td: string[];
                })[];
                "jsx-a11y/no-noninteractive-tabindex": (string | {
                    tags: never[];
                    roles: string[];
                })[];
                "jsx-a11y/no-onchange": string;
                "jsx-a11y/no-redundant-roles": string;
                "jsx-a11y/no-static-element-interactions": (string | {
                    handlers: string[];
                })[];
                "jsx-a11y/role-has-required-aria-props": string;
                "jsx-a11y/role-supports-aria-props": string;
                "jsx-a11y/scope": string;
                "jsx-a11y/tabindex-no-positive": string;
                "jsx-a11y/label-has-for": (string | {
                    components: never[];
                    required: {
                        every: string[];
                    };
                    allowChildren: boolean;
                })[];
            };
        })[];
    };
};
export { configs, rules };
//# sourceMappingURL=index.d.ts.map