// From file: @sage/wh-output/build/index.d.ts
declare module '@sage/wh-output/index' {
	export * from '@sage/wh-output/lib/index';
	//# sourceMappingURL=index.d.ts.map
}
// From file: @sage/wh-output/build/lib/index.d.ts
declare module '@sage/wh-output/lib/index' {
	export * as enums from '@sage/wh-output/lib/enums/index';
	export * as nodeExtensions from '@sage/wh-output/lib/node-extensions/index';
	export * as nodes from '@sage/wh-output/lib/nodes/index';
	export * as serviceOptions from '@sage/wh-output/lib/service-options/index';
	//# sourceMappingURL=index.d.ts.map
}
// From file: @sage/wh-output/build/lib/service-options/index.d.ts
declare module '@sage/wh-output/lib/service-options/index' {
	export type Dummy = void;
	//# sourceMappingURL=index.d.ts.map
}
// From file: @sage/wh-output/build/lib/nodes/shipping-unit.d.ts
declare module '@sage/wh-output/lib/nodes/shipping-unit' {
	import * as sageWhMasterData from '@sage/wh-master-data';
	import * as sageWhProductData from '@sage/wh-product-data';
	import * as sageWhSystem from '@sage/wh-system';
	import { Node, Reference, decimal, integer, Collection } from '@sage/xtrem-core';
	import * as sageWhOutput from '@sage/wh-output/lib/index';
	export class ShippingUnit extends Node {
	    readonly site: Reference<sageWhSystem.nodes.Site>;
	    readonly depositor: Reference<sageWhMasterData.nodes.Depositor | null>;
	    readonly code: Promise<string>;
	    readonly status: Promise<sageWhProductData.enums.ShippingUnitStatus>;
	    readonly shippingUnitType: Reference<sageWhMasterData.nodes.ShippingUnitType>;
	    readonly deliveryOrder: Reference<sageWhOutput.nodes.DeliveryOrder | null>;
	    readonly isShippingUnitSingleDeliveryOrder: Promise<boolean>;
	    readonly isShippingUnitSingleCustomer: Promise<boolean>;
	    readonly pickingOrder: Reference<sageWhOutput.nodes.PickingOrder | null>;
	    readonly preparationArea: Reference<sageWhMasterData.nodes.PreparationArea | null>;
	    readonly pickingMode: Reference<sageWhProductData.nodes.PickingMode | null>;
	    readonly palletisationOrder: Reference<sageWhOutput.nodes.AutoPalletizationOrder | null>;
	    readonly shipTo: Reference<sageWhMasterData.nodes.Customer | null>;
	    readonly postalCode: Promise<string>;
	    readonly isPostponed: Promise<boolean>;
	    readonly height: Promise<decimal | null>;
	    readonly width: Promise<decimal | null>;
	    readonly depth: Promise<decimal | null>;
	    readonly volume: Promise<decimal | null>;
	    readonly weight: Promise<decimal | null>;
	    readonly estimatedWeight: Promise<decimal | null>;
	    readonly numberOfParcels: Promise<integer | null>;
	    readonly parcel: Reference<sageWhOutput.nodes.Parcel | null>;
	    readonly ssccShippingUnitCode: Promise<string>;
	    readonly dockStore: Reference<sageWhMasterData.nodes.Store | null>;
	    readonly dockAddress: Reference<sageWhMasterData.nodes.Location | null>;
	    readonly originDockStore: Reference<sageWhMasterData.nodes.Store | null>;
	    readonly originDockAddress: Reference<sageWhMasterData.nodes.Location | null>;
	    readonly stockOnDockStatus: Promise<sageWhProductData.enums.Colis | null>;
	    readonly isStockOnDockControl: Promise<boolean>;
	    readonly isWrappedShippingUnit: Promise<boolean>;
	    readonly creationType: Promise<sageWhProductData.enums.SuCreationType | null>;
	    readonly subWaveNumber: Promise<integer | null>;
	    readonly isDispatchableInState: Promise<boolean>;
	    readonly parcels: Collection<sageWhOutput.nodes.Parcel>;
	    readonly companyNames: Collection<sageWhOutput.nodes.ShippingUnitCompanyNames>;
	}
	//# sourceMappingURL=shipping-unit.d.ts.map
}
// From file: @sage/wh-output/build/lib/nodes/shipping-unit-company-names.d.ts
declare module '@sage/wh-output/lib/nodes/shipping-unit-company-names' {
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageWhOutput from '@sage/wh-output/lib/index';
	export class ShippingUnitCompanyNames extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly site: Promise<string>;
	    readonly depositor: Promise<string>;
	    readonly code: Promise<string>;
	    readonly _denormalizedParent: Reference<sageWhOutput.nodes.ShippingUnit>;
	    readonly companyName: Promise<string>;
	}
	//# sourceMappingURL=shipping-unit-company-names.d.ts.map
}
// From file: @sage/wh-output/build/lib/nodes/round.d.ts
declare module '@sage/wh-output/lib/nodes/round' {
	import * as sageWhMasterData from '@sage/wh-master-data';
	import * as sageWhSystem from '@sage/wh-system';
	import { Node, Reference, date, decimal, integer, Collection } from '@sage/xtrem-core';
	import * as sageWhOutput from '@sage/wh-output/lib/index';
	export class Round extends Node {
	    readonly site: Reference<sageWhSystem.nodes.Site>;
	    readonly dockType: Promise<sageWhMasterData.enums.DockManagement>;
	    readonly code: Promise<string>;
	    readonly appointment: Reference<sageWhMasterData.nodes.AppointmentManagement | null>;
	    readonly date: Promise<date>;
	    readonly time: Promise<string>;
	    readonly duration: Promise<string>;
	    readonly status: Promise<sageWhMasterData.enums.RoundStatus | null>;
	    readonly carrier: Reference<sageWhMasterData.nodes.Carrier | null>;
	    readonly carrierName: Promise<string>;
	    readonly transportationMethod: Reference<sageWhMasterData.nodes.TransportMode | null>;
	    readonly carriageReference: Promise<string>;
	    readonly dockStore: Reference<sageWhMasterData.nodes.Store | null>;
	    readonly dockAddress: Reference<sageWhMasterData.nodes.Location | null>;
	    readonly genericRound: Reference<sageWhMasterData.nodes.GenericRound | null>;
	    readonly volume: Promise<decimal | null>;
	    readonly weight: Promise<decimal | null>;
	    readonly linearMeters: Promise<decimal | null>;
	    readonly numberOfDeliveryOrders: Promise<integer | null>;
	    readonly numberOfLines: Promise<integer | null>;
	    readonly deliveryOrderNumber: Promise<integer | null>;
	    readonly numberOfConsumptionUnit: Promise<integer | null>;
	    readonly numberOfShippingUnits: Promise<integer | null>;
	    readonly transportType: Reference<sageWhMasterData.nodes.TransportType | null>;
	    readonly shipTo: Reference<sageWhMasterData.nodes.Customer | null>;
	    readonly isInterSiteRound: Promise<boolean>;
	    readonly destinationSite: Reference<sageWhSystem.nodes.Site | null>;
	    readonly deliveryOrders: Collection<sageWhOutput.nodes.DeliveryOrder>;
	}
	//# sourceMappingURL=round.d.ts.map
}
// From file: @sage/wh-output/build/lib/nodes/picking-order.d.ts
declare module '@sage/wh-output/lib/nodes/picking-order' {
	import * as sageWhMasterData from '@sage/wh-master-data';
	import * as sageWhProductData from '@sage/wh-product-data';
	import * as sageWhSystem from '@sage/wh-system';
	import { Node, Reference, date, integer, decimal } from '@sage/xtrem-core';
	import * as sageWhOutput from '@sage/wh-output/lib/index';
	export class PickingOrder extends Node {
	    readonly site: Reference<sageWhSystem.nodes.Site>;
	    readonly depositor: Reference<sageWhMasterData.nodes.Depositor>;
	    readonly code: Promise<string>;
	    readonly status: Promise<sageWhProductData.enums.StoringListPurchaseOrderStatus | null>;
	    readonly pickingOrderType: Promise<sageWhProductData.enums.PoType | null>;
	    readonly pickingMode: Reference<sageWhProductData.nodes.PickingMode>;
	    readonly preparationArea: Reference<sageWhMasterData.nodes.PreparationArea>;
	    readonly deliveryOrder: Reference<sageWhOutput.nodes.DeliveryOrder | null>;
	    readonly round: Reference<sageWhOutput.nodes.Round | null>;
	    readonly level: Promise<sageWhMasterData.enums.ContainerLevel | null>;
	    readonly isPreparationOrderKit: Promise<boolean>;
	    readonly date: Promise<date>;
	    readonly time: Promise<string>;
	    readonly totalMovements: Promise<integer | null>;
	    readonly totalConsumptionUnit: Promise<decimal | null>;
	    readonly totalWeight: Promise<decimal | null>;
	    readonly totalVolume: Promise<decimal | null>;
	    readonly preparationTime: Promise<decimal | null>;
	    readonly equivalentSurface: Promise<decimal | null>;
	    readonly numberOfParcels: Promise<integer | null>;
	    readonly numberOfShippingUnits: Promise<integer | null>;
	    readonly subWaveNumber: Promise<integer>;
	    readonly shipTo: Reference<sageWhMasterData.nodes.Customer | null>;
	    readonly validatingOperator: Reference<sageWhMasterData.nodes.Operand | null>;
	    readonly postingDate: Promise<date | null>;
	    readonly postingTime: Promise<integer | null>;
	    readonly validatingUser: Promise<string>;
	}
	//# sourceMappingURL=picking-order.d.ts.map
}
// From file: @sage/wh-output/build/lib/nodes/parcel.d.ts
declare module '@sage/wh-output/lib/nodes/parcel' {
	import * as sageWhMasterData from '@sage/wh-master-data';
	import * as sageWhProductData from '@sage/wh-product-data';
	import * as sageWhSystem from '@sage/wh-system';
	import { Node, Reference, decimal, date, integer, Collection } from '@sage/xtrem-core';
	import * as sageWhOutput from '@sage/wh-output/lib/index';
	export class Parcel extends Node {
	    readonly site: Reference<sageWhSystem.nodes.Site>;
	    readonly depositor: Reference<sageWhMasterData.nodes.Depositor>;
	    readonly code: Promise<string>;
	    readonly deliveryOrder: Reference<sageWhOutput.nodes.DeliveryOrder>;
	    readonly pickingOrder: Reference<sageWhOutput.nodes.PickingOrder | null>;
	    readonly palletisationOrder: Reference<sageWhOutput.nodes.AutoPalletizationOrder | null>;
	    readonly status: Promise<sageWhProductData.enums.ParcelStatus>;
	    readonly preparationArea: Reference<sageWhMasterData.nodes.PreparationArea>;
	    readonly pickingMode: Reference<sageWhProductData.nodes.PickingMode | null>;
	    readonly parcelRange: Reference<sageWhMasterData.nodes.RangeOfParcel>;
	    readonly parcelType: Reference<sageWhMasterData.nodes.ParcelType>;
	    readonly height: Promise<decimal | null>;
	    readonly width: Promise<decimal | null>;
	    readonly depth: Promise<decimal | null>;
	    readonly volume: Promise<decimal | null>;
	    readonly estimatedWeight: Promise<decimal | null>;
	    readonly realWeight: Promise<decimal | null>;
	    readonly isDispatchableInState: Promise<boolean>;
	    readonly isPalettizableAsIs: Promise<boolean>;
	    readonly carrierParcelNumber: Promise<string>;
	    readonly carrier: Reference<sageWhMasterData.nodes.Carrier | null>;
	    readonly transportationMethod: Reference<sageWhMasterData.nodes.TransportMode | null>;
	    readonly deliveryNote: Reference<sageWhOutput.nodes.DeliveryNote | null>;
	    readonly shippingUnit: Reference<sageWhOutput.nodes.ShippingUnit | null>;
	    readonly isPostponed: Promise<boolean>;
	    readonly validatingOperator: Reference<sageWhMasterData.nodes.Operand | null>;
	    readonly validatingUser: Promise<string>;
	    readonly postingDate: Promise<date | null>;
	    readonly postingTime: Promise<integer | null>;
	    readonly pickingOrderSorting: Promise<string>;
	    readonly ssccParcelCode: Promise<string>;
	    readonly dockStore: Reference<sageWhMasterData.nodes.Store | null>;
	    readonly dockAddress: Reference<sageWhMasterData.nodes.Location | null>;
	    readonly originDockStore: Reference<sageWhMasterData.nodes.Store | null>;
	    readonly originDockAddress: Reference<sageWhMasterData.nodes.Location | null>;
	    readonly stockOnDockStatus: Promise<sageWhProductData.enums.Colis | null>;
	    readonly isStockOnDockControl: Promise<boolean>;
	    readonly pickingOrderType: Promise<sageWhProductData.enums.PoType | null>;
	    readonly shippingUnits: Collection<sageWhOutput.nodes.ShippingUnit>;
	    readonly outputMovements: Collection<sageWhOutput.nodes.OutputMovement>;
	}
	//# sourceMappingURL=parcel.d.ts.map
}
// From file: @sage/wh-output/build/lib/nodes/output-movement.d.ts
declare module '@sage/wh-output/lib/nodes/output-movement' {
	import * as sageWhMasterData from '@sage/wh-master-data';
	import * as sageWhProductData from '@sage/wh-product-data';
	import * as sageWhStockData from '@sage/wh-stock-data';
	import * as sageWhSystem from '@sage/wh-system';
	import { Node, Reference, integer, decimal, date, Collection } from '@sage/xtrem-core';
	import * as sageWhOutput from '@sage/wh-output/lib/index';
	export class OutputMovement extends Node {
	    readonly site: Reference<sageWhSystem.nodes.Site>;
	    readonly depositor: Reference<sageWhMasterData.nodes.Depositor>;
	    readonly code: Promise<string>;
	    readonly deliveryOrder: Reference<sageWhOutput.nodes.DeliveryOrder>;
	    readonly deliveryLineNumber: Promise<integer>;
	    readonly subWaveNumber: Promise<integer>;
	    readonly pickingOrder: Reference<sageWhOutput.nodes.PickingOrder | null>;
	    readonly pickingOrderSorting: Promise<string>;
	    readonly lineType: Promise<sageWhProductData.enums.DoLineType | null>;
	    readonly product: Reference<sageWhProductData.nodes.Product>;
	    readonly numberOfContainers: Promise<decimal>;
	    readonly container: Reference<sageWhProductData.nodes.ProductContainer>;
	    readonly homogeneousContainerCoefficient: Promise<decimal>;
	    readonly numberOfConsumptionUnit: Promise<decimal>;
	    readonly numberOfKit: Promise<decimal | null>;
	    readonly movementCode: Reference<sageWhMasterData.nodes.MovementCode>;
	    readonly lotNumber: Promise<string>;
	    readonly stockStatus: Reference<sageWhMasterData.nodes.StockNature | null>;
	    readonly reservationNumber: Promise<string>;
	    readonly supportNumber: Promise<string>;
	    readonly status: Promise<sageWhProductData.enums.OutputMovementStatus>;
	    readonly source: Reference<sageWhProductData.nodes.Origin | null>;
	    readonly fifoDate: Promise<date | null>;
	    readonly manufacturedDate: Promise<date | null>;
	    readonly detentionDate: Promise<date | null>;
	    readonly sellByDate: Promise<date | null>;
	    readonly shipByDate: Promise<date | null>;
	    readonly useByDate: Promise<date | null>;
	    readonly pickingMode: Reference<sageWhProductData.nodes.PickingMode | null>;
	    readonly store: Reference<sageWhMasterData.nodes.Store | null>;
	    readonly location: Reference<sageWhMasterData.nodes.Location | null>;
	    readonly locationType: Promise<sageWhMasterData.enums.LocationType | null>;
	    readonly stockObject: Reference<sageWhStockData.nodes.StockObject | null>;
	    readonly containerNumber: Promise<string>;
	    readonly homogeneousContainer: Reference<sageWhProductData.nodes.ProductContainer>;
	    readonly homogeneousQuantity: Promise<decimal>;
	    readonly originContainer: Reference<sageWhProductData.nodes.ProductContainer>;
	    readonly sourceQuantity: Promise<decimal>;
	    readonly parcel: Reference<sageWhOutput.nodes.Parcel | null>;
	    readonly shippingUnit: Reference<sageWhOutput.nodes.ShippingUnit | null>;
	    readonly parcelSequence: Promise<integer | null>;
	    readonly deliveryNote: Reference<sageWhOutput.nodes.DeliveryNote | null>;
	    readonly round: Reference<sageWhOutput.nodes.Round | null>;
	    readonly roundSite: Reference<sageWhSystem.nodes.Site | null>;
	    readonly travelSequence: Promise<string>;
	    readonly rowByLevel: Promise<string>;
	    readonly isInTransit: Promise<boolean>;
	    readonly destinationSite: Reference<sageWhSystem.nodes.Site | null>;
	    readonly validatingOperator: Reference<sageWhMasterData.nodes.Operand | null>;
	    readonly validatingUser: Promise<string>;
	    readonly postingDate: Promise<date | null>;
	    readonly postingTime: Promise<integer | null>;
	    readonly groupingCode: Promise<string>;
	    readonly isContractDate: Promise<boolean>;
	    readonly parcels: Collection<sageWhOutput.nodes.Parcel>;
	    readonly containerLevels: Collection<sageWhOutput.nodes.OutputMovementContainerLevels>;
	}
	//# sourceMappingURL=output-movement.d.ts.map
}
// From file: @sage/wh-output/build/lib/nodes/output-movement-container-levels.d.ts
declare module '@sage/wh-output/lib/nodes/output-movement-container-levels' {
	import * as sageWhProductData from '@sage/wh-product-data';
	import { Node, integer, Reference, decimal } from '@sage/xtrem-core';
	import * as sageWhOutput from '@sage/wh-output/lib/index';
	export class OutputMovementContainerLevels extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly site: Promise<string>;
	    readonly depositor: Promise<string>;
	    readonly code: Promise<string>;
	    readonly _denormalizedParent: Reference<sageWhOutput.nodes.OutputMovement>;
	    readonly containerLevel: Reference<sageWhProductData.nodes.ProductContainer | null>;
	    readonly quantityOfConsumptionUnitPerLevel: Promise<decimal | null>;
	}
	//# sourceMappingURL=output-movement-container-levels.d.ts.map
}
// From file: @sage/wh-output/build/lib/nodes/index.d.ts
declare module '@sage/wh-output/lib/nodes/index' {
	export * from '@sage/wh-output/lib/nodes/auto-palletization-order';
	export * from '@sage/wh-output/lib/nodes/carriage-note';
	export * from '@sage/wh-output/lib/nodes/carriage-receipt-ship-to-company-names';
	export * from '@sage/wh-output/lib/nodes/carriage-receipt-shipt-to-addresses';
	export * from '@sage/wh-output/lib/nodes/carriage-receipt';
	export * from '@sage/wh-output/lib/nodes/delivery-note-bill-to-addresses';
	export * from '@sage/wh-output/lib/nodes/delivery-note-bill-to-company-names';
	export * from '@sage/wh-output/lib/nodes/delivery-note-number-of-dispatchable-parcels';
	export * from '@sage/wh-output/lib/nodes/delivery-note-ship-to-addresses';
	export * from '@sage/wh-output/lib/nodes/delivery-note-ship-to-company-names';
	export * from '@sage/wh-output/lib/nodes/delivery-note';
	export * from '@sage/wh-output/lib/nodes/delivery-order-bill-to-addresses';
	export * from '@sage/wh-output/lib/nodes/delivery-order-bill-to-company-names';
	export * from '@sage/wh-output/lib/nodes/delivery-order-line';
	export * from '@sage/wh-output/lib/nodes/delivery-order-ship-to-addresses';
	export * from '@sage/wh-output/lib/nodes/delivery-order-ship-to-company-names';
	export * from '@sage/wh-output/lib/nodes/delivery-order';
	export * from '@sage/wh-output/lib/nodes/output-movement-container-levels';
	export * from '@sage/wh-output/lib/nodes/output-movement';
	export * from '@sage/wh-output/lib/nodes/parcel';
	export * from '@sage/wh-output/lib/nodes/picking-order';
	export * from '@sage/wh-output/lib/nodes/round';
	export * from '@sage/wh-output/lib/nodes/shipping-unit-company-names';
	export * from '@sage/wh-output/lib/nodes/shipping-unit';
	//# sourceMappingURL=index.d.ts.map
}
// From file: @sage/wh-output/build/lib/nodes/delivery-order.d.ts
declare module '@sage/wh-output/lib/nodes/delivery-order' {
	import * as sageWhMasterData from '@sage/wh-master-data';
	import * as sageWhProductData from '@sage/wh-product-data';
	import * as sageWhStructure from '@sage/wh-structure';
	import * as sageWhSystem from '@sage/wh-system';
	import { Node, Reference, date, integer, Collection } from '@sage/xtrem-core';
	import * as sageWhOutput from '@sage/wh-output/lib/index';
	export class DeliveryOrder extends Node {
	    readonly site: Reference<sageWhSystem.nodes.Site>;
	    readonly depositor: Reference<sageWhMasterData.nodes.Depositor>;
	    readonly code: Promise<string>;
	    readonly referenceNumber: Promise<string>;
	    readonly status: Promise<sageWhMasterData.enums.DoHeaderStatus | null>;
	    readonly isMergingOfFlows: Promise<boolean>;
	    readonly date: Promise<date>;
	    readonly plannedLaunchDate: Promise<date>;
	    readonly plannedLaunchTime: Promise<string>;
	    readonly expectedDeliveryDate: Promise<date>;
	    readonly expectedDeliveryTime: Promise<string>;
	    readonly orderReference: Promise<string>;
	    readonly orderNumber: Promise<string>;
	    readonly orderDate: Promise<date | null>;
	    readonly soldTo: Promise<string>;
	    readonly customerReference: Promise<string>;
	    readonly movementCode: Reference<sageWhMasterData.nodes.MovementCode>;
	    readonly pickingMode: Reference<sageWhProductData.nodes.PickingMode>;
	    readonly partialDelivery: Promise<sageWhMasterData.enums.PartialDeliveryAuthorized | null>;
	    readonly servicePriority: Promise<sageWhMasterData.enums.ServicePriority | null>;
	    readonly isUrgent: Promise<boolean>;
	    readonly originalDeliveryOrder: Reference<sageWhOutput.nodes.DeliveryOrder | null>;
	    readonly splittingNumber: Promise<integer | null>;
	    readonly isOutputShortageManagement: Promise<boolean>;
	    readonly isPacking: Promise<sageWhProductData.enums.Packing | null>;
	    readonly isParcelPalletisation: Promise<boolean>;
	    readonly isLoadingOfParcels: Promise<boolean>;
	    readonly isShipmentManagement: Promise<boolean>;
	    readonly shipTo: Reference<sageWhMasterData.nodes.Customer | null>;
	    readonly shipToPostalCode: Promise<string>;
	    readonly shipToCity: Promise<string>;
	    readonly shipToCountry: Reference<sageWhStructure.nodes.Country | null>;
	    readonly shipToCountryName: Promise<string>;
	    readonly shipToRegion: Promise<string>;
	    readonly shipToTelephone: Promise<string>;
	    readonly shipToFax: Promise<string>;
	    readonly deliveryArea: Promise<string>;
	    readonly deliveryNotePrintingReport: Reference<sageWhSystem.nodes.GenericPrintReport>;
	    readonly printLanguage: Reference<sageWhSystem.nodes.Language>;
	    readonly shipToCustomerNotes: Promise<string>;
	    readonly round: Reference<sageWhOutput.nodes.Round | null>;
	    readonly genericRound: Reference<sageWhMasterData.nodes.GenericRound | null>;
	    readonly carrier: Reference<sageWhMasterData.nodes.Carrier | null>;
	    readonly transportationMethod: Reference<sageWhMasterData.nodes.TransportMode | null>;
	    readonly carriageReference: Promise<string>;
	    readonly transportType: Reference<sageWhMasterData.nodes.TransportType | null>;
	    readonly roundPosition: Promise<integer | null>;
	    readonly billToCustomer: Reference<sageWhMasterData.nodes.Customer | null>;
	    readonly billToCountry: Reference<sageWhStructure.nodes.Country | null>;
	    readonly billToCountryName: Promise<string>;
	    readonly billToCity: Promise<string>;
	    readonly billToPostalCode: Promise<string>;
	    readonly billToRegion: Promise<string>;
	    readonly billToTelephone: Promise<string>;
	    readonly billToFax: Promise<string>;
	    readonly billToCustomerNotes: Promise<string>;
	    readonly launchDate: Promise<date | null>;
	    readonly launchTime: Promise<string>;
	    readonly pickingDate: Promise<date | null>;
	    readonly pickingTime: Promise<string>;
	    readonly packingDate: Promise<date | null>;
	    readonly packingTime: Promise<string>;
	    readonly shipmentDate: Promise<date | null>;
	    readonly shipmentTime: Promise<string>;
	    readonly transmittedFromL3: Promise<sageWhProductData.enums.TransmissionL3 | null>;
	    readonly isCarrierAmountCalculation: Promise<boolean>;
	    readonly priceListCode: Reference<sageWhMasterData.nodes.TariffCode | null>;
	    readonly currency: Reference<sageWhMasterData.nodes.Currency | null>;
	    readonly crossDockingLevel: Promise<sageWhMasterData.enums.CrossDockingBlockingLevel | null>;
	    readonly isCrossDockingManagement: Promise<boolean>;
	    readonly isSsccManagementOnOutput: Promise<boolean>;
	    readonly isShippingUnitSingleDeliveryOrder: Promise<boolean>;
	    readonly isShippingUnitSingleCustomer: Promise<boolean>;
	    readonly shippingUnitType: Reference<sageWhMasterData.nodes.ShippingUnitType | null>;
	    readonly shippingUnitGroup: Promise<string>;
	    readonly lines: Collection<sageWhOutput.nodes.DeliveryOrderLine>;
	    readonly billToAddresses: Collection<sageWhOutput.nodes.DeliveryOrderBillToAddresses>;
	    readonly billToCompanyNames: Collection<sageWhOutput.nodes.DeliveryOrderBillToCompanyNames>;
	    readonly shipToAddresses: Collection<sageWhOutput.nodes.DeliveryOrderShipToAddresses>;
	    readonly shipToCompanyNames: Collection<sageWhOutput.nodes.DeliveryOrderShipToCompanyNames>;
	}
	//# sourceMappingURL=delivery-order.d.ts.map
}
// From file: @sage/wh-output/build/lib/nodes/delivery-order-ship-to-company-names.d.ts
declare module '@sage/wh-output/lib/nodes/delivery-order-ship-to-company-names' {
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageWhOutput from '@sage/wh-output/lib/index';
	export class DeliveryOrderShipToCompanyNames extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly site: Promise<string>;
	    readonly depositor: Promise<string>;
	    readonly code: Promise<string>;
	    readonly _denormalizedParent: Reference<sageWhOutput.nodes.DeliveryOrder>;
	    readonly shipToCompanyName: Promise<string>;
	}
	//# sourceMappingURL=delivery-order-ship-to-company-names.d.ts.map
}
// From file: @sage/wh-output/build/lib/nodes/delivery-order-ship-to-addresses.d.ts
declare module '@sage/wh-output/lib/nodes/delivery-order-ship-to-addresses' {
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageWhOutput from '@sage/wh-output/lib/index';
	export class DeliveryOrderShipToAddresses extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly site: Promise<string>;
	    readonly depositor: Promise<string>;
	    readonly code: Promise<string>;
	    readonly _denormalizedParent: Reference<sageWhOutput.nodes.DeliveryOrder>;
	    readonly shipToAddress: Promise<string>;
	}
	//# sourceMappingURL=delivery-order-ship-to-addresses.d.ts.map
}
// From file: @sage/wh-output/build/lib/nodes/delivery-order-line.d.ts
declare module '@sage/wh-output/lib/nodes/delivery-order-line' {
	import * as sageWhMasterData from '@sage/wh-master-data';
	import * as sageWhProductData from '@sage/wh-product-data';
	import * as sageWhSystem from '@sage/wh-system';
	import { Node, Reference, integer, decimal, date, Collection } from '@sage/xtrem-core';
	import * as sageWhOutput from '@sage/wh-output/lib/index';
	export class DeliveryOrderLine extends Node {
	    readonly site: Reference<sageWhSystem.nodes.Site>;
	    readonly depositor: Reference<sageWhMasterData.nodes.Depositor>;
	    readonly deliveryOrder: Reference<sageWhOutput.nodes.DeliveryOrder>;
	    readonly lineNumber: Promise<integer>;
	    readonly status: Promise<sageWhProductData.enums.DeliveryOrderLineStatus | null>;
	    readonly pointer: Promise<integer | null>;
	    readonly kitPointer: Promise<integer | null>;
	    readonly referenceNumber: Promise<string>;
	    readonly orderNumber: Promise<string>;
	    readonly lineType: Promise<sageWhProductData.enums.DoLineType | null>;
	    readonly numberOfKit: Promise<decimal | null>;
	    readonly product: Reference<sageWhProductData.nodes.Product | null>;
	    readonly quantityOfContainers: Promise<decimal | null>;
	    readonly container: Reference<sageWhProductData.nodes.ProductContainer | null>;
	    readonly numberOfConsumptionUnit: Promise<decimal | null>;
	    readonly quantityTotalShipped: Promise<decimal | null>;
	    readonly stockStatus: Reference<sageWhMasterData.nodes.StockNature | null>;
	    readonly reservationNumber: Promise<string>;
	    readonly lotNumber: Promise<string>;
	    readonly isSingleLot: Promise<boolean>;
	    readonly supportNumber: Promise<string>;
	    readonly movementCode: Reference<sageWhMasterData.nodes.MovementCode | null>;
	    readonly fifoDate: Promise<date | null>;
	    readonly creationDate: Promise<date | null>;
	    readonly launchedQuantity: Promise<decimal | null>;
	    readonly shortageQuantity: Promise<decimal | null>;
	    readonly preparedQuantity: Promise<decimal | null>;
	    readonly shippedQuantity: Promise<decimal | null>;
	    readonly voidedQuantity: Promise<decimal | null>;
	    readonly transferredQuantity: Promise<decimal | null>;
	    readonly notTransferredQuantity: Promise<decimal | null>;
	    readonly postponedQuantity: Promise<decimal | null>;
	    readonly crossDockingQuantity: Promise<decimal | null>;
	    readonly isCrossDockingManagement: Promise<boolean>;
	    readonly isDirectMovementNotAddressed: Promise<boolean>;
	    readonly isExpectedInputUnderReceipt: Promise<boolean>;
	    readonly comments: Promise<string>;
	    readonly notes: Promise<string>;
	    readonly launchDate: Promise<date | null>;
	    readonly launchTime: Promise<string>;
	    readonly waitingToShipDate: Promise<date | null>;
	    readonly waitingToShipTime: Promise<string>;
	    readonly shipmentDate: Promise<date | null>;
	    readonly shipmentTime: Promise<string>;
	    readonly parcelRange: Reference<sageWhMasterData.nodes.RangeOfParcel | null>;
	    readonly groupOfParcel: Promise<string>;
	    readonly maximumLevelDispatchInState: Promise<sageWhMasterData.enums.ContainerLevel | null>;
	    readonly isContractDate: Promise<boolean>;
	    readonly outputMovements: Collection<sageWhOutput.nodes.OutputMovement>;
	}
	//# sourceMappingURL=delivery-order-line.d.ts.map
}
// From file: @sage/wh-output/build/lib/nodes/delivery-order-bill-to-company-names.d.ts
declare module '@sage/wh-output/lib/nodes/delivery-order-bill-to-company-names' {
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageWhOutput from '@sage/wh-output/lib/index';
	export class DeliveryOrderBillToCompanyNames extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly site: Promise<string>;
	    readonly depositor: Promise<string>;
	    readonly code: Promise<string>;
	    readonly _denormalizedParent: Reference<sageWhOutput.nodes.DeliveryOrder>;
	    readonly billToCompanyName: Promise<string>;
	}
	//# sourceMappingURL=delivery-order-bill-to-company-names.d.ts.map
}
// From file: @sage/wh-output/build/lib/nodes/delivery-order-bill-to-addresses.d.ts
declare module '@sage/wh-output/lib/nodes/delivery-order-bill-to-addresses' {
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageWhOutput from '@sage/wh-output/lib/index';
	export class DeliveryOrderBillToAddresses extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly site: Promise<string>;
	    readonly depositor: Promise<string>;
	    readonly code: Promise<string>;
	    readonly _denormalizedParent: Reference<sageWhOutput.nodes.DeliveryOrder>;
	    readonly billToAddress: Promise<string>;
	}
	//# sourceMappingURL=delivery-order-bill-to-addresses.d.ts.map
}
// From file: @sage/wh-output/build/lib/nodes/delivery-note.d.ts
declare module '@sage/wh-output/lib/nodes/delivery-note' {
	import * as sageWhMasterData from '@sage/wh-master-data';
	import * as sageWhProductData from '@sage/wh-product-data';
	import * as sageWhStructure from '@sage/wh-structure';
	import * as sageWhSystem from '@sage/wh-system';
	import { Node, Reference, date, decimal, integer, Collection } from '@sage/xtrem-core';
	import * as sageWhOutput from '@sage/wh-output/lib/index';
	export class DeliveryNote extends Node {
	    readonly site: Reference<sageWhSystem.nodes.Site>;
	    readonly depositor: Reference<sageWhMasterData.nodes.Depositor>;
	    readonly code: Promise<string>;
	    readonly creationDate: Promise<date>;
	    readonly creationTime: Promise<string>;
	    readonly isFinalDeliveryNote: Promise<boolean>;
	    readonly isUpdateDeliveryNote: Promise<boolean>;
	    readonly deliveryOrder: Reference<sageWhOutput.nodes.DeliveryOrder>;
	    readonly reference: Promise<string>;
	    readonly orderReference: Promise<string>;
	    readonly orderNumber: Promise<string>;
	    readonly orderDate: Promise<date | null>;
	    readonly soldToCustomer: Promise<string>;
	    readonly customerReference: Promise<string>;
	    readonly pickingMode: Reference<sageWhProductData.nodes.PickingMode>;
	    readonly movementCode: Reference<sageWhMasterData.nodes.MovementCode>;
	    readonly partialDeliveryManagement: Promise<sageWhMasterData.enums.PartialDeliveryAuthorized | null>;
	    readonly expectedDeliveryDate: Promise<date>;
	    readonly expectedDeliveryTime: Promise<string>;
	    readonly shipmentDate: Promise<date | null>;
	    readonly shipmentTime: Promise<string>;
	    readonly shipmentSite: Reference<sageWhSystem.nodes.Site | null>;
	    readonly round: Reference<sageWhOutput.nodes.Round | null>;
	    readonly carriageReceipt: Reference<sageWhOutput.nodes.CarriageReceipt | null>;
	    readonly carrier: Reference<sageWhMasterData.nodes.Carrier | null>;
	    readonly transportationMethod: Reference<sageWhMasterData.nodes.TransportMode | null>;
	    readonly carriageReference: Promise<string>;
	    readonly freightCharge: Promise<decimal | null>;
	    readonly currency: Reference<sageWhMasterData.nodes.Currency | null>;
	    readonly roundPosition: Promise<integer | null>;
	    readonly genericRound: Reference<sageWhMasterData.nodes.GenericRound | null>;
	    readonly transportType: Reference<sageWhMasterData.nodes.TransportType | null>;
	    readonly deliveryArea: Promise<string>;
	    readonly preparationArea: Reference<sageWhMasterData.nodes.PreparationArea>;
	    readonly shipToCustomer: Reference<sageWhMasterData.nodes.Customer | null>;
	    readonly shipToPostalCode: Promise<string>;
	    readonly shipToCity: Promise<string>;
	    readonly shipToCountry: Reference<sageWhStructure.nodes.Country | null>;
	    readonly shipToCountryName: Promise<string>;
	    readonly shipToRegion: Promise<string>;
	    readonly shipToTelephone: Promise<string>;
	    readonly shipToFax: Promise<string>;
	    readonly shipToNotes: Promise<string>;
	    readonly billToCustomer: Reference<sageWhMasterData.nodes.Customer | null>;
	    readonly billToPostalCode: Promise<string>;
	    readonly billToCity: Promise<string>;
	    readonly billToCountry: Reference<sageWhStructure.nodes.Country | null>;
	    readonly billToCountryName: Promise<string>;
	    readonly billToRegion: Promise<string>;
	    readonly billToTelephone: Promise<string>;
	    readonly billToFax: Promise<string>;
	    readonly billToNotes: Promise<string>;
	    readonly numberOfParcels: Promise<integer | null>;
	    readonly numberOfShippingUnit: Promise<integer | null>;
	    readonly weight: Promise<decimal | null>;
	    readonly volume: Promise<decimal | null>;
	    readonly linearMeters: Promise<decimal | null>;
	    readonly numberOfDeliveryOrderLines: Promise<integer | null>;
	    readonly deliveryNotePrintingReport: Reference<sageWhSystem.nodes.GenericPrintReport>;
	    readonly printLanguage: Reference<sageWhSystem.nodes.Language>;
	    readonly ediManagementStatus: Promise<sageWhProductData.enums.EdiMngtStatus | null>;
	    readonly numberOfParcelsWithoutMessage: Promise<integer | null>;
	    readonly ediManagementLevel: Promise<sageWhProductData.enums.EdiLevel | null>;
	    readonly queryNumber: Promise<integer | null>;
	    readonly billToAddresses: Collection<sageWhOutput.nodes.DeliveryNoteBillToAddresses>;
	    readonly billToCompanyNames: Collection<sageWhOutput.nodes.DeliveryNoteBillToCompanyNames>;
	    readonly numberOfDispatchableParcels: Collection<sageWhOutput.nodes.DeliveryNoteNumberOfDispatchableParcels>;
	    readonly shipToAddresses: Collection<sageWhOutput.nodes.DeliveryNoteShipToAddresses>;
	    readonly shipToCompanyNames: Collection<sageWhOutput.nodes.DeliveryNoteShipToCompanyNames>;
	}
	//# sourceMappingURL=delivery-note.d.ts.map
}
// From file: @sage/wh-output/build/lib/nodes/delivery-note-ship-to-company-names.d.ts
declare module '@sage/wh-output/lib/nodes/delivery-note-ship-to-company-names' {
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageWhOutput from '@sage/wh-output/lib/index';
	export class DeliveryNoteShipToCompanyNames extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly site: Promise<string>;
	    readonly depositor: Promise<string>;
	    readonly code: Promise<string>;
	    readonly _denormalizedParent: Reference<sageWhOutput.nodes.DeliveryNote>;
	    readonly shipToCompanyName: Promise<string>;
	}
	//# sourceMappingURL=delivery-note-ship-to-company-names.d.ts.map
}
// From file: @sage/wh-output/build/lib/nodes/delivery-note-ship-to-addresses.d.ts
declare module '@sage/wh-output/lib/nodes/delivery-note-ship-to-addresses' {
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageWhOutput from '@sage/wh-output/lib/index';
	export class DeliveryNoteShipToAddresses extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly site: Promise<string>;
	    readonly depositor: Promise<string>;
	    readonly code: Promise<string>;
	    readonly _denormalizedParent: Reference<sageWhOutput.nodes.DeliveryNote>;
	    readonly shipToAddress: Promise<string>;
	}
	//# sourceMappingURL=delivery-note-ship-to-addresses.d.ts.map
}
// From file: @sage/wh-output/build/lib/nodes/delivery-note-number-of-dispatchable-parcels.d.ts
declare module '@sage/wh-output/lib/nodes/delivery-note-number-of-dispatchable-parcels' {
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageWhOutput from '@sage/wh-output/lib/index';
	export class DeliveryNoteNumberOfDispatchableParcels extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly site: Promise<string>;
	    readonly depositor: Promise<string>;
	    readonly code: Promise<string>;
	    readonly _denormalizedParent: Reference<sageWhOutput.nodes.DeliveryNote>;
	    readonly numberOfDispatchableParcel: Promise<integer | null>;
	}
	//# sourceMappingURL=delivery-note-number-of-dispatchable-parcels.d.ts.map
}
// From file: @sage/wh-output/build/lib/nodes/delivery-note-bill-to-company-names.d.ts
declare module '@sage/wh-output/lib/nodes/delivery-note-bill-to-company-names' {
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageWhOutput from '@sage/wh-output/lib/index';
	export class DeliveryNoteBillToCompanyNames extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly site: Promise<string>;
	    readonly depositor: Promise<string>;
	    readonly code: Promise<string>;
	    readonly _denormalizedParent: Reference<sageWhOutput.nodes.DeliveryNote>;
	    readonly billToCompanyName: Promise<string>;
	}
	//# sourceMappingURL=delivery-note-bill-to-company-names.d.ts.map
}
// From file: @sage/wh-output/build/lib/nodes/delivery-note-bill-to-addresses.d.ts
declare module '@sage/wh-output/lib/nodes/delivery-note-bill-to-addresses' {
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageWhOutput from '@sage/wh-output/lib/index';
	export class DeliveryNoteBillToAddresses extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly site: Promise<string>;
	    readonly depositor: Promise<string>;
	    readonly code: Promise<string>;
	    readonly _denormalizedParent: Reference<sageWhOutput.nodes.DeliveryNote>;
	    readonly billToAddress: Promise<string>;
	}
	//# sourceMappingURL=delivery-note-bill-to-addresses.d.ts.map
}
// From file: @sage/wh-output/build/lib/nodes/carriage-receipt.d.ts
declare module '@sage/wh-output/lib/nodes/carriage-receipt' {
	import * as sageWhMasterData from '@sage/wh-master-data';
	import * as sageWhStructure from '@sage/wh-structure';
	import * as sageWhSystem from '@sage/wh-system';
	import { Node, Reference, date, decimal, integer, Collection } from '@sage/xtrem-core';
	import * as sageWhOutput from '@sage/wh-output/lib/index';
	export class CarriageReceipt extends Node {
	    readonly site: Reference<sageWhSystem.nodes.Site>;
	    readonly code: Promise<string>;
	    readonly deliveryNote: Reference<sageWhOutput.nodes.CarriageNote>;
	    readonly round: Reference<sageWhOutput.nodes.Round>;
	    readonly shipmentDate: Promise<date>;
	    readonly shipmentTime: Promise<string>;
	    readonly linearMeters: Promise<decimal | null>;
	    readonly truckPlacard: Promise<string>;
	    readonly sealNumber: Promise<string>;
	    readonly weight: Promise<decimal | null>;
	    readonly volume: Promise<decimal | null>;
	    readonly numberOfParcels: Promise<integer | null>;
	    readonly numberOfShippingUnits: Promise<integer | null>;
	    readonly numberOfDeliveryNotes: Promise<integer | null>;
	    readonly shipToCustomer: Reference<sageWhMasterData.nodes.Customer | null>;
	    readonly shipToPostalCode: Promise<string>;
	    readonly shipToCity: Promise<string>;
	    readonly shipToCountry: Reference<sageWhStructure.nodes.Country | null>;
	    readonly shipToCountryName: Promise<string>;
	    readonly shipToRegion: Promise<string>;
	    readonly deliveryArea: Promise<string>;
	    readonly freightCharge: Promise<decimal | null>;
	    readonly currency: Reference<sageWhMasterData.nodes.Currency | null>;
	    readonly dockType: Promise<sageWhMasterData.enums.DockManagement>;
	    readonly shipToCompanyNames: Collection<sageWhOutput.nodes.CarriageReceiptShipToCompanyNames>;
	    readonly shiptToAddresses: Collection<sageWhOutput.nodes.CarriageReceiptShiptToAddresses>;
	}
	//# sourceMappingURL=carriage-receipt.d.ts.map
}
// From file: @sage/wh-output/build/lib/nodes/carriage-receipt-shipt-to-addresses.d.ts
declare module '@sage/wh-output/lib/nodes/carriage-receipt-shipt-to-addresses' {
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageWhOutput from '@sage/wh-output/lib/index';
	export class CarriageReceiptShiptToAddresses extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly site: Promise<string>;
	    readonly code: Promise<string>;
	    readonly _denormalizedParent: Reference<sageWhOutput.nodes.CarriageReceipt>;
	    readonly shiptToAddress: Promise<string>;
	}
	//# sourceMappingURL=carriage-receipt-shipt-to-addresses.d.ts.map
}
// From file: @sage/wh-output/build/lib/nodes/carriage-receipt-ship-to-company-names.d.ts
declare module '@sage/wh-output/lib/nodes/carriage-receipt-ship-to-company-names' {
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageWhOutput from '@sage/wh-output/lib/index';
	export class CarriageReceiptShipToCompanyNames extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly site: Promise<string>;
	    readonly code: Promise<string>;
	    readonly _denormalizedParent: Reference<sageWhOutput.nodes.CarriageReceipt>;
	    readonly shipToCompanyName: Promise<string>;
	}
	//# sourceMappingURL=carriage-receipt-ship-to-company-names.d.ts.map
}
// From file: @sage/wh-output/build/lib/nodes/carriage-note.d.ts
declare module '@sage/wh-output/lib/nodes/carriage-note' {
	import * as sageWhMasterData from '@sage/wh-master-data';
	import * as sageWhSystem from '@sage/wh-system';
	import { Node, Reference, date, decimal, integer } from '@sage/xtrem-core';
	import * as sageWhOutput from '@sage/wh-output/lib/index';
	export class CarriageNote extends Node {
	    readonly site: Reference<sageWhSystem.nodes.Site>;
	    readonly code: Promise<string>;
	    readonly round: Reference<sageWhOutput.nodes.Round>;
	    readonly shipmentDate: Promise<date>;
	    readonly shipmentTime: Promise<string>;
	    readonly linearMeters: Promise<decimal | null>;
	    readonly truckPlacard: Promise<string>;
	    readonly sealNumber: Promise<string>;
	    readonly numberOfCarriageReceipts: Promise<integer | null>;
	    readonly numberOfDeliveryNotes: Promise<integer | null>;
	    readonly weight: Promise<decimal | null>;
	    readonly volume: Promise<decimal | null>;
	    readonly numberOfParcels: Promise<integer | null>;
	    readonly numberOfShippingUnits: Promise<integer | null>;
	    readonly freightCharge: Promise<decimal | null>;
	    readonly currency: Reference<sageWhMasterData.nodes.Currency | null>;
	    readonly dockType: Promise<sageWhMasterData.enums.DockManagement>;
	}
	//# sourceMappingURL=carriage-note.d.ts.map
}
// From file: @sage/wh-output/build/lib/nodes/auto-palletization-order.d.ts
declare module '@sage/wh-output/lib/nodes/auto-palletization-order' {
	import * as sageWhMasterData from '@sage/wh-master-data';
	import * as sageWhProductData from '@sage/wh-product-data';
	import * as sageWhSystem from '@sage/wh-system';
	import { Node, Reference, integer, date } from '@sage/xtrem-core';
	import * as sageWhOutput from '@sage/wh-output/lib/index';
	export class AutoPalletizationOrder extends Node {
	    readonly site: Reference<sageWhSystem.nodes.Site>;
	    readonly depositor: Reference<sageWhMasterData.nodes.Depositor>;
	    readonly code: Promise<string>;
	    readonly status: Promise<sageWhProductData.enums.AutoPalletizationStatus | null>;
	    readonly deliveryOrder: Reference<sageWhOutput.nodes.DeliveryOrder | null>;
	    readonly numberOfShippingUnits: Promise<integer | null>;
	    readonly numberOfParcels: Promise<integer | null>;
	    readonly date: Promise<date>;
	    readonly time: Promise<string>;
	    readonly preparationArea: Reference<sageWhMasterData.nodes.PreparationArea | null>;
	    readonly validatingOperator: Reference<sageWhMasterData.nodes.Operand | null>;
	    readonly postingDate: Promise<date | null>;
	    readonly postingTime: Promise<integer | null>;
	    readonly validatingUser: Promise<string>;
	}
	//# sourceMappingURL=auto-palletization-order.d.ts.map
}
// From file: @sage/wh-output/build/lib/node-extensions/serial-number-extension.d.ts
declare module '@sage/wh-output/lib/node-extensions/serial-number-extension' {
	import * as sageWhStockData from '@sage/wh-stock-data';
	import { NodeExtension, Reference } from '@sage/xtrem-core';
	import * as sageWhOutput from '@sage/wh-output/lib/index';
	export class SerialNumberExtension extends NodeExtension<sageWhStockData.nodes.SerialNumber> {
	    readonly deliveryOrder: Reference<sageWhOutput.nodes.DeliveryOrder | null>;
	    readonly outputMovement: Reference<sageWhOutput.nodes.OutputMovement | null>;
	}
	declare module '@sage/wh-stock-data/lib/nodes/serial-number' {
	    interface SerialNumber extends SerialNumberExtension {
	    }
	}
	//# sourceMappingURL=serial-number-extension.d.ts.map
}
// From file: @sage/wh-output/build/lib/node-extensions/location-extension.d.ts
declare module '@sage/wh-output/lib/node-extensions/location-extension' {
	import * as sageWhMasterData from '@sage/wh-master-data';
	import { NodeExtension, Reference } from '@sage/xtrem-core';
	import * as sageWhOutput from '@sage/wh-output/lib/index';
	export class LocationExtension extends NodeExtension<sageWhMasterData.nodes.Location> {
	    readonly deliveryOrderPivot: Reference<sageWhOutput.nodes.DeliveryOrder | null>;
	}
	declare module '@sage/wh-master-data/lib/nodes/location' {
	    interface Location extends LocationExtension {
	    }
	}
	//# sourceMappingURL=location-extension.d.ts.map
}
// From file: @sage/wh-output/build/lib/node-extensions/index.d.ts
declare module '@sage/wh-output/lib/node-extensions/index' {
	export * from '@sage/wh-output/lib/node-extensions/location-extension';
	export * from '@sage/wh-output/lib/node-extensions/serial-number-extension';
	//# sourceMappingURL=index.d.ts.map
}
// From file: @sage/wh-output/build/lib/enums/index.d.ts
declare module '@sage/wh-output/lib/enums/index' {
	export type Dummy = void;
	//# sourceMappingURL=index.d.ts.map
}
declare module '@sage/wh-output' {
	export * from '@sage/wh-output/index';
}
