"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ShippingUnit = void 0;
const sageWhMasterData = require("@sage/wh-master-data");
const sageWhProductData = require("@sage/wh-product-data");
const sageWhSystem = require("@sage/wh-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageWhOutput = require("..");
const joins = {
    referenceJoins: {
        site: {
            code: 'site',
        },
        depositor: {
            site: 'site',
            code: 'depositor',
        },
        shippingUnitType: {
            site: 'site',
            code: 'shippingUnitType',
        },
        deliveryOrder: {
            site: 'site',
            depositor: 'depositor',
            code: 'deliveryOrder',
        },
        pickingOrder: {
            site: 'site',
            depositor: 'depositor',
            code: 'pickingOrder',
        },
        preparationArea: {
            site: 'site',
            code: 'preparationArea',
        },
        pickingMode: {
            site: 'site',
            depositor: 'depositor',
            code: 'pickingMode',
        },
        palletisationOrder: {
            site: 'site',
            depositor: 'depositor',
            code: 'palletisationOrder',
        },
        shipTo: {
            site: 'site',
            code: 'shipTo',
        },
        parcel: {
            site: 'site',
            depositor: 'depositor',
            code: 'parcel',
        },
        dockStore: {
            site: 'site',
            code: 'dockStore',
        },
        dockAddress: {
            site: 'site',
            store: 'dockStore',
            code: 'dockAddress',
        },
        originDockStore: {
            site: 'site',
            code: 'originDockStore',
        },
        originDockAddress: {
            site: 'site',
            store: 'originDockStore',
            code: 'originDockAddress',
        },
    },
    collectionJoins: {
        parcels: {
            site: 'site',
            depositor: 'depositor',
            shippingUnit: 'code',
            pickingOrder: 'pickingOrder',
        },
    },
};
let ShippingUnit = class ShippingUnit extends xtrem_core_1.Node {
};
exports.ShippingUnit = ShippingUnit;
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'FCY',
        columnType: 'string',
        node: () => sageWhSystem.nodes.Site,
        lookupAccess: true,
    })
], ShippingUnit.prototype, "site", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DEP',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.Depositor,
        lookupAccess: true,
    })
], ShippingUnit.prototype, "depositor", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'SHPNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], ShippingUnit.prototype, "code", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SHPSTA',
        dataType: () => sageWhProductData.enums.shippingUnitStatusDatatype,
        lookupAccess: true,
    })
], ShippingUnit.prototype, "status", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SHU',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.ShippingUnitType,
        lookupAccess: true,
    })
], ShippingUnit.prototype, "shippingUnitType", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DLONUM',
        columnType: 'string',
        node: () => sageWhOutput.nodes.DeliveryOrder,
        lookupAccess: true,
    })
], ShippingUnit.prototype, "deliveryOrder", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SHPSNGDLO',
        lookupAccess: true,
    })
], ShippingUnit.prototype, "isShippingUnitSingleDeliveryOrder", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SHPSNGDLV',
        lookupAccess: true,
    })
], ShippingUnit.prototype, "isShippingUnitSingleCustomer", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PKONUM',
        columnType: 'string',
        node: () => sageWhOutput.nodes.PickingOrder,
        lookupAccess: true,
    })
], ShippingUnit.prototype, "pickingOrder", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PKZ',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.PreparationArea,
        lookupAccess: true,
    })
], ShippingUnit.prototype, "preparationArea", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PMD',
        columnType: 'string',
        node: () => sageWhProductData.nodes.PickingMode,
        lookupAccess: true,
    })
], ShippingUnit.prototype, "pickingMode", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'OPANUM',
        columnType: 'string',
        node: () => sageWhOutput.nodes.AutoPalletizationOrder,
        lookupAccess: true,
    })
], ShippingUnit.prototype, "palletisationOrder", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DLVCLT',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.Customer,
        lookupAccess: true,
    })
], ShippingUnit.prototype, "shipTo", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DLVPOS',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], ShippingUnit.prototype, "postalCode", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'FWDFLG',
        lookupAccess: true,
    })
], ShippingUnit.prototype, "isPostponed", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SHPHEI',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        lookupAccess: true,
    })
], ShippingUnit.prototype, "height", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SHPWID',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        lookupAccess: true,
    })
], ShippingUnit.prototype, "width", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SHPDTH',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        lookupAccess: true,
    })
], ShippingUnit.prototype, "depth", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SHPVOL',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        lookupAccess: true,
    })
], ShippingUnit.prototype, "volume", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SHPWEI',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        lookupAccess: true,
    })
], ShippingUnit.prototype, "weight", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'THEWEI',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        lookupAccess: true,
    })
], ShippingUnit.prototype, "estimatedWeight", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PRCNBR',
        lookupAccess: true,
    })
], ShippingUnit.prototype, "numberOfParcels", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PRCNUM',
        columnType: 'string',
        node: () => sageWhOutput.nodes.Parcel,
        lookupAccess: true,
    })
], ShippingUnit.prototype, "parcel", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SSCCOD',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], ShippingUnit.prototype, "ssccShippingUnitCode", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'STOQAT',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.Store,
        lookupAccess: true,
    })
], ShippingUnit.prototype, "dockStore", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ADDQAT',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.Location,
        lookupAccess: true,
    })
], ShippingUnit.prototype, "dockAddress", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ORISTOQAT',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.Store,
        lookupAccess: true,
    })
], ShippingUnit.prototype, "originDockStore", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ORIADDQAT',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.Location,
        lookupAccess: true,
    })
], ShippingUnit.prototype, "originDockAddress", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'STAQAT',
        dataType: () => sageWhProductData.enums.colisDatatype,
        lookupAccess: true,
    })
], ShippingUnit.prototype, "stockOnDockStatus", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'FLGCTLQAT',
        lookupAccess: true,
    })
], ShippingUnit.prototype, "isStockOnDockControl", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'FLGCTLFLM',
        lookupAccess: true,
    })
], ShippingUnit.prototype, "isWrappedShippingUnit", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'TYPCRE',
        dataType: () => sageWhProductData.enums.suCreationTypeDatatype,
        lookupAccess: true,
    })
], ShippingUnit.prototype, "creationType", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SUBNUM',
        lookupAccess: true,
    })
], ShippingUnit.prototype, "subWaveNumber", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DSTFLG',
        lookupAccess: true,
    })
], ShippingUnit.prototype, "isDispatchableInState", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        node: () => sageWhOutput.nodes.Parcel,
        isMutable: true,
        dependsOn: ['site', 'depositor', 'code', 'pickingOrder'],
        lookupAccess: true,
    })
], ShippingUnit.prototype, "parcels", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageWhOutput.nodes.ShippingUnitCompanyNames,
    })
], ShippingUnit.prototype, "companyNames", void 0);
exports.ShippingUnit = ShippingUnit = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'UNITSHIP',
        keyPropertyNames: ['site', 'depositor', 'code'],
        indexes: [
            {
                orderBy: {
                    site: 1,
                    depositor: 1,
                    code: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            joinFallbackProperties: ['depositor'],
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], ShippingUnit);
//# sourceMappingURL=shipping-unit.js.map