import * as sageWhMasterData from '@sage/wh-master-data';
import * as sageWhProductData from '@sage/wh-product-data';
import * as sageWhSystem from '@sage/wh-system';
import { Node, Reference, decimal, integer, Collection } from '@sage/xtrem-core';
import * as sageWhOutput from '..';
export declare class ShippingUnit extends Node {
    readonly site: Reference<sageWhSystem.nodes.Site>;
    readonly depositor: Reference<sageWhMasterData.nodes.Depositor | null>;
    readonly code: Promise<string>;
    readonly status: Promise<sageWhProductData.enums.ShippingUnitStatus>;
    readonly shippingUnitType: Reference<sageWhMasterData.nodes.ShippingUnitType>;
    readonly deliveryOrder: Reference<sageWhOutput.nodes.DeliveryOrder | null>;
    readonly isShippingUnitSingleDeliveryOrder: Promise<boolean>;
    readonly isShippingUnitSingleCustomer: Promise<boolean>;
    readonly pickingOrder: Reference<sageWhOutput.nodes.PickingOrder | null>;
    readonly preparationArea: Reference<sageWhMasterData.nodes.PreparationArea | null>;
    readonly pickingMode: Reference<sageWhProductData.nodes.PickingMode | null>;
    readonly palletisationOrder: Reference<sageWhOutput.nodes.AutoPalletizationOrder | null>;
    readonly shipTo: Reference<sageWhMasterData.nodes.Customer | null>;
    readonly postalCode: Promise<string>;
    readonly isPostponed: Promise<boolean>;
    readonly height: Promise<decimal | null>;
    readonly width: Promise<decimal | null>;
    readonly depth: Promise<decimal | null>;
    readonly volume: Promise<decimal | null>;
    readonly weight: Promise<decimal | null>;
    readonly estimatedWeight: Promise<decimal | null>;
    readonly numberOfParcels: Promise<integer | null>;
    readonly parcel: Reference<sageWhOutput.nodes.Parcel | null>;
    readonly ssccShippingUnitCode: Promise<string>;
    readonly dockStore: Reference<sageWhMasterData.nodes.Store | null>;
    readonly dockAddress: Reference<sageWhMasterData.nodes.Location | null>;
    readonly originDockStore: Reference<sageWhMasterData.nodes.Store | null>;
    readonly originDockAddress: Reference<sageWhMasterData.nodes.Location | null>;
    readonly stockOnDockStatus: Promise<sageWhProductData.enums.Colis | null>;
    readonly isStockOnDockControl: Promise<boolean>;
    readonly isWrappedShippingUnit: Promise<boolean>;
    readonly creationType: Promise<sageWhProductData.enums.SuCreationType | null>;
    readonly subWaveNumber: Promise<integer | null>;
    readonly isDispatchableInState: Promise<boolean>;
    readonly parcels: Collection<sageWhOutput.nodes.Parcel>;
    readonly companyNames: Collection<sageWhOutput.nodes.ShippingUnitCompanyNames>;
}
//# sourceMappingURL=shipping-unit.d.ts.map