"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Round = void 0;
const sageWhMasterData = require("@sage/wh-master-data");
const sageWhSystem = require("@sage/wh-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageWhOutput = require("..");
const joins = {
    referenceJoins: {
        site: {
            code: 'site',
        },
        appointment: {
            site: 'site',
            code: 'appointment',
        },
        carrier: {
            site: 'site',
            code: 'carrier',
        },
        transportationMethod: {
            site: 'site',
            code: 'transportationMethod',
        },
        dockStore: {
            site: 'site',
            code: 'dockStore',
        },
        dockAddress: {
            site: 'site',
            store: 'dockStore',
            code: 'dockAddress',
        },
        genericRound: {
            site: 'site',
            code: 'genericRound',
        },
        transportType: {
            site: 'site',
            code: 'transportType',
        },
        shipTo: {
            site: 'site',
            code: 'shipTo',
        },
        destinationSite: {
            code: 'destinationSite',
        },
    },
    collectionJoins: {
        deliveryOrders: {
            site: 'site',
            round: 'code',
        },
    },
};
let Round = class Round extends xtrem_core_1.Node {
};
exports.Round = Round;
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'FCY',
        columnType: 'string',
        node: () => sageWhSystem.nodes.Site,
        lookupAccess: true,
    })
], Round.prototype, "site", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        columnName: 'TYP',
        dataType: () => sageWhMasterData.enums.dockManagementDatatype,
        lookupAccess: true,
    })
], Round.prototype, "dockType", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'QYMNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], Round.prototype, "code", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CRANUM',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.AppointmentManagement,
        lookupAccess: true,
    })
], Round.prototype, "appointment", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
        lookupAccess: true,
    })
], Round.prototype, "date", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'TIM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], Round.prototype, "time", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'TER',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], Round.prototype, "duration", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'QYMSTA',
        dataType: () => sageWhMasterData.enums.roundStatusDatatype,
        lookupAccess: true,
    })
], Round.prototype, "status", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CRR',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.Carrier,
        lookupAccess: true,
    })
], Round.prototype, "carrier", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'CRRNAM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], Round.prototype, "carrierName", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CRRMOD',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.TransportMode,
        lookupAccess: true,
    })
], Round.prototype, "transportationMethod", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CRRREF',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], Round.prototype, "carriageReference", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'STO',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.Store,
        lookupAccess: true,
    })
], Round.prototype, "dockStore", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SLO',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.Location,
        lookupAccess: true,
    })
], Round.prototype, "dockAddress", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'GDR',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.GenericRound,
        lookupAccess: true,
    })
], Round.prototype, "genericRound", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'VOL',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        lookupAccess: true,
    })
], Round.prototype, "volume", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'WEI',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        lookupAccess: true,
    })
], Round.prototype, "weight", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LMT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        lookupAccess: true,
    })
], Round.prototype, "linearMeters", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'NBLIG',
        lookupAccess: true,
    })
], Round.prototype, "numberOfDeliveryOrders", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LINNBR',
        lookupAccess: true,
    })
], Round.prototype, "numberOfLines", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'HEANBR',
        lookupAccess: true,
    })
], Round.prototype, "deliveryOrderNumber", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CUQ',
        lookupAccess: true,
    })
], Round.prototype, "numberOfConsumptionUnit", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'TOTSHPNBR',
        lookupAccess: true,
    })
], Round.prototype, "numberOfShippingUnits", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CGTXCL',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.TransportType,
        lookupAccess: true,
    })
], Round.prototype, "transportType", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CLTXCL',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.Customer,
        lookupAccess: true,
    })
], Round.prototype, "shipTo", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'INSFLG',
        lookupAccess: true,
    })
], Round.prototype, "isInterSiteRound", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DENFCY',
        columnType: 'string',
        node: () => sageWhSystem.nodes.Site,
        lookupAccess: true,
    })
], Round.prototype, "destinationSite", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        node: () => sageWhOutput.nodes.DeliveryOrder,
        isMutable: true,
        dependsOn: ['site', 'code'],
        lookupAccess: true,
    })
], Round.prototype, "deliveryOrders", void 0);
exports.Round = Round = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'QUAYMGT',
        keyPropertyNames: ['site', 'dockType', 'code'],
        indexes: [
            {
                orderBy: {
                    site: 1,
                    dockType: 1,
                    code: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], Round);
//# sourceMappingURL=round.js.map