import * as sageWhMasterData from '@sage/wh-master-data';
import * as sageWhSystem from '@sage/wh-system';
import { Node, Reference, date, decimal, integer, Collection } from '@sage/xtrem-core';
import * as sageWhOutput from '..';
export declare class Round extends Node {
    readonly site: Reference<sageWhSystem.nodes.Site>;
    readonly dockType: Promise<sageWhMasterData.enums.DockManagement>;
    readonly code: Promise<string>;
    readonly appointment: Reference<sageWhMasterData.nodes.AppointmentManagement | null>;
    readonly date: Promise<date>;
    readonly time: Promise<string>;
    readonly duration: Promise<string>;
    readonly status: Promise<sageWhMasterData.enums.RoundStatus | null>;
    readonly carrier: Reference<sageWhMasterData.nodes.Carrier | null>;
    readonly carrierName: Promise<string>;
    readonly transportationMethod: Reference<sageWhMasterData.nodes.TransportMode | null>;
    readonly carriageReference: Promise<string>;
    readonly dockStore: Reference<sageWhMasterData.nodes.Store | null>;
    readonly dockAddress: Reference<sageWhMasterData.nodes.Location | null>;
    readonly genericRound: Reference<sageWhMasterData.nodes.GenericRound | null>;
    readonly volume: Promise<decimal | null>;
    readonly weight: Promise<decimal | null>;
    readonly linearMeters: Promise<decimal | null>;
    readonly numberOfDeliveryOrders: Promise<integer | null>;
    readonly numberOfLines: Promise<integer | null>;
    readonly deliveryOrderNumber: Promise<integer | null>;
    readonly numberOfConsumptionUnit: Promise<integer | null>;
    readonly numberOfShippingUnits: Promise<integer | null>;
    readonly transportType: Reference<sageWhMasterData.nodes.TransportType | null>;
    readonly shipTo: Reference<sageWhMasterData.nodes.Customer | null>;
    readonly isInterSiteRound: Promise<boolean>;
    readonly destinationSite: Reference<sageWhSystem.nodes.Site | null>;
    readonly deliveryOrders: Collection<sageWhOutput.nodes.DeliveryOrder>;
}
//# sourceMappingURL=round.d.ts.map