import * as sageWhMasterData from '@sage/wh-master-data';
import * as sageWhProductData from '@sage/wh-product-data';
import * as sageWhSystem from '@sage/wh-system';
import { Node, Reference, date, integer, decimal } from '@sage/xtrem-core';
import * as sageWhOutput from '..';
export declare class PickingOrder extends Node {
    readonly site: Reference<sageWhSystem.nodes.Site>;
    readonly depositor: Reference<sageWhMasterData.nodes.Depositor>;
    readonly code: Promise<string>;
    readonly status: Promise<sageWhProductData.enums.StoringListPurchaseOrderStatus | null>;
    readonly pickingOrderType: Promise<sageWhProductData.enums.PoType | null>;
    readonly pickingMode: Reference<sageWhProductData.nodes.PickingMode>;
    readonly preparationArea: Reference<sageWhMasterData.nodes.PreparationArea>;
    readonly deliveryOrder: Reference<sageWhOutput.nodes.DeliveryOrder | null>;
    readonly round: Reference<sageWhOutput.nodes.Round | null>;
    readonly level: Promise<sageWhMasterData.enums.ContainerLevel | null>;
    readonly isPreparationOrderKit: Promise<boolean>;
    readonly date: Promise<date>;
    readonly time: Promise<string>;
    readonly totalMovements: Promise<integer | null>;
    readonly totalConsumptionUnit: Promise<decimal | null>;
    readonly totalWeight: Promise<decimal | null>;
    readonly totalVolume: Promise<decimal | null>;
    readonly preparationTime: Promise<decimal | null>;
    readonly equivalentSurface: Promise<decimal | null>;
    readonly numberOfParcels: Promise<integer | null>;
    readonly numberOfShippingUnits: Promise<integer | null>;
    readonly subWaveNumber: Promise<integer>;
    readonly shipTo: Reference<sageWhMasterData.nodes.Customer | null>;
    readonly validatingOperator: Reference<sageWhMasterData.nodes.Operand | null>;
    readonly postingDate: Promise<date | null>;
    readonly postingTime: Promise<integer | null>;
    readonly validatingUser: Promise<string>;
}
//# sourceMappingURL=picking-order.d.ts.map