"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Parcel = void 0;
const sageWhMasterData = require("@sage/wh-master-data");
const sageWhProductData = require("@sage/wh-product-data");
const sageWhSystem = require("@sage/wh-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageWhOutput = require("..");
const joins = {
    referenceJoins: {
        site: {
            code: 'site',
        },
        depositor: {
            site: 'site',
            code: 'depositor',
        },
        deliveryOrder: {
            site: 'site',
            depositor: 'depositor',
            code: 'deliveryOrder',
        },
        pickingOrder: {
            site: 'site',
            depositor: 'depositor',
            code: 'pickingOrder',
        },
        palletisationOrder: {
            site: 'site',
            depositor: 'depositor',
            code: 'palletisationOrder',
        },
        preparationArea: {
            site: 'site',
            code: 'preparationArea',
        },
        pickingMode: {
            site: 'site',
            depositor: 'depositor',
            code: 'pickingMode',
        },
        parcelRange: {
            site: 'site',
            code: 'parcelRange',
        },
        parcelType: {
            site: 'site',
            parcelRange: 'parcelRange',
            code: 'parcelType',
        },
        carrier: {
            site: 'site',
            code: 'carrier',
        },
        transportationMethod: {
            site: 'site',
            code: 'transportationMethod',
        },
        deliveryNote: {
            site: 'site',
            depositor: 'depositor',
            code: 'deliveryNote',
        },
        shippingUnit: {
            site: 'site',
            depositor: 'depositor',
            code: 'shippingUnit',
        },
        validatingOperator: {
            site: 'site',
            code: 'validatingOperator',
        },
        dockStore: {
            site: 'site',
            code: 'dockStore',
        },
        dockAddress: {
            site: 'site',
            store: 'dockStore',
            code: 'dockAddress',
        },
        originDockStore: {
            site: 'site',
            code: 'originDockStore',
        },
        originDockAddress: {
            site: 'site',
            store: 'originDockStore',
            code: 'originDockAddress',
        },
    },
    collectionJoins: {
        shippingUnits: {
            site: 'site',
            depositor: 'depositor',
            code: 'shippingUnit',
        },
        outputMovements: {
            site: 'site',
            depositor: 'depositor',
            parcel: 'code',
        },
    },
};
let Parcel = class Parcel extends xtrem_core_1.Node {
};
exports.Parcel = Parcel;
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'FCY',
        columnType: 'string',
        node: () => sageWhSystem.nodes.Site,
        lookupAccess: true,
    })
], Parcel.prototype, "site", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DEP',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.Depositor,
        lookupAccess: true,
    })
], Parcel.prototype, "depositor", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'PRCNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], Parcel.prototype, "code", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DLONUM',
        columnType: 'string',
        node: () => sageWhOutput.nodes.DeliveryOrder,
        lookupAccess: true,
    })
], Parcel.prototype, "deliveryOrder", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PKONUM',
        columnType: 'string',
        node: () => sageWhOutput.nodes.PickingOrder,
        lookupAccess: true,
    })
], Parcel.prototype, "pickingOrder", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'OPANUM',
        columnType: 'string',
        node: () => sageWhOutput.nodes.AutoPalletizationOrder,
        lookupAccess: true,
    })
], Parcel.prototype, "palletisationOrder", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PRCSTA',
        dataType: () => sageWhProductData.enums.parcelStatusDatatype,
        lookupAccess: true,
    })
], Parcel.prototype, "status", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PKZ',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.PreparationArea,
        lookupAccess: true,
    })
], Parcel.prototype, "preparationArea", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PMD',
        columnType: 'string',
        node: () => sageWhProductData.nodes.PickingMode,
        lookupAccess: true,
    })
], Parcel.prototype, "pickingMode", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PRA',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.RangeOfParcel,
        lookupAccess: true,
    })
], Parcel.prototype, "parcelRange", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PACTYP',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.ParcelType,
        lookupAccess: true,
    })
], Parcel.prototype, "parcelType", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'HEI',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        lookupAccess: true,
    })
], Parcel.prototype, "height", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'WID',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        lookupAccess: true,
    })
], Parcel.prototype, "width", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DTH',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        lookupAccess: true,
    })
], Parcel.prototype, "depth", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'VOL',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        lookupAccess: true,
    })
], Parcel.prototype, "volume", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'THEWEI',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        lookupAccess: true,
    })
], Parcel.prototype, "estimatedWeight", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'WEI',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        lookupAccess: true,
    })
], Parcel.prototype, "realWeight", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DSTFLG',
        lookupAccess: true,
    })
], Parcel.prototype, "isDispatchableInState", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'USTFLG',
        lookupAccess: true,
    })
], Parcel.prototype, "isPalettizableAsIs", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'CRRPRCNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], Parcel.prototype, "carrierParcelNumber", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CRPCRR',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.Carrier,
        lookupAccess: true,
    })
], Parcel.prototype, "carrier", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CRPCRM',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.TransportMode,
        lookupAccess: true,
    })
], Parcel.prototype, "transportationMethod", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DLNNUM',
        columnType: 'string',
        node: () => sageWhOutput.nodes.DeliveryNote,
        lookupAccess: true,
    })
], Parcel.prototype, "deliveryNote", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SHPNUM',
        columnType: 'string',
        node: () => sageWhOutput.nodes.ShippingUnit,
        lookupAccess: true,
    })
], Parcel.prototype, "shippingUnit", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'FWDFLG',
        lookupAccess: true,
    })
], Parcel.prototype, "isPostponed", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'VLDOPE',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.Operand,
        lookupAccess: true,
    })
], Parcel.prototype, "validatingOperator", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'VLDUSR',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], Parcel.prototype, "validatingUser", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'VLDDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
        lookupAccess: true,
    })
], Parcel.prototype, "postingDate", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'VLDTIM',
        lookupAccess: true,
    })
], Parcel.prototype, "postingTime", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PKOSRT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], Parcel.prototype, "pickingOrderSorting", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SSCCOD',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], Parcel.prototype, "ssccParcelCode", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'STOQAT',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.Store,
        lookupAccess: true,
    })
], Parcel.prototype, "dockStore", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ADDQAT',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.Location,
        lookupAccess: true,
    })
], Parcel.prototype, "dockAddress", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ORISTOQAT',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.Store,
        lookupAccess: true,
    })
], Parcel.prototype, "originDockStore", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ORIADDQAT',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.Location,
        lookupAccess: true,
    })
], Parcel.prototype, "originDockAddress", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'STAQAT',
        dataType: () => sageWhProductData.enums.colisDatatype,
        lookupAccess: true,
    })
], Parcel.prototype, "stockOnDockStatus", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'FLGCTLQAT',
        lookupAccess: true,
    })
], Parcel.prototype, "isStockOnDockControl", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'TYPOP',
        dataType: () => sageWhProductData.enums.poTypeDatatype,
        lookupAccess: true,
    })
], Parcel.prototype, "pickingOrderType", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        node: () => sageWhOutput.nodes.ShippingUnit,
        isMutable: true,
        dependsOn: ['site', 'depositor', 'shippingUnit'],
        lookupAccess: true,
    })
], Parcel.prototype, "shippingUnits", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        node: () => sageWhOutput.nodes.OutputMovement,
        isMutable: true,
        dependsOn: ['site', 'depositor', 'code'],
        lookupAccess: true,
    })
], Parcel.prototype, "outputMovements", void 0);
exports.Parcel = Parcel = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'PARCEL',
        keyPropertyNames: ['site', 'depositor', 'code'],
        indexes: [
            {
                orderBy: {
                    site: 1,
                    depositor: 1,
                    code: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], Parcel);
//# sourceMappingURL=parcel.js.map