import * as sageWhMasterData from '@sage/wh-master-data';
import * as sageWhProductData from '@sage/wh-product-data';
import * as sageWhSystem from '@sage/wh-system';
import { Node, Reference, decimal, date, integer, Collection } from '@sage/xtrem-core';
import * as sageWhOutput from '..';
export declare class Parcel extends Node {
    readonly site: Reference<sageWhSystem.nodes.Site>;
    readonly depositor: Reference<sageWhMasterData.nodes.Depositor>;
    readonly code: Promise<string>;
    readonly deliveryOrder: Reference<sageWhOutput.nodes.DeliveryOrder>;
    readonly pickingOrder: Reference<sageWhOutput.nodes.PickingOrder | null>;
    readonly palletisationOrder: Reference<sageWhOutput.nodes.AutoPalletizationOrder | null>;
    readonly status: Promise<sageWhProductData.enums.ParcelStatus>;
    readonly preparationArea: Reference<sageWhMasterData.nodes.PreparationArea>;
    readonly pickingMode: Reference<sageWhProductData.nodes.PickingMode | null>;
    readonly parcelRange: Reference<sageWhMasterData.nodes.RangeOfParcel>;
    readonly parcelType: Reference<sageWhMasterData.nodes.ParcelType>;
    readonly height: Promise<decimal | null>;
    readonly width: Promise<decimal | null>;
    readonly depth: Promise<decimal | null>;
    readonly volume: Promise<decimal | null>;
    readonly estimatedWeight: Promise<decimal | null>;
    readonly realWeight: Promise<decimal | null>;
    readonly isDispatchableInState: Promise<boolean>;
    readonly isPalettizableAsIs: Promise<boolean>;
    readonly carrierParcelNumber: Promise<string>;
    readonly carrier: Reference<sageWhMasterData.nodes.Carrier | null>;
    readonly transportationMethod: Reference<sageWhMasterData.nodes.TransportMode | null>;
    readonly deliveryNote: Reference<sageWhOutput.nodes.DeliveryNote | null>;
    readonly shippingUnit: Reference<sageWhOutput.nodes.ShippingUnit | null>;
    readonly isPostponed: Promise<boolean>;
    readonly validatingOperator: Reference<sageWhMasterData.nodes.Operand | null>;
    readonly validatingUser: Promise<string>;
    readonly postingDate: Promise<date | null>;
    readonly postingTime: Promise<integer | null>;
    readonly pickingOrderSorting: Promise<string>;
    readonly ssccParcelCode: Promise<string>;
    readonly dockStore: Reference<sageWhMasterData.nodes.Store | null>;
    readonly dockAddress: Reference<sageWhMasterData.nodes.Location | null>;
    readonly originDockStore: Reference<sageWhMasterData.nodes.Store | null>;
    readonly originDockAddress: Reference<sageWhMasterData.nodes.Location | null>;
    readonly stockOnDockStatus: Promise<sageWhProductData.enums.Colis | null>;
    readonly isStockOnDockControl: Promise<boolean>;
    readonly pickingOrderType: Promise<sageWhProductData.enums.PoType | null>;
    readonly shippingUnits: Collection<sageWhOutput.nodes.ShippingUnit>;
    readonly outputMovements: Collection<sageWhOutput.nodes.OutputMovement>;
}
//# sourceMappingURL=parcel.d.ts.map