"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.OutputMovement = void 0;
const sageWhMasterData = require("@sage/wh-master-data");
const sageWhProductData = require("@sage/wh-product-data");
const sageWhStockData = require("@sage/wh-stock-data");
const sageWhSystem = require("@sage/wh-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageWhOutput = require("..");
const joins = {
    referenceJoins: {
        site: {
            code: 'site',
        },
        depositor: {
            site: 'site',
            code: 'depositor',
        },
        deliveryOrder: {
            site: 'site',
            depositor: 'depositor',
            code: 'deliveryOrder',
        },
        pickingOrder: {
            site: 'site',
            depositor: 'depositor',
            code: 'pickingOrder',
        },
        product: {
            site: 'site',
            depositor: 'depositor',
            code: 'product',
        },
        container: {
            site: 'site',
            depositor: 'depositor',
            product: 'product',
            container: 'container',
        },
        movementCode: {
            site: 'site',
            code: 'movementCode',
        },
        stockStatus: {
            site: 'site',
            code: 'stockStatus',
        },
        source: {
            site: 'site',
            depositor: 'depositor',
            code: 'source',
        },
        pickingMode: {
            site: 'site',
            depositor: 'depositor',
            code: 'pickingMode',
        },
        store: {
            site: 'site',
            code: 'store',
        },
        location: {
            site: 'site',
            store: 'store',
            code: 'location',
        },
        stockObject: {
            site: 'site',
            code: 'stockObject',
        },
        homogeneousContainer: {
            site: 'site',
            depositor: 'depositor',
            product: 'product',
            container: 'homogeneousContainer',
        },
        originContainer: {
            site: 'site',
            depositor: 'depositor',
            product: 'product',
            container: 'originContainer',
        },
        parcel: {
            site: 'site',
            depositor: 'depositor',
            code: 'parcel',
        },
        shippingUnit: {
            site: 'site',
            depositor: 'depositor',
            code: 'shippingUnit',
        },
        deliveryNote: {
            site: 'site',
            depositor: 'depositor',
            code: 'deliveryNote',
        },
        round: {
            site: 'roundSite',
            dockType() {
                return 'round';
            },
            code: 'round',
        },
        roundSite: {
            code: 'roundSite',
        },
        destinationSite: {
            code: 'destinationSite',
        },
        validatingOperator: {
            site: 'site',
            code: 'validatingOperator',
        },
    },
    collectionJoins: {
        parcels: {
            site: 'site',
            depositor: 'depositor',
            deliveryOrder: 'deliveryOrder',
            code: 'parcel',
        },
    },
};
let OutputMovement = class OutputMovement extends xtrem_core_1.Node {
};
exports.OutputMovement = OutputMovement;
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'FCY',
        columnType: 'string',
        node: () => sageWhSystem.nodes.Site,
        lookupAccess: true,
    })
], OutputMovement.prototype, "site", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DEP',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.Depositor,
        lookupAccess: true,
    })
], OutputMovement.prototype, "depositor", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'MVTNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], OutputMovement.prototype, "code", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DLONUM',
        columnType: 'string',
        node: () => sageWhOutput.nodes.DeliveryOrder,
        lookupAccess: true,
    })
], OutputMovement.prototype, "deliveryOrder", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DLOLIN',
        lookupAccess: true,
    })
], OutputMovement.prototype, "deliveryLineNumber", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SUBNUM',
        lookupAccess: true,
    })
], OutputMovement.prototype, "subWaveNumber", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PKONUM',
        columnType: 'string',
        node: () => sageWhOutput.nodes.PickingOrder,
        lookupAccess: true,
    })
], OutputMovement.prototype, "pickingOrder", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PKOSRT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], OutputMovement.prototype, "pickingOrderSorting", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'TYP',
        dataType: () => sageWhProductData.enums.doLineTypeDatatype,
        lookupAccess: true,
    })
], OutputMovement.prototype, "lineType", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ITM',
        columnType: 'string',
        node: () => sageWhProductData.nodes.Product,
        lookupAccess: true,
    })
], OutputMovement.prototype, "product", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CTRQTY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        lookupAccess: true,
    })
], OutputMovement.prototype, "numberOfContainers", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CTR',
        columnType: 'string',
        node: () => sageWhProductData.nodes.ProductContainer,
        lookupAccess: true,
    })
], OutputMovement.prototype, "container", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        columnName: 'HMGCOE',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        lookupAccess: true,
    })
], OutputMovement.prototype, "homogeneousContainerCoefficient", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CUQ',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        lookupAccess: true,
    })
], OutputMovement.prototype, "numberOfConsumptionUnit", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CUQKIT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        lookupAccess: true,
    })
], OutputMovement.prototype, "numberOfKit", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'MVT',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.MovementCode,
        lookupAccess: true,
    })
], OutputMovement.prototype, "movementCode", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'LOT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], OutputMovement.prototype, "lotNumber", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SKN',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.StockNature,
        lookupAccess: true,
    })
], OutputMovement.prototype, "stockStatus", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'RSA',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], OutputMovement.prototype, "reservationNumber", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SPT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], OutputMovement.prototype, "supportNumber", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        columnName: 'MVTSTA',
        dataType: () => sageWhProductData.enums.outputMovementStatusDatatype,
        lookupAccess: true,
    })
], OutputMovement.prototype, "status", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ITMORI',
        columnType: 'string',
        node: () => sageWhProductData.nodes.Origin,
        lookupAccess: true,
    })
], OutputMovement.prototype, "source", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'FIFDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
        lookupAccess: true,
    })
], OutputMovement.prototype, "fifoDate", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'MND',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
        lookupAccess: true,
    })
], OutputMovement.prototype, "manufacturedDate", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'RTD',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
        lookupAccess: true,
    })
], OutputMovement.prototype, "detentionDate", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SLD',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
        lookupAccess: true,
    })
], OutputMovement.prototype, "sellByDate", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SND',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
        lookupAccess: true,
    })
], OutputMovement.prototype, "shipByDate", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'USD',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
        lookupAccess: true,
    })
], OutputMovement.prototype, "useByDate", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PMD',
        columnType: 'string',
        node: () => sageWhProductData.nodes.PickingMode,
        lookupAccess: true,
    })
], OutputMovement.prototype, "pickingMode", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'STO',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.Store,
        lookupAccess: true,
    })
], OutputMovement.prototype, "store", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ADD',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.Location,
        lookupAccess: true,
    })
], OutputMovement.prototype, "location", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SLOTYP',
        dataType: () => sageWhMasterData.enums.locationTypeDatatype,
        lookupAccess: true,
    })
], OutputMovement.prototype, "locationType", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SKONUM',
        columnType: 'string',
        node: () => sageWhStockData.nodes.StockObject,
        lookupAccess: true,
    })
], OutputMovement.prototype, "stockObject", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CTRLIKNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], OutputMovement.prototype, "containerNumber", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'HMGCTR',
        columnType: 'string',
        node: () => sageWhProductData.nodes.ProductContainer,
        lookupAccess: true,
    })
], OutputMovement.prototype, "homogeneousContainer", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        columnName: 'HMGQTY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        lookupAccess: true,
    })
], OutputMovement.prototype, "homogeneousQuantity", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ORICTR',
        columnType: 'string',
        node: () => sageWhProductData.nodes.ProductContainer,
        lookupAccess: true,
    })
], OutputMovement.prototype, "originContainer", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ORIQTY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        lookupAccess: true,
    })
], OutputMovement.prototype, "sourceQuantity", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PRCNUM',
        columnType: 'string',
        node: () => sageWhOutput.nodes.Parcel,
        lookupAccess: true,
    })
], OutputMovement.prototype, "parcel", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SHPNUM',
        columnType: 'string',
        node: () => sageWhOutput.nodes.ShippingUnit,
        lookupAccess: true,
    })
], OutputMovement.prototype, "shippingUnit", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PRCSEQ',
        lookupAccess: true,
    })
], OutputMovement.prototype, "parcelSequence", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DLNNUM',
        columnType: 'string',
        node: () => sageWhOutput.nodes.DeliveryNote,
        lookupAccess: true,
    })
], OutputMovement.prototype, "deliveryNote", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'QYMNUM',
        columnType: 'string',
        filters: {
            lookup: {
                dockType: 'round',
            },
            control: {
                dockType: 'round',
            },
        },
        node: () => sageWhOutput.nodes.Round,
        lookupAccess: true,
    })
], OutputMovement.prototype, "round", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'QYMFCY',
        columnType: 'string',
        node: () => sageWhSystem.nodes.Site,
        lookupAccess: true,
    })
], OutputMovement.prototype, "roundSite", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CIRAIS',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], OutputMovement.prototype, "travelSequence", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ROWLVL',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], OutputMovement.prototype, "rowByLevel", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'TNSFLG',
        lookupAccess: true,
    })
], OutputMovement.prototype, "isInTransit", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DENFCY',
        columnType: 'string',
        node: () => sageWhSystem.nodes.Site,
        lookupAccess: true,
    })
], OutputMovement.prototype, "destinationSite", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'VLDOPE',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.Operand,
        lookupAccess: true,
    })
], OutputMovement.prototype, "validatingOperator", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'VLDUSR',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], OutputMovement.prototype, "validatingUser", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'VLDDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
        lookupAccess: true,
    })
], OutputMovement.prototype, "postingDate", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'VLDTIM',
        lookupAccess: true,
    })
], OutputMovement.prototype, "postingTime", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'GRUCOD',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], OutputMovement.prototype, "groupingCode", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CONDATENA',
        lookupAccess: true,
    })
], OutputMovement.prototype, "isContractDate", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        node: () => sageWhOutput.nodes.Parcel,
        isMutable: true,
        dependsOn: ['site', 'depositor', 'deliveryOrder', 'parcel'],
        lookupAccess: true,
    })
], OutputMovement.prototype, "parcels", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageWhOutput.nodes.OutputMovementContainerLevels,
    })
], OutputMovement.prototype, "containerLevels", void 0);
exports.OutputMovement = OutputMovement = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'OUTPUTM',
        keyPropertyNames: ['site', 'depositor', 'code'],
        indexes: [
            {
                orderBy: {
                    site: 1,
                    depositor: 1,
                    code: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], OutputMovement);
//# sourceMappingURL=output-movement.js.map