import * as sageWhMasterData from '@sage/wh-master-data';
import * as sageWhProductData from '@sage/wh-product-data';
import * as sageWhStockData from '@sage/wh-stock-data';
import * as sageWhSystem from '@sage/wh-system';
import { Node, Reference, integer, decimal, date, Collection } from '@sage/xtrem-core';
import * as sageWhOutput from '..';
export declare class OutputMovement extends Node {
    readonly site: Reference<sageWhSystem.nodes.Site>;
    readonly depositor: Reference<sageWhMasterData.nodes.Depositor>;
    readonly code: Promise<string>;
    readonly deliveryOrder: Reference<sageWhOutput.nodes.DeliveryOrder>;
    readonly deliveryLineNumber: Promise<integer>;
    readonly subWaveNumber: Promise<integer>;
    readonly pickingOrder: Reference<sageWhOutput.nodes.PickingOrder | null>;
    readonly pickingOrderSorting: Promise<string>;
    readonly lineType: Promise<sageWhProductData.enums.DoLineType | null>;
    readonly product: Reference<sageWhProductData.nodes.Product>;
    readonly numberOfContainers: Promise<decimal>;
    readonly container: Reference<sageWhProductData.nodes.ProductContainer>;
    readonly homogeneousContainerCoefficient: Promise<decimal>;
    readonly numberOfConsumptionUnit: Promise<decimal>;
    readonly numberOfKit: Promise<decimal | null>;
    readonly movementCode: Reference<sageWhMasterData.nodes.MovementCode>;
    readonly lotNumber: Promise<string>;
    readonly stockStatus: Reference<sageWhMasterData.nodes.StockNature | null>;
    readonly reservationNumber: Promise<string>;
    readonly supportNumber: Promise<string>;
    readonly status: Promise<sageWhProductData.enums.OutputMovementStatus>;
    readonly source: Reference<sageWhProductData.nodes.Origin | null>;
    readonly fifoDate: Promise<date | null>;
    readonly manufacturedDate: Promise<date | null>;
    readonly detentionDate: Promise<date | null>;
    readonly sellByDate: Promise<date | null>;
    readonly shipByDate: Promise<date | null>;
    readonly useByDate: Promise<date | null>;
    readonly pickingMode: Reference<sageWhProductData.nodes.PickingMode | null>;
    readonly store: Reference<sageWhMasterData.nodes.Store | null>;
    readonly location: Reference<sageWhMasterData.nodes.Location | null>;
    readonly locationType: Promise<sageWhMasterData.enums.LocationType | null>;
    readonly stockObject: Reference<sageWhStockData.nodes.StockObject | null>;
    readonly containerNumber: Promise<string>;
    readonly homogeneousContainer: Reference<sageWhProductData.nodes.ProductContainer>;
    readonly homogeneousQuantity: Promise<decimal>;
    readonly originContainer: Reference<sageWhProductData.nodes.ProductContainer>;
    readonly sourceQuantity: Promise<decimal>;
    readonly parcel: Reference<sageWhOutput.nodes.Parcel | null>;
    readonly shippingUnit: Reference<sageWhOutput.nodes.ShippingUnit | null>;
    readonly parcelSequence: Promise<integer | null>;
    readonly deliveryNote: Reference<sageWhOutput.nodes.DeliveryNote | null>;
    readonly round: Reference<sageWhOutput.nodes.Round | null>;
    readonly roundSite: Reference<sageWhSystem.nodes.Site | null>;
    readonly travelSequence: Promise<string>;
    readonly rowByLevel: Promise<string>;
    readonly isInTransit: Promise<boolean>;
    readonly destinationSite: Reference<sageWhSystem.nodes.Site | null>;
    readonly validatingOperator: Reference<sageWhMasterData.nodes.Operand | null>;
    readonly validatingUser: Promise<string>;
    readonly postingDate: Promise<date | null>;
    readonly postingTime: Promise<integer | null>;
    readonly groupingCode: Promise<string>;
    readonly isContractDate: Promise<boolean>;
    readonly parcels: Collection<sageWhOutput.nodes.Parcel>;
    readonly containerLevels: Collection<sageWhOutput.nodes.OutputMovementContainerLevels>;
}
//# sourceMappingURL=output-movement.d.ts.map