"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DeliveryOrder = void 0;
const sageWhMasterData = require("@sage/wh-master-data");
const sageWhProductData = require("@sage/wh-product-data");
const sageWhStructure = require("@sage/wh-structure");
const sageWhSystem = require("@sage/wh-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageWhOutput = require("..");
const joins = {
    referenceJoins: {
        site: {
            code: 'site',
        },
        depositor: {
            site: 'site',
            code: 'depositor',
        },
        movementCode: {
            site: 'site',
            code: 'movementCode',
        },
        pickingMode: {
            site: 'site',
            depositor: 'depositor',
            code: 'pickingMode',
        },
        originalDeliveryOrder: {
            site: 'site',
            depositor: 'depositor',
            code: 'originalDeliveryOrder',
        },
        shipTo: {
            site: 'site',
            code: 'shipTo',
        },
        shipToCountry: {
            code: 'shipToCountry',
        },
        deliveryNotePrintingReport: {
            reportName: 'deliveryNotePrintingReport',
        },
        printLanguage: {
            code: 'printLanguage',
        },
        round: {
            site: 'site',
            dockType() {
                return 'round';
            },
            code: 'round',
        },
        genericRound: {
            site: 'site',
            code: 'genericRound',
        },
        carrier: {
            site: 'site',
            code: 'carrier',
        },
        transportationMethod: {
            site: 'site',
            code: 'transportationMethod',
        },
        transportType: {
            site: 'site',
            code: 'transportType',
        },
        billToCustomer: {
            site: 'site',
            code: 'billToCustomer',
        },
        billToCountry: {
            code: 'billToCountry',
        },
        priceListCode: {
            site: 'site',
            code: 'priceListCode',
        },
        currency: {
            code: 'currency',
        },
        shippingUnitType: {
            site: 'site',
            code: 'shippingUnitType',
        },
    },
    collectionJoins: {
        lines: {
            site: 'site',
            depositor: 'depositor',
            deliveryOrder: 'code',
        },
    },
};
let DeliveryOrder = class DeliveryOrder extends xtrem_core_1.Node {
};
exports.DeliveryOrder = DeliveryOrder;
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'FCY',
        columnType: 'string',
        node: () => sageWhSystem.nodes.Site,
        lookupAccess: true,
    })
], DeliveryOrder.prototype, "site", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DEP',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.Depositor,
        lookupAccess: true,
    })
], DeliveryOrder.prototype, "depositor", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'DLONUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], DeliveryOrder.prototype, "code", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'REF',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], DeliveryOrder.prototype, "referenceNumber", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DOHSTA',
        dataType: () => sageWhMasterData.enums.doHeaderStatusDatatype,
        lookupAccess: true,
    })
], DeliveryOrder.prototype, "status", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'FLCSTA',
        lookupAccess: true,
    })
], DeliveryOrder.prototype, "isMergingOfFlows", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
        lookupAccess: true,
    })
], DeliveryOrder.prototype, "date", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        columnName: 'EXPLNCDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
        lookupAccess: true,
    })
], DeliveryOrder.prototype, "plannedLaunchDate", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'EXPLNCTIM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], DeliveryOrder.prototype, "plannedLaunchTime", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        columnName: 'EXPDLVDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
        lookupAccess: true,
    })
], DeliveryOrder.prototype, "expectedDeliveryDate", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'EXPDLVTIM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], DeliveryOrder.prototype, "expectedDeliveryTime", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ORDREF',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], DeliveryOrder.prototype, "orderReference", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ORDNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], DeliveryOrder.prototype, "orderNumber", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ORDDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
        lookupAccess: true,
    })
], DeliveryOrder.prototype, "orderDate", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ORDCLT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], DeliveryOrder.prototype, "soldTo", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CLTORDREF',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], DeliveryOrder.prototype, "customerReference", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'MVT',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.MovementCode,
        lookupAccess: true,
    })
], DeliveryOrder.prototype, "movementCode", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PMD',
        columnType: 'string',
        node: () => sageWhProductData.nodes.PickingMode,
        lookupAccess: true,
    })
], DeliveryOrder.prototype, "pickingMode", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PTLPIK',
        dataType: () => sageWhMasterData.enums.partialDeliveryAuthorizedDatatype,
        lookupAccess: true,
    })
], DeliveryOrder.prototype, "partialDelivery", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PIR',
        dataType: () => sageWhMasterData.enums.servicePriorityDatatype,
        lookupAccess: true,
    })
], DeliveryOrder.prototype, "servicePriority", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'URG',
        lookupAccess: true,
    })
], DeliveryOrder.prototype, "isUrgent", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DLOORG',
        columnType: 'string',
        node: () => sageWhOutput.nodes.DeliveryOrder,
        lookupAccess: true,
    })
], DeliveryOrder.prototype, "originalDeliveryOrder", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SPLNUM',
        lookupAccess: true,
    })
], DeliveryOrder.prototype, "splittingNumber", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SHRMGT',
        lookupAccess: true,
    })
], DeliveryOrder.prototype, "isOutputShortageManagement", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PKGMGT',
        dataType: () => sageWhProductData.enums.packingDatatype,
        lookupAccess: true,
    })
], DeliveryOrder.prototype, "isPacking", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PRCPLZ',
        lookupAccess: true,
    })
], DeliveryOrder.prototype, "isParcelPalletisation", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'LODCTL',
        lookupAccess: true,
    })
], DeliveryOrder.prototype, "isLoadingOfParcels", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DSPMGT',
        lookupAccess: true,
    })
], DeliveryOrder.prototype, "isShipmentManagement", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DLVCLT',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.Customer,
        lookupAccess: true,
    })
], DeliveryOrder.prototype, "shipTo", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'DLVPOS',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], DeliveryOrder.prototype, "shipToPostalCode", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'DLVCTY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], DeliveryOrder.prototype, "shipToCity", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DLVCRY',
        columnType: 'string',
        node: () => sageWhStructure.nodes.Country,
        lookupAccess: true,
    })
], DeliveryOrder.prototype, "shipToCountry", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DLVCRYNAM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], DeliveryOrder.prototype, "shipToCountryName", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DLVSAT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], DeliveryOrder.prototype, "shipToRegion", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DLVTEL',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], DeliveryOrder.prototype, "shipToTelephone", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DLVFAX',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], DeliveryOrder.prototype, "shipToFax", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DLVARE',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], DeliveryOrder.prototype, "deliveryArea", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DLNEDT',
        columnType: 'string',
        node: () => sageWhSystem.nodes.GenericPrintReport,
        lookupAccess: true,
    })
], DeliveryOrder.prototype, "deliveryNotePrintingReport", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'EDTLAN',
        columnType: 'string',
        node: () => sageWhSystem.nodes.Language,
        lookupAccess: true,
    })
], DeliveryOrder.prototype, "printLanguage", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DLVREM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], DeliveryOrder.prototype, "shipToCustomerNotes", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'QYMNUM',
        columnType: 'string',
        filters: {
            lookup: {
                dockType: 'round',
            },
            control: {
                dockType: 'round',
            },
        },
        node: () => sageWhOutput.nodes.Round,
        lookupAccess: true,
    })
], DeliveryOrder.prototype, "round", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'GDR',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.GenericRound,
        lookupAccess: true,
    })
], DeliveryOrder.prototype, "genericRound", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CRR',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.Carrier,
        lookupAccess: true,
    })
], DeliveryOrder.prototype, "carrier", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CRRMOD',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.TransportMode,
        lookupAccess: true,
    })
], DeliveryOrder.prototype, "transportationMethod", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CRRREF',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], DeliveryOrder.prototype, "carriageReference", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CGT',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.TransportType,
        lookupAccess: true,
    })
], DeliveryOrder.prototype, "transportType", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DRNPST',
        lookupAccess: true,
    })
], DeliveryOrder.prototype, "roundPosition", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'INVCLT',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.Customer,
        lookupAccess: true,
    })
], DeliveryOrder.prototype, "billToCustomer", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'INVCRY',
        columnType: 'string',
        node: () => sageWhStructure.nodes.Country,
        lookupAccess: true,
    })
], DeliveryOrder.prototype, "billToCountry", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'INVCRYNAM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], DeliveryOrder.prototype, "billToCountryName", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'INVCTY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], DeliveryOrder.prototype, "billToCity", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'INVPOS',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], DeliveryOrder.prototype, "billToPostalCode", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'INVSAT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], DeliveryOrder.prototype, "billToRegion", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'INVTEL',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], DeliveryOrder.prototype, "billToTelephone", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'INVFAX',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], DeliveryOrder.prototype, "billToFax", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'INVREM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], DeliveryOrder.prototype, "billToCustomerNotes", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LNCDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
        lookupAccess: true,
    })
], DeliveryOrder.prototype, "launchDate", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'LNCTIM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], DeliveryOrder.prototype, "launchTime", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PIKDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
        lookupAccess: true,
    })
], DeliveryOrder.prototype, "pickingDate", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PIKTIM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], DeliveryOrder.prototype, "pickingTime", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PKGDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
        lookupAccess: true,
    })
], DeliveryOrder.prototype, "packingDate", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PKGTIM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], DeliveryOrder.prototype, "packingTime", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SHPDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
        lookupAccess: true,
    })
], DeliveryOrder.prototype, "shipmentDate", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SHPTIM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], DeliveryOrder.prototype, "shipmentTime", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'TRM',
        dataType: () => sageWhProductData.enums.transmissionL3Datatype,
        lookupAccess: true,
    })
], DeliveryOrder.prototype, "transmittedFromL3", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DLNCST',
        lookupAccess: true,
    })
], DeliveryOrder.prototype, "isCarrierAmountCalculation", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DLNRAC',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.TariffCode,
        lookupAccess: true,
    })
], DeliveryOrder.prototype, "priceListCode", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DLNCUR',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.Currency,
        lookupAccess: true,
    })
], DeliveryOrder.prototype, "currency", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CDKLVLCTL',
        dataType: () => sageWhMasterData.enums.crossDockingBlockingLevelDatatype,
        lookupAccess: true,
    })
], DeliveryOrder.prototype, "crossDockingLevel", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CDKMGT',
        lookupAccess: true,
    })
], DeliveryOrder.prototype, "isCrossDockingManagement", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SSCFLG',
        lookupAccess: true,
    })
], DeliveryOrder.prototype, "isSsccManagementOnOutput", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SHPSNGDLO',
        lookupAccess: true,
    })
], DeliveryOrder.prototype, "isShippingUnitSingleDeliveryOrder", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SHPSNGDLV',
        lookupAccess: true,
    })
], DeliveryOrder.prototype, "isShippingUnitSingleCustomer", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SHU',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.ShippingUnitType,
        lookupAccess: true,
    })
], DeliveryOrder.prototype, "shippingUnitType", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'GRUSHP',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], DeliveryOrder.prototype, "shippingUnitGroup", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        node: () => sageWhOutput.nodes.DeliveryOrderLine,
        isMutable: true,
        dependsOn: ['site', 'depositor', 'code'],
        lookupAccess: true,
    })
], DeliveryOrder.prototype, "lines", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageWhOutput.nodes.DeliveryOrderBillToAddresses,
    })
], DeliveryOrder.prototype, "billToAddresses", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageWhOutput.nodes.DeliveryOrderBillToCompanyNames,
    })
], DeliveryOrder.prototype, "billToCompanyNames", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageWhOutput.nodes.DeliveryOrderShipToAddresses,
    })
], DeliveryOrder.prototype, "shipToAddresses", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageWhOutput.nodes.DeliveryOrderShipToCompanyNames,
    })
], DeliveryOrder.prototype, "shipToCompanyNames", void 0);
exports.DeliveryOrder = DeliveryOrder = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'DLVORDERH',
        keyPropertyNames: ['site', 'depositor', 'code'],
        indexes: [
            {
                orderBy: {
                    site: 1,
                    depositor: 1,
                    code: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], DeliveryOrder);
//# sourceMappingURL=delivery-order.js.map