import * as sageWhMasterData from '@sage/wh-master-data';
import * as sageWhProductData from '@sage/wh-product-data';
import * as sageWhStructure from '@sage/wh-structure';
import * as sageWhSystem from '@sage/wh-system';
import { Node, Reference, date, integer, Collection } from '@sage/xtrem-core';
import * as sageWhOutput from '..';
export declare class DeliveryOrder extends Node {
    readonly site: Reference<sageWhSystem.nodes.Site>;
    readonly depositor: Reference<sageWhMasterData.nodes.Depositor>;
    readonly code: Promise<string>;
    readonly referenceNumber: Promise<string>;
    readonly status: Promise<sageWhMasterData.enums.DoHeaderStatus | null>;
    readonly isMergingOfFlows: Promise<boolean>;
    readonly date: Promise<date>;
    readonly plannedLaunchDate: Promise<date>;
    readonly plannedLaunchTime: Promise<string>;
    readonly expectedDeliveryDate: Promise<date>;
    readonly expectedDeliveryTime: Promise<string>;
    readonly orderReference: Promise<string>;
    readonly orderNumber: Promise<string>;
    readonly orderDate: Promise<date | null>;
    readonly soldTo: Promise<string>;
    readonly customerReference: Promise<string>;
    readonly movementCode: Reference<sageWhMasterData.nodes.MovementCode>;
    readonly pickingMode: Reference<sageWhProductData.nodes.PickingMode>;
    readonly partialDelivery: Promise<sageWhMasterData.enums.PartialDeliveryAuthorized | null>;
    readonly servicePriority: Promise<sageWhMasterData.enums.ServicePriority | null>;
    readonly isUrgent: Promise<boolean>;
    readonly originalDeliveryOrder: Reference<sageWhOutput.nodes.DeliveryOrder | null>;
    readonly splittingNumber: Promise<integer | null>;
    readonly isOutputShortageManagement: Promise<boolean>;
    readonly isPacking: Promise<sageWhProductData.enums.Packing | null>;
    readonly isParcelPalletisation: Promise<boolean>;
    readonly isLoadingOfParcels: Promise<boolean>;
    readonly isShipmentManagement: Promise<boolean>;
    readonly shipTo: Reference<sageWhMasterData.nodes.Customer | null>;
    readonly shipToPostalCode: Promise<string>;
    readonly shipToCity: Promise<string>;
    readonly shipToCountry: Reference<sageWhStructure.nodes.Country | null>;
    readonly shipToCountryName: Promise<string>;
    readonly shipToRegion: Promise<string>;
    readonly shipToTelephone: Promise<string>;
    readonly shipToFax: Promise<string>;
    readonly deliveryArea: Promise<string>;
    readonly deliveryNotePrintingReport: Reference<sageWhSystem.nodes.GenericPrintReport>;
    readonly printLanguage: Reference<sageWhSystem.nodes.Language>;
    readonly shipToCustomerNotes: Promise<string>;
    readonly round: Reference<sageWhOutput.nodes.Round | null>;
    readonly genericRound: Reference<sageWhMasterData.nodes.GenericRound | null>;
    readonly carrier: Reference<sageWhMasterData.nodes.Carrier | null>;
    readonly transportationMethod: Reference<sageWhMasterData.nodes.TransportMode | null>;
    readonly carriageReference: Promise<string>;
    readonly transportType: Reference<sageWhMasterData.nodes.TransportType | null>;
    readonly roundPosition: Promise<integer | null>;
    readonly billToCustomer: Reference<sageWhMasterData.nodes.Customer | null>;
    readonly billToCountry: Reference<sageWhStructure.nodes.Country | null>;
    readonly billToCountryName: Promise<string>;
    readonly billToCity: Promise<string>;
    readonly billToPostalCode: Promise<string>;
    readonly billToRegion: Promise<string>;
    readonly billToTelephone: Promise<string>;
    readonly billToFax: Promise<string>;
    readonly billToCustomerNotes: Promise<string>;
    readonly launchDate: Promise<date | null>;
    readonly launchTime: Promise<string>;
    readonly pickingDate: Promise<date | null>;
    readonly pickingTime: Promise<string>;
    readonly packingDate: Promise<date | null>;
    readonly packingTime: Promise<string>;
    readonly shipmentDate: Promise<date | null>;
    readonly shipmentTime: Promise<string>;
    readonly transmittedFromL3: Promise<sageWhProductData.enums.TransmissionL3 | null>;
    readonly isCarrierAmountCalculation: Promise<boolean>;
    readonly priceListCode: Reference<sageWhMasterData.nodes.TariffCode | null>;
    readonly currency: Reference<sageWhMasterData.nodes.Currency | null>;
    readonly crossDockingLevel: Promise<sageWhMasterData.enums.CrossDockingBlockingLevel | null>;
    readonly isCrossDockingManagement: Promise<boolean>;
    readonly isSsccManagementOnOutput: Promise<boolean>;
    readonly isShippingUnitSingleDeliveryOrder: Promise<boolean>;
    readonly isShippingUnitSingleCustomer: Promise<boolean>;
    readonly shippingUnitType: Reference<sageWhMasterData.nodes.ShippingUnitType | null>;
    readonly shippingUnitGroup: Promise<string>;
    readonly lines: Collection<sageWhOutput.nodes.DeliveryOrderLine>;
    readonly billToAddresses: Collection<sageWhOutput.nodes.DeliveryOrderBillToAddresses>;
    readonly billToCompanyNames: Collection<sageWhOutput.nodes.DeliveryOrderBillToCompanyNames>;
    readonly shipToAddresses: Collection<sageWhOutput.nodes.DeliveryOrderShipToAddresses>;
    readonly shipToCompanyNames: Collection<sageWhOutput.nodes.DeliveryOrderShipToCompanyNames>;
}
//# sourceMappingURL=delivery-order.d.ts.map