import * as sageWhMasterData from '@sage/wh-master-data';
import * as sageWhProductData from '@sage/wh-product-data';
import * as sageWhSystem from '@sage/wh-system';
import { Node, Reference, integer, decimal, date, Collection } from '@sage/xtrem-core';
import * as sageWhOutput from '..';
export declare class DeliveryOrderLine extends Node {
    readonly site: Reference<sageWhSystem.nodes.Site>;
    readonly depositor: Reference<sageWhMasterData.nodes.Depositor>;
    readonly deliveryOrder: Reference<sageWhOutput.nodes.DeliveryOrder>;
    readonly lineNumber: Promise<integer>;
    readonly status: Promise<sageWhProductData.enums.DeliveryOrderLineStatus | null>;
    readonly pointer: Promise<integer | null>;
    readonly kitPointer: Promise<integer | null>;
    readonly referenceNumber: Promise<string>;
    readonly orderNumber: Promise<string>;
    readonly lineType: Promise<sageWhProductData.enums.DoLineType | null>;
    readonly numberOfKit: Promise<decimal | null>;
    readonly product: Reference<sageWhProductData.nodes.Product | null>;
    readonly quantityOfContainers: Promise<decimal | null>;
    readonly container: Reference<sageWhProductData.nodes.ProductContainer | null>;
    readonly numberOfConsumptionUnit: Promise<decimal | null>;
    readonly quantityTotalShipped: Promise<decimal | null>;
    readonly stockStatus: Reference<sageWhMasterData.nodes.StockNature | null>;
    readonly reservationNumber: Promise<string>;
    readonly lotNumber: Promise<string>;
    readonly isSingleLot: Promise<boolean>;
    readonly supportNumber: Promise<string>;
    readonly movementCode: Reference<sageWhMasterData.nodes.MovementCode | null>;
    readonly fifoDate: Promise<date | null>;
    readonly creationDate: Promise<date | null>;
    readonly launchedQuantity: Promise<decimal | null>;
    readonly shortageQuantity: Promise<decimal | null>;
    readonly preparedQuantity: Promise<decimal | null>;
    readonly shippedQuantity: Promise<decimal | null>;
    readonly voidedQuantity: Promise<decimal | null>;
    readonly transferredQuantity: Promise<decimal | null>;
    readonly notTransferredQuantity: Promise<decimal | null>;
    readonly postponedQuantity: Promise<decimal | null>;
    readonly crossDockingQuantity: Promise<decimal | null>;
    readonly isCrossDockingManagement: Promise<boolean>;
    readonly isDirectMovementNotAddressed: Promise<boolean>;
    readonly isExpectedInputUnderReceipt: Promise<boolean>;
    readonly comments: Promise<string>;
    readonly notes: Promise<string>;
    readonly launchDate: Promise<date | null>;
    readonly launchTime: Promise<string>;
    readonly waitingToShipDate: Promise<date | null>;
    readonly waitingToShipTime: Promise<string>;
    readonly shipmentDate: Promise<date | null>;
    readonly shipmentTime: Promise<string>;
    readonly parcelRange: Reference<sageWhMasterData.nodes.RangeOfParcel | null>;
    readonly groupOfParcel: Promise<string>;
    readonly maximumLevelDispatchInState: Promise<sageWhMasterData.enums.ContainerLevel | null>;
    readonly isContractDate: Promise<boolean>;
    readonly outputMovements: Collection<sageWhOutput.nodes.OutputMovement>;
}
//# sourceMappingURL=delivery-order-line.d.ts.map