import * as sageWhMasterData from '@sage/wh-master-data';
import * as sageWhProductData from '@sage/wh-product-data';
import * as sageWhStructure from '@sage/wh-structure';
import * as sageWhSystem from '@sage/wh-system';
import { Node, Reference, date, decimal, integer, Collection } from '@sage/xtrem-core';
import * as sageWhOutput from '..';
export declare class DeliveryNote extends Node {
    readonly site: Reference<sageWhSystem.nodes.Site>;
    readonly depositor: Reference<sageWhMasterData.nodes.Depositor>;
    readonly code: Promise<string>;
    readonly creationDate: Promise<date>;
    readonly creationTime: Promise<string>;
    readonly isFinalDeliveryNote: Promise<boolean>;
    readonly isUpdateDeliveryNote: Promise<boolean>;
    readonly deliveryOrder: Reference<sageWhOutput.nodes.DeliveryOrder>;
    readonly reference: Promise<string>;
    readonly orderReference: Promise<string>;
    readonly orderNumber: Promise<string>;
    readonly orderDate: Promise<date | null>;
    readonly soldToCustomer: Promise<string>;
    readonly customerReference: Promise<string>;
    readonly pickingMode: Reference<sageWhProductData.nodes.PickingMode>;
    readonly movementCode: Reference<sageWhMasterData.nodes.MovementCode>;
    readonly partialDeliveryManagement: Promise<sageWhMasterData.enums.PartialDeliveryAuthorized | null>;
    readonly expectedDeliveryDate: Promise<date>;
    readonly expectedDeliveryTime: Promise<string>;
    readonly shipmentDate: Promise<date | null>;
    readonly shipmentTime: Promise<string>;
    readonly shipmentSite: Reference<sageWhSystem.nodes.Site | null>;
    readonly round: Reference<sageWhOutput.nodes.Round | null>;
    readonly carriageReceipt: Reference<sageWhOutput.nodes.CarriageReceipt | null>;
    readonly carrier: Reference<sageWhMasterData.nodes.Carrier | null>;
    readonly transportationMethod: Reference<sageWhMasterData.nodes.TransportMode | null>;
    readonly carriageReference: Promise<string>;
    readonly freightCharge: Promise<decimal | null>;
    readonly currency: Reference<sageWhMasterData.nodes.Currency | null>;
    readonly roundPosition: Promise<integer | null>;
    readonly genericRound: Reference<sageWhMasterData.nodes.GenericRound | null>;
    readonly transportType: Reference<sageWhMasterData.nodes.TransportType | null>;
    readonly deliveryArea: Promise<string>;
    readonly preparationArea: Reference<sageWhMasterData.nodes.PreparationArea>;
    readonly shipToCustomer: Reference<sageWhMasterData.nodes.Customer | null>;
    readonly shipToPostalCode: Promise<string>;
    readonly shipToCity: Promise<string>;
    readonly shipToCountry: Reference<sageWhStructure.nodes.Country | null>;
    readonly shipToCountryName: Promise<string>;
    readonly shipToRegion: Promise<string>;
    readonly shipToTelephone: Promise<string>;
    readonly shipToFax: Promise<string>;
    readonly shipToNotes: Promise<string>;
    readonly billToCustomer: Reference<sageWhMasterData.nodes.Customer | null>;
    readonly billToPostalCode: Promise<string>;
    readonly billToCity: Promise<string>;
    readonly billToCountry: Reference<sageWhStructure.nodes.Country | null>;
    readonly billToCountryName: Promise<string>;
    readonly billToRegion: Promise<string>;
    readonly billToTelephone: Promise<string>;
    readonly billToFax: Promise<string>;
    readonly billToNotes: Promise<string>;
    readonly numberOfParcels: Promise<integer | null>;
    readonly numberOfShippingUnit: Promise<integer | null>;
    readonly weight: Promise<decimal | null>;
    readonly volume: Promise<decimal | null>;
    readonly linearMeters: Promise<decimal | null>;
    readonly numberOfDeliveryOrderLines: Promise<integer | null>;
    readonly deliveryNotePrintingReport: Reference<sageWhSystem.nodes.GenericPrintReport>;
    readonly printLanguage: Reference<sageWhSystem.nodes.Language>;
    readonly ediManagementStatus: Promise<sageWhProductData.enums.EdiMngtStatus | null>;
    readonly numberOfParcelsWithoutMessage: Promise<integer | null>;
    readonly ediManagementLevel: Promise<sageWhProductData.enums.EdiLevel | null>;
    readonly queryNumber: Promise<integer | null>;
    readonly billToAddresses: Collection<sageWhOutput.nodes.DeliveryNoteBillToAddresses>;
    readonly billToCompanyNames: Collection<sageWhOutput.nodes.DeliveryNoteBillToCompanyNames>;
    readonly numberOfDispatchableParcels: Collection<sageWhOutput.nodes.DeliveryNoteNumberOfDispatchableParcels>;
    readonly shipToAddresses: Collection<sageWhOutput.nodes.DeliveryNoteShipToAddresses>;
    readonly shipToCompanyNames: Collection<sageWhOutput.nodes.DeliveryNoteShipToCompanyNames>;
}
//# sourceMappingURL=delivery-note.d.ts.map