import * as sageWhMasterData from '@sage/wh-master-data';
import * as sageWhStructure from '@sage/wh-structure';
import * as sageWhSystem from '@sage/wh-system';
import { Node, Reference, date, decimal, integer, Collection } from '@sage/xtrem-core';
import * as sageWhOutput from '..';
export declare class CarriageReceipt extends Node {
    readonly site: Reference<sageWhSystem.nodes.Site>;
    readonly code: Promise<string>;
    readonly deliveryNote: Reference<sageWhOutput.nodes.CarriageNote>;
    readonly round: Reference<sageWhOutput.nodes.Round>;
    readonly shipmentDate: Promise<date>;
    readonly shipmentTime: Promise<string>;
    readonly linearMeters: Promise<decimal | null>;
    readonly truckPlacard: Promise<string>;
    readonly sealNumber: Promise<string>;
    readonly weight: Promise<decimal | null>;
    readonly volume: Promise<decimal | null>;
    readonly numberOfParcels: Promise<integer | null>;
    readonly numberOfShippingUnits: Promise<integer | null>;
    readonly numberOfDeliveryNotes: Promise<integer | null>;
    readonly shipToCustomer: Reference<sageWhMasterData.nodes.Customer | null>;
    readonly shipToPostalCode: Promise<string>;
    readonly shipToCity: Promise<string>;
    readonly shipToCountry: Reference<sageWhStructure.nodes.Country | null>;
    readonly shipToCountryName: Promise<string>;
    readonly shipToRegion: Promise<string>;
    readonly deliveryArea: Promise<string>;
    readonly freightCharge: Promise<decimal | null>;
    readonly currency: Reference<sageWhMasterData.nodes.Currency | null>;
    readonly dockType: Promise<sageWhMasterData.enums.DockManagement>;
    readonly shipToCompanyNames: Collection<sageWhOutput.nodes.CarriageReceiptShipToCompanyNames>;
    readonly shiptToAddresses: Collection<sageWhOutput.nodes.CarriageReceiptShiptToAddresses>;
}
//# sourceMappingURL=carriage-receipt.d.ts.map