import * as sageWhMasterData from '@sage/wh-master-data';
import * as sageWhSystem from '@sage/wh-system';
import { Node, Reference, date, decimal, integer } from '@sage/xtrem-core';
import * as sageWhOutput from '..';
export declare class CarriageNote extends Node {
    readonly site: Reference<sageWhSystem.nodes.Site>;
    readonly code: Promise<string>;
    readonly round: Reference<sageWhOutput.nodes.Round>;
    readonly shipmentDate: Promise<date>;
    readonly shipmentTime: Promise<string>;
    readonly linearMeters: Promise<decimal | null>;
    readonly truckPlacard: Promise<string>;
    readonly sealNumber: Promise<string>;
    readonly numberOfCarriageReceipts: Promise<integer | null>;
    readonly numberOfDeliveryNotes: Promise<integer | null>;
    readonly weight: Promise<decimal | null>;
    readonly volume: Promise<decimal | null>;
    readonly numberOfParcels: Promise<integer | null>;
    readonly numberOfShippingUnits: Promise<integer | null>;
    readonly freightCharge: Promise<decimal | null>;
    readonly currency: Reference<sageWhMasterData.nodes.Currency | null>;
    readonly dockType: Promise<sageWhMasterData.enums.DockManagement>;
}
//# sourceMappingURL=carriage-note.d.ts.map