declare module '@sage/wh-output-api-partial' {
    import type {
        AppointmentManagement,
        AssignmentClass,
        Carrier,
        Currency,
        Customer,
        Depositor,
        GenericRound,
        Location,
        LocationInput,
        LocationSplitAddresses,
        LocationSplitAddressesBinding,
        LocationSplitAddressesInput,
        MovementCode,
        Operand,
        Package as SageWhMasterData$Package,
        ParcelType,
        PreparationArea,
        RangeOfParcel,
        RotationClass,
        SerialGroup,
        ShippingUnitType,
        StockNature,
        StorageType,
        Store,
        TariffCode,
        TransportMode,
        TransportType,
    } from '@sage/wh-master-data-api';
    import type {
        Container,
        Origin,
        Package as SageWhProductData$Package,
        PickingMode,
        Product,
        ProductContainer,
    } from '@sage/wh-product-data-api';
    import type { Package as SageWhStockData$Package, SerialNumberInput, StockObject } from '@sage/wh-stock-data-api';
    import type { Country, Package as SageWhStructure$Package } from '@sage/wh-structure-api';
    import type { GenericPrintReport, Language, Package as SageWhSystem$Package, Site } from '@sage/wh-system-api';
    import type { Package as SageXtremAppMetadata$Package } from '@sage/xtrem-app-metadata-api';
    import type { Package as SageXtremX3SystemUtils$Package, SysUser } from '@sage/xtrem-x3-system-utils-api';
    import type {
        AggregateQueryOperation,
        AggregateReadOperation,
        ClientCollection,
        ClientNode,
        ClientNodeInput,
        GetDefaultsOperation,
        QueryOperation,
        ReadOperation,
        VitalClientNode,
        VitalClientNodeInput,
        decimal,
        integer,
    } from '@sage/xtrem-client';
    export interface AutoPalletizationOrder extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        depositor: Depositor;
        code: string;
        status: AutoPalletizationStatus;
        deliveryOrder: DeliveryOrder;
        numberOfShippingUnits: integer;
        numberOfParcels: integer;
        date: string;
        time: string;
        preparationArea: PreparationArea;
        validatingOperator: Operand;
        postingDate: string;
        postingTime: integer;
        validatingUser: string;
    }
    export interface AutoPalletizationOrderInput extends ClientNodeInput {
        site?: string;
        depositor?: string;
        code?: string;
        status?: AutoPalletizationStatus;
        deliveryOrder?: string;
        numberOfShippingUnits?: integer | string;
        numberOfParcels?: integer | string;
        date?: string;
        time?: string;
        preparationArea?: string;
        validatingOperator?: string;
        postingDate?: string;
        postingTime?: integer | string;
        validatingUser?: string;
    }
    export interface AutoPalletizationOrderBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        depositor: Depositor;
        code: string;
        status: AutoPalletizationStatus;
        deliveryOrder: DeliveryOrder;
        numberOfShippingUnits: integer;
        numberOfParcels: integer;
        date: string;
        time: string;
        preparationArea: PreparationArea;
        validatingOperator: Operand;
        postingDate: string;
        postingTime: integer;
        validatingUser: string;
    }
    export interface AutoPalletizationOrder$Lookups {
        site: QueryOperation<Site>;
        depositor: QueryOperation<Depositor>;
        deliveryOrder: QueryOperation<DeliveryOrder>;
        preparationArea: QueryOperation<PreparationArea>;
        validatingOperator: QueryOperation<Operand>;
    }
    export interface AutoPalletizationOrder$Operations {
        query: QueryOperation<AutoPalletizationOrder>;
        read: ReadOperation<AutoPalletizationOrder>;
        aggregate: {
            read: AggregateReadOperation<AutoPalletizationOrder>;
            query: AggregateQueryOperation<AutoPalletizationOrder>;
        };
        lookups(dataOrId: string | { data: AutoPalletizationOrderInput }): AutoPalletizationOrder$Lookups;
        getDefaults: GetDefaultsOperation<AutoPalletizationOrder>;
    }
    export interface CarriageNote extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        code: string;
        round: Round;
        shipmentDate: string;
        shipmentTime: string;
        linearMeters: string;
        truckPlacard: string;
        sealNumber: string;
        numberOfCarriageReceipts: integer;
        numberOfDeliveryNotes: integer;
        weight: string;
        volume: string;
        numberOfParcels: integer;
        numberOfShippingUnits: integer;
        freightCharge: string;
        currency: Currency;
        dockType: DockManagement;
    }
    export interface CarriageNoteInput extends ClientNodeInput {
        site?: string;
        code?: string;
        round?: string;
        shipmentDate?: string;
        shipmentTime?: string;
        linearMeters?: decimal | string;
        truckPlacard?: string;
        sealNumber?: string;
        numberOfCarriageReceipts?: integer | string;
        numberOfDeliveryNotes?: integer | string;
        weight?: decimal | string;
        volume?: decimal | string;
        numberOfParcels?: integer | string;
        numberOfShippingUnits?: integer | string;
        freightCharge?: decimal | string;
        currency?: string;
        dockType?: DockManagement;
    }
    export interface CarriageNoteBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        code: string;
        round: Round;
        shipmentDate: string;
        shipmentTime: string;
        linearMeters: string;
        truckPlacard: string;
        sealNumber: string;
        numberOfCarriageReceipts: integer;
        numberOfDeliveryNotes: integer;
        weight: string;
        volume: string;
        numberOfParcels: integer;
        numberOfShippingUnits: integer;
        freightCharge: string;
        currency: Currency;
        dockType: DockManagement;
    }
    export interface CarriageNote$Lookups {
        site: QueryOperation<Site>;
        round: QueryOperation<Round>;
        currency: QueryOperation<Currency>;
    }
    export interface CarriageNote$Operations {
        query: QueryOperation<CarriageNote>;
        read: ReadOperation<CarriageNote>;
        aggregate: {
            read: AggregateReadOperation<CarriageNote>;
            query: AggregateQueryOperation<CarriageNote>;
        };
        lookups(dataOrId: string | { data: CarriageNoteInput }): CarriageNote$Lookups;
        getDefaults: GetDefaultsOperation<CarriageNote>;
    }
    export interface CarriageReceiptShipToCompanyNames extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        code: string;
        shipToCompanyName: string;
    }
    export interface CarriageReceiptShipToCompanyNamesInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        site?: string;
        code?: string;
        shipToCompanyName?: string;
    }
    export interface CarriageReceiptShipToCompanyNamesBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        code: string;
        shipToCompanyName: string;
    }
    export interface CarriageReceiptShipToCompanyNames$Operations {
        query: QueryOperation<CarriageReceiptShipToCompanyNames>;
        read: ReadOperation<CarriageReceiptShipToCompanyNames>;
        aggregate: {
            read: AggregateReadOperation<CarriageReceiptShipToCompanyNames>;
            query: AggregateQueryOperation<CarriageReceiptShipToCompanyNames>;
        };
        getDefaults: GetDefaultsOperation<CarriageReceiptShipToCompanyNames>;
    }
    export interface CarriageReceiptShiptToAddresses extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        code: string;
        shiptToAddress: string;
    }
    export interface CarriageReceiptShiptToAddressesInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        site?: string;
        code?: string;
        shiptToAddress?: string;
    }
    export interface CarriageReceiptShiptToAddressesBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        code: string;
        shiptToAddress: string;
    }
    export interface CarriageReceiptShiptToAddresses$Operations {
        query: QueryOperation<CarriageReceiptShiptToAddresses>;
        read: ReadOperation<CarriageReceiptShiptToAddresses>;
        aggregate: {
            read: AggregateReadOperation<CarriageReceiptShiptToAddresses>;
            query: AggregateQueryOperation<CarriageReceiptShiptToAddresses>;
        };
        getDefaults: GetDefaultsOperation<CarriageReceiptShiptToAddresses>;
    }
    export interface CarriageReceipt extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        code: string;
        deliveryNote: CarriageNote;
        round: Round;
        shipmentDate: string;
        shipmentTime: string;
        linearMeters: string;
        truckPlacard: string;
        sealNumber: string;
        weight: string;
        volume: string;
        numberOfParcels: integer;
        numberOfShippingUnits: integer;
        numberOfDeliveryNotes: integer;
        shipToCustomer: Customer;
        shipToPostalCode: string;
        shipToCity: string;
        shipToCountry: Country;
        shipToCountryName: string;
        shipToRegion: string;
        deliveryArea: string;
        freightCharge: string;
        currency: Currency;
        dockType: DockManagement;
        shipToCompanyNames: ClientCollection<CarriageReceiptShipToCompanyNames>;
        shiptToAddresses: ClientCollection<CarriageReceiptShiptToAddresses>;
    }
    export interface CarriageReceiptInput extends ClientNodeInput {
        site?: string;
        code?: string;
        deliveryNote?: string;
        round?: string;
        shipmentDate?: string;
        shipmentTime?: string;
        linearMeters?: decimal | string;
        truckPlacard?: string;
        sealNumber?: string;
        weight?: decimal | string;
        volume?: decimal | string;
        numberOfParcels?: integer | string;
        numberOfShippingUnits?: integer | string;
        numberOfDeliveryNotes?: integer | string;
        shipToCustomer?: string;
        shipToPostalCode?: string;
        shipToCity?: string;
        shipToCountry?: string;
        shipToCountryName?: string;
        shipToRegion?: string;
        deliveryArea?: string;
        freightCharge?: decimal | string;
        currency?: string;
        dockType?: DockManagement;
        shipToCompanyNames?: Partial<CarriageReceiptShipToCompanyNamesInput>[];
        shiptToAddresses?: Partial<CarriageReceiptShiptToAddressesInput>[];
    }
    export interface CarriageReceiptBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        code: string;
        deliveryNote: CarriageNote;
        round: Round;
        shipmentDate: string;
        shipmentTime: string;
        linearMeters: string;
        truckPlacard: string;
        sealNumber: string;
        weight: string;
        volume: string;
        numberOfParcels: integer;
        numberOfShippingUnits: integer;
        numberOfDeliveryNotes: integer;
        shipToCustomer: Customer;
        shipToPostalCode: string;
        shipToCity: string;
        shipToCountry: Country;
        shipToCountryName: string;
        shipToRegion: string;
        deliveryArea: string;
        freightCharge: string;
        currency: Currency;
        dockType: DockManagement;
        shipToCompanyNames: ClientCollection<CarriageReceiptShipToCompanyNamesBinding>;
        shiptToAddresses: ClientCollection<CarriageReceiptShiptToAddressesBinding>;
    }
    export interface CarriageReceipt$Lookups {
        site: QueryOperation<Site>;
        deliveryNote: QueryOperation<CarriageNote>;
        round: QueryOperation<Round>;
        shipToCustomer: QueryOperation<Customer>;
        shipToCountry: QueryOperation<Country>;
        currency: QueryOperation<Currency>;
    }
    export interface CarriageReceipt$Operations {
        query: QueryOperation<CarriageReceipt>;
        read: ReadOperation<CarriageReceipt>;
        aggregate: {
            read: AggregateReadOperation<CarriageReceipt>;
            query: AggregateQueryOperation<CarriageReceipt>;
        };
        lookups(dataOrId: string | { data: CarriageReceiptInput }): CarriageReceipt$Lookups;
        getDefaults: GetDefaultsOperation<CarriageReceipt>;
    }
    export interface DeliveryNoteBillToAddresses extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        depositor: string;
        code: string;
        billToAddress: string;
    }
    export interface DeliveryNoteBillToAddressesInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        site?: string;
        depositor?: string;
        code?: string;
        billToAddress?: string;
    }
    export interface DeliveryNoteBillToAddressesBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        depositor: string;
        code: string;
        billToAddress: string;
    }
    export interface DeliveryNoteBillToAddresses$Operations {
        query: QueryOperation<DeliveryNoteBillToAddresses>;
        read: ReadOperation<DeliveryNoteBillToAddresses>;
        aggregate: {
            read: AggregateReadOperation<DeliveryNoteBillToAddresses>;
            query: AggregateQueryOperation<DeliveryNoteBillToAddresses>;
        };
        getDefaults: GetDefaultsOperation<DeliveryNoteBillToAddresses>;
    }
    export interface DeliveryNoteBillToCompanyNames extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        depositor: string;
        code: string;
        billToCompanyName: string;
    }
    export interface DeliveryNoteBillToCompanyNamesInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        site?: string;
        depositor?: string;
        code?: string;
        billToCompanyName?: string;
    }
    export interface DeliveryNoteBillToCompanyNamesBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        depositor: string;
        code: string;
        billToCompanyName: string;
    }
    export interface DeliveryNoteBillToCompanyNames$Operations {
        query: QueryOperation<DeliveryNoteBillToCompanyNames>;
        read: ReadOperation<DeliveryNoteBillToCompanyNames>;
        aggregate: {
            read: AggregateReadOperation<DeliveryNoteBillToCompanyNames>;
            query: AggregateQueryOperation<DeliveryNoteBillToCompanyNames>;
        };
        getDefaults: GetDefaultsOperation<DeliveryNoteBillToCompanyNames>;
    }
    export interface DeliveryNoteNumberOfDispatchableParcels extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        depositor: string;
        code: string;
        numberOfDispatchableParcel: integer;
    }
    export interface DeliveryNoteNumberOfDispatchableParcelsInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        site?: string;
        depositor?: string;
        code?: string;
        numberOfDispatchableParcel?: integer | string;
    }
    export interface DeliveryNoteNumberOfDispatchableParcelsBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        depositor: string;
        code: string;
        numberOfDispatchableParcel: integer;
    }
    export interface DeliveryNoteNumberOfDispatchableParcels$Operations {
        query: QueryOperation<DeliveryNoteNumberOfDispatchableParcels>;
        read: ReadOperation<DeliveryNoteNumberOfDispatchableParcels>;
        aggregate: {
            read: AggregateReadOperation<DeliveryNoteNumberOfDispatchableParcels>;
            query: AggregateQueryOperation<DeliveryNoteNumberOfDispatchableParcels>;
        };
        getDefaults: GetDefaultsOperation<DeliveryNoteNumberOfDispatchableParcels>;
    }
    export interface DeliveryNoteShipToAddresses extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        depositor: string;
        code: string;
        shipToAddress: string;
    }
    export interface DeliveryNoteShipToAddressesInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        site?: string;
        depositor?: string;
        code?: string;
        shipToAddress?: string;
    }
    export interface DeliveryNoteShipToAddressesBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        depositor: string;
        code: string;
        shipToAddress: string;
    }
    export interface DeliveryNoteShipToAddresses$Operations {
        query: QueryOperation<DeliveryNoteShipToAddresses>;
        read: ReadOperation<DeliveryNoteShipToAddresses>;
        aggregate: {
            read: AggregateReadOperation<DeliveryNoteShipToAddresses>;
            query: AggregateQueryOperation<DeliveryNoteShipToAddresses>;
        };
        getDefaults: GetDefaultsOperation<DeliveryNoteShipToAddresses>;
    }
    export interface DeliveryNoteShipToCompanyNames extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        depositor: string;
        code: string;
        shipToCompanyName: string;
    }
    export interface DeliveryNoteShipToCompanyNamesInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        site?: string;
        depositor?: string;
        code?: string;
        shipToCompanyName?: string;
    }
    export interface DeliveryNoteShipToCompanyNamesBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        depositor: string;
        code: string;
        shipToCompanyName: string;
    }
    export interface DeliveryNoteShipToCompanyNames$Operations {
        query: QueryOperation<DeliveryNoteShipToCompanyNames>;
        read: ReadOperation<DeliveryNoteShipToCompanyNames>;
        aggregate: {
            read: AggregateReadOperation<DeliveryNoteShipToCompanyNames>;
            query: AggregateQueryOperation<DeliveryNoteShipToCompanyNames>;
        };
        getDefaults: GetDefaultsOperation<DeliveryNoteShipToCompanyNames>;
    }
    export interface DeliveryNote extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        depositor: Depositor;
        code: string;
        creationDate: string;
        creationTime: string;
        isFinalDeliveryNote: boolean;
        isUpdateDeliveryNote: boolean;
        deliveryOrder: DeliveryOrder;
        reference: string;
        orderReference: string;
        orderNumber: string;
        orderDate: string;
        soldToCustomer: string;
        customerReference: string;
        pickingMode: PickingMode;
        movementCode: MovementCode;
        partialDeliveryManagement: PartialDeliveryAuthorized;
        expectedDeliveryDate: string;
        expectedDeliveryTime: string;
        shipmentDate: string;
        shipmentTime: string;
        shipmentSite: Site;
        round: Round;
        carriageReceipt: CarriageReceipt;
        carrier: Carrier;
        transportationMethod: TransportMode;
        carriageReference: string;
        freightCharge: string;
        currency: Currency;
        roundPosition: integer;
        genericRound: GenericRound;
        transportType: TransportType;
        deliveryArea: string;
        preparationArea: PreparationArea;
        shipToCustomer: Customer;
        shipToPostalCode: string;
        shipToCity: string;
        shipToCountry: Country;
        shipToCountryName: string;
        shipToRegion: string;
        shipToTelephone: string;
        shipToFax: string;
        shipToNotes: string;
        billToCustomer: Customer;
        billToPostalCode: string;
        billToCity: string;
        billToCountry: Country;
        billToCountryName: string;
        billToRegion: string;
        billToTelephone: string;
        billToFax: string;
        billToNotes: string;
        numberOfParcels: integer;
        numberOfShippingUnit: integer;
        weight: string;
        volume: string;
        linearMeters: string;
        numberOfDeliveryOrderLines: integer;
        deliveryNotePrintingReport: GenericPrintReport;
        printLanguage: Language;
        ediManagementStatus: EdiMngtStatus;
        numberOfParcelsWithoutMessage: integer;
        ediManagementLevel: EdiLevel;
        queryNumber: integer;
        billToAddresses: ClientCollection<DeliveryNoteBillToAddresses>;
        billToCompanyNames: ClientCollection<DeliveryNoteBillToCompanyNames>;
        numberOfDispatchableParcels: ClientCollection<DeliveryNoteNumberOfDispatchableParcels>;
        shipToAddresses: ClientCollection<DeliveryNoteShipToAddresses>;
        shipToCompanyNames: ClientCollection<DeliveryNoteShipToCompanyNames>;
    }
    export interface DeliveryNoteInput extends ClientNodeInput {
        site?: string;
        depositor?: string;
        code?: string;
        creationDate?: string;
        creationTime?: string;
        isFinalDeliveryNote?: boolean | string;
        isUpdateDeliveryNote?: boolean | string;
        deliveryOrder?: string;
        reference?: string;
        orderReference?: string;
        orderNumber?: string;
        orderDate?: string;
        soldToCustomer?: string;
        customerReference?: string;
        pickingMode?: string;
        movementCode?: string;
        partialDeliveryManagement?: PartialDeliveryAuthorized;
        expectedDeliveryDate?: string;
        expectedDeliveryTime?: string;
        shipmentDate?: string;
        shipmentTime?: string;
        shipmentSite?: string;
        round?: string;
        carriageReceipt?: string;
        carrier?: string;
        transportationMethod?: string;
        carriageReference?: string;
        freightCharge?: decimal | string;
        currency?: string;
        roundPosition?: integer | string;
        genericRound?: string;
        transportType?: string;
        deliveryArea?: string;
        preparationArea?: string;
        shipToCustomer?: string;
        shipToPostalCode?: string;
        shipToCity?: string;
        shipToCountry?: string;
        shipToCountryName?: string;
        shipToRegion?: string;
        shipToTelephone?: string;
        shipToFax?: string;
        shipToNotes?: string;
        billToCustomer?: string;
        billToPostalCode?: string;
        billToCity?: string;
        billToCountry?: string;
        billToCountryName?: string;
        billToRegion?: string;
        billToTelephone?: string;
        billToFax?: string;
        billToNotes?: string;
        numberOfParcels?: integer | string;
        numberOfShippingUnit?: integer | string;
        weight?: decimal | string;
        volume?: decimal | string;
        linearMeters?: decimal | string;
        numberOfDeliveryOrderLines?: integer | string;
        deliveryNotePrintingReport?: string;
        printLanguage?: string;
        ediManagementStatus?: EdiMngtStatus;
        numberOfParcelsWithoutMessage?: integer | string;
        ediManagementLevel?: EdiLevel;
        queryNumber?: integer | string;
        billToAddresses?: Partial<DeliveryNoteBillToAddressesInput>[];
        billToCompanyNames?: Partial<DeliveryNoteBillToCompanyNamesInput>[];
        numberOfDispatchableParcels?: Partial<DeliveryNoteNumberOfDispatchableParcelsInput>[];
        shipToAddresses?: Partial<DeliveryNoteShipToAddressesInput>[];
        shipToCompanyNames?: Partial<DeliveryNoteShipToCompanyNamesInput>[];
    }
    export interface DeliveryNoteBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        depositor: Depositor;
        code: string;
        creationDate: string;
        creationTime: string;
        isFinalDeliveryNote: boolean;
        isUpdateDeliveryNote: boolean;
        deliveryOrder: DeliveryOrder;
        reference: string;
        orderReference: string;
        orderNumber: string;
        orderDate: string;
        soldToCustomer: string;
        customerReference: string;
        pickingMode: PickingMode;
        movementCode: MovementCode;
        partialDeliveryManagement: PartialDeliveryAuthorized;
        expectedDeliveryDate: string;
        expectedDeliveryTime: string;
        shipmentDate: string;
        shipmentTime: string;
        shipmentSite: Site;
        round: Round;
        carriageReceipt: CarriageReceipt;
        carrier: Carrier;
        transportationMethod: TransportMode;
        carriageReference: string;
        freightCharge: string;
        currency: Currency;
        roundPosition: integer;
        genericRound: GenericRound;
        transportType: TransportType;
        deliveryArea: string;
        preparationArea: PreparationArea;
        shipToCustomer: Customer;
        shipToPostalCode: string;
        shipToCity: string;
        shipToCountry: Country;
        shipToCountryName: string;
        shipToRegion: string;
        shipToTelephone: string;
        shipToFax: string;
        shipToNotes: string;
        billToCustomer: Customer;
        billToPostalCode: string;
        billToCity: string;
        billToCountry: Country;
        billToCountryName: string;
        billToRegion: string;
        billToTelephone: string;
        billToFax: string;
        billToNotes: string;
        numberOfParcels: integer;
        numberOfShippingUnit: integer;
        weight: string;
        volume: string;
        linearMeters: string;
        numberOfDeliveryOrderLines: integer;
        deliveryNotePrintingReport: GenericPrintReport;
        printLanguage: Language;
        ediManagementStatus: EdiMngtStatus;
        numberOfParcelsWithoutMessage: integer;
        ediManagementLevel: EdiLevel;
        queryNumber: integer;
        billToAddresses: ClientCollection<DeliveryNoteBillToAddressesBinding>;
        billToCompanyNames: ClientCollection<DeliveryNoteBillToCompanyNamesBinding>;
        numberOfDispatchableParcels: ClientCollection<DeliveryNoteNumberOfDispatchableParcelsBinding>;
        shipToAddresses: ClientCollection<DeliveryNoteShipToAddressesBinding>;
        shipToCompanyNames: ClientCollection<DeliveryNoteShipToCompanyNamesBinding>;
    }
    export interface DeliveryNote$Lookups {
        site: QueryOperation<Site>;
        depositor: QueryOperation<Depositor>;
        deliveryOrder: QueryOperation<DeliveryOrder>;
        pickingMode: QueryOperation<PickingMode>;
        movementCode: QueryOperation<MovementCode>;
        shipmentSite: QueryOperation<Site>;
        round: QueryOperation<Round>;
        carriageReceipt: QueryOperation<CarriageReceipt>;
        carrier: QueryOperation<Carrier>;
        transportationMethod: QueryOperation<TransportMode>;
        currency: QueryOperation<Currency>;
        genericRound: QueryOperation<GenericRound>;
        transportType: QueryOperation<TransportType>;
        preparationArea: QueryOperation<PreparationArea>;
        shipToCustomer: QueryOperation<Customer>;
        shipToCountry: QueryOperation<Country>;
        billToCustomer: QueryOperation<Customer>;
        billToCountry: QueryOperation<Country>;
        deliveryNotePrintingReport: QueryOperation<GenericPrintReport>;
        printLanguage: QueryOperation<Language>;
    }
    export interface DeliveryNote$Operations {
        query: QueryOperation<DeliveryNote>;
        read: ReadOperation<DeliveryNote>;
        aggregate: {
            read: AggregateReadOperation<DeliveryNote>;
            query: AggregateQueryOperation<DeliveryNote>;
        };
        lookups(dataOrId: string | { data: DeliveryNoteInput }): DeliveryNote$Lookups;
        getDefaults: GetDefaultsOperation<DeliveryNote>;
    }
    export interface DeliveryOrderBillToAddresses extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        depositor: string;
        code: string;
        billToAddress: string;
    }
    export interface DeliveryOrderBillToAddressesInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        site?: string;
        depositor?: string;
        code?: string;
        billToAddress?: string;
    }
    export interface DeliveryOrderBillToAddressesBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        depositor: string;
        code: string;
        billToAddress: string;
    }
    export interface DeliveryOrderBillToAddresses$Operations {
        query: QueryOperation<DeliveryOrderBillToAddresses>;
        read: ReadOperation<DeliveryOrderBillToAddresses>;
        aggregate: {
            read: AggregateReadOperation<DeliveryOrderBillToAddresses>;
            query: AggregateQueryOperation<DeliveryOrderBillToAddresses>;
        };
        getDefaults: GetDefaultsOperation<DeliveryOrderBillToAddresses>;
    }
    export interface DeliveryOrderBillToCompanyNames extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        depositor: string;
        code: string;
        billToCompanyName: string;
    }
    export interface DeliveryOrderBillToCompanyNamesInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        site?: string;
        depositor?: string;
        code?: string;
        billToCompanyName?: string;
    }
    export interface DeliveryOrderBillToCompanyNamesBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        depositor: string;
        code: string;
        billToCompanyName: string;
    }
    export interface DeliveryOrderBillToCompanyNames$Operations {
        query: QueryOperation<DeliveryOrderBillToCompanyNames>;
        read: ReadOperation<DeliveryOrderBillToCompanyNames>;
        aggregate: {
            read: AggregateReadOperation<DeliveryOrderBillToCompanyNames>;
            query: AggregateQueryOperation<DeliveryOrderBillToCompanyNames>;
        };
        getDefaults: GetDefaultsOperation<DeliveryOrderBillToCompanyNames>;
    }
    export interface DeliveryOrderLine extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        depositor: Depositor;
        deliveryOrder: DeliveryOrder;
        lineNumber: integer;
        status: DeliveryOrderLineStatus;
        pointer: integer;
        kitPointer: integer;
        referenceNumber: string;
        orderNumber: string;
        lineType: DoLineType;
        numberOfKit: string;
        product: Product;
        quantityOfContainers: string;
        container: ProductContainer;
        numberOfConsumptionUnit: string;
        quantityTotalShipped: string;
        stockStatus: StockNature;
        reservationNumber: string;
        lotNumber: string;
        isSingleLot: boolean;
        supportNumber: string;
        movementCode: MovementCode;
        fifoDate: string;
        creationDate: string;
        launchedQuantity: string;
        shortageQuantity: string;
        preparedQuantity: string;
        shippedQuantity: string;
        voidedQuantity: string;
        transferredQuantity: string;
        notTransferredQuantity: string;
        postponedQuantity: string;
        crossDockingQuantity: string;
        isCrossDockingManagement: boolean;
        isDirectMovementNotAddressed: boolean;
        isExpectedInputUnderReceipt: boolean;
        comments: string;
        notes: string;
        launchDate: string;
        launchTime: string;
        waitingToShipDate: string;
        waitingToShipTime: string;
        shipmentDate: string;
        shipmentTime: string;
        parcelRange: RangeOfParcel;
        groupOfParcel: string;
        maximumLevelDispatchInState: ContainerLevel;
        isContractDate: boolean;
        outputMovements: ClientCollection<OutputMovement>;
    }
    export interface DeliveryOrderLineInput extends ClientNodeInput {
        site?: string;
        depositor?: string;
        deliveryOrder?: string;
        lineNumber?: integer | string;
        status?: DeliveryOrderLineStatus;
        pointer?: integer | string;
        kitPointer?: integer | string;
        referenceNumber?: string;
        orderNumber?: string;
        lineType?: DoLineType;
        numberOfKit?: decimal | string;
        product?: string;
        quantityOfContainers?: decimal | string;
        container?: string;
        numberOfConsumptionUnit?: decimal | string;
        quantityTotalShipped?: decimal | string;
        stockStatus?: string;
        reservationNumber?: string;
        lotNumber?: string;
        isSingleLot?: boolean | string;
        supportNumber?: string;
        movementCode?: string;
        fifoDate?: string;
        creationDate?: string;
        launchedQuantity?: decimal | string;
        shortageQuantity?: decimal | string;
        preparedQuantity?: decimal | string;
        shippedQuantity?: decimal | string;
        voidedQuantity?: decimal | string;
        transferredQuantity?: decimal | string;
        notTransferredQuantity?: decimal | string;
        postponedQuantity?: decimal | string;
        crossDockingQuantity?: decimal | string;
        isCrossDockingManagement?: boolean | string;
        isDirectMovementNotAddressed?: boolean | string;
        isExpectedInputUnderReceipt?: boolean | string;
        comments?: string;
        notes?: string;
        launchDate?: string;
        launchTime?: string;
        waitingToShipDate?: string;
        waitingToShipTime?: string;
        shipmentDate?: string;
        shipmentTime?: string;
        parcelRange?: string;
        groupOfParcel?: string;
        maximumLevelDispatchInState?: ContainerLevel;
        isContractDate?: boolean | string;
        outputMovements?: Partial<OutputMovementInput>[];
    }
    export interface DeliveryOrderLineBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        depositor: Depositor;
        deliveryOrder: DeliveryOrder;
        lineNumber: integer;
        status: DeliveryOrderLineStatus;
        pointer: integer;
        kitPointer: integer;
        referenceNumber: string;
        orderNumber: string;
        lineType: DoLineType;
        numberOfKit: string;
        product: Product;
        quantityOfContainers: string;
        container: ProductContainer;
        numberOfConsumptionUnit: string;
        quantityTotalShipped: string;
        stockStatus: StockNature;
        reservationNumber: string;
        lotNumber: string;
        isSingleLot: boolean;
        supportNumber: string;
        movementCode: MovementCode;
        fifoDate: string;
        creationDate: string;
        launchedQuantity: string;
        shortageQuantity: string;
        preparedQuantity: string;
        shippedQuantity: string;
        voidedQuantity: string;
        transferredQuantity: string;
        notTransferredQuantity: string;
        postponedQuantity: string;
        crossDockingQuantity: string;
        isCrossDockingManagement: boolean;
        isDirectMovementNotAddressed: boolean;
        isExpectedInputUnderReceipt: boolean;
        comments: string;
        notes: string;
        launchDate: string;
        launchTime: string;
        waitingToShipDate: string;
        waitingToShipTime: string;
        shipmentDate: string;
        shipmentTime: string;
        parcelRange: RangeOfParcel;
        groupOfParcel: string;
        maximumLevelDispatchInState: ContainerLevel;
        isContractDate: boolean;
        outputMovements: ClientCollection<OutputMovement>;
    }
    export interface DeliveryOrderLine$Lookups {
        site: QueryOperation<Site>;
        depositor: QueryOperation<Depositor>;
        deliveryOrder: QueryOperation<DeliveryOrder>;
        product: QueryOperation<Product>;
        container: QueryOperation<ProductContainer>;
        stockStatus: QueryOperation<StockNature>;
        movementCode: QueryOperation<MovementCode>;
        parcelRange: QueryOperation<RangeOfParcel>;
    }
    export interface DeliveryOrderLine$Operations {
        query: QueryOperation<DeliveryOrderLine>;
        read: ReadOperation<DeliveryOrderLine>;
        aggregate: {
            read: AggregateReadOperation<DeliveryOrderLine>;
            query: AggregateQueryOperation<DeliveryOrderLine>;
        };
        lookups(dataOrId: string | { data: DeliveryOrderLineInput }): DeliveryOrderLine$Lookups;
        getDefaults: GetDefaultsOperation<DeliveryOrderLine>;
    }
    export interface DeliveryOrderShipToAddresses extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        depositor: string;
        code: string;
        shipToAddress: string;
    }
    export interface DeliveryOrderShipToAddressesInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        site?: string;
        depositor?: string;
        code?: string;
        shipToAddress?: string;
    }
    export interface DeliveryOrderShipToAddressesBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        depositor: string;
        code: string;
        shipToAddress: string;
    }
    export interface DeliveryOrderShipToAddresses$Operations {
        query: QueryOperation<DeliveryOrderShipToAddresses>;
        read: ReadOperation<DeliveryOrderShipToAddresses>;
        aggregate: {
            read: AggregateReadOperation<DeliveryOrderShipToAddresses>;
            query: AggregateQueryOperation<DeliveryOrderShipToAddresses>;
        };
        getDefaults: GetDefaultsOperation<DeliveryOrderShipToAddresses>;
    }
    export interface DeliveryOrderShipToCompanyNames extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        depositor: string;
        code: string;
        shipToCompanyName: string;
    }
    export interface DeliveryOrderShipToCompanyNamesInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        site?: string;
        depositor?: string;
        code?: string;
        shipToCompanyName?: string;
    }
    export interface DeliveryOrderShipToCompanyNamesBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        depositor: string;
        code: string;
        shipToCompanyName: string;
    }
    export interface DeliveryOrderShipToCompanyNames$Operations {
        query: QueryOperation<DeliveryOrderShipToCompanyNames>;
        read: ReadOperation<DeliveryOrderShipToCompanyNames>;
        aggregate: {
            read: AggregateReadOperation<DeliveryOrderShipToCompanyNames>;
            query: AggregateQueryOperation<DeliveryOrderShipToCompanyNames>;
        };
        getDefaults: GetDefaultsOperation<DeliveryOrderShipToCompanyNames>;
    }
    export interface DeliveryOrder extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        depositor: Depositor;
        code: string;
        referenceNumber: string;
        status: DoHeaderStatus;
        isMergingOfFlows: boolean;
        date: string;
        plannedLaunchDate: string;
        plannedLaunchTime: string;
        expectedDeliveryDate: string;
        expectedDeliveryTime: string;
        orderReference: string;
        orderNumber: string;
        orderDate: string;
        soldTo: string;
        customerReference: string;
        movementCode: MovementCode;
        pickingMode: PickingMode;
        partialDelivery: PartialDeliveryAuthorized;
        servicePriority: ServicePriority;
        isUrgent: boolean;
        originalDeliveryOrder: DeliveryOrder;
        splittingNumber: integer;
        isOutputShortageManagement: boolean;
        isPacking: Packing;
        isParcelPalletisation: boolean;
        isLoadingOfParcels: boolean;
        isShipmentManagement: boolean;
        shipTo: Customer;
        shipToPostalCode: string;
        shipToCity: string;
        shipToCountry: Country;
        shipToCountryName: string;
        shipToRegion: string;
        shipToTelephone: string;
        shipToFax: string;
        deliveryArea: string;
        deliveryNotePrintingReport: GenericPrintReport;
        printLanguage: Language;
        shipToCustomerNotes: string;
        round: Round;
        genericRound: GenericRound;
        carrier: Carrier;
        transportationMethod: TransportMode;
        carriageReference: string;
        transportType: TransportType;
        roundPosition: integer;
        billToCustomer: Customer;
        billToCountry: Country;
        billToCountryName: string;
        billToCity: string;
        billToPostalCode: string;
        billToRegion: string;
        billToTelephone: string;
        billToFax: string;
        billToCustomerNotes: string;
        launchDate: string;
        launchTime: string;
        pickingDate: string;
        pickingTime: string;
        packingDate: string;
        packingTime: string;
        shipmentDate: string;
        shipmentTime: string;
        transmittedFromL3: TransmissionL3;
        isCarrierAmountCalculation: boolean;
        priceListCode: TariffCode;
        currency: Currency;
        crossDockingLevel: CrossDockingBlockingLevel;
        isCrossDockingManagement: boolean;
        isSsccManagementOnOutput: boolean;
        isShippingUnitSingleDeliveryOrder: boolean;
        isShippingUnitSingleCustomer: boolean;
        shippingUnitType: ShippingUnitType;
        shippingUnitGroup: string;
        lines: ClientCollection<DeliveryOrderLine>;
        billToAddresses: ClientCollection<DeliveryOrderBillToAddresses>;
        billToCompanyNames: ClientCollection<DeliveryOrderBillToCompanyNames>;
        shipToAddresses: ClientCollection<DeliveryOrderShipToAddresses>;
        shipToCompanyNames: ClientCollection<DeliveryOrderShipToCompanyNames>;
    }
    export interface DeliveryOrderInput extends ClientNodeInput {
        site?: string;
        depositor?: string;
        code?: string;
        referenceNumber?: string;
        status?: DoHeaderStatus;
        isMergingOfFlows?: boolean | string;
        date?: string;
        plannedLaunchDate?: string;
        plannedLaunchTime?: string;
        expectedDeliveryDate?: string;
        expectedDeliveryTime?: string;
        orderReference?: string;
        orderNumber?: string;
        orderDate?: string;
        soldTo?: string;
        customerReference?: string;
        movementCode?: string;
        pickingMode?: string;
        partialDelivery?: PartialDeliveryAuthorized;
        servicePriority?: ServicePriority;
        isUrgent?: boolean | string;
        originalDeliveryOrder?: string;
        splittingNumber?: integer | string;
        isOutputShortageManagement?: boolean | string;
        isPacking?: Packing;
        isParcelPalletisation?: boolean | string;
        isLoadingOfParcels?: boolean | string;
        isShipmentManagement?: boolean | string;
        shipTo?: string;
        shipToPostalCode?: string;
        shipToCity?: string;
        shipToCountry?: string;
        shipToCountryName?: string;
        shipToRegion?: string;
        shipToTelephone?: string;
        shipToFax?: string;
        deliveryArea?: string;
        deliveryNotePrintingReport?: string;
        printLanguage?: string;
        shipToCustomerNotes?: string;
        round?: string;
        genericRound?: string;
        carrier?: string;
        transportationMethod?: string;
        carriageReference?: string;
        transportType?: string;
        roundPosition?: integer | string;
        billToCustomer?: string;
        billToCountry?: string;
        billToCountryName?: string;
        billToCity?: string;
        billToPostalCode?: string;
        billToRegion?: string;
        billToTelephone?: string;
        billToFax?: string;
        billToCustomerNotes?: string;
        launchDate?: string;
        launchTime?: string;
        pickingDate?: string;
        pickingTime?: string;
        packingDate?: string;
        packingTime?: string;
        shipmentDate?: string;
        shipmentTime?: string;
        transmittedFromL3?: TransmissionL3;
        isCarrierAmountCalculation?: boolean | string;
        priceListCode?: string;
        currency?: string;
        crossDockingLevel?: CrossDockingBlockingLevel;
        isCrossDockingManagement?: boolean | string;
        isSsccManagementOnOutput?: boolean | string;
        isShippingUnitSingleDeliveryOrder?: boolean | string;
        isShippingUnitSingleCustomer?: boolean | string;
        shippingUnitType?: string;
        shippingUnitGroup?: string;
        lines?: Partial<DeliveryOrderLineInput>[];
        billToAddresses?: Partial<DeliveryOrderBillToAddressesInput>[];
        billToCompanyNames?: Partial<DeliveryOrderBillToCompanyNamesInput>[];
        shipToAddresses?: Partial<DeliveryOrderShipToAddressesInput>[];
        shipToCompanyNames?: Partial<DeliveryOrderShipToCompanyNamesInput>[];
    }
    export interface DeliveryOrderBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        depositor: Depositor;
        code: string;
        referenceNumber: string;
        status: DoHeaderStatus;
        isMergingOfFlows: boolean;
        date: string;
        plannedLaunchDate: string;
        plannedLaunchTime: string;
        expectedDeliveryDate: string;
        expectedDeliveryTime: string;
        orderReference: string;
        orderNumber: string;
        orderDate: string;
        soldTo: string;
        customerReference: string;
        movementCode: MovementCode;
        pickingMode: PickingMode;
        partialDelivery: PartialDeliveryAuthorized;
        servicePriority: ServicePriority;
        isUrgent: boolean;
        originalDeliveryOrder: DeliveryOrder;
        splittingNumber: integer;
        isOutputShortageManagement: boolean;
        isPacking: Packing;
        isParcelPalletisation: boolean;
        isLoadingOfParcels: boolean;
        isShipmentManagement: boolean;
        shipTo: Customer;
        shipToPostalCode: string;
        shipToCity: string;
        shipToCountry: Country;
        shipToCountryName: string;
        shipToRegion: string;
        shipToTelephone: string;
        shipToFax: string;
        deliveryArea: string;
        deliveryNotePrintingReport: GenericPrintReport;
        printLanguage: Language;
        shipToCustomerNotes: string;
        round: Round;
        genericRound: GenericRound;
        carrier: Carrier;
        transportationMethod: TransportMode;
        carriageReference: string;
        transportType: TransportType;
        roundPosition: integer;
        billToCustomer: Customer;
        billToCountry: Country;
        billToCountryName: string;
        billToCity: string;
        billToPostalCode: string;
        billToRegion: string;
        billToTelephone: string;
        billToFax: string;
        billToCustomerNotes: string;
        launchDate: string;
        launchTime: string;
        pickingDate: string;
        pickingTime: string;
        packingDate: string;
        packingTime: string;
        shipmentDate: string;
        shipmentTime: string;
        transmittedFromL3: TransmissionL3;
        isCarrierAmountCalculation: boolean;
        priceListCode: TariffCode;
        currency: Currency;
        crossDockingLevel: CrossDockingBlockingLevel;
        isCrossDockingManagement: boolean;
        isSsccManagementOnOutput: boolean;
        isShippingUnitSingleDeliveryOrder: boolean;
        isShippingUnitSingleCustomer: boolean;
        shippingUnitType: ShippingUnitType;
        shippingUnitGroup: string;
        lines: ClientCollection<DeliveryOrderLine>;
        billToAddresses: ClientCollection<DeliveryOrderBillToAddressesBinding>;
        billToCompanyNames: ClientCollection<DeliveryOrderBillToCompanyNamesBinding>;
        shipToAddresses: ClientCollection<DeliveryOrderShipToAddressesBinding>;
        shipToCompanyNames: ClientCollection<DeliveryOrderShipToCompanyNamesBinding>;
    }
    export interface DeliveryOrder$Lookups {
        site: QueryOperation<Site>;
        depositor: QueryOperation<Depositor>;
        movementCode: QueryOperation<MovementCode>;
        pickingMode: QueryOperation<PickingMode>;
        originalDeliveryOrder: QueryOperation<DeliveryOrder>;
        shipTo: QueryOperation<Customer>;
        shipToCountry: QueryOperation<Country>;
        deliveryNotePrintingReport: QueryOperation<GenericPrintReport>;
        printLanguage: QueryOperation<Language>;
        round: QueryOperation<Round>;
        genericRound: QueryOperation<GenericRound>;
        carrier: QueryOperation<Carrier>;
        transportationMethod: QueryOperation<TransportMode>;
        transportType: QueryOperation<TransportType>;
        billToCustomer: QueryOperation<Customer>;
        billToCountry: QueryOperation<Country>;
        priceListCode: QueryOperation<TariffCode>;
        currency: QueryOperation<Currency>;
        shippingUnitType: QueryOperation<ShippingUnitType>;
    }
    export interface DeliveryOrder$Operations {
        query: QueryOperation<DeliveryOrder>;
        read: ReadOperation<DeliveryOrder>;
        aggregate: {
            read: AggregateReadOperation<DeliveryOrder>;
            query: AggregateQueryOperation<DeliveryOrder>;
        };
        lookups(dataOrId: string | { data: DeliveryOrderInput }): DeliveryOrder$Lookups;
        getDefaults: GetDefaultsOperation<DeliveryOrder>;
    }
    export interface OutputMovementContainerLevels extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        depositor: string;
        code: string;
        containerLevel: ProductContainer;
        quantityOfConsumptionUnitPerLevel: string;
    }
    export interface OutputMovementContainerLevelsInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        site?: string;
        depositor?: string;
        code?: string;
        containerLevel?: string;
        quantityOfConsumptionUnitPerLevel?: decimal | string;
    }
    export interface OutputMovementContainerLevelsBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        depositor: string;
        code: string;
        containerLevel: ProductContainer;
        quantityOfConsumptionUnitPerLevel: string;
    }
    export interface OutputMovementContainerLevels$Lookups {
        containerLevel: QueryOperation<ProductContainer>;
    }
    export interface OutputMovementContainerLevels$Operations {
        query: QueryOperation<OutputMovementContainerLevels>;
        read: ReadOperation<OutputMovementContainerLevels>;
        aggregate: {
            read: AggregateReadOperation<OutputMovementContainerLevels>;
            query: AggregateQueryOperation<OutputMovementContainerLevels>;
        };
        lookups(dataOrId: string | { data: OutputMovementContainerLevelsInput }): OutputMovementContainerLevels$Lookups;
        getDefaults: GetDefaultsOperation<OutputMovementContainerLevels>;
    }
    export interface OutputMovement extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        depositor: Depositor;
        code: string;
        deliveryOrder: DeliveryOrder;
        deliveryLineNumber: integer;
        subWaveNumber: integer;
        pickingOrder: PickingOrder;
        pickingOrderSorting: string;
        lineType: DoLineType;
        product: Product;
        numberOfContainers: string;
        container: ProductContainer;
        homogeneousContainerCoefficient: string;
        numberOfConsumptionUnit: string;
        numberOfKit: string;
        movementCode: MovementCode;
        lotNumber: string;
        stockStatus: StockNature;
        reservationNumber: string;
        supportNumber: string;
        status: OutputMovementStatus;
        source: Origin;
        fifoDate: string;
        manufacturedDate: string;
        detentionDate: string;
        sellByDate: string;
        shipByDate: string;
        useByDate: string;
        pickingMode: PickingMode;
        store: Store;
        location: Location;
        locationType: LocationType;
        stockObject: StockObject;
        containerNumber: string;
        homogeneousContainer: ProductContainer;
        homogeneousQuantity: string;
        originContainer: ProductContainer;
        sourceQuantity: string;
        parcel: Parcel;
        shippingUnit: ShippingUnit;
        parcelSequence: integer;
        deliveryNote: DeliveryNote;
        round: Round;
        roundSite: Site;
        travelSequence: string;
        rowByLevel: string;
        isInTransit: boolean;
        destinationSite: Site;
        validatingOperator: Operand;
        validatingUser: string;
        postingDate: string;
        postingTime: integer;
        groupingCode: string;
        isContractDate: boolean;
        parcels: ClientCollection<Parcel>;
        containerLevels: ClientCollection<OutputMovementContainerLevels>;
    }
    export interface OutputMovementInput extends ClientNodeInput {
        site?: string;
        depositor?: string;
        code?: string;
        deliveryOrder?: string;
        deliveryLineNumber?: integer | string;
        subWaveNumber?: integer | string;
        pickingOrder?: string;
        pickingOrderSorting?: string;
        lineType?: DoLineType;
        product?: string;
        numberOfContainers?: decimal | string;
        container?: string;
        homogeneousContainerCoefficient?: decimal | string;
        numberOfConsumptionUnit?: decimal | string;
        numberOfKit?: decimal | string;
        movementCode?: string;
        lotNumber?: string;
        stockStatus?: string;
        reservationNumber?: string;
        supportNumber?: string;
        status?: OutputMovementStatus;
        source?: string;
        fifoDate?: string;
        manufacturedDate?: string;
        detentionDate?: string;
        sellByDate?: string;
        shipByDate?: string;
        useByDate?: string;
        pickingMode?: string;
        store?: string;
        location?: string;
        locationType?: LocationType;
        stockObject?: string;
        containerNumber?: string;
        homogeneousContainer?: string;
        homogeneousQuantity?: decimal | string;
        originContainer?: string;
        sourceQuantity?: decimal | string;
        parcel?: string;
        shippingUnit?: string;
        parcelSequence?: integer | string;
        deliveryNote?: string;
        round?: string;
        roundSite?: string;
        travelSequence?: string;
        rowByLevel?: string;
        isInTransit?: boolean | string;
        destinationSite?: string;
        validatingOperator?: string;
        validatingUser?: string;
        postingDate?: string;
        postingTime?: integer | string;
        groupingCode?: string;
        isContractDate?: boolean | string;
        parcels?: Partial<ParcelInput>[];
        containerLevels?: Partial<OutputMovementContainerLevelsInput>[];
    }
    export interface OutputMovementBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        depositor: Depositor;
        code: string;
        deliveryOrder: DeliveryOrder;
        deliveryLineNumber: integer;
        subWaveNumber: integer;
        pickingOrder: PickingOrder;
        pickingOrderSorting: string;
        lineType: DoLineType;
        product: Product;
        numberOfContainers: string;
        container: ProductContainer;
        homogeneousContainerCoefficient: string;
        numberOfConsumptionUnit: string;
        numberOfKit: string;
        movementCode: MovementCode;
        lotNumber: string;
        stockStatus: StockNature;
        reservationNumber: string;
        supportNumber: string;
        status: OutputMovementStatus;
        source: Origin;
        fifoDate: string;
        manufacturedDate: string;
        detentionDate: string;
        sellByDate: string;
        shipByDate: string;
        useByDate: string;
        pickingMode: PickingMode;
        store: Store;
        location: Location;
        locationType: LocationType;
        stockObject: StockObject;
        containerNumber: string;
        homogeneousContainer: ProductContainer;
        homogeneousQuantity: string;
        originContainer: ProductContainer;
        sourceQuantity: string;
        parcel: Parcel;
        shippingUnit: ShippingUnit;
        parcelSequence: integer;
        deliveryNote: DeliveryNote;
        round: Round;
        roundSite: Site;
        travelSequence: string;
        rowByLevel: string;
        isInTransit: boolean;
        destinationSite: Site;
        validatingOperator: Operand;
        validatingUser: string;
        postingDate: string;
        postingTime: integer;
        groupingCode: string;
        isContractDate: boolean;
        parcels: ClientCollection<Parcel>;
        containerLevels: ClientCollection<OutputMovementContainerLevelsBinding>;
    }
    export interface OutputMovement$Lookups {
        site: QueryOperation<Site>;
        depositor: QueryOperation<Depositor>;
        deliveryOrder: QueryOperation<DeliveryOrder>;
        pickingOrder: QueryOperation<PickingOrder>;
        product: QueryOperation<Product>;
        container: QueryOperation<ProductContainer>;
        movementCode: QueryOperation<MovementCode>;
        stockStatus: QueryOperation<StockNature>;
        source: QueryOperation<Origin>;
        pickingMode: QueryOperation<PickingMode>;
        store: QueryOperation<Store>;
        location: QueryOperation<Location>;
        stockObject: QueryOperation<StockObject>;
        homogeneousContainer: QueryOperation<ProductContainer>;
        originContainer: QueryOperation<ProductContainer>;
        parcel: QueryOperation<Parcel>;
        shippingUnit: QueryOperation<ShippingUnit>;
        deliveryNote: QueryOperation<DeliveryNote>;
        round: QueryOperation<Round>;
        roundSite: QueryOperation<Site>;
        destinationSite: QueryOperation<Site>;
        validatingOperator: QueryOperation<Operand>;
    }
    export interface OutputMovement$Operations {
        query: QueryOperation<OutputMovement>;
        read: ReadOperation<OutputMovement>;
        aggregate: {
            read: AggregateReadOperation<OutputMovement>;
            query: AggregateQueryOperation<OutputMovement>;
        };
        lookups(dataOrId: string | { data: OutputMovementInput }): OutputMovement$Lookups;
        getDefaults: GetDefaultsOperation<OutputMovement>;
    }
    export interface Parcel extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        depositor: Depositor;
        code: string;
        deliveryOrder: DeliveryOrder;
        pickingOrder: PickingOrder;
        palletisationOrder: AutoPalletizationOrder;
        status: ParcelStatus;
        preparationArea: PreparationArea;
        pickingMode: PickingMode;
        parcelRange: RangeOfParcel;
        parcelType: ParcelType;
        height: string;
        width: string;
        depth: string;
        volume: string;
        estimatedWeight: string;
        realWeight: string;
        isDispatchableInState: boolean;
        isPalettizableAsIs: boolean;
        carrierParcelNumber: string;
        carrier: Carrier;
        transportationMethod: TransportMode;
        deliveryNote: DeliveryNote;
        shippingUnit: ShippingUnit;
        isPostponed: boolean;
        validatingOperator: Operand;
        validatingUser: string;
        postingDate: string;
        postingTime: integer;
        pickingOrderSorting: string;
        ssccParcelCode: string;
        dockStore: Store;
        dockAddress: Location;
        originDockStore: Store;
        originDockAddress: Location;
        stockOnDockStatus: Colis;
        isStockOnDockControl: boolean;
        pickingOrderType: PoType;
        shippingUnits: ClientCollection<ShippingUnit>;
        outputMovements: ClientCollection<OutputMovement>;
    }
    export interface ParcelInput extends ClientNodeInput {
        site?: string;
        depositor?: string;
        code?: string;
        deliveryOrder?: string;
        pickingOrder?: string;
        palletisationOrder?: string;
        status?: ParcelStatus;
        preparationArea?: string;
        pickingMode?: string;
        parcelRange?: string;
        parcelType?: string;
        height?: decimal | string;
        width?: decimal | string;
        depth?: decimal | string;
        volume?: decimal | string;
        estimatedWeight?: decimal | string;
        realWeight?: decimal | string;
        isDispatchableInState?: boolean | string;
        isPalettizableAsIs?: boolean | string;
        carrierParcelNumber?: string;
        carrier?: string;
        transportationMethod?: string;
        deliveryNote?: string;
        shippingUnit?: string;
        isPostponed?: boolean | string;
        validatingOperator?: string;
        validatingUser?: string;
        postingDate?: string;
        postingTime?: integer | string;
        pickingOrderSorting?: string;
        ssccParcelCode?: string;
        dockStore?: string;
        dockAddress?: string;
        originDockStore?: string;
        originDockAddress?: string;
        stockOnDockStatus?: Colis;
        isStockOnDockControl?: boolean | string;
        pickingOrderType?: PoType;
        shippingUnits?: Partial<ShippingUnitInput>[];
        outputMovements?: Partial<OutputMovementInput>[];
    }
    export interface ParcelBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        depositor: Depositor;
        code: string;
        deliveryOrder: DeliveryOrder;
        pickingOrder: PickingOrder;
        palletisationOrder: AutoPalletizationOrder;
        status: ParcelStatus;
        preparationArea: PreparationArea;
        pickingMode: PickingMode;
        parcelRange: RangeOfParcel;
        parcelType: ParcelType;
        height: string;
        width: string;
        depth: string;
        volume: string;
        estimatedWeight: string;
        realWeight: string;
        isDispatchableInState: boolean;
        isPalettizableAsIs: boolean;
        carrierParcelNumber: string;
        carrier: Carrier;
        transportationMethod: TransportMode;
        deliveryNote: DeliveryNote;
        shippingUnit: ShippingUnit;
        isPostponed: boolean;
        validatingOperator: Operand;
        validatingUser: string;
        postingDate: string;
        postingTime: integer;
        pickingOrderSorting: string;
        ssccParcelCode: string;
        dockStore: Store;
        dockAddress: Location;
        originDockStore: Store;
        originDockAddress: Location;
        stockOnDockStatus: Colis;
        isStockOnDockControl: boolean;
        pickingOrderType: PoType;
        shippingUnits: ClientCollection<ShippingUnit>;
        outputMovements: ClientCollection<OutputMovement>;
    }
    export interface Parcel$Lookups {
        site: QueryOperation<Site>;
        depositor: QueryOperation<Depositor>;
        deliveryOrder: QueryOperation<DeliveryOrder>;
        pickingOrder: QueryOperation<PickingOrder>;
        palletisationOrder: QueryOperation<AutoPalletizationOrder>;
        preparationArea: QueryOperation<PreparationArea>;
        pickingMode: QueryOperation<PickingMode>;
        parcelRange: QueryOperation<RangeOfParcel>;
        parcelType: QueryOperation<ParcelType>;
        carrier: QueryOperation<Carrier>;
        transportationMethod: QueryOperation<TransportMode>;
        deliveryNote: QueryOperation<DeliveryNote>;
        shippingUnit: QueryOperation<ShippingUnit>;
        validatingOperator: QueryOperation<Operand>;
        dockStore: QueryOperation<Store>;
        dockAddress: QueryOperation<Location>;
        originDockStore: QueryOperation<Store>;
        originDockAddress: QueryOperation<Location>;
    }
    export interface Parcel$Operations {
        query: QueryOperation<Parcel>;
        read: ReadOperation<Parcel>;
        aggregate: {
            read: AggregateReadOperation<Parcel>;
            query: AggregateQueryOperation<Parcel>;
        };
        lookups(dataOrId: string | { data: ParcelInput }): Parcel$Lookups;
        getDefaults: GetDefaultsOperation<Parcel>;
    }
    export interface PickingOrder extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        depositor: Depositor;
        code: string;
        status: StoringListPurchaseOrderStatus;
        pickingOrderType: PoType;
        pickingMode: PickingMode;
        preparationArea: PreparationArea;
        deliveryOrder: DeliveryOrder;
        round: Round;
        level: ContainerLevel;
        isPreparationOrderKit: boolean;
        date: string;
        time: string;
        totalMovements: integer;
        totalConsumptionUnit: string;
        totalWeight: string;
        totalVolume: string;
        preparationTime: string;
        equivalentSurface: string;
        numberOfParcels: integer;
        numberOfShippingUnits: integer;
        subWaveNumber: integer;
        shipTo: Customer;
        validatingOperator: Operand;
        postingDate: string;
        postingTime: integer;
        validatingUser: string;
    }
    export interface PickingOrderInput extends ClientNodeInput {
        site?: string;
        depositor?: string;
        code?: string;
        status?: StoringListPurchaseOrderStatus;
        pickingOrderType?: PoType;
        pickingMode?: string;
        preparationArea?: string;
        deliveryOrder?: string;
        round?: string;
        level?: ContainerLevel;
        isPreparationOrderKit?: boolean | string;
        date?: string;
        time?: string;
        totalMovements?: integer | string;
        totalConsumptionUnit?: decimal | string;
        totalWeight?: decimal | string;
        totalVolume?: decimal | string;
        preparationTime?: decimal | string;
        equivalentSurface?: decimal | string;
        numberOfParcels?: integer | string;
        numberOfShippingUnits?: integer | string;
        subWaveNumber?: integer | string;
        shipTo?: string;
        validatingOperator?: string;
        postingDate?: string;
        postingTime?: integer | string;
        validatingUser?: string;
    }
    export interface PickingOrderBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        depositor: Depositor;
        code: string;
        status: StoringListPurchaseOrderStatus;
        pickingOrderType: PoType;
        pickingMode: PickingMode;
        preparationArea: PreparationArea;
        deliveryOrder: DeliveryOrder;
        round: Round;
        level: ContainerLevel;
        isPreparationOrderKit: boolean;
        date: string;
        time: string;
        totalMovements: integer;
        totalConsumptionUnit: string;
        totalWeight: string;
        totalVolume: string;
        preparationTime: string;
        equivalentSurface: string;
        numberOfParcels: integer;
        numberOfShippingUnits: integer;
        subWaveNumber: integer;
        shipTo: Customer;
        validatingOperator: Operand;
        postingDate: string;
        postingTime: integer;
        validatingUser: string;
    }
    export interface PickingOrder$Lookups {
        site: QueryOperation<Site>;
        depositor: QueryOperation<Depositor>;
        pickingMode: QueryOperation<PickingMode>;
        preparationArea: QueryOperation<PreparationArea>;
        deliveryOrder: QueryOperation<DeliveryOrder>;
        round: QueryOperation<Round>;
        shipTo: QueryOperation<Customer>;
        validatingOperator: QueryOperation<Operand>;
    }
    export interface PickingOrder$Operations {
        query: QueryOperation<PickingOrder>;
        read: ReadOperation<PickingOrder>;
        aggregate: {
            read: AggregateReadOperation<PickingOrder>;
            query: AggregateQueryOperation<PickingOrder>;
        };
        lookups(dataOrId: string | { data: PickingOrderInput }): PickingOrder$Lookups;
        getDefaults: GetDefaultsOperation<PickingOrder>;
    }
    export interface Round extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        dockType: DockManagement;
        code: string;
        appointment: AppointmentManagement;
        date: string;
        time: string;
        duration: string;
        status: RoundStatus;
        carrier: Carrier;
        carrierName: string;
        transportationMethod: TransportMode;
        carriageReference: string;
        dockStore: Store;
        dockAddress: Location;
        genericRound: GenericRound;
        volume: string;
        weight: string;
        linearMeters: string;
        numberOfDeliveryOrders: integer;
        numberOfLines: integer;
        deliveryOrderNumber: integer;
        numberOfConsumptionUnit: integer;
        numberOfShippingUnits: integer;
        transportType: TransportType;
        shipTo: Customer;
        isInterSiteRound: boolean;
        destinationSite: Site;
        deliveryOrders: ClientCollection<DeliveryOrder>;
    }
    export interface RoundInput extends ClientNodeInput {
        site?: string;
        dockType?: DockManagement;
        code?: string;
        appointment?: string;
        date?: string;
        time?: string;
        duration?: string;
        status?: RoundStatus;
        carrier?: string;
        carrierName?: string;
        transportationMethod?: string;
        carriageReference?: string;
        dockStore?: string;
        dockAddress?: string;
        genericRound?: string;
        volume?: decimal | string;
        weight?: decimal | string;
        linearMeters?: decimal | string;
        numberOfDeliveryOrders?: integer | string;
        numberOfLines?: integer | string;
        deliveryOrderNumber?: integer | string;
        numberOfConsumptionUnit?: integer | string;
        numberOfShippingUnits?: integer | string;
        transportType?: string;
        shipTo?: string;
        isInterSiteRound?: boolean | string;
        destinationSite?: string;
        deliveryOrders?: Partial<DeliveryOrderInput>[];
    }
    export interface RoundBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        dockType: DockManagement;
        code: string;
        appointment: AppointmentManagement;
        date: string;
        time: string;
        duration: string;
        status: RoundStatus;
        carrier: Carrier;
        carrierName: string;
        transportationMethod: TransportMode;
        carriageReference: string;
        dockStore: Store;
        dockAddress: Location;
        genericRound: GenericRound;
        volume: string;
        weight: string;
        linearMeters: string;
        numberOfDeliveryOrders: integer;
        numberOfLines: integer;
        deliveryOrderNumber: integer;
        numberOfConsumptionUnit: integer;
        numberOfShippingUnits: integer;
        transportType: TransportType;
        shipTo: Customer;
        isInterSiteRound: boolean;
        destinationSite: Site;
        deliveryOrders: ClientCollection<DeliveryOrder>;
    }
    export interface Round$Lookups {
        site: QueryOperation<Site>;
        appointment: QueryOperation<AppointmentManagement>;
        carrier: QueryOperation<Carrier>;
        transportationMethod: QueryOperation<TransportMode>;
        dockStore: QueryOperation<Store>;
        dockAddress: QueryOperation<Location>;
        genericRound: QueryOperation<GenericRound>;
        transportType: QueryOperation<TransportType>;
        shipTo: QueryOperation<Customer>;
        destinationSite: QueryOperation<Site>;
    }
    export interface Round$Operations {
        query: QueryOperation<Round>;
        read: ReadOperation<Round>;
        aggregate: {
            read: AggregateReadOperation<Round>;
            query: AggregateQueryOperation<Round>;
        };
        lookups(dataOrId: string | { data: RoundInput }): Round$Lookups;
        getDefaults: GetDefaultsOperation<Round>;
    }
    export interface ShippingUnitCompanyNames extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        depositor: string;
        code: string;
        companyName: string;
    }
    export interface ShippingUnitCompanyNamesInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        site?: string;
        depositor?: string;
        code?: string;
        companyName?: string;
    }
    export interface ShippingUnitCompanyNamesBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        depositor: string;
        code: string;
        companyName: string;
    }
    export interface ShippingUnitCompanyNames$Operations {
        query: QueryOperation<ShippingUnitCompanyNames>;
        read: ReadOperation<ShippingUnitCompanyNames>;
        aggregate: {
            read: AggregateReadOperation<ShippingUnitCompanyNames>;
            query: AggregateQueryOperation<ShippingUnitCompanyNames>;
        };
        getDefaults: GetDefaultsOperation<ShippingUnitCompanyNames>;
    }
    export interface ShippingUnit extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        depositor: Depositor;
        code: string;
        status: ShippingUnitStatus;
        shippingUnitType: ShippingUnitType;
        deliveryOrder: DeliveryOrder;
        isShippingUnitSingleDeliveryOrder: boolean;
        isShippingUnitSingleCustomer: boolean;
        pickingOrder: PickingOrder;
        preparationArea: PreparationArea;
        pickingMode: PickingMode;
        palletisationOrder: AutoPalletizationOrder;
        shipTo: Customer;
        postalCode: string;
        isPostponed: boolean;
        height: string;
        width: string;
        depth: string;
        volume: string;
        weight: string;
        estimatedWeight: string;
        numberOfParcels: integer;
        parcel: Parcel;
        ssccShippingUnitCode: string;
        dockStore: Store;
        dockAddress: Location;
        originDockStore: Store;
        originDockAddress: Location;
        stockOnDockStatus: Colis;
        isStockOnDockControl: boolean;
        isWrappedShippingUnit: boolean;
        creationType: SuCreationType;
        subWaveNumber: integer;
        isDispatchableInState: boolean;
        parcels: ClientCollection<Parcel>;
        companyNames: ClientCollection<ShippingUnitCompanyNames>;
    }
    export interface ShippingUnitInput extends ClientNodeInput {
        site?: string;
        depositor?: string;
        code?: string;
        status?: ShippingUnitStatus;
        shippingUnitType?: string;
        deliveryOrder?: string;
        isShippingUnitSingleDeliveryOrder?: boolean | string;
        isShippingUnitSingleCustomer?: boolean | string;
        pickingOrder?: string;
        preparationArea?: string;
        pickingMode?: string;
        palletisationOrder?: string;
        shipTo?: string;
        postalCode?: string;
        isPostponed?: boolean | string;
        height?: decimal | string;
        width?: decimal | string;
        depth?: decimal | string;
        volume?: decimal | string;
        weight?: decimal | string;
        estimatedWeight?: decimal | string;
        numberOfParcels?: integer | string;
        parcel?: string;
        ssccShippingUnitCode?: string;
        dockStore?: string;
        dockAddress?: string;
        originDockStore?: string;
        originDockAddress?: string;
        stockOnDockStatus?: Colis;
        isStockOnDockControl?: boolean | string;
        isWrappedShippingUnit?: boolean | string;
        creationType?: SuCreationType;
        subWaveNumber?: integer | string;
        isDispatchableInState?: boolean | string;
        parcels?: Partial<ParcelInput>[];
        companyNames?: Partial<ShippingUnitCompanyNamesInput>[];
    }
    export interface ShippingUnitBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        depositor: Depositor;
        code: string;
        status: ShippingUnitStatus;
        shippingUnitType: ShippingUnitType;
        deliveryOrder: DeliveryOrder;
        isShippingUnitSingleDeliveryOrder: boolean;
        isShippingUnitSingleCustomer: boolean;
        pickingOrder: PickingOrder;
        preparationArea: PreparationArea;
        pickingMode: PickingMode;
        palletisationOrder: AutoPalletizationOrder;
        shipTo: Customer;
        postalCode: string;
        isPostponed: boolean;
        height: string;
        width: string;
        depth: string;
        volume: string;
        weight: string;
        estimatedWeight: string;
        numberOfParcels: integer;
        parcel: Parcel;
        ssccShippingUnitCode: string;
        dockStore: Store;
        dockAddress: Location;
        originDockStore: Store;
        originDockAddress: Location;
        stockOnDockStatus: Colis;
        isStockOnDockControl: boolean;
        isWrappedShippingUnit: boolean;
        creationType: SuCreationType;
        subWaveNumber: integer;
        isDispatchableInState: boolean;
        parcels: ClientCollection<Parcel>;
        companyNames: ClientCollection<ShippingUnitCompanyNamesBinding>;
    }
    export interface ShippingUnit$Lookups {
        site: QueryOperation<Site>;
        depositor: QueryOperation<Depositor>;
        shippingUnitType: QueryOperation<ShippingUnitType>;
        deliveryOrder: QueryOperation<DeliveryOrder>;
        pickingOrder: QueryOperation<PickingOrder>;
        preparationArea: QueryOperation<PreparationArea>;
        pickingMode: QueryOperation<PickingMode>;
        palletisationOrder: QueryOperation<AutoPalletizationOrder>;
        shipTo: QueryOperation<Customer>;
        parcel: QueryOperation<Parcel>;
        dockStore: QueryOperation<Store>;
        dockAddress: QueryOperation<Location>;
        originDockStore: QueryOperation<Store>;
        originDockAddress: QueryOperation<Location>;
    }
    export interface ShippingUnit$Operations {
        query: QueryOperation<ShippingUnit>;
        read: ReadOperation<ShippingUnit>;
        aggregate: {
            read: AggregateReadOperation<ShippingUnit>;
            query: AggregateQueryOperation<ShippingUnit>;
        };
        lookups(dataOrId: string | { data: ShippingUnitInput }): ShippingUnit$Lookups;
        getDefaults: GetDefaultsOperation<ShippingUnit>;
    }
    export interface LocationExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        store: Store;
        code: string;
        storageType: string;
        storage: StorageType;
        storeType: StoreType;
        locationType: LocationType;
        dockType: DockType;
        depositor: Depositor;
        lotNumber: string;
        reservationNumber: string;
        stockStatus: StockNature;
        numberOfConsumptionUnitPerContainer: string;
        rotationClass: RotationClass;
        assignmentClass: AssignmentClass;
        prohibitedClass: AssignmentClass;
        height: string;
        width: string;
        depth: string;
        volume: string;
        maxVolume: string;
        maxWeightAuthorized: string;
        maxMeters: string;
        maximumLoad: string;
        dockHeight: string;
        storingTime: string;
        unStockingTime: string;
        presentContainerMaximumQuantity: string;
        referenceContainerLevel: integer;
        maximumQuantityInReferenceContainer: string;
        quantityInStock: string;
        lastStockCount: string;
        lastReceipt: string;
        firstArrival: string;
        fifoDate: string;
        quantityInPendingInput: string;
        quantityInPendingOutput: string;
        quantityInPendingReplenish: string;
        isBlockedInInput: boolean;
        isBlockedInOutput: boolean;
        isBlockedInInput2: boolean;
        isBlockedInOutput2: boolean;
        isAutoAddressing: boolean;
        isKeyInControlCode: boolean;
        controlCode: string;
        reorderPoint: string;
        replenishmentType: LocationType;
        replenishmentLevel: ContainerLevel;
        percentageOccupied: integer;
        parity: Parity;
        isTemporaryPicking: boolean;
        isPickingPivot: boolean;
        wavePivot: string;
        pickingPriority: integer;
        isUsed: boolean;
        controlDimension: ControlOfDimensions;
        isActive: boolean;
        isDockLeveler: boolean;
        completeObjectsAddressingThreshold: string;
        displayCode: string;
        storeLocationCode: string;
        storeLocationKey: string;
        splitAddresses: ClientCollection<LocationSplitAddresses>;
        product: Product;
        container: Container;
        source: Origin;
        referenceContainer: Container;
        presentContainer: Container;
        superiorContainer: ProductContainer;
        deliveryOrderPivot: DeliveryOrder;
    }
    export interface LocationInputExtension {
        site?: string;
        store?: string;
        code?: string;
        storageType?: string;
        storage?: string;
        storeType?: StoreType;
        locationType?: LocationType;
        dockType?: DockType;
        depositor?: string;
        lotNumber?: string;
        reservationNumber?: string;
        stockStatus?: string;
        numberOfConsumptionUnitPerContainer?: decimal | string;
        rotationClass?: string;
        assignmentClass?: string;
        prohibitedClass?: string;
        height?: decimal | string;
        width?: decimal | string;
        depth?: decimal | string;
        volume?: decimal | string;
        maxVolume?: decimal | string;
        maxWeightAuthorized?: decimal | string;
        maxMeters?: decimal | string;
        maximumLoad?: decimal | string;
        dockHeight?: decimal | string;
        storingTime?: decimal | string;
        unStockingTime?: decimal | string;
        presentContainerMaximumQuantity?: decimal | string;
        referenceContainerLevel?: integer | string;
        maximumQuantityInReferenceContainer?: decimal | string;
        quantityInStock?: decimal | string;
        lastStockCount?: string;
        lastReceipt?: string;
        firstArrival?: string;
        fifoDate?: string;
        quantityInPendingInput?: decimal | string;
        quantityInPendingOutput?: decimal | string;
        quantityInPendingReplenish?: decimal | string;
        isBlockedInInput?: boolean | string;
        isBlockedInOutput?: boolean | string;
        isBlockedInInput2?: boolean | string;
        isBlockedInOutput2?: boolean | string;
        isAutoAddressing?: boolean | string;
        isKeyInControlCode?: boolean | string;
        controlCode?: string;
        reorderPoint?: decimal | string;
        replenishmentType?: LocationType;
        replenishmentLevel?: ContainerLevel;
        percentageOccupied?: integer | string;
        parity?: Parity;
        isTemporaryPicking?: boolean | string;
        isPickingPivot?: boolean | string;
        wavePivot?: string;
        pickingPriority?: integer | string;
        isUsed?: boolean | string;
        controlDimension?: ControlOfDimensions;
        isActive?: boolean | string;
        isDockLeveler?: boolean | string;
        completeObjectsAddressingThreshold?: decimal | string;
        splitAddresses?: Partial<LocationSplitAddressesInput>[];
        product?: string;
        container?: string;
        source?: string;
        referenceContainer?: string;
        presentContainer?: string;
        superiorContainer?: string;
        deliveryOrderPivot?: string;
    }
    export interface LocationBindingExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        store: Store;
        code: string;
        storageType: string;
        storage: StorageType;
        storeType: StoreType;
        locationType: LocationType;
        dockType: DockType;
        depositor: Depositor;
        lotNumber: string;
        reservationNumber: string;
        stockStatus: StockNature;
        numberOfConsumptionUnitPerContainer: string;
        rotationClass: RotationClass;
        assignmentClass: AssignmentClass;
        prohibitedClass: AssignmentClass;
        height: string;
        width: string;
        depth: string;
        volume: string;
        maxVolume: string;
        maxWeightAuthorized: string;
        maxMeters: string;
        maximumLoad: string;
        dockHeight: string;
        storingTime: string;
        unStockingTime: string;
        presentContainerMaximumQuantity: string;
        referenceContainerLevel: integer;
        maximumQuantityInReferenceContainer: string;
        quantityInStock: string;
        lastStockCount: string;
        lastReceipt: string;
        firstArrival: string;
        fifoDate: string;
        quantityInPendingInput: string;
        quantityInPendingOutput: string;
        quantityInPendingReplenish: string;
        isBlockedInInput: boolean;
        isBlockedInOutput: boolean;
        isBlockedInInput2: boolean;
        isBlockedInOutput2: boolean;
        isAutoAddressing: boolean;
        isKeyInControlCode: boolean;
        controlCode: string;
        reorderPoint: string;
        replenishmentType: LocationType;
        replenishmentLevel: ContainerLevel;
        percentageOccupied: integer;
        parity: Parity;
        isTemporaryPicking: boolean;
        isPickingPivot: boolean;
        wavePivot: string;
        pickingPriority: integer;
        isUsed: boolean;
        controlDimension: ControlOfDimensions;
        isActive: boolean;
        isDockLeveler: boolean;
        completeObjectsAddressingThreshold: string;
        displayCode: string;
        storeLocationCode: string;
        storeLocationKey: string;
        splitAddresses: ClientCollection<LocationSplitAddressesBinding>;
        product: Product;
        container: Container;
        source: Origin;
        referenceContainer: Container;
        presentContainer: Container;
        superiorContainer: ProductContainer;
        deliveryOrderPivot: DeliveryOrder;
    }
    export interface LocationExtension$Lookups {
        deliveryOrderPivot: QueryOperation<DeliveryOrder>;
    }
    export interface LocationExtension$Operations {
        lookups(dataOrId: string | { data: LocationInput }): LocationExtension$Lookups;
    }
    export interface SerialNumberExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        depositor: Depositor;
        product: Product;
        code: string;
        double: integer;
        occurrence: integer;
        linePointerNumber: integer;
        receiptDate: string;
        deliveryOrderLineNumber: integer;
        outputDate: string;
        transmittedToL3: integer;
        stockObject: StockObject;
        serialGroup: SerialGroup;
        validatedStoringList: integer;
        validatedPreparationOrder: integer;
        serialParentGroup: SerialGroup;
        transferDate: string;
        free1: string;
        free2: string;
        free3: string;
        free4: string;
        free5: string;
        voided: integer;
        postponed: integer;
        displayCode: string;
        keyCodeForDuplicates: string;
        deliveryOrder: DeliveryOrder;
        outputMovement: OutputMovement;
    }
    export interface SerialNumberInputExtension {
        site?: string;
        depositor?: string;
        product?: string;
        code?: string;
        double?: integer | string;
        occurrence?: integer | string;
        linePointerNumber?: integer | string;
        receiptDate?: string;
        deliveryOrderLineNumber?: integer | string;
        outputDate?: string;
        transmittedToL3?: integer | string;
        stockObject?: string;
        serialGroup?: string;
        validatedStoringList?: integer | string;
        validatedPreparationOrder?: integer | string;
        serialParentGroup?: string;
        transferDate?: string;
        free1?: string;
        free2?: string;
        free3?: string;
        free4?: string;
        free5?: string;
        voided?: integer | string;
        postponed?: integer | string;
        actionImport?: string;
        deliveryOrder?: string;
        outputMovement?: string;
    }
    export interface SerialNumberBindingExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        depositor: Depositor;
        product: Product;
        code: string;
        double: integer;
        occurrence: integer;
        linePointerNumber: integer;
        receiptDate: string;
        deliveryOrderLineNumber: integer;
        outputDate: string;
        transmittedToL3: integer;
        stockObject: StockObject;
        serialGroup: SerialGroup;
        validatedStoringList: integer;
        validatedPreparationOrder: integer;
        serialParentGroup: SerialGroup;
        transferDate: string;
        free1: string;
        free2: string;
        free3: string;
        free4: string;
        free5: string;
        voided: integer;
        postponed: integer;
        displayCode: string;
        keyCodeForDuplicates: string;
        actionImport: string;
        deliveryOrder: DeliveryOrder;
        outputMovement: OutputMovement;
    }
    export interface SerialNumberExtension$Lookups {
        deliveryOrder: QueryOperation<DeliveryOrder>;
        outputMovement: QueryOperation<OutputMovement>;
    }
    export interface SerialNumberExtension$Operations {
        lookups(dataOrId: string | { data: SerialNumberInput }): SerialNumberExtension$Lookups;
    }
    export interface Package {
        '@sage/wh-output/AutoPalletizationOrder': AutoPalletizationOrder$Operations;
        '@sage/wh-output/CarriageNote': CarriageNote$Operations;
        '@sage/wh-output/CarriageReceiptShipToCompanyNames': CarriageReceiptShipToCompanyNames$Operations;
        '@sage/wh-output/CarriageReceiptShiptToAddresses': CarriageReceiptShiptToAddresses$Operations;
        '@sage/wh-output/CarriageReceipt': CarriageReceipt$Operations;
        '@sage/wh-output/DeliveryNoteBillToAddresses': DeliveryNoteBillToAddresses$Operations;
        '@sage/wh-output/DeliveryNoteBillToCompanyNames': DeliveryNoteBillToCompanyNames$Operations;
        '@sage/wh-output/DeliveryNoteNumberOfDispatchableParcels': DeliveryNoteNumberOfDispatchableParcels$Operations;
        '@sage/wh-output/DeliveryNoteShipToAddresses': DeliveryNoteShipToAddresses$Operations;
        '@sage/wh-output/DeliveryNoteShipToCompanyNames': DeliveryNoteShipToCompanyNames$Operations;
        '@sage/wh-output/DeliveryNote': DeliveryNote$Operations;
        '@sage/wh-output/DeliveryOrderBillToAddresses': DeliveryOrderBillToAddresses$Operations;
        '@sage/wh-output/DeliveryOrderBillToCompanyNames': DeliveryOrderBillToCompanyNames$Operations;
        '@sage/wh-output/DeliveryOrderLine': DeliveryOrderLine$Operations;
        '@sage/wh-output/DeliveryOrderShipToAddresses': DeliveryOrderShipToAddresses$Operations;
        '@sage/wh-output/DeliveryOrderShipToCompanyNames': DeliveryOrderShipToCompanyNames$Operations;
        '@sage/wh-output/DeliveryOrder': DeliveryOrder$Operations;
        '@sage/wh-output/OutputMovementContainerLevels': OutputMovementContainerLevels$Operations;
        '@sage/wh-output/OutputMovement': OutputMovement$Operations;
        '@sage/wh-output/Parcel': Parcel$Operations;
        '@sage/wh-output/PickingOrder': PickingOrder$Operations;
        '@sage/wh-output/Round': Round$Operations;
        '@sage/wh-output/ShippingUnitCompanyNames': ShippingUnitCompanyNames$Operations;
        '@sage/wh-output/ShippingUnit': ShippingUnit$Operations;
    }
    export interface GraphApi
        extends Package,
            SageWhMasterData$Package,
            SageWhProductData$Package,
            SageWhStockData$Package,
            SageWhStructure$Package,
            SageWhSystem$Package,
            SageXtremAppMetadata$Package,
            SageXtremX3SystemUtils$Package {}
}
declare module '@sage/wh-output-api' {
    export type * from '@sage/wh-output-api-partial';
}
declare module '@sage/wh-master-data-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/wh-output-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/wh-product-data-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/wh-output-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/wh-stock-data-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/wh-output-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/wh-structure-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/wh-output-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/wh-system-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/wh-output-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/xtrem-app-metadata-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/wh-output-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/xtrem-x3-system-utils-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/wh-output-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/wh-master-data-api-partial' {
    import type {
        LocationBindingExtension,
        LocationExtension,
        LocationExtension$Lookups,
        LocationExtension$Operations,
        LocationInputExtension,
    } from '@sage/wh-output-api';
    export interface Location extends LocationExtension {}
    export interface LocationBinding extends LocationBindingExtension {}
    export interface LocationInput extends LocationInputExtension {}
    export interface Location$Lookups extends LocationExtension$Lookups {}
    export interface Location$Operations extends LocationExtension$Operations {}
}
declare module '@sage/wh-stock-data-api-partial' {
    import type {
        SerialNumberBindingExtension,
        SerialNumberExtension,
        SerialNumberExtension$Lookups,
        SerialNumberExtension$Operations,
        SerialNumberInputExtension,
    } from '@sage/wh-output-api';
    export interface SerialNumber extends SerialNumberExtension {}
    export interface SerialNumberBinding extends SerialNumberBindingExtension {}
    export interface SerialNumberInput extends SerialNumberInputExtension {}
    export interface SerialNumber$Lookups extends SerialNumberExtension$Lookups {}
    export interface SerialNumber$Operations extends SerialNumberExtension$Operations {}
}
