export interface ConnectedUserCriteria {
    userId: string;
    tenantId: string;
}
export interface MessageTarget {
    userId: string;
    tenantId: string;
    sendToAllMatchingUserSessions: boolean;
    sendToAllUserApps?: boolean;
}
export interface BroadcastMessageTarget {
    tenantId: string;
}
export interface MessageThirdPartyAppTarget {
    applicationId: string;
    tenantId: string;
    sendToAllUserApps?: boolean;
}
export interface ConnectedThirdPartyAppCriteria {
    applicationId: string;
    tenantId: string;
}
export declare abstract class WebsocketRepository {
    abstract isUserOfTenantConnected(connectedUserFilter: ConnectedUserCriteria, acrossAllApps?: boolean): Promise<boolean>;
    abstract sendUserNotification(sendTo: MessageTarget, payload: any): Promise<void>;
    abstract broadcastMessage(sendTo: BroadcastMessageTarget, payload: any): Promise<void>;
    abstract isThirdPartyAppConnected(connectedUserFilter: ConnectedThirdPartyAppCriteria, acrossAllApps?: boolean): Promise<boolean>;
    abstract sendThirdPartyAppNotification(sendTo: MessageThirdPartyAppTarget, payload: any): Promise<void>;
}
