import { SQS } from "@aws-sdk/client-sqs";
import { DynamoDB, DynamoDBClientConfig } from "@aws-sdk/client-dynamodb";
import { BroadcastMessageTarget, ConnectedThirdPartyAppCriteria, ConnectedUserCriteria, MessageTarget, MessageThirdPartyAppTarget, WebsocketRepository } from "../websocketRepository";
export interface WebsocketAWSRepositoryConfig {
    clusterId: string;
    app: string;
    websocketQueueUrl: string;
    dynamoDBTableName: string;
    source?: string;
    AWSOverrideForUnitTesting?: any;
    tracer?: Function;
    awsConfigOverride?: DynamoDBClientConfig;
}
export declare class WebsocketAWSRepository extends WebsocketRepository {
    SQS: SQS;
    DynamoDB: DynamoDB;
    private readonly config;
    private readonly tracer;
    constructor(config: WebsocketAWSRepositoryConfig);
    isUserOfTenantConnected(connectedUserFilter: ConnectedUserCriteria, acrossAllApps?: boolean): Promise<boolean>;
    broadcastMessage(sendTo: BroadcastMessageTarget, payload: any): Promise<void>;
    sendUserNotification(sendTo: MessageTarget, payload: any): Promise<void>;
    private generateSQSMessageAttributes;
    private generateSQSBroadcastMessageAttributes;
    private generateSQSMessageThirdPartyAttributes;
    isThirdPartyAppConnected(connectedAppFilter: ConnectedThirdPartyAppCriteria, acrossAllApps?: boolean): Promise<boolean>;
    sendThirdPartyAppNotification(sendTo: MessageThirdPartyAppTarget, payload: any): Promise<void>;
}
