import { ClientCollection } from './client-node';
import { AggregateEdgesSelector, AggregateGroupSelector, AggregateValuesSelector } from './node-aggregate-queries';
import { EdgesSelector } from './paging';
export type OnlySelected<T, SelectorT> = T extends Array<infer U> ? OnlySelected<U, SelectorT>[] : T extends object ? {
    [K in keyof T & keyof SelectorT]: T[K] extends (infer U)[] | null ? OnlySelected<U, SelectorT[K]>[] : OnlySelected<T[K], SelectorT[K]>;
} : T;
export type Selector<T> = T extends object ? {
    [K in keyof T]?: T[K] extends ClientCollection<infer C> ? CollectionSelector<C> : T[K] extends (infer U)[] | null | undefined ? Selector<U> : Selector<T[K]>;
} : boolean;
export type CollectionSelector<T, SelectorT = Selector<T>> = {
    query?: EdgesSelector<SelectorT>;
    queryAggregate?: AggregateEdgesSelector<T, AggregateGroupSelector<T>, AggregateValuesSelector<T>>;
    readAggregate?: AggregateValuesSelector<T>;
};
//# sourceMappingURL=selector.d.ts.map