import { Operation } from './operations';
import { Edges, EdgesSelector, PagingOptions } from './paging';
import { Request } from './request';
import { OnlySelected, Selector } from './selector';
export type ReadOperation<OutputT> = Operation<string, OutputT>;
export type GetDuplicateOperation<OutputT> = Operation<string, OutputT>;
export type QueryOperation<T> = <SelectorT extends Selector<T>>(nodeSelector: EdgesSelector<SelectorT>, args?: PagingOptions<T>) => Request<Edges<OnlySelected<T, SelectorT>>>;
export type GetDefaultsOperation<T> = <SelectorT extends Selector<T>>(nodeSelector: SelectorT, args?: {
    data?: object;
}) => Request<OnlySelected<T, SelectorT>>;
//# sourceMappingURL=node-queries.d.ts.map