"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.aggregateQueries = void 0;
exports.aggregateEdgesSelector = aggregateEdgesSelector;
const paging_1 = require("./paging");
const request_1 = require("./request");
const selector_1 = require("./selector");
const nodeAggregateReadOperation = (config, path) => (selector, args) => {
    const full = (0, selector_1.fullSelector)([...path, 'readAggregate'], {
        __args: { filter: JSON.stringify((args && args.filter) || {}) },
        ...selector,
    }, false);
    return new request_1.Request(config, [...path, 'readAggregate'], '', full, false);
};
function aggregateEdgesSelector(selector, args) {
    return {
        __args: (0, paging_1.convertPagingOptions)(args || {}),
        edges: { node: selector, cursor: true },
        pageInfo: { hasNextPage: true, endCursor: true, hasPreviousPage: true, startCursor: true },
    };
}
const nodeAggregateQueryOperation = (config, path) => (selector) => {
    const full = (0, selector_1.fullSelector)([...path, 'queryAggregate'], selector, false);
    return new request_1.Request(config, [...path, 'queryAggregate'], '', full, false);
};
/** @internal */
const aggregateQueries = (config, path) => {
    return {
        aggregate: {
            read: nodeAggregateReadOperation(config, path),
            query: nodeAggregateQueryOperation(config, path),
        },
    };
};
exports.aggregateQueries = aggregateQueries;
//# sourceMappingURL=node-aggregate-queries.js.map