import { Filter } from './filters';
import { Edges, PagingOptions, PagingOptionsSelector } from './paging';
import { Request } from './request';
import { OnlySelected } from './selector';
import { integer } from './types';
export type AggregateValuesSelector<T> = T extends object ? {
    [K in keyof T]?: T[K] extends (infer U)[] ? AggregateValuesSelector<U> : AggregateValuesSelector<T[K]>;
} : {
    min?: boolean;
    max?: boolean;
    sum?: boolean;
    avg?: boolean;
    distinctCount?: boolean;
};
export type AggregateGroupSelector<T> = T extends object ? {
    [K in keyof T]?: T[K] extends (infer U)[] ? AggregateGroupSelector<U> : AggregateGroupSelector<T[K]>;
} : {
    _by: 'value' | 'day' | 'month' | 'year';
};
export interface AggregateReadOptions<T> {
    filter?: Filter<T extends infer V ? V : never>;
}
export type AggregateQueryOptions<T> = PagingOptions<T>;
export type AggregateReadOperation<T> = <SelectorT extends AggregateValuesSelector<T>>(selector: SelectorT, args?: AggregateReadOptions<T>) => Request<OnlySelected<AggregateResultValues<T>, SelectorT>>;
export type AggregatePropertyValues<T> = {
    min: T;
    max: T;
    avg: T;
    sum: T;
    distinctCount: integer;
};
export type AggregateResultValues<T> = T extends object ? {
    [K in keyof T]?: T[K] extends (infer U)[] ? AggregateResultValues<U> : AggregateResultValues<T[K]>;
} : AggregatePropertyValues<T>;
export interface AggregateQuerySelector<T, GroupT extends AggregateGroupSelector<T> = AggregateGroupSelector<T>, ValuesT extends AggregateValuesSelector<T> = AggregateValuesSelector<T>> {
    group: GroupT;
    values: ValuesT;
}
export type AggregateEdges<T> = Edges<{
    group: T;
    values: AggregateResultValues<T>;
}>;
export interface AggregateEdgesSelector<T, GroupT extends AggregateGroupSelector<T> = AggregateGroupSelector<T>, ValuesT extends AggregateValuesSelector<T> = AggregateValuesSelector<T>> {
    __args?: PagingOptionsSelector;
    edges: {
        node: {
            group: GroupT;
            values?: ValuesT;
        };
        cursor?: boolean;
    };
    pageInfo?: {
        hasNextPage?: boolean;
        endCursor?: boolean;
        hasPreviousPage?: boolean;
        startCursor?: boolean;
    };
    totalCount?: boolean;
}
export declare function aggregateEdgesSelector<T, GroupT extends AggregateGroupSelector<T> = AggregateGroupSelector<T>, ValuesT extends AggregateValuesSelector<T> = AggregateValuesSelector<T>>(selector: AggregateQuerySelector<T, GroupT, ValuesT>, args?: AggregateQueryOptions<T>): AggregateEdgesSelector<T, GroupT, ValuesT>;
export type AggregateQueryOperation<T> = <GroupT extends AggregateGroupSelector<T>, ValuesT extends AggregateValuesSelector<T>>(selector: AggregateEdgesSelector<T, GroupT, ValuesT>, args?: AggregateQueryOptions<T>) => Request<Edges<{
    group: OnlySelected<T, GroupT>;
    values: OnlySelected<AggregateResultValues<T>, ValuesT>;
}>>;
//# sourceMappingURL=node-aggregate-queries.d.ts.map