"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GraphMutation = exports.Graph = void 0;
const lodash_1 = require("lodash");
const node_aggregate_queries_1 = require("./node-aggregate-queries");
const node_mutations_1 = require("./node-mutations");
const node_queries_1 = require("./node-queries");
function splitPath(nodeName) {
    // remove '@sage' scope
    return nodeName
        .replace(/^@\w*\//, '')
        .split('/')
        .map(lodash_1.camelCase);
}
class Graph {
    constructor(config) {
        this.config = config;
        if (!config.fetcher)
            throw new Error('Invalid configuration: fetcher missing');
    }
    node(nodePath) {
        const config = this.config;
        if (typeof nodePath !== 'string')
            throw new Error(`bad node key: ${typeof nodePath}`);
        const path = splitPath(nodePath);
        return {
            ...(0, node_queries_1.nodeQueries)(config, path),
            ...(0, node_aggregate_queries_1.aggregateQueries)(config, path),
            ...(0, node_mutations_1.nodeMutations)(config, path),
        };
    }
}
exports.Graph = Graph;
class GraphMutation {
    constructor(config) {
        this.config = config;
        if (!config.fetcher)
            throw new Error('Invalid configuration: fetcher missing');
    }
    node(nodePath) {
        const config = this.config;
        if (typeof nodePath !== 'string')
            throw new Error(`bad node key: ${typeof nodePath}`);
        const path = splitPath(nodePath);
        return {
            ...(0, node_mutations_1.nodeMutations)(config, path),
        };
    }
}
exports.GraphMutation = GraphMutation;
//# sourceMappingURL=graph.js.map