"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ClientError = exports.ClientDiagnoseSeverity = void 0;
/** Diagnose severities */
var ClientDiagnoseSeverity;
(function (ClientDiagnoseSeverity) {
    ClientDiagnoseSeverity[ClientDiagnoseSeverity["test"] = 0] = "test";
    ClientDiagnoseSeverity[ClientDiagnoseSeverity["info"] = 1] = "info";
    ClientDiagnoseSeverity[ClientDiagnoseSeverity["warn"] = 2] = "warn";
    ClientDiagnoseSeverity[ClientDiagnoseSeverity["error"] = 3] = "error";
    ClientDiagnoseSeverity[ClientDiagnoseSeverity["exception"] = 4] = "exception";
})(ClientDiagnoseSeverity || (exports.ClientDiagnoseSeverity = ClientDiagnoseSeverity = {}));
function formatError(error) {
    return `${error.path && error.path.join('.')}: ${error.message}`;
}
function formatErrors(errors) {
    return [`${errors.length} error(s):`, ...errors.map(formatError)].join('\n  ');
}
/**
 * Class for errors returned by the client library.
 *
 * this.message is a summary of the errors.
 * this.errors contains the full details, as an array of ErrorDetail objects
 *
 */
class ClientError extends Error {
    constructor(errors) {
        super(formatErrors(errors));
        this.errors = errors;
    }
}
exports.ClientError = ClientError;
//# sourceMappingURL=client-error.js.map