// From file: @sage/xtrem-metrics/build/index.d.ts
declare module '@sage/xtrem-metrics/index' {
	export * from '@sage/xtrem-metrics/lib/index';
	//# sourceMappingURL=index.d.ts.map
}
// From file: @sage/xtrem-metrics/build/lib/types.d.ts
declare module '@sage/xtrem-metrics/lib/types' {
	export interface MetricsContext {
	    tenantId: string | null;
	    cloudflareRayID?: string;
	}
	//# sourceMappingURL=types.d.ts.map
}
// From file: @sage/xtrem-metrics/build/lib/loggers.d.ts
declare module '@sage/xtrem-metrics/lib/loggers' {
	import { Logger } from '@sage/xtrem-log';
	export const loggers: {
	    metrics: Logger;
	    newRelic: Logger;
	};
	//# sourceMappingURL=loggers.d.ts.map
}
// From file: @sage/xtrem-metrics/build/lib/index.d.ts
declare module '@sage/xtrem-metrics/lib/index' {
	export { Gauge as PromGauge } from 'prom-client';
	export * from '@sage/xtrem-metrics/lib/newrelic/index';
	export * from '@sage/xtrem-metrics/lib/prometheus/index';
	export * from '@sage/xtrem-metrics/lib/types';
	//# sourceMappingURL=index.d.ts.map
}
// From file: @sage/xtrem-metrics/build/lib/prometheus/index.d.ts
declare module '@sage/xtrem-metrics/lib/prometheus/index' {
	export * from '@sage/xtrem-metrics/lib/prometheus/custom-metrics';
	export * from '@sage/xtrem-metrics/lib/prometheus/debug-metrics';
	export * from '@sage/xtrem-metrics/lib/prometheus/gauge';
	export * from '@sage/xtrem-metrics/lib/prometheus/histogram';
	//# sourceMappingURL=index.d.ts.map
}
// From file: @sage/xtrem-metrics/build/lib/prometheus/histogram.d.ts
declare module '@sage/xtrem-metrics/lib/prometheus/histogram' {
	import { AnyValue, AsyncResponse } from '@sage/xtrem-shared';
	import { HistogramConfiguration, LabelValues } from 'prom-client';
	export interface HistogramOptions<LabelNameT extends string> extends HistogramConfiguration<LabelNameT> {
	    enabledInProduction?: boolean;
	}
	export class Histogram<LabelNameT extends string> {
	    static createdCount: number;
	    constructor(options: HistogramOptions<LabelNameT>);
	    get isEnabled(): boolean;
	    withMetrics<ResultT extends AnyValue>(labelValues: LabelValues<LabelNameT>, body: () => AsyncResponse<ResultT>): Promise<ResultT>;
	}
	//# sourceMappingURL=histogram.d.ts.map
}
// From file: @sage/xtrem-metrics/build/lib/prometheus/gauge.d.ts
declare module '@sage/xtrem-metrics/lib/prometheus/gauge' {
	import { AnyValue, AsyncResponse } from '@sage/xtrem-shared';
	import { GaugeConfiguration, LabelValues } from 'prom-client';
	export interface GaugeOptions<LabelNameT extends string> extends GaugeConfiguration<LabelNameT> {
	    enabledInProduction?: boolean;
	}
	export class Gauge<LabelNameT extends string> {
	    static createdCount: number;
	    constructor(options: GaugeOptions<LabelNameT>);
	    get isEnabled(): boolean;
	    withMetrics<ResultT extends AnyValue>(labelValues: LabelValues<LabelNameT>, body: () => AsyncResponse<ResultT>): Promise<ResultT>;
	}
	//# sourceMappingURL=gauge.d.ts.map
}
// From file: @sage/xtrem-metrics/build/lib/prometheus/debug-metrics.d.ts
declare module '@sage/xtrem-metrics/lib/prometheus/debug-metrics' {
	import { AnyValue, AsyncResponse } from '@sage/xtrem-shared';
	/**
	 * This class can be used to instrument some piece of code for debugging
	 *
	 * @example
	 * ```
	 * DebugMetrics.withMetrics('myDomain', 'myKey', () => ....)
	 * ```
	 *
	 * To enable the recording of metrics:
	 * - environment variable: set either XTREM_ALL_METRICS_ENABLED or XTREM_DEBUG_METRICS_ENABLED to 1
	 * - xtrem-config.yml file: set deploymentMode to 'development'
	 * - xtrem-config.yml file: enable the domain you want to use:
	 * ```
	debugMetrics:
	      myDomain: true
	 * ```
	 */
	export class DebugMetrics {
	    private static readonly counter;
	    private static _isEnabled;
	    static withMetrics<ResultT extends AnyValue>(domain: string, key: string, body: () => AsyncResponse<ResultT>): Promise<ResultT>;
	}
	//# sourceMappingURL=debug-metrics.d.ts.map
}
// From file: @sage/xtrem-metrics/build/lib/prometheus/custom-metrics.d.ts
declare module '@sage/xtrem-metrics/lib/prometheus/custom-metrics' {
	import { AsyncReader } from '@sage/xtrem-async-helper';
	import { AnyValue, AsyncResponse } from '@sage/xtrem-shared';
	import { Express } from 'express';
	import { EventEmitter } from 'node:events';
	export const allMetricsEnabled: boolean;
	export interface CustomCountersMetrics<KeyT extends object> {
	    withMetrics<ResultT extends AnyValue>(key: KeyT, body: () => AsyncResponse<ResultT>): Promise<ResultT>;
	    withMetricsSync<ResultT extends AnyValue>(key: KeyT, body: () => ResultT): ResultT;
	    wrapReader<ElementT extends AnyValue>(key: KeyT, reader: AsyncReader<ElementT>): AsyncReader<ElementT>;
	}
	export type StatementKind = 'select' | 'insert' | 'update' | 'upsert' | 'delete';
	interface RulesLabels {
	    nodeName: string;
	    propertyName?: string;
	    ruleName: string;
	}
	interface GraphQlLabels {
	    nodeName: string;
	    operationName: string;
	    operationKind: string;
	}
	interface SqlLabels {
	    nodeName: string;
	    statementKind: StatementKind;
	}
	interface BroadcastLabels {
	    tenantId: string;
	    nodeName: string;
	    category: string;
	}
	export class CustomMetrics {
	    static readonly emitter: EventEmitter<[never]>;
	    static readonly rules: CustomCountersMetrics<RulesLabels>;
	    static readonly graphql: CustomCountersMetrics<GraphQlLabels>;
	    static readonly metadata: CustomCountersMetrics<GraphQlLabels>;
	    static readonly sql: CustomCountersMetrics<SqlLabels>;
	    static readonly broadcast: CustomCountersMetrics<BroadcastLabels>;
	    static get expressApp(): Express;
	}
	export {};
	//# sourceMappingURL=custom-metrics.d.ts.map
}
// From file: @sage/xtrem-metrics/build/lib/newrelic/wrapper.d.ts
declare module '@sage/xtrem-metrics/lib/newrelic/wrapper' {
	export const isNewrelicDisabled: boolean;
	export function recordCustomEventToNewrelic(eventName: string, attributes: Record<string, any>): void;
	export function addCustomAttributesToNewrelic(attributes: Record<string, any>): void;
	//# sourceMappingURL=wrapper.d.ts.map
}
// From file: @sage/xtrem-metrics/build/lib/newrelic/web-transaction.d.ts
declare module '@sage/xtrem-metrics/lib/newrelic/web-transaction' {
	export function setWebTransactionName(callback: () => string | null): void;
	//# sourceMappingURL=web-transaction.d.ts.map
}
// From file: @sage/xtrem-metrics/build/lib/newrelic/third-party-request-auditor.d.ts
declare module '@sage/xtrem-metrics/lib/newrelic/third-party-request-auditor' {
	import { MetricsContext } from '@sage/xtrem-metrics/lib/types';
	import { RequestKind } from '@sage/xtrem-metrics/lib/newrelic/custom-event-emiter';
	export interface NullableTenantId {
	    tenantId: string | null;
	}
	/**
	 * Aims at sending to newrelic some statistics related to 3rd party external calls
	 */
	export class ThirdPartyRequestAuditor {
	    private readonly thirdParty;
	    private readonly requestKind;
	    private readonly recordKind;
	    private readonly asyncRequest;
	    private readonly tenantId;
	    private readonly startedAt;
	    private recordCount?;
	    private customDurationInMs;
	    constructor(context: NullableTenantId, thirdParty: string, requestKind: RequestKind, recordKind: string, async: boolean, recordCount?: number);
	    static newSingleRecordRead(context: MetricsContext, thirdPartyId: string, recordKind?: string, async?: boolean): ThirdPartyRequestAuditor;
	    recordSuccess(recordCount?: number): void;
	    recordFailure(recordCount?: number): void;
	    /**
	     * In async mode we can't rely on the object creation to calculate request duration, this allows you to manually set it
	     * When set it override the value sent to newrelic.
	     * @param durationInMs how long it took from request to response in millisecond
	     */
	    withCustomDuration(durationInMs: number): ThirdPartyRequestAuditor;
	    private recordResult;
	}
	//# sourceMappingURL=third-party-request-auditor.d.ts.map
}
// From file: @sage/xtrem-metrics/build/lib/newrelic/index.d.ts
declare module '@sage/xtrem-metrics/lib/newrelic/index' {
	export * from '@sage/xtrem-metrics/lib/newrelic/custom-event-emiter';
	export * from '@sage/xtrem-metrics/lib/newrelic/third-party-request-auditor';
	export * from '@sage/xtrem-metrics/lib/newrelic/web-transaction';
	export * from '@sage/xtrem-metrics/lib/newrelic/wrapper';
	//# sourceMappingURL=index.d.ts.map
}
// From file: @sage/xtrem-metrics/build/lib/newrelic/custom-event-emiter.d.ts
declare module '@sage/xtrem-metrics/lib/newrelic/custom-event-emiter' {
	import { MetricsContext } from '@sage/xtrem-metrics/lib/types';
	export enum RequestKind {
	    read = "Read",
	    list = "List",
	    create = "Create",
	    delete = "Delete",
	    update = "Update",
	    execute = "Execute",// compute something not related to a given entity
	    unknown = "Unknown"
	}
	export interface ThirdPartyNewrelicEvent {
	    thirdParty: string;
	    requestKind: RequestKind;
	    tenantId: string;
	    success: boolean;
	    durationMs: number;
	    recordKind: string;
	    recordCount: number;
	    async: boolean;
	}
	/**
	 * Send to newrelic a custom event related to a 3rd party integration event that can then be used to gather metrics and create dashboards
	 * @param event
	 */
	export function record3rdPartyEventToNewrelic(event: ThirdPartyNewrelicEvent): void;
	export interface NewrelicXtremEvent {
	    tenantId?: string;
	    durationMs?: number;
	    success: boolean;
	    eventKind: string;
	}
	/**
	 * Record execution of message, notification or async mutation to newrelic
	 * @param event
	 */
	export function recordXtremEventToNewrelic(event: NewrelicXtremEvent): void;
	/**
	 * Record an unhandled error in NewRelic
	 * @param context
	 * @param err
	 */
	export function recordXtremErrorToNewrelic(context: MetricsContext, err: Error): void;
	//# sourceMappingURL=custom-event-emiter.d.ts.map
}
declare module '@sage/xtrem-metrics' {
	export * from '@sage/xtrem-metrics/index';
}
