import { AnyValue, AsyncResponse } from '@sage/xtrem-shared';
/**
 * This class can be used to instrument some piece of code for debugging
 *
 * @example
 * ```
 * DebugMetrics.withMetrics('myDomain', 'myKey', () => ....)
 * ```
 *
 * To enable the recording of metrics:
 * - environment variable: set either XTREM_ALL_METRICS_ENABLED or XTREM_DEBUG_METRICS_ENABLED to 1
 * - xtrem-config.yml file: set deploymentMode to 'development'
 * - xtrem-config.yml file: enable the domain you want to use:
 * ```
debugMetrics:
      myDomain: true
 * ```
 */
export declare class DebugMetrics {
    private static readonly counter;
    private static _isEnabled;
    static withMetrics<ResultT extends AnyValue>(domain: string, key: string, body: () => AsyncResponse<ResultT>): Promise<ResultT>;
}
//# sourceMappingURL=debug-metrics.d.ts.map