import { AsyncReader } from '@sage/xtrem-async-helper';
import { AnyValue, AsyncResponse } from '@sage/xtrem-shared';
import { Express } from 'express';
import { EventEmitter } from 'node:events';
export declare const allMetricsEnabled: boolean;
export interface CustomCountersMetrics<KeyT extends object> {
    withMetrics<ResultT extends AnyValue>(key: KeyT, body: () => AsyncResponse<ResultT>): Promise<ResultT>;
    withMetricsSync<ResultT extends AnyValue>(key: KeyT, body: () => ResultT): ResultT;
    wrapReader<ElementT extends AnyValue>(key: KeyT, reader: AsyncReader<ElementT>): AsyncReader<ElementT>;
}
export type StatementKind = 'select' | 'insert' | 'update' | 'upsert' | 'delete';
interface RulesLabels {
    nodeName: string;
    propertyName?: string;
    ruleName: string;
}
interface GraphQlLabels {
    nodeName: string;
    operationName: string;
    operationKind: string;
}
interface SqlLabels {
    nodeName: string;
    statementKind: StatementKind;
}
interface BroadcastLabels {
    tenantId: string;
    nodeName: string;
    category: string;
}
export declare class CustomMetrics {
    static readonly emitter: EventEmitter<[never]>;
    static readonly rules: CustomCountersMetrics<RulesLabels>;
    static readonly graphql: CustomCountersMetrics<GraphQlLabels>;
    static readonly metadata: CustomCountersMetrics<GraphQlLabels>;
    static readonly sql: CustomCountersMetrics<SqlLabels>;
    static readonly broadcast: CustomCountersMetrics<BroadcastLabels>;
    static get expressApp(): Express;
}
export {};
//# sourceMappingURL=custom-metrics.d.ts.map