import { MetricsContext } from '../types';
import { RequestKind } from './custom-event-emiter';
export interface NullableTenantId {
    tenantId: string | null;
}
/**
 * Aims at sending to newrelic some statistics related to 3rd party external calls
 */
export declare class ThirdPartyRequestAuditor {
    private readonly thirdParty;
    private readonly requestKind;
    private readonly recordKind;
    private readonly asyncRequest;
    private readonly tenantId;
    private readonly startedAt;
    private recordCount?;
    private customDurationInMs;
    constructor(context: NullableTenantId, thirdParty: string, requestKind: RequestKind, recordKind: string, async: boolean, recordCount?: number);
    static newSingleRecordRead(context: MetricsContext, thirdPartyId: string, recordKind?: string, async?: boolean): ThirdPartyRequestAuditor;
    recordSuccess(recordCount?: number): void;
    recordFailure(recordCount?: number): void;
    /**
     * In async mode we can't rely on the object creation to calculate request duration, this allows you to manually set it
     * When set it override the value sent to newrelic.
     * @param durationInMs how long it took from request to response in millisecond
     */
    withCustomDuration(durationInMs: number): ThirdPartyRequestAuditor;
    private recordResult;
}
//# sourceMappingURL=third-party-request-auditor.d.ts.map