import { MetricsContext } from '../types';
export declare enum RequestKind {
    read = "Read",
    list = "List",
    create = "Create",
    delete = "Delete",
    update = "Update",
    execute = "Execute",// compute something not related to a given entity
    unknown = "Unknown"
}
export interface ThirdPartyNewrelicEvent {
    thirdParty: string;
    requestKind: RequestKind;
    tenantId: string;
    success: boolean;
    durationMs: number;
    recordKind: string;
    recordCount: number;
    async: boolean;
}
/**
 * Send to newrelic a custom event related to a 3rd party integration event that can then be used to gather metrics and create dashboards
 * @param event
 */
export declare function record3rdPartyEventToNewrelic(event: ThirdPartyNewrelicEvent): void;
export interface NewrelicXtremEvent {
    tenantId?: string;
    durationMs?: number;
    success: boolean;
    eventKind: string;
}
/**
 * Record execution of message, notification or async mutation to newrelic
 * @param event
 */
export declare function recordXtremEventToNewrelic(event: NewrelicXtremEvent): void;
/**
 * Record an unhandled error in NewRelic
 * @param context
 * @param err
 */
export declare function recordXtremErrorToNewrelic(context: MetricsContext, err: Error): void;
//# sourceMappingURL=custom-event-emiter.d.ts.map