// eslint.config.mjs (ESLint v9+)
import { defineConfig, globalIgnores } from 'eslint/config';
import globals from 'globals';
import baseConfig from '../../eslint-base.config.mjs';
import xtremPlugin from '@sage/eslint-plugin-xtrem';

export default defineConfig([
    globalIgnores(['build/**', 'tmp/**', 'node_modules/**', '**/coverage', '**/i18n/*.json']),
    {
        files: ['**/*.{ts,tsx,mts,cts}'],
        languageOptions: {
            parser: '@typescript-eslint/parser',
            parserOptions: {
                tsconfigRootDir: import.meta.dirname,
                project: 'tsconfig.json',
            },
        },
    },
    {
        plugins: {
            '@sage/xtrem': xtremPlugin,
        },
    },
    ...baseConfig,
    {
        files: ['**/*.js'],
        rules: {
            '@typescript-eslint/no-require-imports': 'off',
        },
    },
    {
        files: ['**/*.{ts,tsx,mts,cts}'],
        rules: {
            // To review: ESLint V9 migration (all the following are temporarily disabled)
            '@stylistic/quotes': 'off',
            'no-constant-binary-expression': 'off',
        },
    },
    // config envs
    {
        languageOptions: {
            globals: { ...globals.browser, ...globals.node },
        },
    },
]);
