/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.configMiddleware=void 0,exports.processXtremX3Config=processXtremX3Config,exports.processContextValues=processContextValues;const xtrem_log_1=require("@sage/xtrem-log"),xtrem_x3_config_manager_1=require("@sage/xtrem-x3-config-manager"),_=require("lodash"),error_app_1=require("./error-app"),logger=xtrem_log_1.Logger.getLogger(__filename,"config"),demoMaxSqlConnections=100,demoMaxNodesPerPage=20;function parseScopes(e,o,r){logger.verbose(()=>["x-api-app-id","x-api-app-name","x-api-scope","x-api-base-url"].map(e=>`${e}=${JSON.stringify(o.header(e))}`).join(" "));const s=e.scope||o.header("x-api-scope")||o.header("x-mindo-scope");if(s&&/\ball:readonly\b/i.test(s.toString())){if(e.storage&&!e.storage.managedExternal&&!e.storage.sql)throw new Error("SQL config missing");if(void 0===!e.storage.maxConnections)e.storage.maxConnections=demoMaxSqlConnections;if(e.graphql=e.graphql||{},e.graphql.isReadonly=true,void 0===!e.graphql.maxNodesPerPage)e.graphql.maxNodesPerPage=demoMaxNodesPerPage;logger.info(()=>"request is configured in read-only mode")}if(s){const e=/\bfolder\.([^/s]+?)\b/g;let o,a=true;for(;o=e.exec(s.toString());){if(o[1]===r.locals.contextValues.folderName){a=true;break}a=false}if(!a)throw new Error(`Unauthorized folder ${r.locals.contextValues.folderName} `)}}function acceptService(e,o,r){if(!e.scope)return true;const s=o.url.split("/")[1];if(!s)return logger.error("no service"),(0,error_app_1.badRequest)(o,r),false;if(!/^[a-z][a-z0-9-]*$/.test(s))return logger.error("Invalid syntax for service (must start with a lowercase letter and can only contain lowercase letters, digits and '-')"),(0,error_app_1.badRequest)(o,r),false;if(e.scope){if(!(new RegExp(`\\bapi\\.${s}\\b`,"i").test(e.scope)||/(?:api|explorer|metadata)/.test(s)))return logger.error(`unauthorized scope ${e.scope}`),(0,error_app_1.forbidden)(o,r),false}return true}function processConfig(e,o,r,s){if(logger.verbose(()=>`email=${JSON.stringify(e.email)} scope=${JSON.stringify(e.scope)} `),parseScopes(e,o,r),acceptService(e,o,r))s()}function processLocalConfig(e){return e.locals.config={...xtrem_x3_config_manager_1.X3ConfigManager.current,...e.locals.context},e.locals.config}async function processXtremX3Config(e,o,r){const s=e.header("x-etna-config");if(!o.locals.contextValues)o.locals.contextValues={};const a=xtrem_x3_config_manager_1.X3ConfigManager.current.x3;if(!s){if(o.locals.config=xtrem_x3_config_manager_1.X3ConfigManager.current,a&&a.development&&a.development.folderName)o.locals.contextValues.folderName=a.development.folderName,o.locals.contextValues.referenceFolder=a.development.referenceFolder||a.development.folderName;return o.locals.contextValues.sessionLogin=o.locals.config.user,o.locals.config}if(Array.isArray(s))o.status(400).json({error:"multiple x-etna-config headers not allowed"});const n=r||await xtrem_x3_config_manager_1.X3ConfigManager.getSecret(),t=await xtrem_x3_config_manager_1.X3ConfigManager.decrypt(s,{secret:n});if(t.session){if(t.user=t.session.userName,t.email=t.session.userName,o.locals.contextValues.sessionLogin=t.session.login||t.login,t.session.keyFunctions)o.locals.contextValues.keyFunctions=t.session.keyFunctions;delete t.session}if(t.folderName)o.locals.contextValues.folderName=t.folderName,o.locals.contextValues.referenceFolder=t.referenceFolder||t.folderName;else throw new Error("x-etna-config missing folder name");if(t.sql){if("sqlServer"===t.sql.driver)t.sql.driver="tedious";const e={...a?.sql,...t.sql};t.x3={...a,sql:e},delete t.sql}else t.x3=a;if(!t.x3.sql)throw new Error("X3 SQL config not found");if(t.cookies)o.locals.contextValues.x3Cookies=t.cookies;return o.locals.contextValues.xtremServiceUrl=t.xtremServiceUrl,o.locals.config={...processLocalConfig(o),...t},o.locals.config}async function processContextValues(e,o,r){const s=e.header("x-etna-context-values");if(Array.isArray(s))o.status(400).json({error:"multiple x-etna-context-values headers not allowed"});if(o.locals.contextValues=o.locals.contextValues??{},s){const e=r||await xtrem_x3_config_manager_1.X3ConfigManager.getSecret();o.locals.contextValues=_.merge(await xtrem_x3_config_manager_1.X3ConfigManager.decrypt(s,{secret:e}),o.locals.contextValues)}}const configMiddleware=async(e,o,r)=>{if(/^\/(ping|ready|login-service)$/.test(e.path))return void r();try{await processContextValues(e,o);processConfig(await processXtremX3Config(e,o),e,o,r)}catch(e){o.status(400).json({error:e.message})}};exports.configMiddleware=configMiddleware;
//# sourceMappingURL=config-middleware.js.map