/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.X3ServiceAgentGenerateController=void 0,exports.pingAgent=pingAgent;const xtremCliCompile=require("@sage/xtrem-cli-compile"),xtrem_cli_lib_1=require("@sage/xtrem-cli-lib"),xtrem_core_1=require("@sage/xtrem-core"),xtrem_x3_dictionary_1=require("@sage/xtrem-x3-dictionary"),fs=require("fs-extra"),jszip=require("jszip"),path=require("path"),util_1=require("util"),api_1=require("../api"),x3_service_agent_request_generation_1=require("../api/x3-service-agent-request-generation"),auth_1=require("../auth"),loggers_1=require("../loggers"),logger=loggers_1.loggers.service;class X3ServiceAgentGenerateController{static async translationGeneration(e,t,a,n,r,i){(0,x3_service_agent_request_generation_1.addEventToTrace)(i,{name:x3_service_agent_request_generation_1.X3ServiceAgentGenerationTraceSteps.TRANSLATION_GENERATION,timestamp:(new Date).toISOString(),status:x3_service_agent_request_generation_1.TraceStatus.START,parent_trace_id:i});const s=await(0,xtrem_core_1.asyncArray)(e).map(async e=>{const i=[t,e.type],s=path.join(...i),o=path.join(s,path.basename(e.name)),_=new xtrem_x3_dictionary_1.X3TranslationGenerator(a,o,e.name,n,r);return await _.init(),_}).toArray();await Promise.all(s.map(e=>(logger.info(`Generating translations for ${e.packageName} into ${e.dir}`),e.generateTranslation()))),(0,x3_service_agent_request_generation_1.addEventToTrace)(i,{name:x3_service_agent_request_generation_1.X3ServiceAgentGenerationTraceSteps.TRANSLATION_GENERATION,timestamp:(new Date).toISOString(),status:x3_service_agent_request_generation_1.TraceStatus.COMPLETED,parent_trace_id:i})}static async packageGeneration(e,t,a,n,r,i,s,o){(0,x3_service_agent_request_generation_1.addEventToTrace)(o,{name:x3_service_agent_request_generation_1.X3ServiceAgentGenerationTraceSteps.PACKAGE_GENERATION,timestamp:(new Date).toISOString(),status:x3_service_agent_request_generation_1.TraceStatus.START,parent_trace_id:o}),xtrem_x3_dictionary_1.X3PackageGenerator.clearCache(),await xtrem_x3_dictionary_1.X3PackageGenerator.preLoadPackageData(e,t,a);const _=await(0,xtrem_core_1.asyncArray)(i).map(async n=>{const i=[r,n.type],o=path.join(...i),_=path.join(o,path.basename(n.name));xtrem_x3_dictionary_1.X3PackageGenerator.ensurePackageStructureExists(o,{name:n.name,version:s,serviceName:a,isCustom:!!n.isCustom,isHidden:n.isHidden});const c=new xtrem_x3_dictionary_1.X3PackageGenerator(_,n.name,e,a,t);return await c.init(),c}).toArray();if(await Promise.all(_.map(e=>(logger.info(`Generating ${e.metadata.name} into ${e.dir}`),e.generate()))),n)logger.info("Generating main package"),xtrem_x3_dictionary_1.X3PackageGenerator.generateMainPackage(r,s,a);(0,x3_service_agent_request_generation_1.addEventToTrace)(o,{name:x3_service_agent_request_generation_1.X3ServiceAgentGenerationTraceSteps.PACKAGE_GENERATION,timestamp:(new Date).toISOString(),status:x3_service_agent_request_generation_1.TraceStatus.COMPLETED,parent_trace_id:o})}static async unzipPackage(e,t){logger.info(`Unzipping ZIP file to temp location ${t}`);const a=await jszip.loadAsync(e);await Promise.all(Object.keys(a.files).map(async e=>{const n=a.files[e];if(n.dir)return;const r=await n.async("nodebuffer"),i=path.join(t,e);await fs.ensureDir(path.dirname(i)),await fs.writeFile(i,r)}))}static overridePackages(e,t){let a="";if(fs.pathExistsSync(e)){fs.readdirSync(e,{withFileTypes:true}).filter(e=>e.isDirectory()).map(e=>e.name).forEach(n=>{const r=path.join(e,n,"package.json");if(fs.pathExistsSync(r)){const i=fs.readJsonSync(r);if(i.name){a=i.name;const r=t.find(e=>e.name===a);if(r){if(logger.info(`Package ${a} found in addonsPackages`),fs.pathExistsSync(r.addonGenerateTempTypePath))fs.removeSync(r.addonGenerateTempTypePath);fs.copySync(path.join(e,n),path.normalize(r.addonGenerateTempTypePath))}else logger.warn(`Package ${a} not found in addonsPackages`)}}})}else logger.warn(`Not found: ${e} to read package.json`)}static copyAddonsToTempLocation(e,t){(0,x3_service_agent_request_generation_1.addEventToTrace)(t,{name:x3_service_agent_request_generation_1.X3ServiceAgentGenerationTraceSteps.COPY_TO_TEMP_DIRECTORY,timestamp:(new Date).toISOString(),status:x3_service_agent_request_generation_1.TraceStatus.START,parent_trace_id:t}),e.forEach(e=>{fs.readdirSync(e.addonFolderOwnerPath).forEach(t=>{const a=path.join(e.addonFolderOwnerPath,t),n=path.join(e.addonGenerateTempTypePath,t);fs.copySync(a,n)})}),(0,x3_service_agent_request_generation_1.addEventToTrace)(t,{name:x3_service_agent_request_generation_1.X3ServiceAgentGenerationTraceSteps.COPY_TO_TEMP_DIRECTORY,timestamp:(new Date).toISOString(),status:x3_service_agent_request_generation_1.TraceStatus.COMPLETED,parent_trace_id:t})}static copyAddOnsFromTempLocationToOriginalLocation(e){if(fs.existsSync(e.addonGenerateTempTypePath))fs.ensureDirSync(e.addonFolderOwnerPath),fs.copySync(e.addonGenerateTempTypePath,e.addonFolderOwnerPath,{dereference:true})}static async zipFileHandling(e,t,a,n){(0,x3_service_agent_request_generation_1.addEventToTrace)(n,{name:x3_service_agent_request_generation_1.X3ServiceAgentGenerationTraceSteps.UNZIP_PACKAGE,timestamp:(new Date).toISOString(),status:x3_service_agent_request_generation_1.TraceStatus.START,parent_trace_id:n}),logger.info(`Write ZIP file to temp location ${a}`),await fs.writeFile(a,e),await this.unzipPackage(e,t),(0,x3_service_agent_request_generation_1.addEventToTrace)(n,{name:x3_service_agent_request_generation_1.X3ServiceAgentGenerationTraceSteps.UNZIP_PACKAGE,timestamp:(new Date).toISOString(),status:x3_service_agent_request_generation_1.TraceStatus.COMPLETED,parent_trace_id:n})}static rollbackAddonsFolder(e,t){if(fs.existsSync(e))logger.warn(`Removing new add-ons folder on path ${e}`),fs.removeSync(e);else logger.error(`New add-ons folder on path ${e} does not exist - skipping remove`);if(fs.existsSync(t))logger.warn(`Renaming add-ons folder on path ${t} to ${e}`),fs.renameSync(t,e);else logger.error(`Add-ons folder on path ${t} does not exist - skipping rename`)}static prepareTempDir(e){if(fs.existsSync(e))logger.info(`Cleaning temp location ${e}`),fs.emptyDirSync(e);else logger.info(`Creating temp location ${e}`),fs.ensureDirSync(e)}static async sleep(e){await(0,util_1.promisify)(setTimeout)(e)}static addAddonPathForPackage(e,t,a){return e.map(e=>(e.addonGenerateTempTypePath=path.join(t,e.type,path.basename(e.name)),e.addonFolderOwnerPath=path.join(a,path.normalize(e.name)),e))}static async verifyAuthToken(e,t){await auth_1.X3ServiceAgentConfig.verifyAuthToken(e.security,t)}static async sendTraceDataToSyracuse(e,t,a){await api_1.X3ApiTracerHelper.sendRequest(x3_service_agent_request_generation_1.TRACE_DATA[e],t,a)}static async externalGeneration(e,t,a,n,r,i,s,o){(0,x3_service_agent_request_generation_1.addEventToTrace)(s,{name:x3_service_agent_request_generation_1.X3ServiceAgentGenerationTraceSteps.MAIN_PROCESS,timestamp:(new Date).toISOString(),status:x3_service_agent_request_generation_1.TraceStatus.START,parent_trace_id:s});const _=setInterval(()=>{this.verifyAuthToken(e,o),this.sendTraceDataToSyracuse(s,a,o),x3_service_agent_request_generation_1.TRACE_DATA[s]={context:{service_name:a,folder_name:t,trace_id:s,session:""},attributes:{},start_time:(new Date).toISOString(),end_time:"",events:[]}},e.x3?.agent?.traceInterval??3e4),c=process.cwd(),g=e.addOns?.folder,p=path.join(c,"add-ons"),d=g??p,l=t?path.join(d,t):d;logger.info(`Add-ons folder path: ${l}`);const m=Date.now(),f=path.join(c,"x3-builder-agent"),u=path.join(f,t).toLowerCase(),T=this.addAddonPathForPackage(r,u,l),S=`${l}_${m}`;let x=false,v="";try{if(logger.info(`Temporary folder path: ${u}`),this.prepareTempDir(u),fs.existsSync(l))logger.info(`Copying add-ons from ${l} to ${u}`),this.copyAddonsToTempLocation(T,s);else logger.warn(`Add-ons folder path ${l} does not exist - skipping copy`);if(void 0!==i){const e=`${t}_${m}`,a=path.join(u,e),n=path.join(u,`${e}.zip`);await this.zipFileHandling(i,a,n,s),this.overridePackages(a,T)}logger.info(`Generating packages for ${t} with service ${a} to ${u}`);const e=xtrem_x3_dictionary_1.X3PackageGenerator.readPackageJson(c);logger.info(`Version: ${e.version}`),await this.packageGeneration(n,t,a,false,u,T,e.version,s),logger.info(`Compiling generated packages for ${t} with service ${a} in ${u}`);const r=T.map(e=>e.name.split("/")[1]);if(process.env.XTREM_I18N_TO_BASE="1",await(0,xtrem_core_1.asyncArray)(r).forEach(async e=>{const t=path.join(u,"application",e,"package.json");if(await fs.exists(t))(0,x3_service_agent_request_generation_1.addEventToTrace)(s,{name:x3_service_agent_request_generation_1.X3ServiceAgentGenerationTraceSteps.BUILD_PACKAGE,timestamp:(new Date).toISOString(),status:x3_service_agent_request_generation_1.TraceStatus.START,parent_trace_id:s,message:`Compiling package ${e}`}),logger.info(`Compiling package ${e} in ${u}`),xtrem_cli_lib_1.cliContext.dir=path.join(u,"application",e),xtrem_cli_lib_1.cliContext.executionMode=xtrem_cli_lib_1.ExecutionMode.INTEGRATED,await xtremCliCompile.compile({skipClient:false,skipCop:true,skipServer:false,skipClean:false,skipDts:false,skipApiClient:false,force:false,isInstrumented:false,isBinary:false,isProd:false,isUsingReferences:false,isOnlyApi:false,isOnlyChanged:false,skipApplication:true,skipClientTypeCheck:true}),logger.info(`Package ${e} compiled in ${u}`),(0,x3_service_agent_request_generation_1.addEventToTrace)(s,{name:x3_service_agent_request_generation_1.X3ServiceAgentGenerationTraceSteps.BUILD_PACKAGE,timestamp:(new Date).toISOString(),status:x3_service_agent_request_generation_1.TraceStatus.COMPLETED,parent_trace_id:s,message:`Compiling package ${e} - ${x3_service_agent_request_generation_1.TraceStatus.COMPLETED}`});else logger.warn(`Not found package.json in ${t}`)}),await this.sleep(3e3),logger.info(`Generating translations for ${t} with service ${a} to ${u}`),await this.translationGeneration(T,u,t,n,a,s),fs.existsSync(l))logger.info(`Renaming add-ons folder on path ${l} to ${S}`),fs.renameSync(l,S);else logger.warn(`Add-ons folder on path ${l} does not exist - skipping rename`);if(fs.existsSync(u))logger.info(`Copying add-ons from ${u} to ${l}`),T.forEach(e=>{this.copyAddOnsFromTempLocationToOriginalLocation(e)});else logger.warn(`Temp location ${u} does not exist - skipping copy`);if(x=true,fs.existsSync(S))logger.info(`Removing add-ons-temp folder on path ${S}`),fs.removeSync(S);else logger.warn(`Add-ons-temp folder on path ${S} does not exist - skipping remove`)}catch(e){this.rollbackAddonsFolder(l,S),v=`Error during external generation: ${e.message}`,logger.error(()=>e.stack)}finally{if(fs.existsSync(f))logger.info(`Removing xBuilderAgentTempDirPath folder on path ${f}`),fs.removeSync(f);else logger.warn(`xBuilderAgentTempDirPath folder on path ${f} does not exist - skipping remove`);if(process.send&&x)logger.info(`Sending KILL message to worker parent process for worker ${t}`),process.send({event:"killWorkers",requestSource:t},void 0,void 0,e=>{if(e)logger.error(()=>`Error sending KILL message to worker parent process for worker ${t}: ${e.message}`)});(0,x3_service_agent_request_generation_1.addEventToTrace)(s,{name:x3_service_agent_request_generation_1.X3ServiceAgentGenerationTraceSteps.MAIN_PROCESS,timestamp:(new Date).toISOString(),status:v?x3_service_agent_request_generation_1.TraceStatus.ERROR:x3_service_agent_request_generation_1.TraceStatus.COMPLETED,parent_trace_id:s,message:v??""}),logger.info(`Stopping interval for trace_id ${s}`),clearInterval(_),logger.info(`Sending last trace data to Syracuse for trace_id ${s}`),x3_service_agent_request_generation_1.TRACE_DATA[s].end_time=(new Date).toISOString(),x3_service_agent_request_generation_1.TRACE_DATA[s].global_status=v?x3_service_agent_request_generation_1.TraceStatus.ERROR:x3_service_agent_request_generation_1.TraceStatus.COMPLETED,await this.sendTraceDataToSyracuse(s,a,o),logger.info(`Deleting trace data for trace_id ${s}`),delete x3_service_agent_request_generation_1.TRACE_DATA[s]}}}function pingAgent(e,t){t.json({})}exports.X3ServiceAgentGenerateController=X3ServiceAgentGenerateController;
//# sourceMappingURL=x3-service-agent-generate-controller.js.map