import { MetadataPackage } from '@sage/xtrem-x3-dictionary';
import { Request, Response } from 'express';
import { X3HeaderContext } from '../api/x3-service-agent-request-generation';
export declare class X3ServiceAgentGenerateController {
    private static translationGeneration;
    private static packageGeneration;
    private static unzipPackage;
    /**
     * Override packages in tempGeneratedDir with the content of the tempZipDirPath
     *
     * @param tempGeneratedDir - The directory where the packages are generated
     * @param tempZipDirPath - The directory where the zip file is unzipped
     * @param directories - The list of directories in tempGeneratedDir
     */
    private static overridePackages;
    private static copyAddonsToTempLocation;
    private static copyAddOnsFromTempLocationToOriginalLocation;
    private static zipFileHandling;
    private static rollbackAddonsFolder;
    private static prepareTempDir;
    static sleep(ms: number): Promise<void>;
    private static addAddonPathForPackage;
    private static verifyAuthToken;
    static sendTraceDataToSyracuse(trace_id: string, serviceName: string, contextValues: X3HeaderContext): Promise<void>;
    static externalGeneration(config: any, folderName: string, serviceName: string, connPool: any, metaPackages: MetadataPackage[], zipBuffer: Buffer | undefined, trace_id: string, contextValues: X3HeaderContext): Promise<void>;
}
export declare function pingAgent(req: Request, res: Response): void;
//# sourceMappingURL=x3-service-agent-generate-controller.d.ts.map